/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.experimental.graphinfo.GraphEdgeInfo;
import com.android.tools.r8.experimental.graphinfo.GraphNode;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.ProguardKeepRule;

public abstract class KeepReason {
    public abstract GraphEdgeInfo.EdgeKind edgeKind();

    public abstract GraphNode getSourceNode(Enqueuer var1);

    static KeepReason dueToKeepRule(ProguardKeepRule rule) {
        return new DueToKeepRule(rule);
    }

    static KeepReason dueToProguardCompatibilityKeepRule(ProguardKeepRule rule) {
        return new DueToProguardCompatibilityKeepRule(rule);
    }

    static KeepReason instantiatedIn(DexEncodedMethod method) {
        return new InstatiatedIn(method);
    }

    public static KeepReason invokedViaSuperFrom(DexEncodedMethod from) {
        return new InvokedViaSuper(from);
    }

    public static KeepReason reachableFromLiveType(DexType type) {
        return new ReachableFromLiveType(type);
    }

    public static KeepReason invokedFrom(DexEncodedMethod method) {
        return new InvokedFrom(method);
    }

    public static KeepReason invokedFromLambdaCreatedIn(DexEncodedMethod method) {
        return new InvokedFromLambdaCreatedIn(method);
    }

    public static KeepReason isLibraryMethod() {
        return new IsLibraryMethod();
    }

    public static KeepReason fieldReferencedIn(DexEncodedMethod method) {
        return new ReferencedFrom(method);
    }

    public static KeepReason referencedInAnnotation(DexItem holder) {
        return new ReferencedInAnnotation(holder);
    }

    public boolean isDueToKeepRule() {
        return false;
    }

    public boolean isDueToReflectiveUse() {
        return false;
    }

    public boolean isDueToProguardCompatibility() {
        return false;
    }

    public ProguardKeepRule getProguardKeepRule() {
        return null;
    }

    public static KeepReason targetedBySuperFrom(DexEncodedMethod from) {
        return new TargetedBySuper(from);
    }

    public static KeepReason reflectiveUseIn(DexEncodedMethod method) {
        return new ReflectiveUseFrom(method);
    }

    public static KeepReason methodHandleReferencedIn(DexEncodedMethod method) {
        return new MethodHandleReferencedFrom(method);
    }

    private static class MethodHandleReferencedFrom
    extends BasedOnOtherMethod {
        private MethodHandleReferencedFrom(DexEncodedMethod method) {
            super(method);
        }

        @Override
        public GraphEdgeInfo.EdgeKind edgeKind() {
            return GraphEdgeInfo.EdgeKind.MethodHandleUseFrom;
        }

        @Override
        String getKind() {
            return "method handle referenced from";
        }
    }

    private static class ReflectiveUseFrom
    extends BasedOnOtherMethod {
        private ReflectiveUseFrom(DexEncodedMethod method) {
            super(method);
        }

        @Override
        public boolean isDueToReflectiveUse() {
            return true;
        }

        @Override
        public GraphEdgeInfo.EdgeKind edgeKind() {
            return GraphEdgeInfo.EdgeKind.ReflectiveUseFrom;
        }

        @Override
        String getKind() {
            return "reflective use in";
        }
    }

    private static class ReferencedInAnnotation
    extends KeepReason {
        private final DexItem holder;

        private ReferencedInAnnotation(DexItem holder) {
            this.holder = holder;
        }

        @Override
        public GraphEdgeInfo.EdgeKind edgeKind() {
            return GraphEdgeInfo.EdgeKind.ReferencedInAnnotation;
        }

        @Override
        public GraphNode getSourceNode(Enqueuer enqueuer) {
            return enqueuer.getAnnotationGraphNode(this.holder);
        }
    }

    private static class IsLibraryMethod
    extends KeepReason {
        private IsLibraryMethod() {
        }

        @Override
        public GraphEdgeInfo.EdgeKind edgeKind() {
            return GraphEdgeInfo.EdgeKind.IsLibraryMethod;
        }

        @Override
        public GraphNode getSourceNode(Enqueuer enqueuer) {
            return null;
        }
    }

    private static class ReachableFromLiveType
    extends KeepReason {
        private final DexType type;

        private ReachableFromLiveType(DexType type) {
            this.type = type;
        }

        @Override
        public GraphEdgeInfo.EdgeKind edgeKind() {
            return GraphEdgeInfo.EdgeKind.ReachableFromLiveType;
        }

        @Override
        public GraphNode getSourceNode(Enqueuer enqueuer) {
            return enqueuer.getClassGraphNode(this.type);
        }
    }

    private static class ReferencedFrom
    extends BasedOnOtherMethod {
        private ReferencedFrom(DexEncodedMethod method) {
            super(method);
        }

        @Override
        public GraphEdgeInfo.EdgeKind edgeKind() {
            return GraphEdgeInfo.EdgeKind.ReferencedFrom;
        }

        @Override
        String getKind() {
            return "referenced from";
        }
    }

    private static class InvokedFromLambdaCreatedIn
    extends BasedOnOtherMethod {
        private InvokedFromLambdaCreatedIn(DexEncodedMethod method) {
            super(method);
        }

        @Override
        public GraphEdgeInfo.EdgeKind edgeKind() {
            return GraphEdgeInfo.EdgeKind.InvokedFromLambdaCreatedIn;
        }

        @Override
        String getKind() {
            return "invoked from lambda created in";
        }
    }

    private static class InvokedFrom
    extends BasedOnOtherMethod {
        private InvokedFrom(DexEncodedMethod method) {
            super(method);
        }

        @Override
        public GraphEdgeInfo.EdgeKind edgeKind() {
            return GraphEdgeInfo.EdgeKind.InvokedFrom;
        }

        @Override
        String getKind() {
            return "invoked from";
        }
    }

    private static class TargetedBySuper
    extends BasedOnOtherMethod {
        private TargetedBySuper(DexEncodedMethod method) {
            super(method);
        }

        @Override
        public GraphEdgeInfo.EdgeKind edgeKind() {
            return GraphEdgeInfo.EdgeKind.TargetedBySuper;
        }

        @Override
        String getKind() {
            return "targeted by super from";
        }
    }

    private static class InvokedViaSuper
    extends BasedOnOtherMethod {
        private InvokedViaSuper(DexEncodedMethod method) {
            super(method);
        }

        @Override
        public GraphEdgeInfo.EdgeKind edgeKind() {
            return GraphEdgeInfo.EdgeKind.InvokedViaSuper;
        }

        @Override
        String getKind() {
            return "invoked via super from";
        }
    }

    private static class InstatiatedIn
    extends BasedOnOtherMethod {
        private InstatiatedIn(DexEncodedMethod method) {
            super(method);
        }

        @Override
        public GraphEdgeInfo.EdgeKind edgeKind() {
            return GraphEdgeInfo.EdgeKind.InstantiatedIn;
        }

        @Override
        String getKind() {
            return "instantiated in";
        }
    }

    private static abstract class BasedOnOtherMethod
    extends KeepReason {
        private final DexEncodedMethod method;

        private BasedOnOtherMethod(DexEncodedMethod method) {
            this.method = method;
        }

        abstract String getKind();

        @Override
        public GraphNode getSourceNode(Enqueuer enqueuer) {
            return enqueuer.getMethodGraphNode(this.method.method);
        }
    }

    private static class DueToProguardCompatibilityKeepRule
    extends DueToKeepRule {
        private DueToProguardCompatibilityKeepRule(ProguardKeepRule keepRule) {
            super(keepRule);
        }

        @Override
        public GraphEdgeInfo.EdgeKind edgeKind() {
            return GraphEdgeInfo.EdgeKind.CompatibilityRule;
        }

        @Override
        public boolean isDueToProguardCompatibility() {
            return true;
        }
    }

    private static class DueToKeepRule
    extends KeepReason {
        final ProguardKeepRule keepRule;

        private DueToKeepRule(ProguardKeepRule keepRule) {
            this.keepRule = keepRule;
        }

        @Override
        public GraphEdgeInfo.EdgeKind edgeKind() {
            return GraphEdgeInfo.EdgeKind.KeepRule;
        }

        @Override
        public boolean isDueToKeepRule() {
            return true;
        }

        @Override
        public ProguardKeepRule getProguardKeepRule() {
            return this.keepRule;
        }

        @Override
        public GraphNode getSourceNode(Enqueuer enqueuer) {
            return enqueuer.getKeepRuleGraphNode(this.keepRule);
        }
    }
}

