/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.base.MoreObjects;
import com.android.tools.r8.com.google.common.base.Predicates;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.ClassAccessFlags;
import com.android.tools.r8.graph.Descriptor;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexClasspathClass;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexLibraryClass;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.EnclosingMethodAttribute;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.kotlin.KotlinInfo;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.InternalOptions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;

public abstract class DexClass
extends DexDefinition {
    private static final DexEncodedMethod[] NO_METHODS = new DexEncodedMethod[0];
    private static final DexEncodedField[] NO_FIELDS = new DexEncodedField[0];
    public final Origin origin;
    public DexType type;
    public final ClassAccessFlags accessFlags;
    public DexType superType;
    public DexTypeList interfaces;
    public DexString sourceFile;
    protected DexEncodedField[] staticFields = NO_FIELDS;
    protected DexEncodedField[] instanceFields = NO_FIELDS;
    protected DexEncodedMethod[] directMethods = NO_METHODS;
    protected DexEncodedMethod[] virtualMethods = NO_METHODS;
    private EnclosingMethodAttribute enclosingMethod;
    private final List<InnerClassAttribute> innerClasses;
    public DexAnnotationSet annotations;

    public DexClass(DexString sourceFile, DexTypeList interfaces, ClassAccessFlags accessFlags, DexType superType, DexType type, DexEncodedField[] staticFields, DexEncodedField[] instanceFields, DexEncodedMethod[] directMethods, DexEncodedMethod[] virtualMethods, EnclosingMethodAttribute enclosingMethod, List<InnerClassAttribute> innerClasses, DexAnnotationSet annotations, Origin origin, boolean skipNameValidationForTesting) {
        assert (origin != null);
        this.origin = origin;
        this.sourceFile = sourceFile;
        this.interfaces = interfaces;
        this.accessFlags = accessFlags;
        this.superType = superType;
        this.type = type;
        this.setStaticFields(staticFields);
        this.setInstanceFields(instanceFields);
        this.setDirectMethods(directMethods);
        this.setVirtualMethods(virtualMethods);
        this.enclosingMethod = enclosingMethod;
        this.innerClasses = innerClasses;
        this.annotations = annotations;
        if (type == superType) {
            throw new CompilationError("Class " + type.toString() + " cannot extend itself");
        }
        for (DexType interfaceType : interfaces.values) {
            if (type != interfaceType) continue;
            throw new CompilationError("Interface " + type.toString() + " cannot implement itself");
        }
        if (!skipNameValidationForTesting && !type.descriptor.isValidClassDescriptor()) {
            throw new CompilationError("Class descriptor '" + type.descriptor.toString() + "' cannot be represented in dex format.");
        }
    }

    public Iterable<DexEncodedField> fields() {
        return this.fields(Predicates.alwaysTrue());
    }

    public Iterable<DexEncodedField> fields(Predicate<? super DexEncodedField> predicate) {
        return Iterables.concat(Iterables.filter(Arrays.asList(this.instanceFields), predicate::test), Iterables.filter(Arrays.asList(this.staticFields), predicate::test));
    }

    public Iterable<DexEncodedMethod> methods() {
        return this.methods(Predicates.alwaysTrue());
    }

    public Iterable<DexEncodedMethod> methods(Predicate<? super DexEncodedMethod> predicate) {
        return Iterables.concat(Iterables.filter(Arrays.asList(this.directMethods), predicate::test), Iterables.filter(Arrays.asList(this.virtualMethods), predicate::test));
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        throw new Unreachable();
    }

    public List<DexEncodedMethod> directMethods() {
        assert (this.directMethods != null);
        if (InternalOptions.assertionsEnabled()) {
            return Collections.unmodifiableList(Arrays.asList(this.directMethods));
        }
        return Arrays.asList(this.directMethods);
    }

    public void appendDirectMethod(DexEncodedMethod method) {
        DexEncodedMethod[] newMethods = new DexEncodedMethod[this.directMethods.length + 1];
        System.arraycopy(this.directMethods, 0, newMethods, 0, this.directMethods.length);
        newMethods[this.directMethods.length] = method;
        this.directMethods = newMethods;
        assert (this.verifyCorrectnessOfMethodHolder(method));
        assert (this.verifyNoDuplicateMethods());
    }

    public void appendDirectMethods(Collection<DexEncodedMethod> methods) {
        DexEncodedMethod[] newMethods = new DexEncodedMethod[this.directMethods.length + methods.size()];
        System.arraycopy(this.directMethods, 0, newMethods, 0, this.directMethods.length);
        int i = this.directMethods.length;
        Iterator<DexEncodedMethod> iterator2 = methods.iterator();
        while (iterator2.hasNext()) {
            DexEncodedMethod method;
            newMethods[i] = method = iterator2.next();
            ++i;
        }
        this.directMethods = newMethods;
        assert (this.verifyCorrectnessOfMethodHolders(methods));
        assert (this.verifyNoDuplicateMethods());
    }

    public void removeDirectMethod(int index) {
        DexEncodedMethod[] newMethods = new DexEncodedMethod[this.directMethods.length - 1];
        System.arraycopy(this.directMethods, 0, newMethods, 0, index);
        System.arraycopy(this.directMethods, index + 1, newMethods, index, this.directMethods.length - index - 1);
        this.directMethods = newMethods;
    }

    public void setDirectMethod(int index, DexEncodedMethod method) {
        this.directMethods[index] = method;
        assert (this.verifyCorrectnessOfMethodHolder(method));
        assert (this.verifyNoDuplicateMethods());
    }

    public void setDirectMethods(DexEncodedMethod[] values2) {
        this.directMethods = MoreObjects.firstNonNull(values2, NO_METHODS);
        assert (this.verifyCorrectnessOfMethodHolders(this.directMethods()));
        assert (this.verifyNoDuplicateMethods());
    }

    public List<DexEncodedMethod> virtualMethods() {
        assert (this.virtualMethods != null);
        if (InternalOptions.assertionsEnabled()) {
            return Collections.unmodifiableList(Arrays.asList(this.virtualMethods));
        }
        return Arrays.asList(this.virtualMethods);
    }

    public void appendVirtualMethod(DexEncodedMethod method) {
        DexEncodedMethod[] newMethods = new DexEncodedMethod[this.virtualMethods.length + 1];
        System.arraycopy(this.virtualMethods, 0, newMethods, 0, this.virtualMethods.length);
        newMethods[this.virtualMethods.length] = method;
        this.virtualMethods = newMethods;
        assert (this.verifyCorrectnessOfMethodHolder(method));
        assert (this.verifyNoDuplicateMethods());
    }

    public void appendVirtualMethods(Collection<DexEncodedMethod> methods) {
        DexEncodedMethod[] newMethods = new DexEncodedMethod[this.virtualMethods.length + methods.size()];
        System.arraycopy(this.virtualMethods, 0, newMethods, 0, this.virtualMethods.length);
        int i = this.virtualMethods.length;
        Iterator<DexEncodedMethod> iterator2 = methods.iterator();
        while (iterator2.hasNext()) {
            DexEncodedMethod method;
            newMethods[i] = method = iterator2.next();
            ++i;
        }
        this.virtualMethods = newMethods;
        assert (this.verifyCorrectnessOfMethodHolders(methods));
        assert (this.verifyNoDuplicateMethods());
    }

    public void removeVirtualMethod(int index) {
        DexEncodedMethod[] newMethods = new DexEncodedMethod[this.virtualMethods.length - 1];
        System.arraycopy(this.virtualMethods, 0, newMethods, 0, index);
        System.arraycopy(this.virtualMethods, index + 1, newMethods, index, this.virtualMethods.length - index - 1);
        this.virtualMethods = newMethods;
    }

    public void setVirtualMethod(int index, DexEncodedMethod method) {
        this.virtualMethods[index] = method;
        assert (this.verifyCorrectnessOfMethodHolder(method));
        assert (this.verifyNoDuplicateMethods());
    }

    public void setVirtualMethods(DexEncodedMethod[] values2) {
        this.virtualMethods = MoreObjects.firstNonNull(values2, NO_METHODS);
        assert (this.verifyCorrectnessOfMethodHolders(this.virtualMethods()));
        assert (this.verifyNoDuplicateMethods());
    }

    private boolean verifyCorrectnessOfMethodHolder(DexEncodedMethod method) {
        assert (method.method.holder == this.type) : "Expected method `" + method.method.toSourceString() + "` to have holder `" + this.type.toSourceString() + "`";
        return true;
    }

    private boolean verifyCorrectnessOfMethodHolders(Iterable<DexEncodedMethod> methods) {
        for (DexEncodedMethod method : methods) {
            assert (this.verifyCorrectnessOfMethodHolder(method));
        }
        return true;
    }

    private boolean verifyNoDuplicateMethods() {
        Set<DexMethod> unique = Sets.newIdentityHashSet();
        for (DexEncodedMethod method : this.methods()) {
            boolean changed = unique.add(method.method);
            assert (changed) : "Duplicate method `" + method.method.toSourceString() + "`";
        }
        return true;
    }

    public void forEachMethod(Consumer<DexEncodedMethod> consumer) {
        for (DexEncodedMethod method : this.directMethods()) {
            consumer.accept(method);
        }
        for (DexEncodedMethod method : this.virtualMethods()) {
            consumer.accept(method);
        }
    }

    public DexEncodedMethod[] allMethodsSorted() {
        int vLen = this.virtualMethods.length;
        int dLen = this.directMethods.length;
        DexEncodedMethod[] result = new DexEncodedMethod[vLen + dLen];
        System.arraycopy(this.virtualMethods, 0, result, 0, vLen);
        System.arraycopy(this.directMethods, 0, result, vLen, dLen);
        Arrays.sort(result, (a, b) -> a.method.slowCompareTo(b.method));
        return result;
    }

    public void virtualizeMethods(Set<DexEncodedMethod> privateInstanceMethods) {
        int vLen = this.virtualMethods.length;
        int dLen = this.directMethods.length;
        int mLen = privateInstanceMethods.size();
        assert (mLen <= dLen);
        DexEncodedMethod[] newDirectMethods = new DexEncodedMethod[dLen - mLen];
        int index = 0;
        for (int i = 0; i < dLen; ++i) {
            DexEncodedMethod encodedMethod = this.directMethods[i];
            if (privateInstanceMethods.contains(encodedMethod)) continue;
            newDirectMethods[index++] = encodedMethod;
        }
        assert (index == dLen - mLen);
        this.setDirectMethods(newDirectMethods);
        DexEncodedMethod[] newVirtualMethods = new DexEncodedMethod[vLen + mLen];
        System.arraycopy(this.virtualMethods, 0, newVirtualMethods, 0, vLen);
        index = vLen;
        for (DexEncodedMethod encodedMethod : privateInstanceMethods) {
            newVirtualMethods[index++] = encodedMethod;
        }
        this.setVirtualMethods(newVirtualMethods);
    }

    public void forEachAnnotation(Consumer<DexAnnotation> consumer) {
        for (DexAnnotation annotation : this.annotations.annotations) {
            consumer.accept(annotation);
        }
        for (DexEncodedMethod method : this.directMethods()) {
            DexAnnotation[] dexAnnotationArray = method.annotations.annotations;
            int annotation = dexAnnotationArray.length;
            for (int i = 0; i < annotation; ++i) {
                DexAnnotation annotation2 = dexAnnotationArray[i];
                consumer.accept(annotation2);
            }
            method.parameterAnnotationsList.forEachAnnotation(consumer);
        }
        for (DexEncodedMethod method : this.virtualMethods()) {
            for (DexAnnotation annotation2 : method.annotations.annotations) {
                consumer.accept(annotation2);
            }
            method.parameterAnnotationsList.forEachAnnotation(consumer);
        }
        for (DexEncodedField field : this.instanceFields()) {
            DexAnnotation[] dexAnnotationArray = field.annotations.annotations;
            int n = dexAnnotationArray.length;
            for (int i = 0; i < n; ++i) {
                DexAnnotation annotation = dexAnnotationArray[i];
                consumer.accept(annotation);
            }
        }
        for (DexEncodedField field : this.staticFields()) {
            for (DexAnnotation annotation : field.annotations.annotations) {
                consumer.accept(annotation);
            }
        }
    }

    public void forEachField(Consumer<DexEncodedField> consumer) {
        for (DexEncodedField field : this.staticFields()) {
            consumer.accept(field);
        }
        for (DexEncodedField field : this.instanceFields()) {
            consumer.accept(field);
        }
    }

    public DexEncodedField[] staticFields() {
        return this.staticFields;
    }

    public void setStaticFields(DexEncodedField[] values2) {
        this.staticFields = MoreObjects.firstNonNull(values2, NO_FIELDS);
    }

    public boolean definesStaticField(DexField field) {
        for (DexEncodedField encodedField : this.staticFields()) {
            if (encodedField.field != field) continue;
            return true;
        }
        return false;
    }

    public DexEncodedField[] instanceFields() {
        return this.instanceFields;
    }

    public void setInstanceFields(DexEncodedField[] values2) {
        this.instanceFields = MoreObjects.firstNonNull(values2, NO_FIELDS);
    }

    public DexEncodedField[] allFieldsSorted() {
        int iLen = this.instanceFields.length;
        int sLen = this.staticFields.length;
        DexEncodedField[] result = new DexEncodedField[iLen + sLen];
        System.arraycopy(this.instanceFields, 0, result, 0, iLen);
        System.arraycopy(this.staticFields, 0, result, iLen, sLen);
        Arrays.sort(result, (a, b) -> a.field.slowCompareTo(b.field));
        return result;
    }

    public DexEncodedField lookupStaticField(DexField field) {
        return (DexEncodedField)this.lookupTarget(this.staticFields(), field);
    }

    public DexEncodedField lookupInstanceField(DexField field) {
        return (DexEncodedField)this.lookupTarget(this.instanceFields(), field);
    }

    public DexEncodedField lookupField(DexField field) {
        DexEncodedField result = this.lookupInstanceField(field);
        return result == null ? this.lookupStaticField(field) : result;
    }

    public DexEncodedMethod lookupDirectMethod(DexMethod method) {
        return (DexEncodedMethod)this.lookupTarget(this.directMethods, method);
    }

    public DexEncodedMethod lookupVirtualMethod(DexMethod method) {
        return (DexEncodedMethod)this.lookupTarget(this.virtualMethods, method);
    }

    public DexEncodedMethod lookupMethod(DexMethod method) {
        DexEncodedMethod result = this.lookupDirectMethod(method);
        return result == null ? this.lookupVirtualMethod(method) : result;
    }

    private <T extends DexItem, S extends Descriptor<T, S>> T lookupTarget(T[] items, S descriptor) {
        for (T entry : items) {
            if (!descriptor.match(entry)) continue;
            return entry;
        }
        return null;
    }

    public boolean isInterface() {
        return this.accessFlags.isInterface();
    }

    public boolean isEnum() {
        return this.accessFlags.isEnum();
    }

    public abstract void addDependencies(MixedSectionCollection var1);

    @Override
    public DexReference toReference() {
        return this.getType();
    }

    @Override
    public boolean isDexClass() {
        return true;
    }

    @Override
    public DexClass asDexClass() {
        return this;
    }

    public boolean isProgramClass() {
        return false;
    }

    public DexProgramClass asProgramClass() {
        return null;
    }

    public boolean isClasspathClass() {
        return false;
    }

    public DexClasspathClass asClasspathClass() {
        return null;
    }

    public boolean isLibraryClass() {
        return false;
    }

    public DexLibraryClass asLibraryClass() {
        return null;
    }

    @Override
    public boolean isStatic() {
        return this.accessFlags.isStatic();
    }

    @Override
    public boolean isStaticMember() {
        return false;
    }

    public DexEncodedMethod getClassInitializer() {
        return Arrays.stream(this.directMethods).filter(DexEncodedMethod::isClassInitializer).findAny().orElse(null);
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public DexType getType() {
        return this.type;
    }

    public boolean hasClassInitializer() {
        return this.getClassInitializer() != null;
    }

    public boolean hasTrivialClassInitializer() {
        if (this.isLibraryClass()) {
            return this.superType == null;
        }
        DexEncodedMethod clinit = this.getClassInitializer();
        return clinit != null && clinit.getCode() != null && clinit.getCode().isEmptyVoidMethod();
    }

    public boolean hasNonTrivialClassInitializer() {
        if (this.isLibraryClass()) {
            return this.superType != null;
        }
        DexEncodedMethod clinit = this.getClassInitializer();
        if (clinit == null || clinit.getCode() == null) {
            return false;
        }
        return !clinit.getCode().isEmptyVoidMethod();
    }

    public boolean hasDefaultInitializer() {
        return this.getDefaultInitializer() != null;
    }

    public DexEncodedMethod getDefaultInitializer() {
        for (DexEncodedMethod method : this.directMethods()) {
            if (!method.isDefaultInitializer()) continue;
            return method;
        }
        return null;
    }

    public boolean hasMissingSuperType(AppInfo appInfo) {
        if (this.superType != null && this.superType.isMissingOrHasMissingSuperType(appInfo)) {
            return true;
        }
        for (DexType interfaceType : this.interfaces.values) {
            if (!interfaceType.isMissingOrHasMissingSuperType(appInfo)) continue;
            return true;
        }
        return false;
    }

    public boolean isSerializable(AppInfo appInfo) {
        return this.type.isSerializable(appInfo);
    }

    public boolean isExternalizable(AppInfo appInfo) {
        return this.type.isExternalizable(appInfo);
    }

    public boolean classInitializationMayHaveSideEffects(AppInfo appInfo) {
        return this.classInitializationMayHaveSideEffects(appInfo, Predicates.alwaysFalse());
    }

    public boolean classInitializationMayHaveSideEffects(AppInfo appInfo, Predicate<DexType> ignore) {
        if (ignore.test(this.type) || appInfo.dexItemFactory.libraryTypesWithoutStaticInitialization.contains(this.type)) {
            return false;
        }
        if (this.hasNonTrivialClassInitializer()) {
            return true;
        }
        if (this.defaultValuesForStaticFieldsMayTriggerAllocation()) {
            return true;
        }
        return this.initializationOfParentTypesMayHaveSideEffects(appInfo, ignore);
    }

    public boolean initializationOfParentTypesMayHaveSideEffects(AppInfo appInfo) {
        return this.initializationOfParentTypesMayHaveSideEffects(appInfo, Predicates.alwaysFalse());
    }

    public boolean initializationOfParentTypesMayHaveSideEffects(AppInfo appInfo, Predicate<DexType> ignore) {
        for (DexType iface : this.interfaces.values) {
            if (!iface.classInitializationMayHaveSideEffects(appInfo, ignore)) continue;
            return true;
        }
        return this.superType != null && this.superType.classInitializationMayHaveSideEffects(appInfo, ignore);
    }

    public boolean defaultValuesForStaticFieldsMayTriggerAllocation() {
        return Arrays.stream(this.staticFields()).anyMatch(field -> field.getStaticValue().mayTriggerAllocation());
    }

    public List<InnerClassAttribute> getInnerClasses() {
        return this.innerClasses;
    }

    public EnclosingMethodAttribute getEnclosingMethod() {
        return this.enclosingMethod;
    }

    public void clearEnclosingMethod() {
        this.enclosingMethod = null;
    }

    public void removeEnclosingMethod(Predicate<EnclosingMethodAttribute> predicate) {
        if (this.enclosingMethod != null && predicate.test(this.enclosingMethod)) {
            this.enclosingMethod = null;
        }
    }

    public void clearInnerClasses() {
        this.innerClasses.clear();
    }

    public void removeInnerClasses(Predicate<InnerClassAttribute> predicate) {
        this.innerClasses.removeIf(predicate::test);
    }

    public InnerClassAttribute getInnerClassAttributeForThisClass() {
        for (InnerClassAttribute innerClassAttribute : this.getInnerClasses()) {
            if (this.type != innerClassAttribute.getInner()) continue;
            return innerClassAttribute;
        }
        return null;
    }

    public boolean isLocalClass() {
        InnerClassAttribute innerClass = this.getInnerClassAttributeForThisClass();
        return innerClass != null && innerClass.isNamed() && this.getEnclosingMethod() != null;
    }

    public boolean isMemberClass() {
        InnerClassAttribute innerClass = this.getInnerClassAttributeForThisClass();
        return innerClass != null && innerClass.getOuter() != null && innerClass.isNamed() && this.getEnclosingMethod() == null;
    }

    public boolean isAnonymousClass() {
        InnerClassAttribute innerClass = this.getInnerClassAttributeForThisClass();
        return innerClass != null && innerClass.isAnonymous() && this.getEnclosingMethod() != null;
    }

    public abstract KotlinInfo getKotlinInfo();

    public final boolean hasKotlinInfo() {
        return this.getKotlinInfo() != null;
    }

    public boolean isValid() {
        assert (!this.isInterface() || Arrays.stream(this.virtualMethods).noneMatch(method -> method.accessFlags.isFinal()));
        assert (this.verifyCorrectnessOfMethodHolders(this.methods()));
        assert (this.verifyNoDuplicateMethods());
        return true;
    }

    public static interface MethodSetter {
        public void setMethod(int var1, DexEncodedMethod var2);
    }
}

