/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.DexArchive;
import com.android.builder.dexing.DexArchiveEntry;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

final class NonIncrementalJarDexArchive
implements DexArchive {
    private static final FileTime ZERO_TIME = FileTime.fromMillis(0L);
    private final Path targetPath;
    private JarOutputStream jarOutputStream;
    private ZipFile readOnlyZipFile;

    public NonIncrementalJarDexArchive(Path targetPath) throws IOException {
        this.targetPath = targetPath;
        if (Files.isRegularFile(targetPath, new LinkOption[0])) {
            this.readOnlyZipFile = new ZipFile(targetPath.toFile());
        } else {
            this.jarOutputStream = new JarOutputStream(new BufferedOutputStream(Files.newOutputStream(targetPath, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW)));
        }
    }

    @Override
    public Path getRootPath() {
        return this.targetPath;
    }

    @Override
    public void addFile(String relativePath, byte[] bytes, int offset, int end) throws IOException {
        Preconditions.checkNotNull((Object)this.jarOutputStream, (String)"Archive is not writeable : %s", (Object)this.targetPath);
        CRC32 checksum = new CRC32();
        checksum.update(bytes, offset, end);
        ZipEntry zipEntry = new ZipEntry(relativePath);
        zipEntry.setLastModifiedTime(ZERO_TIME);
        zipEntry.setLastAccessTime(ZERO_TIME);
        zipEntry.setCreationTime(ZERO_TIME);
        zipEntry.setCrc(checksum.getValue());
        zipEntry.setSize(end - offset);
        zipEntry.setCompressedSize(end - offset);
        zipEntry.setMethod(0);
        this.jarOutputStream.putNextEntry(zipEntry);
        this.jarOutputStream.write(bytes, offset, end);
        this.jarOutputStream.flush();
        this.jarOutputStream.closeEntry();
    }

    @Override
    public List<DexArchiveEntry> getFiles() throws IOException {
        Preconditions.checkNotNull((Object)this.readOnlyZipFile, (String)"Archive is not readable : %s", (Object)this.targetPath);
        ArrayList<DexArchiveEntry> dexEntries = new ArrayList<DexArchiveEntry>();
        Enumeration<? extends ZipEntry> entries = this.readOnlyZipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            BufferedInputStream inputStream = new BufferedInputStream(this.readOnlyZipFile.getInputStream(zipEntry));
            Throwable throwable = null;
            try {
                byte[] content = ByteStreams.toByteArray((InputStream)inputStream);
                dexEntries.add(new DexArchiveEntry(content, zipEntry.getName(), this));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream == null) continue;
                if (throwable != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                inputStream.close();
            }
        }
        return dexEntries;
    }

    @Override
    public void close() throws IOException {
        if (this.jarOutputStream != null) {
            this.jarOutputStream.flush();
            this.jarOutputStream.close();
        } else if (this.readOnlyZipFile != null) {
            this.readOnlyZipFile.close();
        } else {
            throw new IllegalStateException("Dex archive is neither readable nor writable.");
        }
    }
}

