/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.com.google.common.collect.Streams;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.Descriptor;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexLibraryClass;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DirectMappedDexApplication;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.shaking.ClassInlineRule;
import com.android.tools.r8.shaking.ClassMergingRule;
import com.android.tools.r8.shaking.ConstantArgumentRule;
import com.android.tools.r8.shaking.DexStringCache;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.InlineRule;
import com.android.tools.r8.shaking.ProguardAssumeNoSideEffectRule;
import com.android.tools.r8.shaking.ProguardAssumeValuesRule;
import com.android.tools.r8.shaking.ProguardCheckDiscardRule;
import com.android.tools.r8.shaking.ProguardConfigurationRule;
import com.android.tools.r8.shaking.ProguardIdentifierNameStringRule;
import com.android.tools.r8.shaking.ProguardIfRule;
import com.android.tools.r8.shaking.ProguardKeepPackageNamesRule;
import com.android.tools.r8.shaking.ProguardKeepRule;
import com.android.tools.r8.shaking.ProguardKeepRuleModifiers;
import com.android.tools.r8.shaking.ProguardMemberRule;
import com.android.tools.r8.shaking.ProguardTypeMatcher;
import com.android.tools.r8.shaking.ProguardWhyAreYouKeepingRule;
import com.android.tools.r8.shaking.UnusedArgumentRule;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.MethodSignatureEquivalence;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.ThreadUtils;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class RootSetBuilder {
    private final AppView<? extends AppInfo> appView;
    private final DirectMappedDexApplication application;
    private final Iterable<? extends ProguardConfigurationRule> rules;
    private final Map<DexReference, Set<ProguardKeepRule>> noShrinking = new IdentityHashMap<DexReference, Set<ProguardKeepRule>>();
    private final Set<DexReference> noOptimization = Sets.newIdentityHashSet();
    private final Set<DexReference> noObfuscation = Sets.newIdentityHashSet();
    private final LinkedHashMap<DexReference, DexReference> reasonAsked = new LinkedHashMap();
    private final Set<DexReference> keepPackageName = Sets.newIdentityHashSet();
    private final Set<ProguardConfigurationRule> rulesThatUseExtendsOrImplementsWrong = Sets.newIdentityHashSet();
    private final Set<DexReference> checkDiscarded = Sets.newIdentityHashSet();
    private final Set<DexMethod> alwaysInline = Sets.newIdentityHashSet();
    private final Set<DexMethod> forceInline = Sets.newIdentityHashSet();
    private final Set<DexMethod> neverInline = Sets.newIdentityHashSet();
    private final Set<DexMethod> keepParametersWithConstantValue = Sets.newIdentityHashSet();
    private final Set<DexMethod> keepUnusedArguments = Sets.newIdentityHashSet();
    private final Set<DexType> neverClassInline = Sets.newIdentityHashSet();
    private final Set<DexType> neverMerge = Sets.newIdentityHashSet();
    private final Map<DexReference, Map<DexReference, Set<ProguardKeepRule>>> dependentNoShrinking = new IdentityHashMap<DexReference, Map<DexReference, Set<ProguardKeepRule>>>();
    private final Map<DexReference, ProguardMemberRule> noSideEffects = new IdentityHashMap<DexReference, ProguardMemberRule>();
    private final Map<DexReference, ProguardMemberRule> assumedValues = new IdentityHashMap<DexReference, ProguardMemberRule>();
    private final Set<DexReference> identifierNameStrings = Sets.newIdentityHashSet();
    private final InternalOptions options;
    private final DexStringCache dexStringCache = new DexStringCache();
    private final Set<ProguardIfRule> ifRules = Sets.newIdentityHashSet();

    public RootSetBuilder(AppView<? extends AppInfo> appView, DexApplication application, Iterable<? extends ProguardConfigurationRule> rules, InternalOptions options) {
        this.appView = appView;
        this.application = application.asDirect();
        this.rules = rules;
        this.options = options;
    }

    RootSetBuilder(AppView<? extends AppInfo> appView, Collection<ProguardIfRule> ifRules, InternalOptions options) {
        this(appView, appView.appInfo().app, ifRules, options);
    }

    private void process(DexClass clazz, ProguardConfigurationRule rule, ProguardIfRule ifRule) {
        if (!this.satisfyClassType(rule, clazz)) {
            return;
        }
        if (!RootSetBuilder.satisfyAccessFlag(rule, clazz)) {
            return;
        }
        if (!RootSetBuilder.satisfyAnnotation(rule, clazz)) {
            return;
        }
        if (rule.hasInheritanceClassName() && !this.satisfyInheritanceRule(clazz, rule)) {
            return;
        }
        if (rule.getClassNames().matches(clazz.type)) {
            List<ProguardMemberRule> memberKeepRules = rule.getMemberRules();
            if (rule instanceof ProguardKeepRule) {
                if (clazz.isLibraryClass()) {
                    return;
                }
                switch (((ProguardKeepRule)rule).getType()) {
                    case KEEP_CLASS_MEMBERS: {
                        ImmutableMap<Predicate<DexDefinition>, DexDefinition> preconditionSupplier = ImmutableMap.of(definition -> true, clazz);
                        this.markMatchingVisibleMethods(clazz, memberKeepRules, rule, preconditionSupplier, false);
                        this.markMatchingVisibleFields(clazz, memberKeepRules, rule, preconditionSupplier, false);
                        break;
                    }
                    case KEEP_CLASSES_WITH_MEMBERS: {
                        if (!this.allRulesSatisfied(memberKeepRules, clazz)) break;
                    }
                    case KEEP: {
                        this.markClass(clazz, rule);
                        HashMap<Predicate<DexDefinition>, DexDefinition> preconditionSupplier = new HashMap<Predicate<DexDefinition>, DexDefinition>();
                        if (ifRule != null) {
                            preconditionSupplier.put(DexDefinition::isStaticMember, null);
                            preconditionSupplier.put(definition -> !definition.isStaticMember(), clazz);
                        } else {
                            preconditionSupplier.put(definition -> true, null);
                        }
                        this.markMatchingVisibleMethods(clazz, memberKeepRules, rule, preconditionSupplier, false);
                        this.markMatchingVisibleFields(clazz, memberKeepRules, rule, preconditionSupplier, false);
                        break;
                    }
                    case CONDITIONAL: {
                        throw new Unreachable("-if rule will be evaluated separately, not here.");
                    }
                }
            } else {
                if (rule instanceof ProguardIfRule) {
                    throw new Unreachable("-if rule will be evaluated separately, not here.");
                }
                if (rule instanceof ProguardCheckDiscardRule) {
                    if (memberKeepRules.isEmpty()) {
                        this.markClass(clazz, rule);
                    } else {
                        ImmutableMap<Predicate<DexDefinition>, DexDefinition> preconditionSupplier = ImmutableMap.of(definition -> true, clazz);
                        this.markMatchingFields(clazz, memberKeepRules, rule, preconditionSupplier);
                        this.markMatchingMethods(clazz, memberKeepRules, rule, preconditionSupplier);
                    }
                } else if (rule instanceof ProguardWhyAreYouKeepingRule || rule instanceof ProguardKeepPackageNamesRule) {
                    this.markClass(clazz, rule);
                    this.markMatchingVisibleMethods(clazz, memberKeepRules, rule, null, true);
                    this.markMatchingVisibleFields(clazz, memberKeepRules, rule, null, true);
                } else if (rule instanceof ProguardAssumeNoSideEffectRule) {
                    this.markMatchingVisibleMethods(clazz, memberKeepRules, rule, null, true);
                    this.markMatchingVisibleFields(clazz, memberKeepRules, rule, null, true);
                } else if (rule instanceof ClassMergingRule) {
                    if (this.allRulesSatisfied(memberKeepRules, clazz)) {
                        this.markClass(clazz, rule);
                    }
                } else if (rule instanceof InlineRule || rule instanceof ConstantArgumentRule || rule instanceof UnusedArgumentRule) {
                    this.markMatchingMethods(clazz, memberKeepRules, rule, null);
                } else if (rule instanceof ClassInlineRule) {
                    if (this.allRulesSatisfied(memberKeepRules, clazz)) {
                        this.markClass(clazz, rule);
                    }
                } else if (rule instanceof ProguardAssumeValuesRule) {
                    this.markMatchingVisibleMethods(clazz, memberKeepRules, rule, null, true);
                    this.markMatchingVisibleFields(clazz, memberKeepRules, rule, null, true);
                } else {
                    assert (rule instanceof ProguardIdentifierNameStringRule);
                    this.markMatchingFields(clazz, memberKeepRules, rule, null);
                    this.markMatchingMethods(clazz, memberKeepRules, rule, null);
                }
            }
        }
    }

    private void runPerRule(ExecutorService executorService, List<Future<?>> futures, ProguardConfigurationRule rule, ProguardIfRule ifRule) {
        List<DexType> specifics = rule.getClassNames().asSpecificDexTypes();
        if (specifics != null) {
            for (DexType type : specifics) {
                DexClass clazz = this.application.definitionFor(type);
                if (clazz == null) continue;
                this.process(clazz, rule, ifRule);
            }
        } else {
            futures.add(executorService.submit(() -> {
                for (DexProgramClass dexProgramClass : this.application.classes()) {
                    this.process(dexProgramClass, rule, ifRule);
                }
                if (rule.applyToLibraryClasses()) {
                    for (DexLibraryClass dexLibraryClass : this.application.libraryClasses()) {
                        this.process(dexLibraryClass, rule, ifRule);
                    }
                }
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RootSet run(ExecutorService executorService) throws ExecutionException {
        this.application.timing.begin("Build root set...");
        try {
            ArrayList futures = new ArrayList();
            if (this.rules != null) {
                for (ProguardConfigurationRule proguardConfigurationRule : this.rules) {
                    if (proguardConfigurationRule instanceof ProguardIfRule) {
                        ProguardIfRule ifRule = (ProguardIfRule)proguardConfigurationRule;
                        this.ifRules.add(ifRule);
                        continue;
                    }
                    this.runPerRule(executorService, futures, proguardConfigurationRule, null);
                }
                ThreadUtils.awaitFutures(futures);
            }
        }
        finally {
            this.application.timing.end();
        }
        return new RootSet(this.noShrinking, this.noOptimization, this.noObfuscation, ImmutableList.copyOf(this.reasonAsked.values()), this.keepPackageName, this.checkDiscarded, this.alwaysInline, this.forceInline, this.neverInline, this.keepParametersWithConstantValue, this.keepUnusedArguments, this.neverClassInline, this.neverMerge, this.noSideEffects, this.assumedValues, this.dependentNoShrinking, this.identifierNameStrings, this.ifRules);
    }

    IfRuleEvaluator getIfRuleEvaluator(Set<DexEncodedField> liveFields, Set<DexEncodedMethod> liveMethods, Set<DexEncodedMethod> targetedMethods, ExecutorService executorService) {
        return new IfRuleEvaluator(liveFields, liveMethods, targetedMethods, executorService);
    }

    private static DexDefinition testAndGetPrecondition(DexDefinition definition, Map<Predicate<DexDefinition>, DexDefinition> preconditionSupplier) {
        if (preconditionSupplier == null) {
            return null;
        }
        DexDefinition precondition = null;
        boolean conditionEverMatched = false;
        for (Map.Entry<Predicate<DexDefinition>, DexDefinition> entry : preconditionSupplier.entrySet()) {
            if (!entry.getKey().test(definition)) continue;
            precondition = entry.getValue();
            conditionEverMatched = true;
            break;
        }
        assert (conditionEverMatched);
        return precondition;
    }

    private void markMatchingVisibleMethods(DexClass clazz, Collection<ProguardMemberRule> memberKeepRules, ProguardConfigurationRule rule, Map<Predicate<DexDefinition>, DexDefinition> preconditionSupplier, boolean includeLibraryClasses) {
        HashSet methodsMarked = this.options.forceProguardCompatibility ? null : new HashSet();
        DexClass startingClass = clazz;
        while (clazz != null) {
            if (!includeLibraryClasses && clazz.isLibraryClass()) {
                return;
            }
            if (clazz == startingClass || this.options.forceProguardCompatibility) {
                clazz.directMethods().forEach(method -> {
                    DexDefinition precondition = RootSetBuilder.testAndGetPrecondition(method, preconditionSupplier);
                    this.markMethod((DexEncodedMethod)method, memberKeepRules, methodsMarked, rule, precondition);
                });
            }
            clazz.virtualMethods().forEach(method -> {
                DexDefinition precondition = RootSetBuilder.testAndGetPrecondition(method, preconditionSupplier);
                this.markMethod((DexEncodedMethod)method, memberKeepRules, methodsMarked, rule, precondition);
            });
            clazz = clazz.superType == null ? null : this.application.definitionFor(clazz.superType);
        }
    }

    private void markMatchingMethods(DexClass clazz, Collection<ProguardMemberRule> memberKeepRules, ProguardConfigurationRule rule, Map<Predicate<DexDefinition>, DexDefinition> preconditionSupplier) {
        clazz.forEachMethod(method -> {
            DexDefinition precondition = RootSetBuilder.testAndGetPrecondition(method, preconditionSupplier);
            this.markMethod((DexEncodedMethod)method, memberKeepRules, null, rule, precondition);
        });
    }

    private void markMatchingVisibleFields(DexClass clazz, Collection<ProguardMemberRule> memberKeepRules, ProguardConfigurationRule rule, Map<Predicate<DexDefinition>, DexDefinition> preconditionSupplier, boolean includeLibraryClasses) {
        while (clazz != null) {
            if (!includeLibraryClasses && clazz.isLibraryClass()) {
                return;
            }
            clazz.forEachField(field -> {
                DexDefinition precondition = RootSetBuilder.testAndGetPrecondition(field, preconditionSupplier);
                this.markField((DexEncodedField)field, memberKeepRules, rule, precondition);
            });
            clazz = clazz.superType == null ? null : this.application.definitionFor(clazz.superType);
        }
    }

    private void markMatchingFields(DexClass clazz, Collection<ProguardMemberRule> memberKeepRules, ProguardConfigurationRule rule, Map<Predicate<DexDefinition>, DexDefinition> preconditionSupplier) {
        clazz.forEachField(field -> {
            DexDefinition precondition = RootSetBuilder.testAndGetPrecondition(field, preconditionSupplier);
            this.markField((DexEncodedField)field, memberKeepRules, rule, precondition);
        });
    }

    public static void writeSeeds(Enqueuer.AppInfoWithLiveness appInfo, PrintStream out, Predicate<DexType> include) {
        for (DexReference seed : appInfo.getPinnedItems()) {
            if (seed.isDexType()) {
                if (!include.test(seed.asDexType())) continue;
                out.println(seed.toSourceString());
                continue;
            }
            if (seed.isDexField()) {
                DexField field = seed.asDexField();
                if (!include.test(field.clazz)) continue;
                out.println(field.clazz.toSourceString() + ": " + field.type.toSourceString() + " " + field.name.toSourceString());
                continue;
            }
            assert (seed.isDexMethod());
            DexMethod method = seed.asDexMethod();
            if (!include.test(method.holder)) continue;
            out.print(method.holder.toSourceString() + ": ");
            DexEncodedMethod encodedMethod = appInfo.definitionFor(method);
            if (encodedMethod.accessFlags.isConstructor()) {
                if (encodedMethod.accessFlags.isStatic()) {
                    out.print("<clinit>");
                } else {
                    String holderName = method.holder.toSourceString();
                    String constrName = holderName.substring(holderName.lastIndexOf(46) + 1);
                    out.print(constrName);
                }
            } else {
                out.print(method.proto.returnType.toSourceString() + " " + method.name.toSourceString());
            }
            boolean first = true;
            out.print("(");
            for (DexType param : method.proto.parameters.values) {
                if (!first) {
                    out.print(",");
                }
                first = false;
                out.print(param.toSourceString());
            }
            out.println(")");
        }
        out.close();
    }

    private boolean satisfyClassType(ProguardConfigurationRule rule, DexClass clazz) {
        return rule.getClassType().matches(clazz) != rule.getClassTypeNegated();
    }

    private static boolean satisfyAccessFlag(ProguardConfigurationRule rule, DexClass clazz) {
        return rule.getClassAccessFlags().containsAll(clazz.accessFlags) && rule.getNegatedClassAccessFlags().containsNone(clazz.accessFlags);
    }

    private static boolean satisfyAnnotation(ProguardConfigurationRule rule, DexClass clazz) {
        return RootSetBuilder.containsAnnotation(rule.getClassAnnotation(), clazz.annotations);
    }

    private boolean satisfyInheritanceRule(DexClass clazz, ProguardConfigurationRule rule) {
        boolean extendsExpected = this.satisfyExtendsRule(clazz, rule);
        boolean implementsExpected = false;
        if (!extendsExpected) {
            implementsExpected = this.satisfyImplementsRule(clazz, rule);
        }
        if (extendsExpected || implementsExpected) {
            if (rule.getInheritanceClassName().matchesSpecificType()) {
                if (rule.getInheritanceIsExtends()) {
                    if (implementsExpected && this.rulesThatUseExtendsOrImplementsWrong.add(rule)) {
                        assert (this.options.testing.allowProguardRulesThatUseExtendsOrImplementsWrong);
                        this.options.reporter.warning(new StringDiagnostic("The rule `" + rule + "` uses extends but actually matches implements."));
                    }
                } else if (extendsExpected && this.rulesThatUseExtendsOrImplementsWrong.add(rule)) {
                    assert (this.options.testing.allowProguardRulesThatUseExtendsOrImplementsWrong);
                    this.options.reporter.warning(new StringDiagnostic("The rule `" + rule + "` uses implements but actually matches extends."));
                }
            }
            return true;
        }
        return false;
    }

    private boolean satisfyExtendsRule(DexClass clazz, ProguardConfigurationRule rule) {
        if (this.anySuperTypeMatchesExtendsRule(clazz.superType, rule)) {
            return true;
        }
        return this.anySourceMatchesInheritanceRuleDirectly(clazz, rule, false);
    }

    private boolean anySuperTypeMatchesExtendsRule(DexType type, ProguardConfigurationRule rule) {
        while (type != null) {
            DexClass clazz = this.application.definitionFor(type);
            if (clazz == null) {
                return false;
            }
            if (rule.getInheritanceClassName().matches(clazz.type, this.appView) && RootSetBuilder.containsAnnotation(rule.getInheritanceAnnotation(), clazz.annotations)) {
                return true;
            }
            type = clazz.superType;
        }
        return false;
    }

    private boolean satisfyImplementsRule(DexClass clazz, ProguardConfigurationRule rule) {
        if (this.anyImplementedInterfaceMatchesImplementsRule(clazz, rule)) {
            return true;
        }
        return this.anySourceMatchesInheritanceRuleDirectly(clazz, rule, true);
    }

    private boolean anyImplementedInterfaceMatchesImplementsRule(DexClass clazz, ProguardConfigurationRule rule) {
        if (clazz == null) {
            return false;
        }
        for (DexType iface : clazz.interfaces.values) {
            DexClass ifaceClass = this.application.definitionFor(iface);
            if (ifaceClass == null) {
                return false;
            }
            if (rule.getInheritanceClassName().matches(iface, this.appView) && RootSetBuilder.containsAnnotation(rule.getInheritanceAnnotation(), ifaceClass.annotations)) {
                return true;
            }
            if (!this.anyImplementedInterfaceMatchesImplementsRule(ifaceClass, rule)) continue;
            return true;
        }
        if (clazz.superType == null) {
            return false;
        }
        DexClass superClass = this.application.definitionFor(clazz.superType);
        if (superClass == null) {
            return false;
        }
        return this.anyImplementedInterfaceMatchesImplementsRule(superClass, rule);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean anySourceMatchesInheritanceRuleDirectly(DexClass clazz, ProguardConfigurationRule rule, boolean isInterface) {
        if (this.appView.verticallyMergedClasses() == null) return false;
        if (!this.appView.verticallyMergedClasses().getSourcesFor(clazz.type).stream().filter(sourceType -> this.appView.appInfo().definitionFor((DexType)sourceType).accessFlags.isInterface() == isInterface).anyMatch(rule.getInheritanceClassName()::matches)) return false;
        return true;
    }

    private boolean allRulesSatisfied(Collection<ProguardMemberRule> memberKeepRules, DexClass clazz) {
        for (ProguardMemberRule rule : memberKeepRules) {
            if (this.ruleSatisfied(rule, clazz)) continue;
            return false;
        }
        return true;
    }

    private boolean ruleSatisfied(ProguardMemberRule rule, DexClass clazz) {
        return this.ruleSatisfiedByMethods(rule, clazz.directMethods()) || this.ruleSatisfiedByMethods(rule, clazz.virtualMethods()) || this.ruleSatisfiedByFields(rule, clazz.staticFields()) || this.ruleSatisfiedByFields(rule, clazz.instanceFields());
    }

    private boolean ruleSatisfiedByMethods(ProguardMemberRule rule, Iterable<DexEncodedMethod> methods) {
        if (rule.getRuleType().includesMethods()) {
            for (DexEncodedMethod method : methods) {
                if (!rule.matches(method, this.appView, this.dexStringCache)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean ruleSatisfiedByMethods(ProguardMemberRule rule, DexEncodedMethod[] methods) {
        return this.ruleSatisfiedByMethods(rule, Arrays.asList(methods));
    }

    private boolean ruleSatisfiedByFields(ProguardMemberRule rule, Iterable<DexEncodedField> fields) {
        if (rule.getRuleType().includesFields()) {
            for (DexEncodedField field : fields) {
                if (!rule.matches(field, this.appView, this.dexStringCache)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean ruleSatisfiedByFields(ProguardMemberRule rule, DexEncodedField[] fields) {
        return this.ruleSatisfiedByFields(rule, Arrays.asList(fields));
    }

    static boolean containsAnnotation(ProguardTypeMatcher classAnnotation, DexAnnotationSet annotations) {
        if (classAnnotation == null) {
            return true;
        }
        if (annotations.isEmpty()) {
            return false;
        }
        for (DexAnnotation annotation : annotations.annotations) {
            if (!classAnnotation.matches(annotation.annotation.type)) continue;
            return true;
        }
        return false;
    }

    private void markMethod(DexEncodedMethod method, Collection<ProguardMemberRule> rules, Set<Equivalence.Wrapper<DexMethod>> methodsMarked, ProguardConfigurationRule context, DexDefinition precondition) {
        if (methodsMarked != null && methodsMarked.contains(MethodSignatureEquivalence.get().wrap(method.method))) {
            return;
        }
        for (ProguardMemberRule rule : rules) {
            if (!rule.matches(method, this.appView, this.dexStringCache)) continue;
            if (methodsMarked != null) {
                methodsMarked.add(MethodSignatureEquivalence.get().wrap(method.method));
            }
            this.addItemToSets(method, context, rule, precondition);
        }
    }

    private void markField(DexEncodedField field, Collection<ProguardMemberRule> rules, ProguardConfigurationRule context, DexDefinition precondition) {
        for (ProguardMemberRule rule : rules) {
            if (!rule.matches(field, this.appView, this.dexStringCache)) continue;
            this.addItemToSets(field, context, rule, precondition);
        }
    }

    private void markClass(DexClass clazz, ProguardConfigurationRule rule) {
        this.addItemToSets(clazz, rule, null, null);
    }

    private void includeDescriptor(DexDefinition item, DexType type, ProguardKeepRule context) {
        if (type.isVoidType()) {
            return;
        }
        if (type.isArrayType()) {
            type = type.toBaseType(this.application.dexItemFactory);
        }
        if (type.isPrimitiveType()) {
            return;
        }
        DexClass definition = this.appView.appInfo().definitionFor(type);
        if (definition == null || definition.isLibraryClass()) {
            return;
        }
        this.dependentNoShrinking.computeIfAbsent(item.toReference(), x -> new IdentityHashMap()).computeIfAbsent(type, k -> new HashSet()).add(context);
        this.noObfuscation.add(type);
    }

    private void includeDescriptorClasses(DexDefinition item, ProguardKeepRule context) {
        if (item.isDexEncodedMethod()) {
            DexMethod method = item.asDexEncodedMethod().method;
            this.includeDescriptor(item, method.proto.returnType, context);
            for (DexType value : method.proto.parameters.values) {
                this.includeDescriptor(item, value, context);
            }
        } else if (item.isDexEncodedField()) {
            DexField field = item.asDexEncodedField().field;
            this.includeDescriptor(item, field.type, context);
        } else assert (item.isDexClass());
    }

    private synchronized void addItemToSets(DexDefinition item, ProguardConfigurationRule context, ProguardMemberRule rule, DexDefinition precondition) {
        block33: {
            block41: {
                block40: {
                    block39: {
                        block38: {
                            block37: {
                                block36: {
                                    block35: {
                                        block34: {
                                            block32: {
                                                if (!(context instanceof ProguardKeepRule)) break block32;
                                                if (item.isDexEncodedMethod()) {
                                                    DexClass holder;
                                                    DexEncodedMethod encodedMethod = item.asDexEncodedMethod();
                                                    if (encodedMethod.method.isLambdaDeserializeMethod(this.appView.dexItemFactory())) {
                                                        return;
                                                    }
                                                    if (this.options.isInterfaceMethodDesugaringEnabled() && encodedMethod.hasCode() && (encodedMethod.isPrivateMethod() || encodedMethod.isStaticMember()) && (holder = this.appView.appInfo().definitionFor(encodedMethod.method.getHolder())) != null && holder.isInterface()) {
                                                        if (rule.isSpecific()) {
                                                            this.options.reporter.warning(new StringDiagnostic("The rule `" + rule + "` is ignored because the targeting interface method `" + encodedMethod.method.toSourceString() + "` will be desugared."));
                                                        }
                                                        return;
                                                    }
                                                }
                                                ProguardKeepRule keepRule = (ProguardKeepRule)context;
                                                ProguardKeepRuleModifiers modifiers = keepRule.getModifiers();
                                                if (!modifiers.allowsShrinking) {
                                                    if (precondition != null) {
                                                        this.dependentNoShrinking.computeIfAbsent(precondition.toReference(), x -> new IdentityHashMap()).computeIfAbsent(item.toReference(), i -> new HashSet()).add(keepRule);
                                                    } else {
                                                        this.noShrinking.computeIfAbsent(item.toReference(), i -> new HashSet()).add(keepRule);
                                                    }
                                                }
                                                if (!modifiers.allowsOptimization) {
                                                    this.noOptimization.add(item.toReference());
                                                }
                                                if (!modifiers.allowsObfuscation) {
                                                    this.noObfuscation.add(item.toReference());
                                                }
                                                if (modifiers.includeDescriptorClasses) {
                                                    this.includeDescriptorClasses(item, keepRule);
                                                }
                                                break block33;
                                            }
                                            if (!(context instanceof ProguardAssumeNoSideEffectRule)) break block34;
                                            this.noSideEffects.put(item.toReference(), rule);
                                            break block33;
                                        }
                                        if (!(context instanceof ProguardWhyAreYouKeepingRule)) break block35;
                                        this.reasonAsked.computeIfAbsent(item.toReference(), i -> i);
                                        break block33;
                                    }
                                    if (!(context instanceof ProguardKeepPackageNamesRule)) break block36;
                                    this.keepPackageName.add(item.toReference());
                                    break block33;
                                }
                                if (!(context instanceof ProguardAssumeValuesRule)) break block37;
                                this.assumedValues.put(item.toReference(), rule);
                                break block33;
                            }
                            if (!(context instanceof ProguardCheckDiscardRule)) break block38;
                            this.checkDiscarded.add(item.toReference());
                            break block33;
                        }
                        if (!(context instanceof InlineRule)) break block39;
                        if (!item.isDexEncodedMethod()) break block33;
                        switch (((InlineRule)context).getType()) {
                            case ALWAYS: {
                                this.alwaysInline.add(item.asDexEncodedMethod().method);
                                break block33;
                            }
                            case FORCE: {
                                this.forceInline.add(item.asDexEncodedMethod().method);
                                break block33;
                            }
                            case NEVER: {
                                this.neverInline.add(item.asDexEncodedMethod().method);
                                break block33;
                            }
                            default: {
                                throw new Unreachable();
                            }
                        }
                    }
                    if (!(context instanceof ClassInlineRule)) break block40;
                    switch (((ClassInlineRule)context).getType()) {
                        case NEVER: {
                            if (item.isDexClass()) {
                                this.neverClassInline.add(item.asDexClass().type);
                            }
                            break block33;
                        }
                        default: {
                            throw new Unreachable();
                        }
                    }
                }
                if (!(context instanceof ClassMergingRule)) break block41;
                switch (((ClassMergingRule)context).getType()) {
                    case NEVER: {
                        if (item.isDexClass()) {
                            this.neverMerge.add(item.asDexClass().type);
                        }
                        break block33;
                    }
                    default: {
                        throw new Unreachable();
                    }
                }
            }
            if (context instanceof ProguardIdentifierNameStringRule) {
                if (item.isDexEncodedField()) {
                    this.identifierNameStrings.add(item.asDexEncodedField().field);
                } else if (item.isDexEncodedMethod()) {
                    this.identifierNameStrings.add(item.asDexEncodedMethod().method);
                }
            } else if (context instanceof ConstantArgumentRule) {
                if (item.isDexEncodedMethod()) {
                    this.keepParametersWithConstantValue.add(item.asDexEncodedMethod().method);
                }
            } else if (context instanceof UnusedArgumentRule && item.isDexEncodedMethod()) {
                this.keepUnusedArguments.add(item.asDexEncodedMethod().method);
            }
        }
    }

    static class ConsequentRootSet {
        final Set<DexMethod> neverInline;
        final Set<DexType> neverClassInline;
        final Map<DexReference, Set<ProguardKeepRule>> noShrinking;
        final Set<DexReference> noOptimization;
        final Set<DexReference> noObfuscation;
        final Map<DexReference, Map<DexReference, Set<ProguardKeepRule>>> dependentNoShrinking;

        private ConsequentRootSet(Set<DexMethod> neverInline, Set<DexType> neverClassInline, Map<DexReference, Set<ProguardKeepRule>> noShrinking, Set<DexReference> noOptimization, Set<DexReference> noObfuscation, Map<DexReference, Map<DexReference, Set<ProguardKeepRule>>> dependentNoShrinking) {
            this.neverInline = Collections.unmodifiableSet(neverInline);
            this.neverClassInline = Collections.unmodifiableSet(neverClassInline);
            this.noShrinking = Collections.unmodifiableMap(noShrinking);
            this.noOptimization = Collections.unmodifiableSet(noOptimization);
            this.noObfuscation = Collections.unmodifiableSet(noObfuscation);
            this.dependentNoShrinking = Collections.unmodifiableMap(dependentNoShrinking);
        }
    }

    public static class RootSet {
        public final Map<DexReference, Set<ProguardKeepRule>> noShrinking;
        public final Set<DexReference> noOptimization;
        public final Set<DexReference> noObfuscation;
        public final ImmutableList<DexReference> reasonAsked;
        public final Set<DexReference> keepPackageName;
        public final Set<DexReference> checkDiscarded;
        public final Set<DexMethod> alwaysInline;
        public final Set<DexMethod> forceInline;
        public final Set<DexMethod> neverInline;
        public final Set<DexMethod> keepConstantArguments;
        public final Set<DexMethod> keepUnusedArguments;
        public final Set<DexType> neverClassInline;
        public final Set<DexType> neverMerge;
        public final Map<DexReference, ProguardMemberRule> noSideEffects;
        public final Map<DexReference, ProguardMemberRule> assumedValues;
        private final Map<DexReference, Map<DexReference, Set<ProguardKeepRule>>> dependentNoShrinking;
        public final Set<DexReference> identifierNameStrings;
        public final Set<ProguardIfRule> ifRules;

        private RootSet(Map<DexReference, Set<ProguardKeepRule>> noShrinking, Set<DexReference> noOptimization, Set<DexReference> noObfuscation, ImmutableList<DexReference> reasonAsked, Set<DexReference> keepPackageName, Set<DexReference> checkDiscarded, Set<DexMethod> alwaysInline, Set<DexMethod> forceInline, Set<DexMethod> neverInline, Set<DexMethod> keepConstantArguments, Set<DexMethod> keepUnusedArguments, Set<DexType> neverClassInline, Set<DexType> neverMerge, Map<DexReference, ProguardMemberRule> noSideEffects, Map<DexReference, ProguardMemberRule> assumedValues, Map<DexReference, Map<DexReference, Set<ProguardKeepRule>>> dependentNoShrinking, Set<DexReference> identifierNameStrings, Set<ProguardIfRule> ifRules) {
            this.noShrinking = noShrinking;
            this.noOptimization = noOptimization;
            this.noObfuscation = noObfuscation;
            this.reasonAsked = reasonAsked;
            this.keepPackageName = Collections.unmodifiableSet(keepPackageName);
            this.checkDiscarded = Collections.unmodifiableSet(checkDiscarded);
            this.alwaysInline = Collections.unmodifiableSet(alwaysInline);
            this.forceInline = Collections.unmodifiableSet(forceInline);
            this.neverInline = neverInline;
            this.keepConstantArguments = keepConstantArguments;
            this.keepUnusedArguments = keepUnusedArguments;
            this.neverClassInline = neverClassInline;
            this.neverMerge = Collections.unmodifiableSet(neverMerge);
            this.noSideEffects = noSideEffects;
            this.assumedValues = assumedValues;
            this.dependentNoShrinking = dependentNoShrinking;
            this.identifierNameStrings = Collections.unmodifiableSet(identifierNameStrings);
            this.ifRules = Collections.unmodifiableSet(ifRules);
        }

        private RootSet(RootSet previous, GraphLense lense) {
            this.noShrinking = GraphLense.rewriteMutableReferenceKeys(previous.noShrinking, lense::lookupReference);
            this.noOptimization = lense.rewriteMutableReferencesConservatively(previous.noOptimization);
            this.noObfuscation = lense.rewriteMutableReferencesConservatively(previous.noObfuscation);
            this.reasonAsked = lense.rewriteReferencesConservatively(previous.reasonAsked);
            this.keepPackageName = lense.rewriteReferencesConservatively(previous.keepPackageName);
            this.checkDiscarded = lense.rewriteReferencesConservatively(previous.checkDiscarded);
            this.alwaysInline = lense.rewriteMethodsConservatively(previous.alwaysInline);
            this.forceInline = lense.rewriteMethodsConservatively(previous.forceInline);
            this.neverInline = lense.rewriteMutableMethodsConservatively(previous.neverInline);
            this.keepConstantArguments = lense.rewriteMutableMethodsConservatively(previous.keepConstantArguments);
            this.keepUnusedArguments = lense.rewriteMutableMethodsConservatively(previous.keepUnusedArguments);
            this.neverClassInline = lense.rewriteMutableTypesConservatively(previous.neverClassInline);
            this.neverMerge = lense.rewriteTypesConservatively(previous.neverMerge);
            this.noSideEffects = GraphLense.rewriteMutableReferenceKeys(previous.noSideEffects, lense::lookupReference);
            this.assumedValues = GraphLense.rewriteMutableReferenceKeys(previous.assumedValues, lense::lookupReference);
            this.dependentNoShrinking = RootSet.rewriteDependentReferenceKeys(previous.dependentNoShrinking, lense::lookupReference);
            this.identifierNameStrings = lense.rewriteReferencesConservatively(previous.identifierNameStrings);
            this.ifRules = Collections.unmodifiableSet(previous.ifRules);
        }

        public RootSet rewrittenWithLense(GraphLense lense) {
            return new RootSet(this, lense);
        }

        private static <T extends DexReference, S> Map<T, Map<T, S>> rewriteDependentReferenceKeys(Map<T, Map<T, S>> original, Function<T, T> rewrite) {
            IdentityHashMap<DexReference, ImmutableMap<T, S>> result = new IdentityHashMap<DexReference, ImmutableMap<T, S>>();
            for (DexReference item : original.keySet()) {
                result.put((DexReference)rewrite.apply(item), GraphLense.rewriteReferenceKeys(original.get(item), rewrite));
            }
            return result;
        }

        void addConsequentRootSet(ConsequentRootSet consequentRootSet) {
            this.neverInline.addAll(consequentRootSet.neverInline);
            this.neverClassInline.addAll(consequentRootSet.neverClassInline);
            this.noOptimization.addAll(consequentRootSet.noOptimization);
            this.noObfuscation.addAll(consequentRootSet.noObfuscation);
            this.addDependentItems(consequentRootSet.dependentNoShrinking);
        }

        private void addDependentItems(Map<DexReference, Map<DexReference, Set<ProguardKeepRule>>> dependentItems) {
            dependentItems.forEach((reference, dependence) -> this.dependentNoShrinking.computeIfAbsent((DexReference)reference, x -> new IdentityHashMap()).putAll(dependence));
        }

        Map<DexReference, Set<ProguardKeepRule>> getDependentItems(DexDefinition item) {
            return Collections.unmodifiableMap(this.dependentNoShrinking.getOrDefault(item.toReference(), Collections.emptyMap()));
        }

        public void copy(DexReference original, DexReference rewritten) {
            if (this.noShrinking.containsKey(original)) {
                this.noShrinking.put(rewritten, this.noShrinking.get(original));
            }
            if (this.noOptimization.contains(original)) {
                this.noOptimization.add(rewritten);
            }
            if (this.noObfuscation.contains(original)) {
                this.noObfuscation.add(rewritten);
            }
            if (this.noSideEffects.containsKey(original)) {
                this.noSideEffects.put(rewritten, this.noSideEffects.get(original));
            }
            if (this.assumedValues.containsKey(original)) {
                this.assumedValues.put(rewritten, this.assumedValues.get(original));
            }
        }

        public void prune(DexReference reference) {
            this.noShrinking.remove(reference);
            this.noOptimization.remove(reference);
            this.noObfuscation.remove(reference);
            this.noSideEffects.remove(reference);
            this.assumedValues.remove(reference);
        }

        public void move(DexReference original, DexReference rewritten) {
            this.copy(original, rewritten);
            this.prune(original);
        }

        public boolean verifyKeptFieldsAreAccessedAndLive(Enqueuer.AppInfoWithLiveness appInfo) {
            for (DexReference reference : this.noShrinking.keySet()) {
                DexField field;
                DexEncodedField encodedField;
                if (reference.isDexField() && (encodedField = appInfo.definitionFor(field = reference.asDexField())) != null && (encodedField.isStatic() || this.isKeptDirectlyOrIndirectly(field.clazz, appInfo))) assert (appInfo.liveFields.contains(field)) : "Expected kept field `" + field.toSourceString() + "` to be live";
            }
            return true;
        }

        public boolean verifyKeptMethodsAreTargetedAndLive(Enqueuer.AppInfoWithLiveness appInfo) {
            for (DexReference reference : this.noShrinking.keySet()) {
                if (!reference.isDexMethod()) continue;
                DexMethod method = reference.asDexMethod();
                assert (appInfo.targetedMethods.contains(method)) : "Expected kept method `" + method.toSourceString() + "` to be targeted";
                DexEncodedMethod encodedMethod = appInfo.definitionFor(method);
                if (!encodedMethod.accessFlags.isAbstract() && this.isKeptDirectlyOrIndirectly(method.holder, appInfo)) assert (appInfo.liveMethods.contains(method)) : "Expected non-abstract kept method `" + method.toSourceString() + "` to be live";
            }
            return true;
        }

        public boolean verifyKeptTypesAreLive(Enqueuer.AppInfoWithLiveness appInfo) {
            for (DexReference reference : this.noShrinking.keySet()) {
                if (!reference.isDexType()) continue;
                DexType type = reference.asDexType();
                assert (appInfo.liveTypes.contains(type)) : "Expected kept type `" + type.toSourceString() + "` to be live";
            }
            return true;
        }

        private boolean isKeptDirectlyOrIndirectly(DexType type, Enqueuer.AppInfoWithLiveness appInfo) {
            if (this.noShrinking.containsKey(type)) {
                return true;
            }
            DexClass clazz = appInfo.definitionFor(type);
            if (clazz == null) {
                return false;
            }
            if (clazz.superType != null) {
                return this.isKeptDirectlyOrIndirectly(clazz.superType, appInfo);
            }
            return false;
        }

        public boolean verifyKeptItemsAreKept(DexApplication application, AppInfo appInfo) {
            Set<DexReference> pinnedItems = appInfo.hasLiveness() ? appInfo.withLiveness().pinnedItems : null;
            IdentityHashMap<DexType, Set> requiredReferencesPerType = new IdentityHashMap<DexType, Set>();
            for (DexReference dexReference : this.noShrinking.keySet()) {
                assert (pinnedItems == null || pinnedItems.contains(dexReference)) : "Expected reference `" + dexReference.toSourceString() + "` to be pinned";
                if (dexReference.isDexType()) {
                    DexType type = dexReference.asDexType();
                    requiredReferencesPerType.putIfAbsent(type, Sets.newIdentityHashSet());
                    continue;
                }
                assert (dexReference.isDexField() || dexReference.isDexMethod());
                Descriptor descriptor = dexReference.asDescriptor();
                requiredReferencesPerType.computeIfAbsent(descriptor.getHolder(), key -> Sets.newIdentityHashSet()).add(dexReference);
            }
            for (DexProgramClass dexProgramClass : application.classes()) {
                Set requiredReferences = requiredReferencesPerType.getOrDefault(dexProgramClass.type, ImmutableSet.of());
                Set fields = null;
                Set methods = null;
                for (DexReference requiredReference : requiredReferences) {
                    if (requiredReference.isDexField()) {
                        DexField requiredField = requiredReference.asDexField();
                        if (fields == null) {
                            fields = Streams.stream(dexProgramClass.fields()).map(DexEncodedField::getKey).collect(Collectors.toSet());
                        }
                        assert (fields.contains(requiredField)) : "Expected field `" + requiredField.toSourceString() + "` from the root set to be present";
                        continue;
                    }
                    if (requiredReference.isDexMethod()) {
                        DexMethod requiredMethod = requiredReference.asDexMethod();
                        if (methods == null) {
                            methods = Streams.stream(dexProgramClass.methods()).map(DexEncodedMethod::getKey).collect(Collectors.toSet());
                        }
                        assert (methods.contains(requiredMethod)) : "Expected method `" + requiredMethod.toSourceString() + "` from the root set to be present";
                        continue;
                    }
                    assert (false);
                }
                requiredReferencesPerType.remove(dexProgramClass.type);
            }
            if (!requiredReferencesPerType.isEmpty()) {
                DexType type = (DexType)requiredReferencesPerType.keySet().iterator().next();
                DexClass dexClass = application.definitionFor(type);
                assert (dexClass == null || dexClass.isProgramClass()) : "Unexpected library type in root set: `" + type + "`";
                assert (requiredReferencesPerType.isEmpty()) : "Expected type `" + type.toSourceString() + "` to be present";
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("RootSet");
            builder.append("\nnoShrinking: " + this.noShrinking.size());
            builder.append("\nnoOptimization: " + this.noOptimization.size());
            builder.append("\nnoObfuscation: " + this.noObfuscation.size());
            builder.append("\nreasonAsked: " + this.reasonAsked.size());
            builder.append("\nkeepPackageName: " + this.keepPackageName.size());
            builder.append("\ncheckDiscarded: " + this.checkDiscarded.size());
            builder.append("\nnoSideEffects: " + this.noSideEffects.size());
            builder.append("\nassumedValues: " + this.assumedValues.size());
            builder.append("\ndependentNoShrinking: " + this.dependentNoShrinking.size());
            builder.append("\nidentifierNameStrings: " + this.identifierNameStrings.size());
            builder.append("\nifRules: " + this.ifRules.size());
            builder.append("\n\nNo Shrinking:");
            this.noShrinking.keySet().stream().sorted(Comparator.comparing(DexItem::toSourceString)).forEach(a -> builder.append("\n").append(a.toSourceString()).append(" ").append(this.noShrinking.get(a)));
            builder.append("\n");
            return builder.toString();
        }
    }

    class IfRuleEvaluator {
        private final Set<DexEncodedField> liveFields;
        private final Set<DexEncodedMethod> liveMethods;
        private final Set<DexEncodedMethod> targetedMethods;
        private final ExecutorService executorService;
        private final List<Future<?>> futures = new ArrayList();

        public IfRuleEvaluator(Set<DexEncodedField> liveFields, Set<DexEncodedMethod> liveMethods, Set<DexEncodedMethod> targetedMethods, ExecutorService executorService) {
            this.liveFields = liveFields;
            this.liveMethods = liveMethods;
            this.targetedMethods = targetedMethods;
            this.executorService = executorService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ConsequentRootSet run(Set<DexType> liveTypes) throws ExecutionException {
            ((RootSetBuilder)RootSetBuilder.this).application.timing.begin("Find consequent items for -if rules...");
            try {
                if (RootSetBuilder.this.rules != null) {
                    for (ProguardConfigurationRule rule : RootSetBuilder.this.rules) {
                        assert (rule instanceof ProguardIfRule);
                        ProguardIfRule ifRule = (ProguardIfRule)rule;
                        for (DexType type : liveTypes) {
                            DexClass clazz = ((AppInfo)RootSetBuilder.this.appView.appInfo()).definitionFor(type);
                            if (clazz == null) continue;
                            this.evaluateIfRule(ifRule, clazz, clazz);
                            if (!((RootSetBuilder)RootSetBuilder.this).options.enableVerticalClassMerging || RootSetBuilder.this.appView.verticallyMergedClasses() == null) continue;
                            for (DexType sourceType : RootSetBuilder.this.appView.verticallyMergedClasses().getSourcesFor(type)) {
                                DexClass sourceClass = ((AppInfo)RootSetBuilder.this.appView.appInfo()).definitionFor(sourceType);
                                assert (sourceClass != null);
                                this.evaluateIfRule(ifRule, sourceClass, clazz);
                            }
                        }
                    }
                    ThreadUtils.awaitFutures(this.futures);
                }
            }
            finally {
                ((RootSetBuilder)RootSetBuilder.this).application.timing.end();
            }
            return new ConsequentRootSet(RootSetBuilder.this.neverInline, RootSetBuilder.this.neverClassInline, RootSetBuilder.this.noShrinking, RootSetBuilder.this.noOptimization, RootSetBuilder.this.noObfuscation, RootSetBuilder.this.dependentNoShrinking);
        }

        private void evaluateIfRule(ProguardIfRule rule, DexClass sourceClass, DexClass targetClass) {
            if (!RootSetBuilder.this.satisfyClassType(rule, sourceClass)) {
                return;
            }
            if (!RootSetBuilder.satisfyAccessFlag(rule, sourceClass)) {
                return;
            }
            if (!RootSetBuilder.satisfyAnnotation(rule, sourceClass)) {
                return;
            }
            if (!rule.getClassNames().matches(sourceClass.type)) {
                return;
            }
            if (rule.hasInheritanceClassName() && !RootSetBuilder.this.satisfyInheritanceRule(targetClass, rule)) {
                return;
            }
            List<ProguardMemberRule> memberKeepRules = rule.getMemberRules();
            if (memberKeepRules.isEmpty()) {
                this.materializeIfRule(rule);
                return;
            }
            Set filteredMembers = Sets.newIdentityHashSet();
            Iterables.addAll(filteredMembers, targetClass.fields(f -> this.liveFields.contains(f) && RootSetBuilder.this.appView.graphLense().getOriginalFieldSignature(f.field).getHolder() == sourceClass.type));
            Iterables.addAll(filteredMembers, targetClass.methods(m -> (this.liveMethods.contains(m) || this.targetedMethods.contains(m)) && RootSetBuilder.this.appView.graphLense().getOriginalMethodSignature(m.method).getHolder() == sourceClass.type));
            if (filteredMembers.size() < memberKeepRules.size()) {
                return;
            }
            Sets.combinations(filteredMembers, memberKeepRules.size()).forEach(combination -> {
                Collection fieldsInCombination = DexDefinition.filterDexEncodedField(combination.stream()).collect(Collectors.toList());
                Collection methodsInCombination = DexDefinition.filterDexEncodedMethod(combination.stream()).collect(Collectors.toList());
                boolean satisfied = memberKeepRules.stream().allMatch(memberRule -> RootSetBuilder.this.ruleSatisfiedByFields(memberRule, fieldsInCombination) || RootSetBuilder.this.ruleSatisfiedByMethods(memberRule, methodsInCombination));
                if (satisfied) {
                    this.materializeIfRule(rule);
                }
            });
        }

        private void materializeIfRule(ProguardIfRule rule) {
            InlineRule neverInlineRuleForCondition;
            ProguardIfRule materializedRule = rule.materialize();
            ClassInlineRule neverClassInlineRuleForCondition = materializedRule.neverClassInlineRuleForCondition();
            if (neverClassInlineRuleForCondition != null) {
                RootSetBuilder.this.runPerRule(this.executorService, this.futures, neverClassInlineRuleForCondition, materializedRule);
            }
            if ((neverInlineRuleForCondition = materializedRule.neverInlineRuleForCondition()) != null) {
                RootSetBuilder.this.runPerRule(this.executorService, this.futures, neverInlineRuleForCondition, materializedRule);
            }
            RootSetBuilder.this.runPerRule(this.executorService, this.futures, materializedRule.subsequentRule, materializedRule);
        }
    }
}

