/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.code.CfArrayStore;
import com.android.tools.r8.code.Aput;
import com.android.tools.r8.code.AputBoolean;
import com.android.tools.r8.code.AputByte;
import com.android.tools.r8.code.AputChar;
import com.android.tools.r8.code.AputObject;
import com.android.tools.r8.code.AputShort;
import com.android.tools.r8.code.AputWide;
import com.android.tools.r8.code.Format23x;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.ImpreciseMemberTypeInstruction;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.conversion.TypeConstraintResolver;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.ir.regalloc.RegisterAllocator;
import java.util.Arrays;

public class ArrayPut
extends Instruction
implements ImpreciseMemberTypeInstruction {
    private static final int ARRAY_INDEX = 0;
    private static final int INDEX_INDEX = 1;
    private static final int VALUE_INDEX = 2;
    private MemberType type;

    public ArrayPut(MemberType type, Value array, Value index, Value value) {
        super(null, Arrays.asList(array, index, value));
        assert (type != null);
        assert (array.verifyCompatible(ValueType.OBJECT));
        assert (index.verifyCompatible(ValueType.INT));
        this.type = type;
    }

    public Value array() {
        return (Value)this.inValues.get(0);
    }

    public Value index() {
        return (Value)this.inValues.get(1);
    }

    public Value value() {
        return (Value)this.inValues.get(2);
    }

    @Override
    public MemberType getMemberType() {
        return this.type;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Format23x instruction;
        int value = builder.allocatedRegister(this.value(), this.getNumber());
        int array = builder.allocatedRegister(this.array(), this.getNumber());
        int index = builder.allocatedRegister(this.index(), this.getNumber());
        switch (this.type) {
            case INT: 
            case FLOAT: {
                instruction = new Aput(value, array, index);
                break;
            }
            case LONG: 
            case DOUBLE: {
                instruction = new AputWide(value, array, index);
                break;
            }
            case OBJECT: {
                instruction = new AputObject(value, array, index);
                break;
            }
            case BOOLEAN: {
                instruction = new AputBoolean(value, array, index);
                break;
            }
            case BYTE: {
                instruction = new AputByte(value, array, index);
                break;
            }
            case CHAR: {
                instruction = new AputChar(value, array, index);
                break;
            }
            case SHORT: {
                instruction = new AputShort(value, array, index);
                break;
            }
            case INT_OR_FLOAT: 
            case LONG_OR_DOUBLE: {
                throw new Unreachable("Unexpected imprecise type: " + (Object)((Object)this.type));
            }
            default: {
                throw new Unreachable("Unexpected type: " + (Object)((Object)this.type));
            }
        }
        builder.add((Instruction)this, (com.android.tools.r8.code.Instruction)instruction);
    }

    @Override
    public int maxInValueRegister() {
        return 255;
    }

    @Override
    public int maxOutValueRegister() {
        assert (false) : "ArrayPut instructions define no values.";
        return 0;
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean instructionInstanceCanThrow() {
        Value newArraySizeValue;
        if (this.index().isConstant() && !this.array().isPhi() && this.array().definition.isNewArrayEmpty() && (newArraySizeValue = this.array().definition.asNewArrayEmpty().size()).isConstant()) {
            int newArraySize = newArraySizeValue.getConstInstruction().asConstNumber().getIntValue();
            int index = this.index().getConstInstruction().asConstNumber().getIntValue();
            return newArraySize <= 0 || index < 0 || newArraySize <= index;
        }
        return true;
    }

    @Override
    public boolean canBeDeadCode(AppInfo appInfo, IRCode code) {
        return false;
    }

    @Override
    public boolean identicalAfterRegisterAllocation(Instruction other, RegisterAllocator allocator) {
        return false;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isArrayPut() && other.asArrayPut().type == this.type;
    }

    @Override
    public boolean isArrayPut() {
        return true;
    }

    @Override
    public ArrayPut asArrayPut() {
        return this;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forArrayPut();
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
    }

    @Override
    public boolean hasInvariantOutType() {
        return true;
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfArrayStore(this.type));
    }

    @Override
    public boolean throwsNpeIfValueIsNull(Value value, DexItemFactory dexItemFactory) {
        return this.array() == value;
    }

    @Override
    public void constrainType(TypeConstraintResolver constraintResolver) {
        constraintResolver.constrainArrayMemberType(this.type, this.value(), this.array(), t -> {
            this.type = t;
        });
    }
}

