/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.com.google.common.base.Supplier;
import com.android.tools.r8.com.google.common.base.Suppliers;
import com.android.tools.r8.com.google.common.collect.ArrayListMultimap;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Maps;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.graph.ParameterUsagesInfo;
import com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.AlwaysMaterializingNop;
import com.android.tools.r8.ir.code.ArrayPut;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.Binop;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.CheckCast;
import com.android.tools.r8.ir.code.Cmp;
import com.android.tools.r8.ir.code.ConstInstruction;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.ConstString;
import com.android.tools.r8.ir.code.DebugLocalWrite;
import com.android.tools.r8.ir.code.DexItemBasedConstString;
import com.android.tools.r8.ir.code.DominatorTree;
import com.android.tools.r8.ir.code.Goto;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.InstanceOf;
import com.android.tools.r8.ir.code.InstancePut;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeNewArray;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.NewArrayEmpty;
import com.android.tools.r8.ir.code.NewArrayFilledData;
import com.android.tools.r8.ir.code.NewInstance;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.Return;
import com.android.tools.r8.ir.code.StaticGet;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.ir.code.Switch;
import com.android.tools.r8.ir.code.Throw;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.code.Xor;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.conversion.OptimizationFeedback;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.ReflectionOptimizer;
import com.android.tools.r8.ir.optimize.SwitchUtils;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceSortedMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntArrayList;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntList;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import com.android.tools.r8.kotlin.Kotlin;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.InternalOutputMode;
import com.android.tools.r8.utils.LongInterval;
import com.android.tools.r8.utils.MethodSignatureEquivalence;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public class CodeRewriter {
    private static final int MAX_FILL_ARRAY_SIZE = 8192;
    private static final int STOP_SHARED_CONSTANT_THRESHOLD = 50;
    private static final int SELF_RECURSION_LIMIT = 4;
    public final IRConverter converter;
    private final AppInfo appInfo;
    private final AppView<? extends AppInfo> appView;
    private final DexItemFactory dexItemFactory;
    private final Set<DexMethod> libraryMethodsReturningReceiver;
    private final InternalOptions options;

    public CodeRewriter(IRConverter converter, Set<DexMethod> libraryMethodsReturningReceiver, InternalOptions options) {
        this.converter = converter;
        this.appInfo = converter.appInfo;
        this.appView = converter.appView;
        this.options = options;
        this.dexItemFactory = this.appInfo.dexItemFactory;
        this.libraryMethodsReturningReceiver = libraryMethodsReturningReceiver;
    }

    private static boolean removedTrivialGotos(IRCode code) {
        BasicBlock nextBlock;
        ListIterator<BasicBlock> iterator2 = code.listIterator();
        assert (iterator2.hasNext());
        BasicBlock block = iterator2.next();
        do {
            nextBlock = iterator2.hasNext() ? iterator2.next() : null;
            BasicBlock blk = block;
            assert (!block.isTrivialGoto() || block.exit().asGoto().getTarget() == block || code.blocks.get(0) == block || block.getPredecessors().stream().anyMatch(b -> b.exit().fallthroughBlock() == blk));
            assert (!block.isTrivialGoto() || block.exit().asGoto().getTarget() != nextBlock);
        } while ((block = nextBlock) != null);
        return true;
    }

    public static boolean isFallthroughBlock(BasicBlock block) {
        for (BasicBlock pred : block.getPredecessors()) {
            if (pred.exit().fallthroughBlock() != block) continue;
            return true;
        }
        return false;
    }

    private static void collapseTrivialGoto(IRCode code, BasicBlock block, BasicBlock nextBlock, List<BasicBlock> blocksToRemove) {
        if (block.exit().asGoto().getTarget() == block) {
            return;
        }
        BasicBlock target = block.endOfGotoChain();
        boolean needed = false;
        if (target == null) {
            target = block.exit().asGoto().getTarget();
        }
        if (target != nextBlock) {
            boolean bl = needed = code.blocks.get(0) == block || CodeRewriter.isFallthroughBlock(block);
        }
        if (!needed) {
            blocksToRemove.add(block);
            CodeRewriter.unlinkTrivialGotoBlock(block, target);
        }
    }

    public static void unlinkTrivialGotoBlock(BasicBlock block, BasicBlock target) {
        assert (block.isTrivialGoto());
        for (BasicBlock pred : block.getPredecessors()) {
            pred.replaceSuccessor(block, target);
        }
        for (BasicBlock succ : block.getSuccessors()) {
            succ.getMutablePredecessors().remove(block);
        }
        for (BasicBlock pred : block.getPredecessors()) {
            if (target.getPredecessors().contains(pred)) continue;
            target.getMutablePredecessors().add(pred);
        }
    }

    private static void collapseIfTrueTarget(BasicBlock block) {
        If insn = block.exit().asIf();
        BasicBlock target = insn.getTrueTarget();
        BasicBlock newTarget = target.endOfGotoChain();
        BasicBlock fallthrough = insn.fallthroughBlock();
        BasicBlock newFallthrough = fallthrough.endOfGotoChain();
        if (newTarget != null && target != newTarget) {
            insn.getBlock().replaceSuccessor(target, newTarget);
            target.getMutablePredecessors().remove(block);
            if (!newTarget.getPredecessors().contains(block)) {
                newTarget.getMutablePredecessors().add(block);
            }
        }
        if (block.exit().isIf() && (insn = block.exit().asIf()).getTrueTarget() == newFallthrough) {
            block.replaceSuccessor(insn.getTrueTarget(), fallthrough);
            assert (block.exit().isGoto());
            assert (block.exit().asGoto().getTarget() == fallthrough);
        }
    }

    private static void collapseNonFallthroughSwitchTargets(BasicBlock block) {
        Switch insn = block.exit().asSwitch();
        BasicBlock fallthroughBlock = insn.fallthroughBlock();
        HashSet<BasicBlock> replacedBlocks = new HashSet<BasicBlock>();
        for (int j = 0; j < insn.targetBlockIndices().length; ++j) {
            BasicBlock newTarget;
            BasicBlock target = insn.targetBlock(j);
            if (target == fallthroughBlock || (newTarget = target.endOfGotoChain()) == null || target == newTarget || replacedBlocks.contains(target)) continue;
            insn.getBlock().replaceSuccessor(target, newTarget);
            target.getMutablePredecessors().remove(block);
            if (!newTarget.getPredecessors().contains(block)) {
                newTarget.getMutablePredecessors().add(block);
            }
            replacedBlocks.add(target);
        }
    }

    public static void disableDex2OatInliningForSelfRecursiveMethods(IRCode code, InternalOptions options, AppInfo appInfo) {
        if (!options.canHaveDex2OatInliningIssue() || code.hasCatchHandlers()) {
            return;
        }
        InstructionIterator it = code.instructionIterator();
        int selfRecursionFanOut = 0;
        Instruction lastSelfRecursiveCall = null;
        while (it.hasNext()) {
            Instruction i = (Instruction)it.next();
            if (!i.isInvokeMethod() || i.asInvokeMethod().getInvokedMethod() != code.method.method) continue;
            ++selfRecursionFanOut;
            lastSelfRecursiveCall = i;
        }
        if (selfRecursionFanOut > 4) {
            assert (lastSelfRecursiveCall != null);
            InstructionListIterator splitIterator = lastSelfRecursiveCall.getBlock().listIterator(lastSelfRecursiveCall);
            splitIterator.previous();
            BasicBlock newBlock = splitIterator.split(code, 1);
            DexType guard = options.itemFactory.throwableType;
            BasicBlock rethrowBlock = BasicBlock.createRethrowBlock(code, lastSelfRecursiveCall.getPosition(), guard, appInfo, options);
            code.blocks.add(rethrowBlock);
            newBlock.addCatchHandler(rethrowBlock, guard);
        }
    }

    private void convertSwitchToSwitchAndIfs(IRCode code, ListIterator<BasicBlock> blocksIterator, BasicBlock originalBlock, InstructionListIterator iterator2, Switch theSwitch, List<IntList> switches, IntList keysToRemove) {
        int i;
        Position position = theSwitch.getPosition();
        Int2ReferenceSortedMap<BasicBlock> keyToTarget = theSwitch.getKeyToTargetMap();
        BasicBlock fallthroughBlock = theSwitch.fallthroughBlock();
        iterator2.previous();
        BasicBlock originalSwitchBlock = iterator2.split(code, blocksIterator);
        assert (!originalSwitchBlock.hasCatchHandlers());
        assert (originalSwitchBlock.getInstructions().size() == 1);
        assert (originalBlock.exit().isGoto());
        theSwitch.moveDebugValues(originalBlock.exit());
        blocksIterator.remove();
        theSwitch.getBlock().detachAllSuccessors();
        BasicBlock block = theSwitch.getBlock().unlinkSinglePredecessor();
        assert (theSwitch.getBlock().getPredecessors().size() == 0);
        assert (theSwitch.getBlock().getSuccessors().size() == 0);
        assert (block == originalBlock);
        int nextBlockNumber = code.getHighestBlockNumber() + 1;
        LinkedList<BasicBlock> newBlocks = new LinkedList<BasicBlock>();
        for (i = switches.size() - 1; i >= 0; --i) {
            SwitchBuilder switchBuilder = new SwitchBuilder(position);
            switchBuilder.setValue(theSwitch.value());
            IntList keys2 = switches.get(i);
            for (int j = 0; j < keys2.size(); ++j) {
                int key = keys2.getInt(j);
                switchBuilder.addKeyAndTarget(key, (BasicBlock)keyToTarget.get(key));
            }
            switchBuilder.setFallthrough(fallthroughBlock).setBlockNumber(nextBlockNumber++);
            BasicBlock newSwitchBlock = switchBuilder.build();
            newBlocks.addFirst(newSwitchBlock);
            fallthroughBlock = newSwitchBlock;
        }
        for (i = keysToRemove.size() - 1; i >= 0; --i) {
            int key = keysToRemove.getInt(i);
            BasicBlock peeledOffTarget = (BasicBlock)keyToTarget.get(key);
            IfBuilder ifBuilder = new IfBuilder(position, code);
            ifBuilder.setLeft(theSwitch.value()).setRight(key).setTarget(peeledOffTarget).setFallthrough(fallthroughBlock).setBlockNumber(nextBlockNumber++);
            BasicBlock ifBlock = ifBuilder.build();
            newBlocks.addFirst(ifBlock);
            fallthroughBlock = ifBlock;
        }
        originalBlock.link(fallthroughBlock);
        newBlocks.forEach(blocksIterator::add);
    }

    private Interval combineOrAddInterval(List<Interval> intervals, Interval previous, Interval current) {
        int penalty;
        InternalOutputMode mode = this.options.getInternalOutputMode();
        int n = penalty = mode.isGeneratingClassFiles() ? 4 : 0;
        if (previous == null) {
            intervals.add(current);
            return current;
        }
        Interval combined = new Interval(previous.keys, current.keys);
        long packedSavings = combined.packedSavings(mode);
        if (packedSavings <= 0L || packedSavings < previous.estimatedSize(mode) + current.estimatedSize(mode) - (long)penalty) {
            intervals.add(current);
            return current;
        }
        intervals.set(intervals.size() - 1, combined);
        return combined;
    }

    private void tryAddToBiggestSavings(Set<Interval> biggestPackedSet, PriorityQueue<Interval> intervals, Interval toAdd, int maximumNumberOfSwitches) {
        assert (!biggestPackedSet.contains(toAdd));
        long savings = toAdd.packedSavings(this.options.getInternalOutputMode());
        if (savings <= 0L) {
            return;
        }
        if (intervals.size() < maximumNumberOfSwitches) {
            intervals.add(toAdd);
            biggestPackedSet.add(toAdd);
        } else if (savings > intervals.peek().packedSavings(this.options.getInternalOutputMode())) {
            intervals.add(toAdd);
            biggestPackedSet.add(toAdd);
            biggestPackedSet.remove(intervals.poll());
        }
    }

    private int sizeForKeysWrittenAsIfs(ValueType type, Collection<Integer> keys2) {
        int ifsSize = If.estimatedSize(this.options.getInternalOutputMode()) * keys2.size();
        if (this.options.getInternalOutputMode().isGeneratingClassFiles()) {
            ifsSize += keys2.size() * 4;
        }
        for (int k : keys2) {
            if (k == 0) continue;
            ifsSize += ConstNumber.estimatedSize(this.options.getInternalOutputMode(), type, k);
        }
        return ifsSize;
    }

    private int codeUnitMargin() {
        return this.options.getInternalOutputMode().isGeneratingClassFiles() ? 3 : 1;
    }

    private int findIfsForCandidates(List<Interval> newSwitches, Switch theSwitch, IntList outliers) {
        HashSet<Interval> switchesToRemove = new HashSet<Interval>();
        InternalOutputMode mode = this.options.getInternalOutputMode();
        int outliersAsIfSize = 0;
        for (Interval candidate : newSwitches) {
            int maxIfBudget = 10;
            long switchSize = candidate.estimatedSize(mode);
            int sizeOfAllKeysAsIf = this.sizeForKeysWrittenAsIfs(theSwitch.value().outType(), candidate.keys);
            if (candidate.keys.size() <= maxIfBudget && (long)sizeOfAllKeysAsIf < switchSize - (long)this.codeUnitMargin()) {
                outliersAsIfSize += sizeOfAllKeysAsIf;
                switchesToRemove.add(candidate);
                outliers.addAll(candidate.keys);
                continue;
            }
            IntList candidateKeys = candidate.keys;
            int smallestPosition = -1;
            long smallest = Long.MAX_VALUE;
            for (int i = 0; i < candidateKeys.size(); ++i) {
                long current = Math.abs((long)candidateKeys.getInt(i));
                if (current >= smallest) continue;
                smallestPosition = i;
                smallest = current;
            }
            IntArrayList ifKeys = new IntArrayList();
            ifKeys.add(candidateKeys.getInt(smallestPosition));
            long previousSavings = 0L;
            long currentSavings = switchSize - (long)this.sizeForKeysWrittenAsIfs(theSwitch.value().outType(), ifKeys) - Switch.estimatedSparseSize(mode, candidateKeys.size() - ifKeys.size());
            int minIndex = smallestPosition - 1;
            int maxIndex = smallestPosition + 1;
            while (ifKeys.size() < maxIfBudget && currentSavings > previousSavings) {
                if (minIndex >= 0 && maxIndex < candidateKeys.size()) {
                    long valMin = Math.abs((long)candidateKeys.getInt(minIndex));
                    int valMax = Math.abs(candidateKeys.getInt(maxIndex));
                    if ((long)valMax <= valMin) {
                        ifKeys.add(candidateKeys.getInt(maxIndex++));
                    } else {
                        ifKeys.add(candidateKeys.getInt(minIndex--));
                    }
                } else if (minIndex >= 0) {
                    ifKeys.add(candidateKeys.getInt(minIndex--));
                } else {
                    if (maxIndex >= candidateKeys.size()) break;
                    ifKeys.add(candidateKeys.getInt(maxIndex++));
                }
                previousSavings = currentSavings;
                currentSavings = switchSize - (long)this.sizeForKeysWrittenAsIfs(theSwitch.value().outType(), ifKeys) - Switch.estimatedSparseSize(mode, candidateKeys.size() - ifKeys.size());
            }
            if (previousSavings >= currentSavings) {
                int lastKey = ifKeys.getInt(ifKeys.size() - 1);
                ifKeys.removeInt(ifKeys.size() - 1);
                if (lastKey == candidateKeys.getInt(minIndex + 1)) {
                    ++minIndex;
                } else {
                    --maxIndex;
                }
            }
            ++minIndex;
            --maxIndex;
            if (ifKeys.size() <= 0) continue;
            int ifsSize = this.sizeForKeysWrittenAsIfs(theSwitch.value().outType(), ifKeys);
            long newSwitchSize = Switch.estimatedSparseSize(mode, candidateKeys.size() - ifKeys.size());
            if (newSwitchSize + (long)ifsSize + (long)this.codeUnitMargin() >= switchSize) continue;
            candidateKeys.removeElements(minIndex, maxIndex);
            outliers.addAll(ifKeys);
            outliersAsIfSize += ifsSize;
        }
        newSwitches.removeAll(switchesToRemove);
        return outliersAsIfSize;
    }

    public void rewriteSwitch(IRCode code) {
        ListIterator<BasicBlock> blocksIterator = code.listIterator();
        while (blocksIterator.hasNext()) {
            BasicBlock block = blocksIterator.next();
            InstructionListIterator iterator2 = block.listIterator();
            while (iterator2.hasNext()) {
                Instruction instruction = (Instruction)iterator2.next();
                if (!instruction.isSwitch()) continue;
                Switch theSwitch = instruction.asSwitch();
                if (theSwitch.numberOfKeys() == 1) {
                    int caseBlockIndex;
                    int fallthroughBlockIndex = theSwitch.getFallthroughBlockIndex();
                    if (fallthroughBlockIndex < (caseBlockIndex = theSwitch.targetBlockIndices()[0])) {
                        block.swapSuccessorsByIndex(fallthroughBlockIndex, caseBlockIndex);
                    }
                    if (theSwitch.getFirstKey() == 0) {
                        iterator2.replaceCurrentInstruction(new If(If.Type.EQ, theSwitch.value()));
                        continue;
                    }
                    ConstNumber labelConst = code.createIntConstant(theSwitch.getFirstKey());
                    labelConst.setPosition(theSwitch.getPosition());
                    iterator2.previous();
                    iterator2.add(labelConst);
                    Instruction dummy = (Instruction)iterator2.next();
                    assert (dummy == theSwitch);
                    If theIf = new If(If.Type.EQ, ImmutableList.of(theSwitch.value(), labelConst.dest()));
                    iterator2.replaceCurrentInstruction(theIf);
                    continue;
                }
                InternalOutputMode mode = this.options.getInternalOutputMode();
                int[] keys2 = theSwitch.getKeys();
                int maxNumberOfIfsOrSwitches = 10;
                PriorityQueue<Interval> biggestPackedSavings = new PriorityQueue<Interval>((x, y) -> Long.compare(y.packedSavings(mode), x.packedSavings(mode)));
                HashSet<Interval> biggestPackedSet = new HashSet<Interval>();
                ArrayList<Interval> intervals = new ArrayList<Interval>();
                int previousKey = keys2[0];
                IntArrayList currentKeys = new IntArrayList();
                currentKeys.add(previousKey);
                Interval previousInterval = null;
                for (int i = 1; i < keys2.length; ++i) {
                    int key = keys2[i];
                    if ((long)key - (long)previousKey > 1L) {
                        Interval current = new Interval(currentKeys);
                        Interval added = this.combineOrAddInterval(intervals, previousInterval, current);
                        if (added != current && biggestPackedSet.contains(previousInterval)) {
                            biggestPackedSet.remove(previousInterval);
                            biggestPackedSavings.remove(previousInterval);
                        }
                        this.tryAddToBiggestSavings(biggestPackedSet, biggestPackedSavings, added, maxNumberOfIfsOrSwitches);
                        previousInterval = added;
                        currentKeys = new IntArrayList();
                    }
                    currentKeys.add(key);
                    previousKey = key;
                }
                Interval current = new Interval(currentKeys);
                Interval added = this.combineOrAddInterval(intervals, previousInterval, current);
                if (added != current && biggestPackedSet.contains(previousInterval)) {
                    biggestPackedSet.remove(previousInterval);
                    biggestPackedSavings.remove(previousInterval);
                }
                this.tryAddToBiggestSavings(biggestPackedSet, biggestPackedSavings, added, maxNumberOfIfsOrSwitches);
                if (biggestPackedSet.size() == maxNumberOfIfsOrSwitches && maxNumberOfIfsOrSwitches < intervals.size()) {
                    biggestPackedSet.remove(biggestPackedSavings.poll());
                }
                Interval sparse = null;
                ArrayList<Interval> newSwitches = new ArrayList<Interval>(maxNumberOfIfsOrSwitches);
                for (int i = 0; i < intervals.size(); ++i) {
                    Interval interval = (Interval)intervals.get(i);
                    if (biggestPackedSet.contains(interval)) {
                        newSwitches.add(interval);
                        continue;
                    }
                    if (sparse == null) {
                        sparse = interval;
                        newSwitches.add(sparse);
                        continue;
                    }
                    sparse.addInterval(interval);
                }
                IntArrayList outliers = new IntArrayList();
                int outliersAsIfSize = this.findIfsForCandidates(newSwitches, theSwitch, outliers);
                long newSwitchesSize = 0L;
                ArrayList<IntList> newSwitchSequences = new ArrayList<IntList>(newSwitches.size());
                for (Interval interval : newSwitches) {
                    newSwitchesSize += interval.estimatedSize(mode);
                    newSwitchSequences.add(interval.keys);
                }
                long currentSize = Switch.estimatedSize(mode, theSwitch.getKeys());
                if (newSwitchesSize + (long)outliersAsIfSize + (long)this.codeUnitMargin() >= currentSize) continue;
                this.convertSwitchToSwitchAndIfs(code, blocksIterator, block, iterator2, theSwitch, newSwitchSequences, outliers);
            }
        }
        code.splitCriticalEdges();
        assert (code.isConsistentSSA());
    }

    public void removeSwitchMaps(IRCode code) {
        for (BasicBlock block : code.blocks) {
            InstructionListIterator it = block.listIterator();
            while (it.hasNext()) {
                Instruction staticGet;
                Switch switchInsn;
                SwitchUtils.EnumSwitchInfo info;
                Instruction insn = (Instruction)it.next();
                if (!insn.isSwitch() || (info = SwitchUtils.analyzeSwitchOverEnum(switchInsn = insn.asSwitch(), this.appInfo.withLiveness())) == null) continue;
                Int2IntArrayMap targetMap = new Int2IntArrayMap();
                IntArrayList keys2 = new IntArrayList(switchInsn.numberOfKeys());
                for (int i = 0; i < switchInsn.numberOfKeys(); ++i) {
                    assert (switchInsn.targetBlockIndices()[i] != switchInsn.getFallthroughBlockIndex());
                    int key = info.ordinalsMap.getInt(info.indexMap.get(switchInsn.getKey(i)));
                    keys2.add(key);
                    targetMap.put(key, switchInsn.targetBlockIndices()[i]);
                }
                keys2.sort(Comparator.naturalOrder());
                int[] targets = new int[keys2.size()];
                for (int i = 0; i < keys2.size(); ++i) {
                    targets[i] = targetMap.get(keys2.getInt(i));
                }
                Switch newSwitch = new Switch(info.ordinalInvoke.outValue(), keys2.toIntArray(), targets, switchInsn.getFallthroughBlockIndex());
                it.replaceCurrentInstruction(newSwitch);
                Instruction arrayGet = info.arrayGet;
                if (arrayGet.outValue().numberOfUsers() == 0) {
                    arrayGet.inValues().forEach(v -> v.removeUser(arrayGet));
                    arrayGet.getBlock().removeInstruction(arrayGet);
                }
                if ((staticGet = info.staticGet).outValue().numberOfUsers() != 0) continue;
                assert (staticGet.inValues().isEmpty());
                staticGet.getBlock().removeInstruction(staticGet);
            }
        }
    }

    public static void collapseTrivialGotos(DexEncodedMethod method, IRCode code) {
        BasicBlock nextBlock;
        assert (code.isConsistentGraph());
        ArrayList<BasicBlock> blocksToRemove = new ArrayList<BasicBlock>();
        ListIterator<BasicBlock> iterator2 = code.listIterator();
        assert (iterator2.hasNext());
        BasicBlock block = iterator2.next();
        do {
            BasicBlock basicBlock = nextBlock = iterator2.hasNext() ? iterator2.next() : null;
            if (block.isTrivialGoto()) {
                CodeRewriter.collapseTrivialGoto(code, block, nextBlock, blocksToRemove);
            }
            if (block.exit().isIf()) {
                CodeRewriter.collapseIfTrueTarget(block);
            }
            if (block.exit().isSwitch()) {
                CodeRewriter.collapseNonFallthroughSwitchTargets(block);
            }
            block = nextBlock;
        } while (nextBlock != null);
        code.removeBlocks(blocksToRemove);
        while (!blocksToRemove.isEmpty()) {
            blocksToRemove = new ArrayList();
            iterator2 = code.listIterator();
            block = iterator2.next();
            do {
                BasicBlock basicBlock = nextBlock = iterator2.hasNext() ? iterator2.next() : null;
                if (!block.isTrivialGoto()) continue;
                CodeRewriter.collapseTrivialGoto(code, block, nextBlock, blocksToRemove);
            } while ((block = nextBlock) != null);
            code.removeBlocks(blocksToRemove);
        }
        assert (CodeRewriter.removedTrivialGotos(code));
        assert (code.isConsistentGraph());
    }

    public void identifyReturnsArgument(DexEncodedMethod method, IRCode code, OptimizationFeedback feedback) {
        List<BasicBlock> normalExits = code.computeNormalExitBlocks();
        if (normalExits.isEmpty()) {
            feedback.methodNeverReturnsNormally(method);
            return;
        }
        Return firstExit = normalExits.get(0).exit().asReturn();
        if (firstExit.isReturnVoid()) {
            return;
        }
        Value returnValue = firstExit.returnValue();
        boolean isNeverNull = returnValue.isNeverNull();
        for (int i = 1; i < normalExits.size(); ++i) {
            Return exit = normalExits.get(i).exit().asReturn();
            Value value = exit.returnValue();
            if (value != returnValue) {
                returnValue = null;
            }
            isNeverNull = isNeverNull && value.isNeverNull();
        }
        if (returnValue != null) {
            if (returnValue.isArgument()) {
                int index = code.collectArguments().indexOf(returnValue);
                assert (index != -1);
                feedback.methodReturnsArgument(method, index);
            }
            if (returnValue.isConstant() && returnValue.definition.isConstNumber()) {
                long value = returnValue.definition.asConstNumber().getRawValue();
                feedback.methodReturnsConstant(method, value);
            }
        }
        if (isNeverNull) {
            feedback.methodNeverReturnsNull(method);
        }
    }

    public void identifyInvokeSemanticsForInlining(DexEncodedMethod method, IRCode code, GraphLense graphLense, OptimizationFeedback feedback) {
        if (method.isStatic()) {
            feedback.markTriggerClassInitBeforeAnySideEffect(method, CodeRewriter.triggersClassInitializationBeforeSideEffect(code, method.method.getHolder()));
        } else {
            Value receiver = code.getThis();
            feedback.markCheckNullReceiverBeforeAnySideEffect(method, receiver.isUsed() && CodeRewriter.checksNullBeforeSideEffect(code, this.appInfo, graphLense, receiver));
        }
    }

    public void identifyClassInlinerEligibility(DexEncodedMethod method, IRCode code, OptimizationFeedback feedback) {
        boolean instanceInitializer = method.isInstanceInitializer();
        if (method.accessFlags.isNative() || !method.isNonAbstractVirtualMethod() && !instanceInitializer || method.accessFlags.isSynchronized()) {
            return;
        }
        feedback.setClassInlinerEligibility(method, null);
        Value receiver = code.getThis();
        if (receiver.numberOfPhiUsers() > 0) {
            return;
        }
        DexClass clazz = this.appInfo.definitionFor(method.method.holder);
        if (clazz == null) {
            return;
        }
        boolean receiverUsedAsReturnValue = false;
        boolean seenSuperInitCall = false;
        for (Instruction insn : receiver.uniqueUsers()) {
            if (insn.isReturn()) {
                receiverUsedAsReturnValue = true;
                continue;
            }
            if (insn.isInstanceGet() || insn.isInstancePut()) {
                if (insn.isInstancePut()) {
                    InstancePut instancePutInstruction = insn.asInstancePut();
                    if (instancePutInstruction.object() != receiver) {
                        return;
                    }
                    if (instancePutInstruction.value() == receiver) {
                        return;
                    }
                }
                DexField field = insn.asFieldInstruction().getField();
                if (field.clazz == clazz.type && clazz.lookupInstanceField(field) != null) continue;
                return;
            }
            if (insn.isInvokeDirect()) {
                InvokeDirect invokedDirect = insn.asInvokeDirect();
                DexMethod invokedMethod = invokedDirect.getInvokedMethod();
                if (this.dexItemFactory.isConstructor(invokedMethod) && invokedMethod.holder == clazz.superType && invokedDirect.inValues().lastIndexOf(receiver) == 0 && !seenSuperInitCall && instanceInitializer) {
                    seenSuperInitCall = true;
                    continue;
                }
                return;
            }
            return;
        }
        if (instanceInitializer && !seenSuperInitCall) {
            return;
        }
        feedback.setClassInlinerEligibility(method, new DexEncodedMethod.ClassInlinerEligibility(receiverUsedAsReturnValue));
    }

    public void identifyTrivialInitializer(DexEncodedMethod method, IRCode code, OptimizationFeedback feedback) {
        boolean isInstanceInitializer = method.isInstanceInitializer();
        boolean isClassInitializer = method.isClassInitializer();
        assert (isInstanceInitializer || isClassInitializer);
        if (method.accessFlags.isNative()) {
            return;
        }
        DexClass clazz = this.appInfo.definitionFor(method.method.holder);
        if (clazz == null) {
            return;
        }
        feedback.setTrivialInitializer(method, isInstanceInitializer ? this.computeInstanceInitializerInfo(code, clazz, this.appInfo::definitionFor) : this.computeClassInitializerInfo(code, clazz));
    }

    public void identifyParameterUsages(DexEncodedMethod method, IRCode code, OptimizationFeedback feedback) {
        ArrayList<ParameterUsagesInfo.ParameterUsage> usages = new ArrayList<ParameterUsagesInfo.ParameterUsage>();
        List<Value> values2 = code.collectArguments();
        for (int i = 0; i < values2.size(); ++i) {
            ParameterUsagesInfo.ParameterUsage usage;
            Value value = values2.get(i);
            if (value.numberOfPhiUsers() > 0 || (usage = this.collectParameterUsages(i, value)) == null) continue;
            usages.add(usage);
        }
        feedback.setParameterUsages(method, usages.isEmpty() ? null : new ParameterUsagesInfo(usages));
    }

    private ParameterUsagesInfo.ParameterUsage collectParameterUsages(int i, Value value) {
        ParameterUsagesInfo.ParameterUsageBuilder builder = new ParameterUsagesInfo.ParameterUsageBuilder(value, i);
        for (Instruction user : value.uniqueUsers()) {
            if (builder.note(user)) continue;
            return null;
        }
        return builder.build();
    }

    private DexEncodedMethod.TrivialInitializer computeInstanceInitializerInfo(IRCode code, DexClass clazz, Function<DexType, DexClass> typeToClass) {
        Value receiver = code.getThis();
        InstructionIterator it = code.instructionIterator();
        while (it.hasNext()) {
            Instruction insn = (Instruction)it.next();
            if (insn.isReturn() || insn.isArgument()) continue;
            if (insn.isConstInstruction()) {
                if (!insn.instructionInstanceCanThrow()) continue;
                return null;
            }
            if (insn.isInvokeDirect()) {
                InvokeDirect invokedDirect = insn.asInvokeDirect();
                DexMethod invokedMethod = invokedDirect.getInvokedMethod();
                if (invokedMethod.holder != clazz.superType) {
                    return null;
                }
                if (invokedMethod == this.dexItemFactory.objectMethods.constructor) continue;
                DexClass holder = typeToClass.apply(invokedMethod.holder);
                if (holder == null) {
                    return null;
                }
                DexEncodedMethod callTarget = holder.lookupDirectMethod(invokedMethod);
                if (callTarget == null || !callTarget.isInstanceInitializer() || callTarget.getOptimizationInfo().getTrivialInitializerInfo() == null || invokedDirect.getReceiver() != receiver) {
                    return null;
                }
                for (Value value : invokedDirect.inValues()) {
                    if (value == receiver || value.isConstant() || value.isArgument()) continue;
                    return null;
                }
                continue;
            }
            if (insn.isInstancePut()) {
                InstancePut instancePut = insn.asInstancePut();
                DexEncodedField field = clazz.lookupInstanceField(instancePut.getField());
                if (field != null && instancePut.object() == receiver && (instancePut.value() == receiver || instancePut.value().isArgument())) continue;
                return null;
            }
            if (insn.isGoto()) {
                if (insn.asGoto().isTrivialGotoToTheNextBlock(code)) continue;
                return null;
            }
            return null;
        }
        return DexEncodedMethod.TrivialInitializer.TrivialInstanceInitializer.INSTANCE;
    }

    private synchronized DexEncodedMethod.TrivialInitializer computeClassInitializerInfo(IRCode code, DexClass clazz) {
        InstructionIterator it = code.instructionIterator();
        Value createdSingletonInstance = null;
        DexField singletonField = null;
        while (it.hasNext()) {
            Instruction insn = (Instruction)it.next();
            if (insn.isReturn()) continue;
            if (insn.isNewInstance()) {
                NewInstance newInstance = insn.asNewInstance();
                if (createdSingletonInstance != null || newInstance.clazz != clazz.type || insn.outValue() == null) {
                    return null;
                }
                createdSingletonInstance = insn.outValue();
                continue;
            }
            if (insn.isInvokeDirect()) {
                InvokeDirect invokedDirect = insn.asInvokeDirect();
                if (createdSingletonInstance == null || invokedDirect.getReceiver() != createdSingletonInstance) {
                    return null;
                }
                DexEncodedMethod callTarget = clazz.lookupDirectMethod(invokedDirect.getInvokedMethod());
                if (callTarget != null && callTarget.isInstanceInitializer() && callTarget.method.proto.parameters.isEmpty() && callTarget.getOptimizationInfo().getTrivialInitializerInfo() != null) continue;
                return null;
            }
            if (insn.isStaticPut()) {
                StaticPut staticPut = insn.asStaticPut();
                if (singletonField != null || createdSingletonInstance == null || staticPut.inValue() != createdSingletonInstance) {
                    return null;
                }
                DexEncodedField field = clazz.lookupStaticField(staticPut.getField());
                if (field == null || !field.accessFlags.isStatic() || !field.accessFlags.isFinal()) {
                    return null;
                }
                singletonField = field.field;
                continue;
            }
            return null;
        }
        return singletonField == null ? null : new DexEncodedMethod.TrivialInitializer.TrivialClassInitializer(singletonField);
    }

    public static boolean checksNullBeforeSideEffect(IRCode code, AppInfo appInfo, GraphLense graphLense, Value value) {
        return CodeRewriter.alwaysTriggerExpectedEffectBeforeAnythingElse(code, (instr, it) -> {
            BasicBlock currentBlock = instr.getBlock();
            if (!currentBlock.hasCatchHandlers() && CodeRewriter.isNullCheck(instr, value)) {
                return InstructionEffect.CONDITIONAL_EFFECT;
            }
            if (CodeRewriter.isKotlinNullCheck(appInfo, graphLense, instr, value)) {
                DexMethod invokedMethod = instr.asInvokeStatic().getInvokedMethod();
                if (invokedMethod.name == appInfo.dexItemFactory.kotlin.intrinsics.throwParameterIsNullException.name) {
                    for (BasicBlock predecessor : currentBlock.getPredecessors()) {
                        Instruction last = (Instruction)predecessor.listIterator(predecessor.getInstructions().size()).previous();
                        if (!CodeRewriter.isNullCheck(last, value)) continue;
                        return InstructionEffect.DESIRED_EFFECT;
                    }
                    return InstructionEffect.NO_EFFECT;
                }
                assert (invokedMethod.name == appInfo.dexItemFactory.kotlin.intrinsics.checkParameterIsNotNull.name);
                return InstructionEffect.DESIRED_EFFECT;
            }
            if (CodeRewriter.isInstantiationOfNullPointerException(instr, it, appInfo.dexItemFactory)) {
                it.next();
                return InstructionEffect.NO_EFFECT;
            }
            if (instr.throwsNpeIfValueIsNull(value, appInfo.dexItemFactory)) {
                if (!currentBlock.hasCatchHandlers()) {
                    return InstructionEffect.DESIRED_EFFECT;
                }
            } else if (CodeRewriter.instructionHasSideEffects(instr)) {
                if (instr.isConstString() && !instr.instructionInstanceCanThrow()) {
                    return InstructionEffect.NO_EFFECT;
                }
                return InstructionEffect.OTHER_EFFECT;
            }
            return InstructionEffect.NO_EFFECT;
        });
    }

    private static boolean isKotlinNullCheck(AppInfo appInfo, GraphLense graphLense, Instruction instr, Value value) {
        if (!instr.isInvokeStatic()) {
            return false;
        }
        MethodSignatureEquivalence wrapper = MethodSignatureEquivalence.get();
        Equivalence.Wrapper<DexMethod> checkParameterIsNotNull = wrapper.wrap(appInfo.dexItemFactory.kotlin.intrinsics.checkParameterIsNotNull);
        Equivalence.Wrapper<DexMethod> throwParamIsNullException = wrapper.wrap(appInfo.dexItemFactory.kotlin.intrinsics.throwParameterIsNullException);
        DexMethod invokedMethod = graphLense.getOriginalMethodSignature(instr.asInvokeStatic().getInvokedMethod());
        Equivalence.Wrapper<DexMethod> methodWrap = wrapper.wrap(invokedMethod);
        return (methodWrap.equals(throwParamIsNullException) || methodWrap.equals(checkParameterIsNotNull) && instr.inValues().get(0).equals(value)) && invokedMethod.getHolder().getPackageDescriptor().startsWith(Kotlin.NAME);
    }

    private static boolean isNullCheck(Instruction instr, Value value) {
        return instr.isIf() && instr.asIf().isZeroTest() && instr.inValues().get(0).equals(value) && (instr.asIf().getType() == If.Type.EQ || instr.asIf().getType() == If.Type.NE);
    }

    private static boolean instructionHasSideEffects(Instruction instruction) {
        return instruction.instructionTypeCanThrow();
    }

    private static boolean isInstantiationOfNullPointerException(Instruction instruction, InstructionListIterator it, DexItemFactory dexItemFactory) {
        if (!instruction.isNewInstance() || instruction.asNewInstance().clazz != dexItemFactory.npeType) {
            return false;
        }
        Instruction next = it.peekNext();
        return next != null && next.isInvokeDirect() && next.asInvokeDirect().getInvokedMethod() == dexItemFactory.npeMethods.init;
    }

    private static boolean triggersClassInitializationBeforeSideEffect(IRCode code, DexType klass) {
        return CodeRewriter.alwaysTriggerExpectedEffectBeforeAnythingElse(code, (instruction, it) -> {
            if (instruction.triggersInitializationOfClass(klass)) {
                if (!instruction.getBlock().hasCatchHandlers()) {
                    return InstructionEffect.DESIRED_EFFECT;
                }
            } else if (CodeRewriter.instructionHasSideEffects(instruction)) {
                return InstructionEffect.OTHER_EFFECT;
            }
            return InstructionEffect.NO_EFFECT;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean alwaysTriggerExpectedEffectBeforeAnythingElse(IRCode code, BiFunction<Instruction, InstructionListIterator, InstructionEffect> function) {
        int color = code.reserveMarkingColor();
        try {
            ArrayDeque<BasicBlock> worklist = new ArrayDeque<BasicBlock>();
            BasicBlock entry = code.blocks.getFirst();
            worklist.add(entry);
            entry.mark(color);
            while (!worklist.isEmpty()) {
                Instruction lastInstruction;
                BasicBlock currentBlock = (BasicBlock)worklist.poll();
                assert (currentBlock.isMarked(color));
                InstructionEffect result = InstructionEffect.NO_EFFECT;
                InstructionListIterator it = currentBlock.listIterator();
                while (result == InstructionEffect.NO_EFFECT && it.hasNext()) {
                    result = function.apply((Instruction)it.next(), it);
                }
                if (result == InstructionEffect.OTHER_EFFECT) {
                    boolean bl = false;
                    return bl;
                }
                if (result == InstructionEffect.DESIRED_EFFECT) continue;
                if (result == InstructionEffect.CONDITIONAL_EFFECT) {
                    assert (!currentBlock.getNormalSuccessors().isEmpty());
                    lastInstruction = currentBlock.getInstructions().getLast();
                    assert (lastInstruction.isIf());
                    BasicBlock targetIfReceiverIsNull = lastInstruction.asIf().targetFromCondition(0);
                    if (targetIfReceiverIsNull.isMarked(color)) continue;
                    worklist.add(targetIfReceiverIsNull);
                    targetIfReceiverIsNull.mark(color);
                    continue;
                }
                assert (result == InstructionEffect.NO_EFFECT);
                if (currentBlock.getNormalSuccessors().isEmpty()) {
                    lastInstruction = currentBlock.getInstructions().getLast();
                    assert (lastInstruction.isReturn() || lastInstruction.isThrow());
                    boolean targetIfReceiverIsNull = false;
                    return targetIfReceiverIsNull;
                }
                for (BasicBlock successor : currentBlock.getSuccessors()) {
                    if (successor.isMarked(color)) continue;
                    worklist.add(successor);
                    successor.mark(color);
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            code.returnMarkingColor(color);
        }
    }

    private boolean checkArgumentType(InvokeMethod invoke, int argumentIndex) {
        TypeLatticeElement returnType = TypeLatticeElement.fromDexType(invoke.getInvokedMethod().proto.returnType, false, this.appInfo);
        TypeLatticeElement argumentType = TypeLatticeElement.fromDexType(this.getArgumentType(invoke, argumentIndex), false, this.appInfo);
        if (this.appView != null && this.appView.enableWholeProgramOptimizations()) {
            return argumentType.lessThanOrEqual(returnType, this.appInfo);
        }
        return argumentType.equals(returnType);
    }

    private DexType getArgumentType(InvokeMethod invoke, int argumentIndex) {
        if (invoke.isInvokeStatic()) {
            return invoke.getInvokedMethod().proto.parameters.values[argumentIndex];
        }
        if (argumentIndex == 0) {
            return invoke.getInvokedMethod().getHolder();
        }
        return invoke.getInvokedMethod().proto.parameters.values[argumentIndex - 1];
    }

    public void rewriteMoveResult(IRCode code) {
        if (this.options.isGeneratingClassFiles()) {
            return;
        }
        Enqueuer.AppInfoWithLiveness appInfoWithLiveness = this.appInfo.withLiveness();
        Set<Value> needToWidenValues = Sets.newIdentityHashSet();
        Set<Value> needToNarrowValues = Sets.newIdentityHashSet();
        InstructionIterator iterator2 = code.instructionIterator();
        while (iterator2.hasNext()) {
            int argumentIndex;
            DexMethod invokedMethod;
            DexEncodedMethod definition;
            DexEncodedMethod target;
            InvokeMethod invoke;
            Instruction current = (Instruction)iterator2.next();
            if (!current.isInvokeMethod() || (invoke = current.asInvokeMethod()).outValue() == null || invoke.outValue().hasLocalInfo()) continue;
            if (this.libraryMethodsReturningReceiver.contains(invoke.getInvokedMethod())) {
                if (!this.checkArgumentType(invoke, 0)) continue;
                invoke.outValue().replaceUsers(invoke.arguments().get(0));
                invoke.setOutValue(null);
                continue;
            }
            if (appInfoWithLiveness == null || (target = invoke.lookupSingleTarget(appInfoWithLiveness, code.method.method.getHolder())) == null || (definition = this.appInfo.definitionFor(invokedMethod = target.method)) == null || !definition.getOptimizationInfo().returnsArgument() || (argumentIndex = definition.getOptimizationInfo().getReturnedArgument()) < 0 || !this.checkArgumentType(invoke, argumentIndex)) continue;
            Value argument = invoke.arguments().get(argumentIndex);
            Value outValue = invoke.outValue();
            assert (outValue.verifyCompatible(argument.outType()));
            if (argument.getTypeLattice().lessThanOrEqual(outValue.getTypeLattice(), this.appInfo)) {
                needToNarrowValues.addAll(outValue.affectedValues());
            } else {
                needToWidenValues.addAll(outValue.affectedValues());
            }
            outValue.replaceUsers(argument);
            invoke.setOutValue(null);
        }
        if (!needToWidenValues.isEmpty() || !needToNarrowValues.isEmpty()) {
            TypeAnalysis analysis = new TypeAnalysis(this.appInfo, code.method);
            if (!needToWidenValues.isEmpty()) {
                analysis.widening(needToWidenValues);
            }
            if (!needToNarrowValues.isEmpty()) {
                analysis.narrowing(needToNarrowValues);
            }
        }
        assert (code.isConsistentGraph());
    }

    public void disableAssertions(AppInfo appInfo, DexEncodedMethod method, IRCode code, OptimizationFeedback feedback) {
        if (method.isClassInitializer()) {
            if (!this.hasJavacClinitAssertionCode(code)) {
                return;
            }
            feedback.setInitializerEnablingJavaAssertions(method);
        } else {
            DexClass clazz = appInfo.definitionFor(method.method.holder);
            if (clazz == null) {
                return;
            }
            DexEncodedMethod clinit = clazz.getClassInitializer();
            if (clinit == null || !clinit.isProcessed() || !clinit.getOptimizationInfo().isInitializerEnablingJavaAssertions()) {
                return;
            }
        }
        InstructionIterator iterator2 = code.instructionIterator();
        while (iterator2.hasNext()) {
            Instruction current = (Instruction)iterator2.next();
            if (current.isInvokeMethod()) {
                InvokeMethod invoke = current.asInvokeMethod();
                if (invoke.getInvokedMethod() != this.dexItemFactory.classMethods.desiredAssertionStatus) continue;
                iterator2.replaceCurrentInstruction(code.createIntConstant(0));
                continue;
            }
            if (current.isStaticPut()) {
                StaticPut staticPut = current.asStaticPut();
                if (staticPut.getField().name != this.dexItemFactory.assertionsDisabled) continue;
                iterator2.remove();
                continue;
            }
            if (!current.isStaticGet()) continue;
            StaticGet staticGet = current.asStaticGet();
            if (staticGet.getField().name != this.dexItemFactory.assertionsDisabled) continue;
            iterator2.replaceCurrentInstruction(code.createIntConstant(1));
        }
    }

    private boolean isClassDesiredAssertionStatusInvoke(Instruction instruction) {
        return instruction.isInvokeMethod() && instruction.asInvokeMethod().getInvokedMethod() == this.dexItemFactory.classMethods.desiredAssertionStatus;
    }

    private boolean isAssertionsDisabledFieldPut(Instruction instruction) {
        return instruction.isStaticPut() && instruction.asStaticPut().getField().name == this.dexItemFactory.assertionsDisabled;
    }

    private boolean isNotDebugInstruction(Instruction instruction) {
        return !instruction.isDebugInstruction();
    }

    private Value blockWithSingleConstNumberAndGoto(BasicBlock block) {
        InstructionIterator iterator2 = block.iterator();
        Instruction constNumber = iterator2.nextUntil(this::isNotDebugInstruction);
        if (constNumber == null || !constNumber.isConstNumber()) {
            return null;
        }
        Instruction exit = iterator2.nextUntil(this::isNotDebugInstruction);
        return exit != null && exit.isGoto() ? constNumber.outValue() : null;
    }

    private Value blockWithAssertionsDisabledFieldPut(BasicBlock block) {
        InstructionIterator iterator2 = block.iterator();
        Instruction fieldPut = iterator2.nextUntil(this::isNotDebugInstruction);
        return fieldPut != null && this.isAssertionsDisabledFieldPut(fieldPut) ? fieldPut.inValues().get(0) : null;
    }

    private boolean hasJavacClinitAssertionCode(IRCode code) {
        BasicBlock falseTarget;
        InstructionIterator iterator2 = code.instructionIterator();
        Instruction current = iterator2.nextUntil(this::isClassDesiredAssertionStatusInvoke);
        if (current == null) {
            return false;
        }
        Value DesiredAssertionStatus = current.outValue();
        assert (iterator2.hasNext());
        current = (Instruction)iterator2.next();
        if (!current.isIf() || !current.asIf().isZeroTest() || current.asIf().inValues().get(0) != DesiredAssertionStatus) {
            return false;
        }
        If theIf = current.asIf();
        BasicBlock trueTarget = theIf.getTrueTarget();
        if (trueTarget == (falseTarget = theIf.fallthroughBlock())) {
            return false;
        }
        Value trueValue = this.blockWithSingleConstNumberAndGoto(trueTarget);
        Value falseValue = this.blockWithSingleConstNumberAndGoto(falseTarget);
        if (trueValue == null || falseValue == null || trueTarget.exit().asGoto().getTarget() != falseTarget.exit().asGoto().getTarget()) {
            return false;
        }
        BasicBlock target = trueTarget.exit().asGoto().getTarget();
        Value storeValue = this.blockWithAssertionsDisabledFieldPut(target);
        return storeValue != null && storeValue.isPhi() && storeValue.asPhi().getOperands().size() == 2 && storeValue.asPhi().getOperands().contains(trueValue) && storeValue.asPhi().getOperands().contains(falseValue);
    }

    private boolean isClassNameConstantOf(DexClass clazz, StaticPut put) {
        if (put.getField().type != this.dexItemFactory.stringType) {
            return false;
        }
        if (put.inValue().definition != null) {
            return this.isClassNameConstantOf(clazz, put.inValue().definition);
        }
        return false;
    }

    private boolean isClassNameConstantOf(DexClass clazz, Instruction instruction) {
        InvokeVirtual invoke;
        return instruction.isInvokeVirtual() && this.dexItemFactory.classMethods.isReflectiveNameLookup((invoke = instruction.asInvokeVirtual()).getInvokedMethod()) && !invoke.inValues().get(0).isPhi() && invoke.inValues().get((int)0).definition.isConstClass() && invoke.inValues().get((int)0).definition.asConstClass().getValue() == clazz.type;
    }

    public void collectClassInitializerDefaults(DexEncodedMethod method, IRCode code) {
        if (!method.isClassInitializer()) {
            return;
        }
        DexClass clazz = this.appInfo.definitionFor(method.method.getHolder());
        if (clazz == null) {
            return;
        }
        Set<StaticPut> puts = Sets.newIdentityHashSet();
        IdentityHashMap<DexField, StaticPut> finalFieldPut = Maps.newIdentityHashMap();
        this.computeUnnecessaryStaticPuts(code, method, clazz, puts, finalFieldPut);
        if (!puts.isEmpty()) {
            for (StaticPut put : finalFieldPut.values()) {
                ConstInstruction cnst;
                DexField field = put.getField();
                DexEncodedField encodedField = this.appInfo.definitionFor(field);
                Value inValue = put.inValue();
                if (field.type == this.dexItemFactory.stringType) {
                    if (inValue.isConstant()) {
                        if (inValue.isConstNumber()) {
                            assert (inValue.isZero());
                            encodedField.setStaticValue(DexValue.DexValueNull.NULL);
                            continue;
                        }
                        if (inValue.isConstString()) {
                            cnst = inValue.getConstInstruction().asConstString();
                            encodedField.setStaticValue(new DexValue.DexValueString(((ConstString)cnst).getValue()));
                            continue;
                        }
                        if (inValue.isDexItemBasedConstString()) {
                            cnst = inValue.getConstInstruction().asDexItemBasedConstString();
                            assert (!((DexItemBasedConstString)cnst).getClassNameComputationInfo().needsToComputeClassName());
                            encodedField.setStaticValue(new DexValue.DexItemBasedValueString(((DexItemBasedConstString)cnst).getItem(), ((DexItemBasedConstString)cnst).getClassNameComputationInfo()));
                            continue;
                        }
                        assert (false);
                        continue;
                    }
                    InvokeVirtual invoke = inValue.definition.asInvokeVirtual();
                    DexMethod invokedMethod = invoke.getInvokedMethod();
                    DexType holderType = method.method.getHolder();
                    DexClass holder = this.appInfo.definitionFor(holderType);
                    assert (holder != null);
                    String descriptor = holderType.toDescriptorString();
                    DexValue.DexItemBasedValueString deferred = null;
                    String name = null;
                    if (invokedMethod == this.appInfo.dexItemFactory.classMethods.getName) {
                        if (code.options.enableMinification && !this.converter.rootSet.noObfuscation.contains(holderType)) {
                            deferred = new DexValue.DexItemBasedValueString(holderType, new ReflectionOptimizer.ClassNameComputationInfo(ReflectionOptimizer.ClassNameComputationInfo.ClassNameComputationOption.NAME));
                        } else {
                            name = ReflectionOptimizer.computeClassName(descriptor, holder, ReflectionOptimizer.ClassNameComputationInfo.ClassNameComputationOption.NAME);
                        }
                    } else if (invokedMethod != this.appInfo.dexItemFactory.classMethods.getTypeName) {
                        if (invokedMethod == this.appInfo.dexItemFactory.classMethods.getCanonicalName) {
                            if (code.options.enableMinification && !this.converter.rootSet.noObfuscation.contains(holderType)) {
                                deferred = new DexValue.DexItemBasedValueString(holderType, new ReflectionOptimizer.ClassNameComputationInfo(ReflectionOptimizer.ClassNameComputationInfo.ClassNameComputationOption.CANONICAL_NAME));
                            } else {
                                name = ReflectionOptimizer.computeClassName(descriptor, holder, ReflectionOptimizer.ClassNameComputationInfo.ClassNameComputationOption.CANONICAL_NAME);
                            }
                        } else if (invokedMethod == this.appInfo.dexItemFactory.classMethods.getSimpleName) {
                            if (code.options.enableMinification && !this.converter.rootSet.noObfuscation.contains(holderType)) {
                                deferred = new DexValue.DexItemBasedValueString(holderType, new ReflectionOptimizer.ClassNameComputationInfo(ReflectionOptimizer.ClassNameComputationInfo.ClassNameComputationOption.SIMPLE_NAME));
                            } else {
                                name = ReflectionOptimizer.computeClassName(descriptor, holder, ReflectionOptimizer.ClassNameComputationInfo.ClassNameComputationOption.SIMPLE_NAME);
                            }
                        }
                    }
                    assert (name != null || deferred != null);
                    if (name != null) {
                        encodedField.setStaticValue(new DexValue.DexValueString(this.dexItemFactory.createString(name)));
                        continue;
                    }
                    assert (deferred != null);
                    encodedField.setStaticValue(deferred);
                    continue;
                }
                if (field.type.isClassType() || field.type.isArrayType()) {
                    if (inValue.isZero()) {
                        encodedField.setStaticValue(DexValue.DexValueNull.NULL);
                        continue;
                    }
                    throw new Unreachable("Unexpected default value for field type " + field.type + ".");
                }
                cnst = inValue.getConstInstruction().asConstNumber();
                if (field.type == this.dexItemFactory.booleanType) {
                    encodedField.setStaticValue(DexValue.DexValueBoolean.create(((ConstNumber)cnst).getBooleanValue()));
                    continue;
                }
                if (field.type == this.dexItemFactory.byteType) {
                    encodedField.setStaticValue(DexValue.DexValueByte.create((byte)((ConstNumber)cnst).getIntValue()));
                    continue;
                }
                if (field.type == this.dexItemFactory.shortType) {
                    encodedField.setStaticValue(DexValue.DexValueShort.create((short)((ConstNumber)cnst).getIntValue()));
                    continue;
                }
                if (field.type == this.dexItemFactory.intType) {
                    encodedField.setStaticValue(DexValue.DexValueInt.create(((ConstNumber)cnst).getIntValue()));
                    continue;
                }
                if (field.type == this.dexItemFactory.longType) {
                    encodedField.setStaticValue(DexValue.DexValueLong.create(((ConstNumber)cnst).getLongValue()));
                    continue;
                }
                if (field.type == this.dexItemFactory.floatType) {
                    encodedField.setStaticValue(DexValue.DexValueFloat.create(((ConstNumber)cnst).getFloatValue()));
                    continue;
                }
                if (field.type == this.dexItemFactory.doubleType) {
                    encodedField.setStaticValue(DexValue.DexValueDouble.create(((ConstNumber)cnst).getDoubleValue()));
                    continue;
                }
                if (field.type == this.dexItemFactory.charType) {
                    encodedField.setStaticValue(DexValue.DexValueChar.create((char)((ConstNumber)cnst).getIntValue()));
                    continue;
                }
                throw new Unreachable("Unexpected field type " + field.type + ".");
            }
            ArrayList<Instruction> toRemove = new ArrayList<Instruction>();
            InstructionIterator iterator2 = code.instructionIterator();
            while (iterator2.hasNext()) {
                Instruction current = (Instruction)iterator2.next();
                if (!current.isStaticPut() || !puts.contains(current.asStaticPut())) continue;
                iterator2.remove();
                StaticPut put = current.asStaticPut();
                if (put.inValue().uniqueUsers().size() != 0) continue;
                if (put.inValue().isConstString()) {
                    toRemove.add(put.inValue().definition);
                    continue;
                }
                if (!put.inValue().definition.isInvokeVirtual()) continue;
                toRemove.add(put.inValue().definition);
            }
            if (toRemove.size() > 0) {
                iterator2 = code.instructionIterator();
                while (iterator2.hasNext()) {
                    if (!toRemove.contains(iterator2.next())) continue;
                    iterator2.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeUnnecessaryStaticPuts(IRCode code, DexEncodedMethod clinit, DexClass clazz, Set<StaticPut> puts, Map<DexField, StaticPut> finalFieldPut) {
        int color = code.reserveMarkingColor();
        try {
            BasicBlock block = code.blocks.getFirst();
            while (!block.isMarked(color) && block.getPredecessors().size() <= 1) {
                block.mark(color);
                InstructionListIterator it = block.listIterator();
                while (it.hasNext()) {
                    Instruction instruction = (Instruction)it.next();
                    if (!CodeRewriter.instructionHasSideEffects(instruction)) continue;
                    if (this.isClassNameConstantOf(clazz, instruction)) continue;
                    if (instruction.isStaticPut()) {
                        StaticPut put = instruction.asStaticPut();
                        if (put.getField().clazz != clazz.type) {
                            return;
                        }
                        DexField field = put.getField();
                        if (!clazz.definesStaticField(field)) continue;
                        if (put.inValue().isDexItemBasedConstStringThatNeedsToComputeClassName()) continue;
                        if (put.inValue().isConstant()) {
                            if ((field.type.isClassType() || field.type.isArrayType()) && put.inValue().isZero()) {
                                finalFieldPut.put(put.getField(), put);
                                puts.add(put);
                                continue;
                            }
                            if (!field.type.isPrimitiveType() && field.type != this.dexItemFactory.stringType) continue;
                            finalFieldPut.put(put.getField(), put);
                            puts.add(put);
                            continue;
                        }
                        if (!this.isClassNameConstantOf(clazz, put)) continue;
                        finalFieldPut.put(put.getField(), put);
                        puts.add(put);
                        continue;
                    }
                    if (instruction.isConstString() || instruction.isDexItemBasedConstString() || instruction.isConstClass()) continue;
                    return;
                }
                if (!block.exit().isGoto()) continue;
                block = block.exit().asGoto().getTarget();
            }
        }
        finally {
            code.returnMarkingColor(color);
        }
    }

    public void removeTrivialCheckCastAndInstanceOfInstructions(IRCode code, boolean enableWholeProgramOptimizations) {
        if (!enableWholeProgramOptimizations) {
            return;
        }
        InstructionIterator it = code.instructionIterator();
        boolean needToRemoveTrivialPhis = false;
        while (it.hasNext()) {
            boolean hasPhiUsers;
            Instruction current = (Instruction)it.next();
            if (current.isCheckCast()) {
                boolean bl = hasPhiUsers = current.outValue().numberOfPhiUsers() != 0;
                if (!this.removeCheckCastInstructionIfTrivial(current.asCheckCast(), it, code)) continue;
                needToRemoveTrivialPhis |= hasPhiUsers;
                continue;
            }
            if (!current.isInstanceOf()) continue;
            boolean bl = hasPhiUsers = current.outValue().numberOfPhiUsers() != 0;
            if (!this.removeInstanceOfInstructionIfTrivial(current.asInstanceOf(), it, code)) continue;
            needToRemoveTrivialPhis |= hasPhiUsers;
        }
        if (needToRemoveTrivialPhis) {
            code.removeAllTrivialPhis();
        }
        assert (code.isConsistentSSA());
    }

    private boolean removeCheckCastInstructionIfTrivial(CheckCast checkCast, InstructionIterator it, IRCode code) {
        Value inValue = checkCast.object();
        Value outValue = checkCast.outValue();
        DexType castType = checkCast.getType();
        if (this.isTypeInaccessibleInCurrentContext(castType, code.method)) {
            return false;
        }
        if (this.options.canHaveArtCheckCastVerifierBug() && inValue.getTypeLattice().isNullType() && castType.isArrayType() && castType.toBaseType(this.dexItemFactory).isFloatType()) {
            return false;
        }
        Predicate<Instruction> isCheckcastToSubtype = user -> user.isCheckCast() && user.asCheckCast().getType().isSubtypeOf(castType, this.appInfo);
        if (!checkCast.getBlock().hasCatchHandlers() && outValue.isUsed() && outValue.numberOfPhiUsers() == 0 && outValue.uniqueUsers().stream().allMatch(isCheckcastToSubtype)) {
            CodeRewriter.removeOrReplaceByDebugLocalWrite(checkCast, it, inValue, outValue);
            return true;
        }
        TypeLatticeElement inTypeLattice = inValue.getTypeLattice();
        TypeLatticeElement outTypeLattice = outValue.getTypeLattice();
        TypeLatticeElement castTypeLattice = TypeLatticeElement.fromDexType(castType, inTypeLattice.isNullable(), this.appInfo);
        assert (inTypeLattice.nullElement().lessThanOrEqual(outTypeLattice.nullElement()));
        if (inTypeLattice.lessThanOrEqual(castTypeLattice, this.appInfo)) {
            assert (inTypeLattice.lessThanOrEqual(outTypeLattice, this.appInfo));
            CodeRewriter.removeOrReplaceByDebugLocalWrite(checkCast, it, inValue, outValue);
            return true;
        }
        assert (!inTypeLattice.isDefinitelyNull());
        assert (outTypeLattice.asNullable().equals(castTypeLattice.asNullable()));
        return false;
    }

    private boolean isTypeInaccessibleInCurrentContext(DexType type, DexEncodedMethod context) {
        DexType baseType = type.toBaseType(this.appInfo.dexItemFactory);
        if (baseType.isPrimitiveType()) {
            return false;
        }
        DexClass clazz = this.appInfo.definitionFor(baseType);
        if (clazz == null) {
            return true;
        }
        Inliner.ConstraintWithTarget classVisibility = Inliner.ConstraintWithTarget.deriveConstraint(context.method.getHolder(), baseType, clazz.accessFlags, this.appInfo);
        return classVisibility == Inliner.ConstraintWithTarget.NEVER;
    }

    private boolean removeInstanceOfInstructionIfTrivial(InstanceOf instanceOf, InstructionIterator it, IRCode code) {
        if (this.isTypeInaccessibleInCurrentContext(instanceOf.type(), code.method)) {
            return false;
        }
        Value inValue = instanceOf.value();
        TypeLatticeElement inType = inValue.getTypeLattice();
        TypeLatticeElement instanceOfType = TypeLatticeElement.fromDexType(instanceOf.type(), inType.isNullable(), this.appInfo);
        InstanceOfResult result = InstanceOfResult.UNKNOWN;
        if (inType.isDefinitelyNull()) {
            result = InstanceOfResult.FALSE;
        } else if (inType.lessThanOrEqual(instanceOfType, this.appInfo) && !inType.isNullable()) {
            result = InstanceOfResult.TRUE;
        } else if (!inValue.isPhi() && inValue.definition.isCreatingInstanceOrArray() && instanceOfType.strictlyLessThan(inType, this.appInfo)) {
            result = InstanceOfResult.FALSE;
        } else if (this.appInfo.hasLiveness()) {
            if (instanceOf.type().isClassType() && this.isNeverInstantiatedDirectlyOrIndirectly(instanceOf.type())) {
                result = InstanceOfResult.FALSE;
            }
            if (result == InstanceOfResult.UNKNOWN && inType.isClassType() && this.isNeverInstantiatedDirectlyOrIndirectly(inType.asClassTypeLatticeElement().getClassType())) {
                result = InstanceOfResult.FALSE;
            }
        }
        if (result != InstanceOfResult.UNKNOWN) {
            it.replaceCurrentInstruction(new ConstNumber(new Value(code.valueNumberGenerator.next(), TypeLatticeElement.INT, instanceOf.outValue().getLocalInfo()), result == InstanceOfResult.TRUE ? 1L : 0L));
            return true;
        }
        return false;
    }

    private boolean isNeverInstantiatedDirectlyOrIndirectly(DexType type) {
        assert (this.appInfo.hasLiveness());
        assert (type.isClassType());
        DexClass clazz = this.appInfo.definitionFor(type);
        return clazz != null && clazz.isProgramClass() && !this.appInfo.withLiveness().isInstantiatedDirectlyOrIndirectly(type);
    }

    public static void removeOrReplaceByDebugLocalWrite(Instruction currentInstruction, InstructionIterator it, Value inValue, Value outValue) {
        if (outValue.hasLocalInfo() && outValue.getLocalInfo() != inValue.getLocalInfo()) {
            DebugLocalWrite debugLocalWrite = new DebugLocalWrite(outValue, inValue);
            it.replaceCurrentInstruction(debugLocalWrite);
        } else {
            if (outValue.hasLocalInfo()) {
                assert (outValue.getLocalInfo() == inValue.getLocalInfo());
                currentInstruction.removeDebugValue(outValue.getLocalInfo());
            }
            outValue.replaceUsers(inValue);
            it.removeOrReplaceByDebugLocalRead();
        }
    }

    private boolean canBeFolded(Instruction instruction) {
        return instruction.isBinop() && instruction.asBinop().canBeFolded() || instruction.isUnop() && instruction.asUnop().canBeFolded();
    }

    public void splitRangeInvokeConstants(IRCode code) {
        for (BasicBlock block : code.blocks) {
            InstructionListIterator it = block.listIterator();
            while (it.hasNext()) {
                Instruction current = (Instruction)it.next();
                if (!current.isInvoke() || current.asInvoke().requiredArgumentRegisters() <= 5) continue;
                Invoke invoke = current.asInvoke();
                it.previous();
                IdentityHashMap<ConstNumber, ConstNumber> oldToNew = new IdentityHashMap<ConstNumber, ConstNumber>();
                for (int i = 0; i < invoke.inValues().size(); ++i) {
                    Value value = invoke.inValues().get(i);
                    if (!value.isConstNumber() || value.numberOfUsers() <= 1) continue;
                    ConstNumber definition = value.getConstInstruction().asConstNumber();
                    Value originalValue = definition.outValue();
                    ConstNumber newNumber = (ConstNumber)oldToNew.get(definition);
                    if (newNumber == null) {
                        newNumber = ConstNumber.copyOf(code, definition);
                        it.add(newNumber);
                        newNumber.setPosition(current.getPosition());
                        oldToNew.put(definition, newNumber);
                    }
                    invoke.inValues().set(i, newNumber.outValue());
                    originalValue.removeUser(invoke);
                    newNumber.outValue().addUser(invoke);
                }
                it.next();
            }
        }
    }

    public void useDedicatedConstantForLitInstruction(IRCode code) {
        for (BasicBlock block : code.blocks) {
            InstructionListIterator instructionIterator = block.listIterator();
            while (instructionIterator.hasNext()) {
                Value constValue;
                Instruction currentInstruction = (Instruction)instructionIterator.next();
                if (!CodeRewriter.shouldBeLitInstruction(currentInstruction)) continue;
                assert (currentInstruction.isBinop());
                Binop binop = currentInstruction.asBinop();
                if (binop.leftValue().isConstNumber()) {
                    constValue = binop.leftValue();
                } else if (binop.rightValue().isConstNumber()) {
                    constValue = binop.rightValue();
                } else {
                    throw new Unreachable();
                }
                if (constValue.numberOfAllUsers() <= 1) continue;
                ConstNumber newConstant = ConstNumber.copyOf(code, constValue.definition.asConstNumber());
                newConstant.setPosition(currentInstruction.getPosition());
                newConstant.setBlock(currentInstruction.getBlock());
                currentInstruction.replaceValue(constValue, newConstant.outValue());
                constValue.removeUser(currentInstruction);
                instructionIterator.previous();
                instructionIterator.add(newConstant);
                instructionIterator.next();
            }
        }
        assert (code.isConsistentSSA());
    }

    private static boolean shouldBeLitInstruction(Instruction instruction) {
        Binop binop;
        if (!(!instruction.isArithmeticBinop() && !instruction.isLogicalBinop() || (binop = instruction.asBinop()).needsValueInRegister(binop.leftValue()) && binop.needsValueInRegister(binop.rightValue()))) {
            return !CodeRewriter.canBe2AddrInstruction(binop);
        }
        return false;
    }

    private static boolean canBe2AddrInstruction(Binop binop) {
        Value value = null;
        if (binop.needsValueInRegister(binop.leftValue())) {
            value = binop.leftValue();
        } else if (binop.isCommutative() && binop.needsValueInRegister(binop.rightValue())) {
            value = binop.rightValue();
        }
        if (value != null) {
            Set<Instruction> users = value.debugUsers() != null ? Iterables.concat(value.uniqueUsers(), value.debugUsers()) : value.uniqueUsers();
            for (Instruction instruction : users) {
                if (!CodeRewriter.hasPath(binop, instruction)) continue;
                return false;
            }
            for (Phi phi : value.uniquePhiUsers()) {
                if (!binop.getBlock().hasPathTo(phi.getBlock())) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean hasPath(Instruction source, Instruction target) {
        BasicBlock targetBlock;
        BasicBlock sourceBlock = source.getBlock();
        if (sourceBlock == (targetBlock = target.getBlock())) {
            return sourceBlock.getInstructions().indexOf(source) < targetBlock.getInstructions().indexOf(target);
        }
        return source.getBlock().hasPathTo(targetBlock);
    }

    public void shortenLiveRanges(IRCode code) {
        Supplier<DominatorTree> dominatorTreeMemoization = Suppliers.memoize(() -> new DominatorTree(code));
        HashMap<BasicBlock, List<Instruction>> addConstantInBlock = new HashMap<BasicBlock, List<Instruction>>();
        LinkedList<BasicBlock> blocks = code.blocks;
        for (int i = 0; i < blocks.size(); ++i) {
            BasicBlock block = blocks.get(i);
            if (i == 0) {
                this.shortenLiveRangesInsideBlock(code, block, dominatorTreeMemoization, addConstantInBlock, insn -> insn.isConstNumber() && insn.outValue().numberOfAllUsers() != 0 || insn.isConstString() && insn.outValue().numberOfAllUsers() != 0);
                continue;
            }
            this.shortenLiveRangesInsideBlock(code, block, dominatorTreeMemoization, addConstantInBlock, insn -> insn.isConstString() && insn.outValue().numberOfAllUsers() == 1);
        }
        for (BasicBlock block : blocks) {
            List instructions = (List)addConstantInBlock.get(block);
            if (instructions == null) continue;
            if (block != blocks.get(0) && instructions.size() > 50) {
                for (Instruction instruction : instructions) {
                    if (instruction.outValue().numberOfPhiUsers() != 0 || instruction.isConstString()) {
                        this.insertConstantInBlock(instruction, block);
                        continue;
                    }
                    assert (instruction.isConstNumber());
                    ConstNumber constNumber = instruction.asConstNumber();
                    Value constantValue = instruction.outValue();
                    assert (constantValue.numberOfUsers() != 0);
                    assert (constantValue.numberOfUsers() == constantValue.numberOfAllUsers());
                    for (Instruction user : constantValue.uniqueUsers()) {
                        ConstNumber newCstNum = ConstNumber.copyOf(code, constNumber);
                        newCstNum.setPosition(user.getPosition());
                        InstructionListIterator iterator2 = user.getBlock().listIterator(user);
                        iterator2.previous();
                        iterator2.add(newCstNum);
                        user.replaceValue(constantValue, newCstNum.outValue());
                    }
                    constantValue.clearUsers();
                }
                continue;
            }
            for (Instruction instruction : instructions) {
                this.insertConstantInBlock(instruction, block);
            }
        }
        assert (code.isConsistentSSA());
    }

    private void shortenLiveRangesInsideBlock(IRCode code, BasicBlock block, Supplier<DominatorTree> dominatorTreeMemoization, Map<BasicBlock, List<Instruction>> addConstantInBlock, Predicate<ConstInstruction> selector) {
        InstructionListIterator it = block.listIterator();
        while (it.hasNext()) {
            ConstInstruction instruction;
            Instruction next = (Instruction)it.next();
            if (!next.isConstInstruction() || !selector.test(instruction = next.asConstInstruction()) || instruction.outValue().hasLocalInfo()) continue;
            LinkedList<BasicBlock> userBlocks = new LinkedList<BasicBlock>();
            for (Instruction user : instruction.outValue().uniqueUsers()) {
                userBlocks.add(user.getBlock());
            }
            for (Phi phi : instruction.outValue().uniquePhiUsers()) {
                userBlocks.add(phi.getBlock());
            }
            DominatorTree dominatorTree = dominatorTreeMemoization.get();
            BasicBlock dominator = dominatorTree.closestDominator(userBlocks);
            for (Phi phi : instruction.outValue().uniquePhiUsers()) {
                if (phi.getBlock() != dominator) continue;
                if (instruction.outValue().numberOfAllUsers() == 1 && phi.usesValueOneTime(instruction.outValue())) {
                    int predIndex = phi.getOperands().indexOf(instruction.outValue());
                    dominator = dominator.getPredecessors().get(predIndex);
                    break;
                }
                dominator = dominatorTree.immediateDominator(dominator);
                break;
            }
            if (instruction.instructionTypeCanThrow() && (block.hasCatchHandlers() || dominator.hasCatchHandlers())) continue;
            List csts = addConstantInBlock.computeIfAbsent(dominator, k -> new ArrayList());
            ConstInstruction copy = instruction.isConstNumber() ? ConstNumber.copyOf(code, instruction.asConstNumber()) : ConstString.copyOf(code, instruction.asConstString());
            instruction.outValue().replaceUsers(copy.outValue());
            csts.add(copy);
        }
    }

    private void insertConstantInBlock(Instruction instruction, BasicBlock block) {
        boolean hasCatchHandlers = block.hasCatchHandlers();
        InstructionListIterator insertAt = block.listIterator();
        insertAt.nextUntil(i -> i.inValues().contains(instruction.outValue()) || i.isJumpInstruction() || hasCatchHandlers && i.instructionTypeCanThrow() || this.options.canHaveCmpIfFloatBug() && i.isCmp());
        Instruction next = (Instruction)insertAt.previous();
        instruction.setPosition(next.getPosition());
        insertAt.add(instruction);
    }

    private short[] computeArrayFilledData(ConstInstruction[] values2, int size, int elementSize) {
        if (values2 == null) {
            return null;
        }
        if (elementSize == 1) {
            short[] result = new short[(size + 1) / 2];
            for (int i = 0; i < size; i += 2) {
                short value = (short)(values2[i].asConstNumber().getIntValue() & 0xFF);
                if (i + 1 < size) {
                    value = (short)(value | (short)((values2[i + 1].asConstNumber().getIntValue() & 0xFF) << 8));
                }
                result[i / 2] = value;
            }
            return result;
        }
        assert (elementSize == 2 || elementSize == 4 || elementSize == 8);
        int shortsPerConstant = elementSize / 2;
        short[] result = new short[size * shortsPerConstant];
        for (int i = 0; i < size; ++i) {
            long value = values2[i].asConstNumber().getRawValue();
            for (int part = 0; part < shortsPerConstant; ++part) {
                result[i * shortsPerConstant + part] = (short)(value >> 16 * part & 0xFFFFL);
            }
        }
        return result;
    }

    private ConstInstruction[] computeConstantArrayValues(NewArrayEmpty newArray, BasicBlock block, int size) {
        BasicBlock nextBlock;
        if (size > 8192) {
            return null;
        }
        ConstInstruction[] values2 = new ConstInstruction[size];
        int remaining = size;
        Set<Instruction> users = newArray.outValue().uniqueUsers();
        Set<BasicBlock> visitedBlocks = Sets.newIdentityHashSet();
        InstructionListIterator it = block.listIterator();
        it.nextUntil(i -> i == newArray);
        do {
            visitedBlocks.add(block);
            while (it.hasNext()) {
                ConstInstruction value;
                Instruction instruction = (Instruction)it.next();
                if (block.hasCatchHandlers() && instruction.instructionInstanceCanThrow()) {
                    return null;
                }
                if (!users.contains(instruction)) continue;
                if (!instruction.isArrayPut()) {
                    return null;
                }
                ArrayPut arrayPut = instruction.asArrayPut();
                if (!arrayPut.value().isConstant() || !arrayPut.index().isConstNumber()) {
                    return null;
                }
                int index = arrayPut.index().getConstInstruction().asConstNumber().getIntValue();
                if (index < 0 || index >= values2.length) {
                    return null;
                }
                if (values2[index] != null) {
                    return null;
                }
                values2[index] = value = arrayPut.value().getConstInstruction();
                if (--remaining != 0) continue;
                return values2;
            }
        } while ((it = (block = (nextBlock = block.exit().isGoto() ? block.exit().asGoto().getTarget() : null) != null && !visitedBlocks.contains(nextBlock) ? nextBlock : null) != null ? block.listIterator() : null) != null);
        return null;
    }

    private boolean allowNewFilledArrayConstruction(Instruction instruction) {
        if (!(instruction instanceof NewArrayEmpty)) {
            return false;
        }
        NewArrayEmpty newArray = instruction.asNewArrayEmpty();
        if (!newArray.size().isConstant()) {
            return false;
        }
        assert (newArray.size().isConstNumber());
        int size = newArray.size().getConstInstruction().asConstNumber().getIntValue();
        if (size < 1) {
            return false;
        }
        if (newArray.type.isPrimitiveArrayType()) {
            return true;
        }
        return newArray.type == this.dexItemFactory.stringArrayType && this.options.canUseFilledNewArrayOfObjects();
    }

    public void simplifyArrayConstruction(IRCode code) {
        if (this.options.isGeneratingClassFiles()) {
            return;
        }
        for (BasicBlock block : code.blocks) {
            BasicBlock nextBlock;
            HashMap<Value, InvokeNewArray> instructionToInsertForArray = new HashMap<Value, InvokeNewArray>();
            HashMap<Value, Integer> storesToRemoveForArray = new HashMap<Value, Integer>();
            InstructionListIterator it = block.listIterator();
            while (it.hasNext()) {
                int elementSize;
                short[] contents;
                int size;
                NewArrayEmpty newArray;
                ConstInstruction[] values2;
                Instruction instruction = (Instruction)it.next();
                if (instruction.getLocalInfo() != null || !this.allowNewFilledArrayConstruction(instruction) || (values2 = this.computeConstantArrayValues(newArray = instruction.asNewArrayEmpty(), block, size = newArray.size().getConstInstruction().asConstNumber().getIntValue())) == null) continue;
                if (newArray.type == this.dexItemFactory.stringArrayType) {
                    if (size > 200) continue;
                    ArrayList<Value> stringValues = new ArrayList<Value>(size);
                    for (ConstInstruction constInstruction : values2) {
                        stringValues.add(constInstruction.outValue());
                    }
                    Value invokeValue = code.createValue(newArray.outValue().getTypeLattice(), newArray.getLocalInfo());
                    InvokeNewArray invoke = new InvokeNewArray(this.dexItemFactory.stringArrayType, invokeValue, stringValues);
                    for (Value value : newArray.inValues()) {
                        value.removeUser(newArray);
                    }
                    newArray.outValue().replaceUsers(invokeValue);
                    it.removeOrReplaceByDebugLocalRead();
                    instructionToInsertForArray.put(invokeValue, invoke);
                    storesToRemoveForArray.put(invokeValue, size);
                    continue;
                }
                if (size == 1 || (contents = this.computeArrayFilledData(values2, size, elementSize = newArray.type.elementSizeForPrimitiveArrayType())) == null || block.hasCatchHandlers()) continue;
                int arraySize = newArray.size().getConstInstruction().asConstNumber().getIntValue();
                NewArrayFilledData fillArray = new NewArrayFilledData(newArray.outValue(), elementSize, arraySize, contents);
                fillArray.setPosition(newArray.getPosition());
                it.add(fillArray);
                storesToRemoveForArray.put(newArray.outValue(), size);
            }
            if (storesToRemoveForArray.isEmpty()) continue;
            Set<BasicBlock> visitedBlocks = Sets.newIdentityHashSet();
            do {
                visitedBlocks.add(block);
                it = block.listIterator();
                while (it.hasNext()) {
                    Value array;
                    Integer toRemoveCount;
                    Instruction instruction = (Instruction)it.next();
                    if (!instruction.isArrayPut() || (toRemoveCount = (Integer)storesToRemoveForArray.get(array = instruction.asArrayPut().array())) == null) continue;
                    if (toRemoveCount > 0) {
                        toRemoveCount = toRemoveCount - 1;
                        storesToRemoveForArray.put(array, toRemoveCount);
                        it.remove();
                    }
                    if (toRemoveCount != 0) continue;
                    toRemoveCount = toRemoveCount - 1;
                    storesToRemoveForArray.put(array, toRemoveCount);
                    Instruction construction = (Instruction)instructionToInsertForArray.get(array);
                    if (construction == null) continue;
                    construction.setPosition(instruction.getPosition());
                    it.add(construction);
                }
            } while ((block = (nextBlock = block.exit().isGoto() ? block.exit().asGoto().getTarget() : null) != null && !visitedBlocks.contains(nextBlock) ? nextBlock : null) != null);
        }
    }

    private static boolean hasLocalOrLineChangeBetween(Instruction from, Instruction to, DexString localVar) {
        if (from.getBlock() != to.getBlock()) {
            return true;
        }
        if (from.getPosition().isSome() && to.getPosition().isSome() && !from.getPosition().equals(to.getPosition())) {
            return true;
        }
        InstructionListIterator iterator2 = from.getBlock().listIterator(from);
        Position position = null;
        while (iterator2.hasNext()) {
            Instruction instruction = (Instruction)iterator2.next();
            if (position == null) {
                if (instruction.getPosition().isSome()) {
                    position = instruction.getPosition();
                }
            } else if (instruction.getPosition().isSome() && !position.equals(instruction.getPosition())) {
                return true;
            }
            if (instruction == to) {
                return false;
            }
            if (instruction.outValue() == null || !instruction.outValue().hasLocalInfo() || instruction.outValue().getLocalInfo().name != localVar) continue;
            return true;
        }
        throw new Unreachable();
    }

    public void simplifyDebugLocals(IRCode code) {
        for (BasicBlock block : code.blocks) {
            Instruction instruction;
            for (Phi phi : block.getPhis()) {
                if (phi.hasLocalInfo() || phi.numberOfUsers() != 1 || phi.numberOfAllUsers() != 1 || !(instruction = phi.singleUniqueUser()).isDebugLocalWrite()) continue;
                this.removeDebugWriteOfPhi(phi, instruction.asDebugLocalWrite());
            }
            InstructionListIterator iterator2 = block.listIterator();
            while (iterator2.hasNext()) {
                Instruction prevInstruction = iterator2.peekPrevious();
                instruction = (Instruction)iterator2.next();
                if (!instruction.isDebugLocalWrite()) continue;
                assert (instruction.inValues().size() == 1);
                Value inValue = instruction.inValues().get(0);
                DebugLocalInfo localInfo = instruction.outValue().getLocalInfo();
                DexString localName = localInfo.name;
                if (inValue.hasLocalInfo() || inValue.numberOfAllUsers() != 1 || inValue.definition == null || CodeRewriter.hasLocalOrLineChangeBetween(inValue.definition, instruction, localName)) continue;
                inValue.setLocalInfo(localInfo);
                instruction.outValue().replaceUsers(inValue);
                Value overwrittenLocal = instruction.removeDebugValue(localInfo);
                if (overwrittenLocal != null) {
                    inValue.definition.addDebugValue(overwrittenLocal);
                    overwrittenLocal.addDebugLocalEnd(inValue.definition);
                }
                if (!(prevInstruction == null || prevInstruction.outValue() != null && prevInstruction.outValue().hasLocalInfo() && instruction.getDebugValues().contains(prevInstruction.outValue()))) {
                    instruction.moveDebugValues(prevInstruction);
                }
                iterator2.removeOrReplaceByDebugLocalRead();
            }
        }
    }

    private void removeDebugWriteOfPhi(Phi phi, DebugLocalWrite write) {
        assert (write.src() == phi);
        InstructionListIterator iterator2 = phi.getBlock().listIterator();
        while (iterator2.hasNext()) {
            Instruction next = (Instruction)iterator2.next();
            if (!next.isDebugLocalWrite()) {
                return;
            }
            if (next == write) {
                phi.setLocalInfo(write.getLocalInfo());
                write.outValue().replaceUsers(phi);
                iterator2.removeOrReplaceByDebugLocalRead();
                return;
            }
            assert (next.getLocalInfo().name != write.getLocalInfo().name);
        }
    }

    private boolean shareCatchHandlers(Instruction i0, Instruction i1) {
        if (!i0.instructionTypeCanThrow()) {
            assert (!i1.instructionTypeCanThrow());
            return true;
        }
        assert (i1.instructionTypeCanThrow());
        CatchHandlers<BasicBlock> ch0 = i0.getBlock().getCatchHandlers();
        CatchHandlers<BasicBlock> ch1 = i1.getBlock().getCatchHandlers();
        return ch0.equals(ch1);
    }

    private boolean isCSEInstructionCandidate(Instruction instruction) {
        return (instruction.isBinop() || instruction.isUnop() || instruction.isInstanceOf() || instruction.isCheckCast()) && instruction.getLocalInfo() == null && !instruction.hasInValueWithLocalInfo();
    }

    private boolean hasCSECandidate(IRCode code, int noCandidate) {
        for (BasicBlock block : code.blocks) {
            InstructionListIterator iterator2 = block.listIterator();
            while (iterator2.hasNext()) {
                if (!this.isCSEInstructionCandidate((Instruction)iterator2.next())) continue;
                return true;
            }
            block.mark(noCandidate);
        }
        return false;
    }

    public void commonSubexpressionElimination(IRCode code) {
        int noCandidate = code.reserveMarkingColor();
        if (this.hasCSECandidate(code, noCandidate)) {
            ArrayListMultimap<Equivalence.Wrapper<Instruction>, Value> instructionToValue = ArrayListMultimap.create();
            CSEExpressionEquivalence equivalence = new CSEExpressionEquivalence(code);
            DominatorTree dominatorTree = new DominatorTree(code);
            for (int i = 0; i < dominatorTree.getSortedBlocks().length; ++i) {
                BasicBlock block = dominatorTree.getSortedBlocks()[i];
                if (block.isMarked(noCandidate)) continue;
                InstructionListIterator iterator2 = block.listIterator();
                while (iterator2.hasNext()) {
                    Instruction instruction = (Instruction)iterator2.next();
                    if (!this.isCSEInstructionCandidate(instruction)) continue;
                    Collection candidates = instructionToValue.get((Object)equivalence.wrap(instruction));
                    boolean eliminated = false;
                    if (candidates.size() > 0) {
                        for (Value candidate : candidates) {
                            if (!dominatorTree.dominatedBy(block, candidate.definition.getBlock()) || !this.shareCatchHandlers(instruction, candidate.definition)) continue;
                            instruction.outValue().replaceUsers(candidate);
                            eliminated = true;
                            iterator2.removeOrReplaceByDebugLocalRead();
                            break;
                        }
                    }
                    if (eliminated) continue;
                    instructionToValue.put(equivalence.wrap(instruction), instruction.outValue());
                }
            }
        }
        code.returnMarkingColor(noCandidate);
        assert (code.isConsistentSSA());
    }

    public void simplifyIf(IRCode code) {
        for (BasicBlock block : code.blocks) {
            if (block.getNumber() != 0 && block.getPredecessors().isEmpty() || !block.exit().isIf()) continue;
            this.flipIfBranchesIfNeeded(block);
            this.rewriteIfWithConstZero(block);
            if (this.simplifyKnownBooleanCondition(code, block)) continue;
            If theIf = block.exit().asIf();
            List<Value> inValues = theIf.inValues();
            if (inValues.get(0).isConstNumber() && (theIf.isZeroTest() || inValues.get(1).isConstNumber())) {
                if (theIf.isZeroTest()) {
                    ConstNumber cond = inValues.get(0).getConstInstruction().asConstNumber();
                    BasicBlock target = theIf.targetFromCondition(cond);
                    this.simplifyIfWithKnownCondition(code, block, theIf, target);
                    continue;
                }
                ConstNumber left = inValues.get(0).getConstInstruction().asConstNumber();
                ConstNumber right = inValues.get(1).getConstInstruction().asConstNumber();
                BasicBlock target = theIf.targetFromCondition(left, right);
                this.simplifyIfWithKnownCondition(code, block, theIf, target);
                continue;
            }
            if (inValues.get(0).hasValueRange() && (theIf.isZeroTest() || inValues.get(1).hasValueRange())) {
                LongInterval rightRange;
                if (theIf.isZeroTest()) {
                    LongInterval interval = inValues.get(0).getValueRange();
                    if (!interval.containsValue(0L)) {
                        int sign = Long.signum(interval.getMin());
                        this.simplifyIfWithKnownCondition(code, block, theIf, sign);
                        continue;
                    }
                    switch (theIf.getType()) {
                        case GE: 
                        case LT: {
                            if (interval.getMin() != 0L) break;
                            this.simplifyIfWithKnownCondition(code, block, theIf, 0);
                            break;
                        }
                        case LE: 
                        case GT: {
                            if (interval.getMax() != 0L) break;
                            this.simplifyIfWithKnownCondition(code, block, theIf, 0);
                            break;
                        }
                        case EQ: 
                        case NE: {
                            assert (!interval.isSingleValue());
                            break;
                        }
                    }
                    continue;
                }
                LongInterval leftRange = inValues.get(0).getValueRange();
                if (!leftRange.overlapsWith(rightRange = inValues.get(1).getValueRange())) {
                    int cond = Long.signum(leftRange.getMin() - rightRange.getMin());
                    this.simplifyIfWithKnownCondition(code, block, theIf, cond);
                    continue;
                }
                switch (theIf.getType()) {
                    case GE: 
                    case LT: {
                        if (leftRange.getMin() != rightRange.getMax()) break;
                        this.simplifyIfWithKnownCondition(code, block, theIf, 0);
                        break;
                    }
                    case LE: 
                    case GT: {
                        if (leftRange.getMax() != rightRange.getMin()) break;
                        this.simplifyIfWithKnownCondition(code, block, theIf, 0);
                        break;
                    }
                }
                continue;
            }
            if (!theIf.isZeroTest() || inValues.get(0).isConstNumber() || theIf.getType() != If.Type.EQ && theIf.getType() != If.Type.NE) continue;
            if (inValues.get(0).isNeverNull()) {
                this.simplifyIfWithKnownCondition(code, block, theIf, 1);
                continue;
            }
            TypeLatticeElement l = inValues.get(0).getTypeLattice();
            if (l.isPrimitive() || l.isNullable()) continue;
            this.simplifyIfWithKnownCondition(code, block, theIf, 1);
        }
        Set<Value> affectedValues = code.removeUnreachableBlocks();
        if (!affectedValues.isEmpty()) {
            new TypeAnalysis(this.appInfo, code.method).narrowing(affectedValues);
        }
        assert (code.isConsistentSSA());
    }

    private void simplifyIfWithKnownCondition(IRCode code, BasicBlock block, If theIf, BasicBlock target) {
        BasicBlock deadTarget = target == theIf.getTrueTarget() ? theIf.fallthroughBlock() : theIf.getTrueTarget();
        this.rewriteIfToGoto(code, block, theIf, target, deadTarget);
    }

    private void simplifyIfWithKnownCondition(IRCode code, BasicBlock block, If theIf, int cond) {
        this.simplifyIfWithKnownCondition(code, block, theIf, theIf.targetFromCondition(cond));
    }

    public void processMethodsNeverReturningNormally(IRCode code) {
        Enqueuer.AppInfoWithLiveness appInfoWithLiveness = this.appInfo.withLiveness();
        if (appInfoWithLiveness == null) {
            return;
        }
        ListIterator<BasicBlock> blockIterator = code.listIterator();
        while (blockIterator.hasNext()) {
            BasicBlock block = blockIterator.next();
            if (block.getNumber() != 0 && block.getPredecessors().isEmpty()) continue;
            InstructionListIterator insnIterator = block.listIterator();
            while (insnIterator.hasNext()) {
                DexEncodedMethod singleTarget;
                Instruction insn = (Instruction)insnIterator.next();
                if (!insn.isInvokeMethod() || (singleTarget = insn.asInvokeMethod().lookupSingleTarget(appInfoWithLiveness, code.method.method.getHolder())) == null || !singleTarget.getOptimizationInfo().neverReturnsNormally()) continue;
                BasicBlock newBlock = insnIterator.split(code, blockIterator);
                assert (!insnIterator.hasNext());
                blockIterator.previous();
                newBlock.unlinkSinglePredecessorSiblingsAllowed();
                Instruction gotoInsn = (Instruction)insnIterator.previous();
                assert (gotoInsn.isGoto());
                assert (insnIterator.hasNext());
                BasicBlock throwNullBlock = insnIterator.split(code, blockIterator);
                InstructionListIterator throwNullInsnIterator = throwNullBlock.listIterator();
                Value nullValue = code.createValue(TypeLatticeElement.NULL, gotoInsn.getLocalInfo());
                ConstNumber nullConstant = new ConstNumber(nullValue, 0L);
                nullConstant.setPosition(insn.getPosition());
                throwNullInsnIterator.add(nullConstant);
                Throw notReachableThrow = new Throw(nullValue);
                Instruction insnGoto = (Instruction)throwNullInsnIterator.next();
                assert (insnGoto.isGoto());
                throwNullInsnIterator.replaceCurrentInstruction(notReachableThrow);
            }
        }
        code.removeUnreachableBlocks();
        assert (code.isConsistentSSA());
    }

    private boolean simplifyKnownBooleanCondition(IRCode code, BasicBlock block) {
        If theIf = block.exit().asIf();
        Value testValue = theIf.inValues().get(0);
        if (theIf.isZeroTest() && testValue.knownToBeBoolean()) {
            BasicBlock targetBlock;
            BasicBlock trueBlock = theIf.getTrueTarget();
            BasicBlock falseBlock = theIf.fallthroughBlock();
            if (this.isBlockSupportedBySimplifyKnownBooleanCondition(trueBlock) && this.isBlockSupportedBySimplifyKnownBooleanCondition(falseBlock) && trueBlock.getSuccessors().get(0) == falseBlock.getSuccessors().get(0) && (targetBlock = trueBlock.getSuccessors().get(0)).getPredecessors().size() == 2) {
                int trueIndex = targetBlock.getPredecessors().indexOf(trueBlock);
                int falseIndex = trueIndex == 0 ? 1 : 0;
                int deadPhis = 0;
                for (Phi phi : targetBlock.getPhis()) {
                    Value trueValue = phi.getOperand(trueIndex);
                    Value falseValue = phi.getOperand(falseIndex);
                    if (!trueValue.isConstNumber() || !falseValue.isConstNumber()) continue;
                    ConstNumber trueNumber = trueValue.getConstInstruction().asConstNumber();
                    ConstNumber falseNumber = falseValue.getConstInstruction().asConstNumber();
                    if (theIf.getType() == If.Type.EQ && trueNumber.isIntegerZero() && falseNumber.isIntegerOne() || theIf.getType() == If.Type.NE && trueNumber.isIntegerOne() && falseNumber.isIntegerZero()) {
                        phi.replaceUsers(testValue);
                        ++deadPhis;
                        continue;
                    }
                    if ((theIf.getType() != If.Type.NE || !trueNumber.isIntegerZero() || !falseNumber.isIntegerOne()) && (theIf.getType() != If.Type.EQ || !trueNumber.isIntegerOne() || !falseNumber.isIntegerZero())) continue;
                    Value newOutValue = code.createValue(phi.getTypeLattice(), phi.getLocalInfo());
                    ConstNumber cstToUse = trueNumber.isIntegerOne() ? trueNumber : falseNumber;
                    BasicBlock phiBlock = phi.getBlock();
                    Position phiPosition = phiBlock.getPosition();
                    int insertIndex = 0;
                    if (cstToUse.getBlock() == trueBlock || cstToUse.getBlock() == falseBlock) {
                        cstToUse = ConstNumber.copyOf(code, cstToUse);
                        cstToUse.setBlock(phiBlock);
                        cstToUse.setPosition(phiPosition);
                        phiBlock.getInstructions().add(insertIndex++, cstToUse);
                    }
                    phi.replaceUsers(newOutValue);
                    Xor newInstruction = new Xor(NumericType.INT, newOutValue, testValue, cstToUse.outValue());
                    newInstruction.setBlock(phiBlock);
                    newInstruction.setPosition(phiPosition);
                    phiBlock.getInstructions().add(insertIndex, newInstruction);
                    ++deadPhis;
                }
                if (deadPhis == targetBlock.getPhis().size()) {
                    this.rewriteIfToGoto(code, block, theIf, trueBlock, falseBlock);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isBlockSupportedBySimplifyKnownBooleanCondition(BasicBlock b) {
        Instruction constInstruction;
        if (b.isTrivialGoto()) {
            return true;
        }
        int instructionSize = b.getInstructions().size();
        if (b.exit().isGoto() && (instructionSize == 2 || instructionSize == 3) && (constInstruction = b.getInstructions().get(instructionSize - 2)).isConstNumber()) {
            if (!constInstruction.asConstNumber().isIntegerOne() && !constInstruction.asConstNumber().isIntegerZero()) {
                return false;
            }
            if (instructionSize == 2) {
                return true;
            }
            Instruction firstInstruction = b.getInstructions().getFirst();
            if (firstInstruction.isDebugPosition()) {
                assert (b.getPredecessors().size() == 1);
                BasicBlock predecessorBlock = b.getPredecessors().get(0);
                InstructionListIterator it = predecessorBlock.listIterator(predecessorBlock.exit());
                Instruction previousPosition = null;
                while (it.hasPrevious() && !(previousPosition = (Instruction)it.previous()).isDebugPosition()) {
                }
                if (previousPosition != null) {
                    return previousPosition.getPosition() == firstInstruction.getPosition();
                }
            }
        }
        return false;
    }

    private void rewriteIfToGoto(IRCode code, BasicBlock block, If theIf, BasicBlock target, BasicBlock deadTarget) {
        deadTarget.unlinkSinglePredecessorSiblingsAllowed();
        assert (theIf == block.exit());
        block.replaceLastInstruction(new Goto());
        assert (block.exit().isGoto());
        assert (block.exit().asGoto().getTarget() == target);
    }

    private void rewriteIfWithConstZero(BasicBlock block) {
        If theIf = block.exit().asIf();
        if (theIf.isZeroTest()) {
            return;
        }
        List<Value> inValues = theIf.inValues();
        Value leftValue = inValues.get(0);
        Value rightValue = inValues.get(1);
        if (leftValue.isConstNumber() || rightValue.isConstNumber()) {
            if (leftValue.isConstNumber()) {
                if (leftValue.getConstInstruction().asConstNumber().isZero()) {
                    If ifz = new If(theIf.getType().forSwappedOperands(), rightValue);
                    block.replaceLastInstruction(ifz);
                    assert (block.exit() == ifz);
                }
            } else if (rightValue.getConstInstruction().asConstNumber().isZero()) {
                If ifz = new If(theIf.getType(), leftValue);
                block.replaceLastInstruction(ifz);
                assert (block.exit() == ifz);
            }
        }
    }

    private boolean flipIfBranchesIfNeeded(BasicBlock block) {
        If theIf = block.exit().asIf();
        BasicBlock trueTarget = theIf.getTrueTarget();
        BasicBlock fallthrough = theIf.fallthroughBlock();
        assert (trueTarget != fallthrough);
        if (!fallthrough.isSimpleAlwaysThrowingPath() || trueTarget.isSimpleAlwaysThrowingPath()) {
            return false;
        }
        List<Value> inValues = theIf.inValues();
        If newIf = new If(theIf.getType().inverted(), inValues);
        block.replaceLastInstruction(newIf);
        block.swapSuccessors(trueTarget, fallthrough);
        return true;
    }

    public void rewriteLongCompareAndRequireNonNull(IRCode code, InternalOptions options) {
        if (options.canUseLongCompareAndObjectsNonNull()) {
            return;
        }
        InstructionIterator iterator2 = code.instructionIterator();
        while (iterator2.hasNext()) {
            Instruction current = (Instruction)iterator2.next();
            if (!current.isInvokeMethod()) continue;
            DexMethod invokedMethod = current.asInvokeMethod().getInvokedMethod();
            if (invokedMethod == this.dexItemFactory.longMethods.compare) {
                List<Value> inValues = current.inValues();
                assert (inValues.size() == 2);
                iterator2.replaceCurrentInstruction(new Cmp(NumericType.LONG, Cmp.Bias.NONE, current.outValue(), inValues.get(0), inValues.get(1)));
                continue;
            }
            if (invokedMethod != this.dexItemFactory.objectsMethods.requireNonNull) continue;
            InvokeVirtual callToGetClass = new InvokeVirtual(this.dexItemFactory.objectMethods.getClass, null, current.inValues());
            if (current.outValue() != null) {
                current.outValue().replaceUsers(current.inValues().get(0));
                current.setOutValue(null);
            }
            iterator2.replaceCurrentInstruction(callToGetClass);
        }
        assert (code.isConsistentSSA());
    }

    public void rewriteThrowableAddAndGetSuppressed(IRCode code) {
        DexItemFactory.ThrowableMethods throwableMethods = this.dexItemFactory.throwableMethods;
        for (BasicBlock block : code.blocks) {
            InstructionListIterator iterator2 = block.listIterator();
            while (iterator2.hasNext()) {
                Instruction current = (Instruction)iterator2.next();
                if (!current.isInvokeMethod()) continue;
                DexMethod invokedMethod = current.asInvokeMethod().getInvokedMethod();
                if (this.matchesMethodOfThrowable(invokedMethod, throwableMethods.addSuppressed)) {
                    iterator2.removeOrReplaceByDebugLocalRead();
                    continue;
                }
                if (!this.matchesMethodOfThrowable(invokedMethod, throwableMethods.getSuppressed)) continue;
                Value destValue = current.outValue();
                if (destValue == null) {
                    iterator2.removeOrReplaceByDebugLocalRead();
                    continue;
                }
                ConstNumber zero = code.createIntConstant(0);
                zero.setPosition(current.getPosition());
                assert (iterator2.hasPrevious());
                iterator2.previous();
                iterator2.add(zero);
                Instruction next = (Instruction)iterator2.next();
                assert (current == next);
                NewArrayEmpty newArray = new NewArrayEmpty(destValue, zero.outValue(), this.dexItemFactory.createType(this.dexItemFactory.throwableArrayDescriptor));
                iterator2.replaceCurrentInstruction(newArray);
            }
        }
        assert (code.isConsistentSSA());
    }

    private boolean matchesMethodOfThrowable(DexMethod invoked, DexMethod expected) {
        return invoked.name == expected.name && invoked.proto == expected.proto && this.isSubtypeOfThrowable(invoked.holder);
    }

    private boolean isSubtypeOfThrowable(DexType type) {
        while (type != null && type != this.dexItemFactory.objectType) {
            if (type == this.dexItemFactory.throwableType) {
                return true;
            }
            DexClass dexClass = this.appInfo.definitionFor(type);
            if (dexClass == null) {
                throw new CompilationError("Class or interface " + type.toSourceString() + " required for desugaring of try-with-resources is not found.");
            }
            type = dexClass.superType;
        }
        return false;
    }

    private Value addConstString(IRCode code, InstructionListIterator iterator2, String s) {
        TypeLatticeElement typeLattice = TypeLatticeElement.stringClassType(this.appInfo);
        Value value = code.createValue(typeLattice);
        BasicBlock.ThrowingInfo throwingInfo = this.options.isGeneratingClassFiles() ? BasicBlock.ThrowingInfo.NO_THROW : BasicBlock.ThrowingInfo.CAN_THROW;
        iterator2.add(new ConstString(value, this.dexItemFactory.createString(s), throwingInfo));
        return value;
    }

    public void logArgumentTypes(DexEncodedMethod method, IRCode code) {
        List<Value> arguments = code.collectArguments();
        BasicBlock block = code.blocks.getFirst();
        InstructionListIterator iterator2 = block.listIterator();
        Position position = Position.synthetic(1, method.method, null);
        iterator2.setInsertionPosition(position);
        iterator2.nextUntil(instruction -> !instruction.isArgument());
        iterator2.previous();
        iterator2.split(code);
        iterator2.previous();
        assert (!block.hasCatchHandlers());
        DexType javaLangSystemType = this.dexItemFactory.createType("Ljava/lang/System;");
        DexType javaIoPrintStreamType = this.dexItemFactory.createType("Ljava/io/PrintStream;");
        Value out = code.createValue(TypeLatticeElement.fromDexType(javaIoPrintStreamType, false, this.appInfo));
        DexProto proto = this.dexItemFactory.createProto(this.dexItemFactory.voidType, this.dexItemFactory.objectType);
        DexMethod print = this.dexItemFactory.createMethod(javaIoPrintStreamType, proto, "print");
        DexMethod printLn = this.dexItemFactory.createMethod(javaIoPrintStreamType, proto, "println");
        iterator2.add(new StaticGet(out, this.dexItemFactory.createField(javaLangSystemType, javaIoPrintStreamType, "out")));
        Value value = this.addConstString(code, iterator2, "INVOKE ");
        iterator2.add(new InvokeVirtual(print, null, ImmutableList.of(out, value)));
        value = this.addConstString(code, iterator2, method.method.qualifiedName());
        iterator2.add(new InvokeVirtual(print, null, ImmutableList.of(out, value)));
        Value openParenthesis = this.addConstString(code, iterator2, "(");
        Value comma = this.addConstString(code, iterator2, ",");
        Value closeParenthesis = this.addConstString(code, iterator2, ")");
        Value indent = this.addConstString(code, iterator2, "  ");
        Value nul = this.addConstString(code, iterator2, "(null)");
        Value primitive = this.addConstString(code, iterator2, "(primitive)");
        Value empty = this.addConstString(code, iterator2, "");
        iterator2.add(new InvokeVirtual(printLn, null, ImmutableList.of(out, openParenthesis)));
        for (int i = 0; i < arguments.size(); ++i) {
            iterator2.add(new InvokeVirtual(print, null, ImmutableList.of(out, indent)));
            BasicBlock eol = BasicBlock.createGotoBlock(code.blocks.size(), position);
            code.blocks.add(eol);
            BasicBlock successor = block.unlinkSingleSuccessor();
            block.link(eol);
            eol.link(successor);
            Value argument = arguments.get(i);
            if (!argument.getTypeLattice().isReference()) {
                iterator2.add(new InvokeVirtual(print, null, ImmutableList.of(out, primitive)));
            } else {
                successor = block.unlinkSingleSuccessor();
                If theIf = new If(If.Type.NE, argument);
                theIf.setPosition(position);
                BasicBlock ifBlock = BasicBlock.createIfBlock(code.blocks.size(), theIf);
                code.blocks.add(ifBlock);
                BasicBlock isNullBlock = BasicBlock.createGotoBlock(code.blocks.size(), position);
                code.blocks.add(isNullBlock);
                BasicBlock isNotNullBlock = BasicBlock.createGotoBlock(code.blocks.size(), position);
                code.blocks.add(isNotNullBlock);
                block.link(ifBlock);
                ifBlock.link(isNotNullBlock);
                ifBlock.link(isNullBlock);
                isNotNullBlock.link(successor);
                isNullBlock.link(successor);
                iterator2 = isNullBlock.listIterator();
                iterator2.setInsertionPosition(position);
                iterator2.add(new InvokeVirtual(print, null, ImmutableList.of(out, nul)));
                iterator2 = isNotNullBlock.listIterator();
                iterator2.setInsertionPosition(position);
                value = code.createValue(TypeLatticeElement.classClassType(this.appInfo));
                iterator2.add(new InvokeVirtual(this.dexItemFactory.objectMethods.getClass, value, ImmutableList.of(arguments.get(i))));
                iterator2.add(new InvokeVirtual(print, null, ImmutableList.of(out, value)));
            }
            iterator2 = eol.listIterator();
            iterator2.setInsertionPosition(position);
            if (i == arguments.size() - 1) {
                iterator2.add(new InvokeVirtual(printLn, null, ImmutableList.of(out, closeParenthesis)));
            } else {
                iterator2.add(new InvokeVirtual(printLn, null, ImmutableList.of(out, comma)));
            }
            block = eol;
        }
        iterator2.add(new InvokeVirtual(printLn, null, ImmutableList.of(out, empty)));
    }

    public static void ensureDirectStringNewToInit(IRCode code) {
        DexItemFactory factory = code.options.itemFactory;
        for (BasicBlock block : code.blocks) {
            InstructionListIterator it = block.listIterator();
            while (it.hasNext()) {
                InvokeDirect invoke;
                DexMethod method;
                Instruction instruction = (Instruction)it.next();
                if (!instruction.isInvokeDirect() || !factory.isConstructor(method = (invoke = instruction.asInvokeDirect()).getInvokedMethod()) || method.holder != factory.stringType || !invoke.getReceiver().isPhi()) continue;
                NewInstance newInstance = CodeRewriter.findNewInstance(invoke.getReceiver().asPhi());
                CodeRewriter.replaceTrivialNewInstancePhis(newInstance.outValue());
                if (invoke.getReceiver().isPhi()) {
                    throw new CompilationError("Failed to remove trivial phis between new-instance and <init>");
                }
                newInstance.markNoSpilling();
            }
        }
    }

    private static NewInstance findNewInstance(Phi phi) {
        HashSet<Phi> seen = new HashSet<Phi>();
        HashSet<Value> values2 = new HashSet<Value>();
        CodeRewriter.recursiveAddOperands(phi, seen, values2);
        if (values2.size() != 1) {
            throw new CompilationError("Failed to identify unique new-instance for <init>");
        }
        Value newInstanceValue = (Value)values2.iterator().next();
        if (newInstanceValue.definition == null || !newInstanceValue.definition.isNewInstance()) {
            throw new CompilationError("Invalid defining value for call to <init>");
        }
        return newInstanceValue.definition.asNewInstance();
    }

    private static void recursiveAddOperands(Phi phi, Set<Phi> seen, Set<Value> values2) {
        for (Value operand : phi.getOperands()) {
            if (!operand.isPhi()) {
                values2.add(operand);
                continue;
            }
            Phi phiOp = operand.asPhi();
            if (!seen.add(phiOp)) continue;
            CodeRewriter.recursiveAddOperands(phiOp, seen, values2);
        }
    }

    private static void replaceTrivialNewInstancePhis(Value newInstanceValue) {
        List<Set<Value>> components = new SCC().computeSCC(newInstanceValue);
        for (int i = components.size() - 1; i >= 0; --i) {
            Set<Value> component = components.get(i);
            if (component.size() == 1 && component.iterator().next() == newInstanceValue) continue;
            HashSet<Phi> trivialPhis = new HashSet<Phi>();
            for (Value value : component) {
                boolean isTrivial = true;
                Phi p = value.asPhi();
                for (Value op : p.getOperands()) {
                    if (op == newInstanceValue || component.contains(op)) continue;
                    isTrivial = false;
                    break;
                }
                if (!isTrivial) continue;
                trivialPhis.add(p);
            }
            for (Phi trivialPhi : trivialPhis) {
                for (Value op : trivialPhi.getOperands()) {
                    op.removePhiUser(trivialPhi);
                }
                trivialPhi.replaceUsers(newInstanceValue);
                trivialPhi.getBlock().removePhi(trivialPhi);
            }
        }
    }

    public void workaroundNumberConversionRegisterAllocationBug(IRCode code) {
        Supplier<DexMethod> javaLangDoubleisNaN = Suppliers.memoize(() -> this.dexItemFactory.createMethod(this.dexItemFactory.createString("Ljava/lang/Double;"), this.dexItemFactory.createString("isNaN"), this.dexItemFactory.booleanDescriptor, new DexString[]{this.dexItemFactory.doubleDescriptor}));
        ListIterator<BasicBlock> blocks = code.listIterator();
        while (blocks.hasNext()) {
            BasicBlock block = blocks.next();
            InstructionListIterator it = block.listIterator();
            while (it.hasNext()) {
                Instruction instruction = (Instruction)it.next();
                if (!instruction.isArithmeticBinop() && !instruction.isNeg()) continue;
                for (Value value : instruction.inValues()) {
                    BasicBlock blockWithInvokeNaN;
                    if (value.isPhi() || !value.definition.isNumberConversion() || value.definition.asNumberConversion().to != NumericType.DOUBLE) continue;
                    InvokeStatic invokeIsNaN = new InvokeStatic(javaLangDoubleisNaN.get(), null, ImmutableList.of(value));
                    invokeIsNaN.setPosition(instruction.getPosition());
                    it.previous();
                    BasicBlock basicBlock = blockWithInvokeNaN = block.hasCatchHandlers() ? it.split(code, blocks) : block;
                    if (blockWithInvokeNaN != block) {
                        it = block.listIterator(block.getInstructions().size());
                        it.previous();
                        it.add(invokeIsNaN);
                        block = blockWithInvokeNaN;
                        it = block.listIterator();
                    } else {
                        it.add(invokeIsNaN);
                    }
                    Instruction temp = (Instruction)it.next();
                    assert (temp == instruction);
                }
            }
        }
    }

    public void workaroundExceptionTargetingLoopHeaderBug(IRCode code) {
        for (BasicBlock block : code.blocks) {
            if (!block.hasCatchHandlers()) continue;
            for (BasicBlock handler : block.getCatchHandlers().getUniqueTargets()) {
                BasicBlock target = handler.endOfGotoChain();
                if (target.getPredecessors().size() <= 2 || target.getNormalPredecessors().size() <= 1 || target.getNormalSuccessors().size() <= 1) continue;
                AlwaysMaterializingNop fixit = new AlwaysMaterializingNop();
                fixit.setBlock(handler);
                fixit.setPosition(handler.getPosition());
                handler.getInstructions().addFirst(fixit);
            }
        }
    }

    private static class SCC {
        private int currentTime = 0;
        private final Reference2IntMap<Value> discoverTime = new Reference2IntOpenHashMap<Value>();
        private final Set<Value> unassignedSet = new HashSet<Value>();
        private final Deque<Value> unassignedStack = new ArrayDeque<Value>();
        private final Deque<Value> preorderStack = new ArrayDeque<Value>();
        private final List<Set<Value>> components = new ArrayList<Set<Value>>();

        private SCC() {
        }

        public List<Set<Value>> computeSCC(Value v) {
            assert (this.currentTime == 0);
            this.dfs(v);
            return this.components;
        }

        private void dfs(Value value) {
            this.discoverTime.put(value, this.currentTime++);
            this.unassignedSet.add(value);
            this.unassignedStack.push(value);
            this.preorderStack.push(value);
            for (Phi phi : value.uniquePhiUsers()) {
                if (!this.discoverTime.containsKey(phi)) {
                    this.dfs(phi);
                    continue;
                }
                if (!this.unassignedSet.contains(phi)) continue;
                int discoverTimeOfPhi = this.discoverTime.getInt(phi);
                while (discoverTimeOfPhi < this.discoverTime.getInt(this.preorderStack.peek())) {
                    this.preorderStack.pop();
                }
            }
            if (this.preorderStack.peek() == value) {
                Value member;
                HashSet<Value> component = new HashSet<Value>(this.unassignedStack.size());
                do {
                    member = this.unassignedStack.pop();
                    this.unassignedSet.remove(member);
                    component.add(member);
                } while (member != value);
                this.components.add(component);
                this.preorderStack.pop();
            }
        }
    }

    private static class CSEExpressionEquivalence
    extends Equivalence<Instruction> {
        private final IRCode code;

        private CSEExpressionEquivalence(IRCode code) {
            this.code = code;
        }

        @Override
        protected boolean doEquivalent(Instruction a, Instruction b) {
            if (a.isCmp() && this.code.options.canHaveCmpLongBug()) {
                return false;
            }
            if (!a.identicalNonValueNonPositionParts(b)) {
                return false;
            }
            if (a.isBinop() && a.asBinop().isCommutative()) {
                Value a0 = a.inValues().get(0);
                Value a1 = a.inValues().get(1);
                Value b0 = b.inValues().get(0);
                Value b1 = b.inValues().get(1);
                return CSEExpressionEquivalence.identicalValue(a0, b0) && CSEExpressionEquivalence.identicalValue(a1, b1) || CSEExpressionEquivalence.identicalValue(a0, b1) && CSEExpressionEquivalence.identicalValue(a1, b0);
            }
            assert (a.inValues().size() == b.inValues().size());
            for (int i = 0; i < a.inValues().size(); ++i) {
                if (CSEExpressionEquivalence.identicalValue(a.inValues().get(i), b.inValues().get(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        protected int doHash(Instruction instruction) {
            int prime = 29;
            int hash = instruction.getClass().hashCode();
            if (instruction.isBinop()) {
                Binop binop = instruction.asBinop();
                Value in0 = instruction.inValues().get(0);
                Value in1 = instruction.inValues().get(1);
                if (binop.isCommutative()) {
                    hash += hash * 29 + CSEExpressionEquivalence.getHashCode(in0) * CSEExpressionEquivalence.getHashCode(in1);
                } else {
                    hash += hash * 29 + CSEExpressionEquivalence.getHashCode(in0);
                    hash += hash * 29 + CSEExpressionEquivalence.getHashCode(in1);
                }
                return hash;
            }
            for (Value value : instruction.inValues()) {
                hash += hash * 29 + CSEExpressionEquivalence.getHashCode(value);
            }
            return hash;
        }

        private static boolean identicalValue(Value a, Value b) {
            if (a.equals(b)) {
                return true;
            }
            if (a.isConstNumber() && b.isConstNumber()) {
                return a.definition.identicalNonValueNonPositionParts(b.definition);
            }
            return false;
        }

        private static int getHashCode(Value a) {
            if (a.isConstNumber()) {
                return Long.hashCode(a.definition.asConstNumber().getRawValue());
            }
            return a.hashCode();
        }
    }

    private static enum InstructionEffect {
        DESIRED_EFFECT,
        CONDITIONAL_EFFECT,
        OTHER_EFFECT,
        NO_EFFECT;

    }

    private static class Interval {
        private final IntList keys = new IntArrayList();

        public Interval(IntList ... allKeys) {
            assert (allKeys.length > 0);
            for (IntList keys2 : allKeys) {
                assert (keys2.size() > 0);
                this.keys.addAll(keys2);
            }
        }

        public int getMin() {
            return this.keys.getInt(0);
        }

        public int getMax() {
            return this.keys.getInt(this.keys.size() - 1);
        }

        public void addInterval(Interval other) {
            assert (this.getMax() < other.getMin());
            this.keys.addAll(other.keys);
        }

        public long packedSavings(InternalOutputMode mode) {
            long packedTargets = (long)this.getMax() - (long)this.getMin() + 1L;
            if (!Switch.canBePacked(mode, packedTargets)) {
                return -9223372036854775807L;
            }
            long sparseCost = (long)Switch.baseSparseSize(mode) + Switch.sparsePayloadSize(mode, this.keys.size());
            long packedCost = (long)Switch.basePackedSize(mode) + Switch.packedPayloadSize(mode, packedTargets);
            return sparseCost - packedCost;
        }

        public long estimatedSize(InternalOutputMode mode) {
            return Switch.estimatedSize(mode, this.keys.toIntArray());
        }
    }

    public static class IfBuilder
    extends InstructionBuilder<IfBuilder> {
        private final IRCode code;
        private Value left;
        private int right;
        private BasicBlock target;
        private BasicBlock fallthrough;

        public IfBuilder(Position position, IRCode code) {
            super(position);
            this.code = code;
        }

        @Override
        public IfBuilder self() {
            return this;
        }

        public IfBuilder setLeft(Value left) {
            this.left = left;
            return this;
        }

        public IfBuilder setRight(int right) {
            this.right = right;
            return this;
        }

        public IfBuilder setTarget(BasicBlock target) {
            this.target = target;
            return this;
        }

        public IfBuilder setFallthrough(BasicBlock fallthrough) {
            this.fallthrough = fallthrough;
            return this;
        }

        public BasicBlock build() {
            BasicBlock ifBlock;
            If newIf;
            assert (this.target != null);
            assert (this.fallthrough != null);
            if (this.right != 0) {
                ConstNumber rightConst = this.code.createIntConstant(this.right);
                rightConst.setPosition(this.position);
                newIf = new If(If.Type.EQ, ImmutableList.of(this.left, rightConst.dest()));
                ifBlock = BasicBlock.createIfBlock(this.blockNumber, newIf, rightConst);
            } else {
                newIf = new If(If.Type.EQ, this.left);
                ifBlock = BasicBlock.createIfBlock(this.blockNumber, newIf);
            }
            newIf.setPosition(this.position);
            ifBlock.link(this.target);
            ifBlock.link(this.fallthrough);
            return ifBlock;
        }
    }

    public static class SwitchBuilder
    extends InstructionBuilder<SwitchBuilder> {
        private Value value;
        private final Int2ObjectSortedMap<BasicBlock> keyToTarget = new Int2ObjectAVLTreeMap<BasicBlock>();
        private BasicBlock fallthrough;

        public SwitchBuilder(Position position) {
            super(position);
        }

        @Override
        public SwitchBuilder self() {
            return this;
        }

        public SwitchBuilder setValue(Value value) {
            this.value = value;
            return this;
        }

        public SwitchBuilder addKeyAndTarget(int key, BasicBlock target) {
            this.keyToTarget.put(key, target);
            return this;
        }

        public SwitchBuilder setFallthrough(BasicBlock fallthrough) {
            this.fallthrough = fallthrough;
            return this;
        }

        public BasicBlock build() {
            int NOT_FOUND = -1;
            Object2IntLinkedOpenHashMap<BasicBlock> targetToSuccessorIndex = new Object2IntLinkedOpenHashMap<BasicBlock>();
            targetToSuccessorIndex.defaultReturnValue(-1);
            int[] keys2 = new int[this.keyToTarget.size()];
            int[] targetBlockIndices = new int[this.keyToTarget.size()];
            int count = 0;
            IntBidirectionalIterator iter = this.keyToTarget.keySet().iterator();
            while (iter.hasNext()) {
                int key = iter.nextInt();
                BasicBlock target = (BasicBlock)this.keyToTarget.get(key);
                Integer targetIndex = targetToSuccessorIndex.computeIfAbsent(target, b -> targetToSuccessorIndex.size());
                keys2[count] = key;
                targetBlockIndices[count] = targetIndex;
                ++count;
            }
            Integer fallthroughIndex = targetToSuccessorIndex.computeIfAbsent(this.fallthrough, b -> targetToSuccessorIndex.size());
            Switch newSwitch = new Switch(this.value, keys2, targetBlockIndices, fallthroughIndex);
            newSwitch.setPosition(this.position);
            BasicBlock newSwitchBlock = BasicBlock.createSwitchBlock(this.blockNumber, newSwitch);
            for (BasicBlock successor : targetToSuccessorIndex.keySet()) {
                newSwitchBlock.link(successor);
            }
            return newSwitchBlock;
        }
    }

    public static abstract class InstructionBuilder<T> {
        protected int blockNumber;
        protected final Position position;

        protected InstructionBuilder(Position position) {
            this.position = position;
        }

        public abstract T self();

        public T setBlockNumber(int blockNumber) {
            this.blockNumber = blockNumber;
            return this.self();
        }
    }

    private static enum InstanceOfResult {
        UNKNOWN,
        TRUE,
        FALSE;

    }
}

