/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.naming.MemberNameMinifier;
import com.android.tools.r8.naming.MethodNameMinifier;
import com.android.tools.r8.naming.NamingState;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Timing;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class InterfaceMethodNameMinifier {
    private final Enqueuer.AppInfoWithLiveness appInfo;
    private final Set<DexCallSite> desugaredCallSites;
    private final Equivalence<DexMethod> equivalence;
    private final MethodNameMinifier.FrontierState frontierState;
    private final MemberNameMinifier.State minifierState;
    private final InternalOptions options;
    private final Map<DexCallSite, DexString> callSiteRenamings = new IdentityHashMap<DexCallSite, DexString>();
    private final Map<Equivalence.Wrapper<DexMethod>, Set<NamingState<DexProto, ?>>> globalStateMap = new HashMap();
    private final Map<Equivalence.Wrapper<DexMethod>, NamingState<DexProto, ?>> originStates = new HashMap();
    private final Map<Equivalence.Wrapper<DexMethod>, Set<DexMethod>> sourceMethodsMap = new HashMap<Equivalence.Wrapper<DexMethod>, Set<DexMethod>>();

    InterfaceMethodNameMinifier(Enqueuer.AppInfoWithLiveness appInfo, Set<DexCallSite> desugaredCallSites, Equivalence<DexMethod> equivalence, MethodNameMinifier.FrontierState frontierState, MemberNameMinifier.State minifierState, InternalOptions options) {
        this.appInfo = appInfo;
        this.desugaredCallSites = desugaredCallSites;
        this.equivalence = equivalence;
        this.frontierState = frontierState;
        this.minifierState = minifierState;
        this.options = options;
    }

    public Comparator<Equivalence.Wrapper<DexMethod>> createDefaultInterfaceMethodOrdering() {
        return (a, b) -> this.globalStateMap.get(b).size() - this.globalStateMap.get(a).size();
    }

    Map<DexCallSite, DexString> getCallSiteRenamings() {
        return this.callSiteRenamings;
    }

    private void reserveNamesInInterfaces() {
        for (DexType type : DexType.allInterfaces(this.appInfo.dexItemFactory)) {
            assert (type.isInterface());
            this.frontierState.allocateNamingStateAndReserve(type, type, null);
        }
    }

    void assignNamesToInterfaceMethods(Timing timing) {
        this.reserveNamesInInterfaces();
        timing.begin("Compute map");
        for (DexType type : DexType.allInterfaces(this.appInfo.dexItemFactory)) {
            assert (type.isInterface());
            DexClass clazz = this.appInfo.definitionFor(type);
            if (clazz == null) continue;
            assert (clazz.isInterface());
            Set<NamingState<DexProto, ?>> collectedStates = this.getReachableStates(type);
            for (DexEncodedMethod method : MethodNameMinifier.shuffleMethods(clazz.methods(), this.options)) {
                this.addStatesToGlobalMapForMethod(method.method, collectedStates, type);
            }
        }
        Sets.SetView<DexCallSite> liveCallSites = Sets.union(this.desugaredCallSites, this.appInfo.callSites);
        IdentityHashMap callSites = new IdentityHashMap();
        HashMap<Equivalence.Wrapper, Equivalence.Wrapper> unificationParent = new HashMap<Equivalence.Wrapper, Equivalence.Wrapper>();
        liveCallSites.forEach(callSite -> {
            HashSet<Equivalence.Wrapper<DexMethod>> callSiteMethods = new HashSet<Equivalence.Wrapper<DexMethod>>();
            Set<DexEncodedMethod> implementedMethods = this.appInfo.lookupLambdaImplementedMethods((DexCallSite)callSite);
            if (implementedMethods.isEmpty()) {
                return;
            }
            callSites.put(callSite, implementedMethods.iterator().next().method);
            for (DexEncodedMethod method : implementedMethods) {
                DexType dexType = method.method.holder;
                assert (dexType.isInterface());
                Set<NamingState<DexProto, ?>> collectedStates = this.getReachableStates(dexType);
                this.addStatesToGlobalMapForMethod(method.method, collectedStates, dexType);
                callSiteMethods.add(this.equivalence.wrap(method.method));
            }
            if (callSiteMethods.size() > 1) {
                Equivalence.Wrapper mainKey = (Equivalence.Wrapper)callSiteMethods.iterator().next();
                mainKey = unificationParent.getOrDefault(mainKey, mainKey);
                for (Equivalence.Wrapper wrapper : callSiteMethods) {
                    unificationParent.put(wrapper, mainKey);
                }
            }
        });
        HashMap<Equivalence.Wrapper<DexMethod>, Set<Equivalence.Wrapper<DexMethod>>> unification = new HashMap<Equivalence.Wrapper<DexMethod>, Set<Equivalence.Wrapper<DexMethod>>>();
        for (Equivalence.Wrapper key2 : unificationParent.keySet()) {
            Equivalence.Wrapper root = (Equivalence.Wrapper)unificationParent.get(key2);
            while (unificationParent.get(root) != root) {
                Equivalence.Wrapper wrapper2 = (Equivalence.Wrapper)unificationParent.get(unificationParent.get(root));
                unificationParent.put(root, wrapper2);
                root = wrapper2;
            }
            unification.computeIfAbsent(root, k -> new HashSet()).add(key2);
        }
        timing.end();
        timing.begin("Allocate names");
        List interfaceMethods = this.globalStateMap.keySet().stream().filter(wrapper -> unificationParent.getOrDefault(wrapper, (Equivalence.Wrapper)wrapper).equals(wrapper)).sorted(this.options.testing.minifier.createInterfaceMethodOrdering(this)).collect(Collectors.toList());
        List reservedInterfaceMethods = interfaceMethods.stream().filter(wrapper -> this.anyIsReserved((Equivalence.Wrapper<DexMethod>)wrapper, (Map<Equivalence.Wrapper<DexMethod>, Set<Equivalence.Wrapper<DexMethod>>>)unification)).collect(Collectors.toList());
        for (Equivalence.Wrapper wrapper3 : reservedInterfaceMethods) {
            this.propagateReservedNames(wrapper3, unification);
        }
        assert (reservedInterfaceMethods.stream().noneMatch(key -> this.propagateReservedNames((Equivalence.Wrapper<DexMethod>)key, (Map<Equivalence.Wrapper<DexMethod>, Set<Equivalence.Wrapper<DexMethod>>>)unification)));
        for (Equivalence.Wrapper wrapper4 : interfaceMethods) {
            if (reservedInterfaceMethods.contains(wrapper4)) continue;
            this.assignNameToInterfaceMethod(wrapper4, unification);
        }
        for (Map.Entry entry : callSites.entrySet()) {
            DexMethod method = (DexMethod)entry.getValue();
            DexString renamed = this.minifierState.getRenaming(method);
            if (this.originStates.get(this.equivalence.wrap(method)).isReserved(method.name, method.proto)) {
                assert (renamed == null);
                this.callSiteRenamings.put((DexCallSite)entry.getKey(), method.name);
                continue;
            }
            assert (renamed != null);
            this.callSiteRenamings.put((DexCallSite)entry.getKey(), renamed);
        }
        timing.end();
    }

    private boolean propagateReservedNames(Equivalence.Wrapper<DexMethod> key, Map<Equivalence.Wrapper<DexMethod>, Set<Equivalence.Wrapper<DexMethod>>> unification) {
        Set<Equivalence.Wrapper<DexMethod>> unifiedMethods = unification.getOrDefault(key, Collections.singleton(key));
        boolean changed = false;
        for (Equivalence.Wrapper<DexMethod> wrapper : unifiedMethods) {
            DexMethod unifiedMethod = wrapper.get();
            assert (unifiedMethod != null);
            for (NamingState<DexProto, ?> namingState : this.globalStateMap.get(wrapper)) {
                if (namingState.isReserved(unifiedMethod.name, unifiedMethod.proto)) continue;
                namingState.reserveName(unifiedMethod.name, unifiedMethod.proto);
                changed = true;
            }
        }
        return changed;
    }

    private void assignNameToInterfaceMethod(Equivalence.Wrapper<DexMethod> key, Map<Equivalence.Wrapper<DexMethod>, Set<Equivalence.Wrapper<DexMethod>>> unification) {
        ArrayList<MethodNameMinifier.MethodNamingState> collectedStates = new ArrayList<MethodNameMinifier.MethodNamingState>();
        Set<DexMethod> sourceMethods = Sets.newIdentityHashSet();
        for (Equivalence.Wrapper<DexMethod> k : unification.getOrDefault(key, Collections.singleton(key))) {
            DexMethod unifiedMethod = k.get();
            assert (unifiedMethod != null);
            sourceMethods.addAll((Collection)this.sourceMethodsMap.get(k));
            for (NamingState<DexProto, ?> namingState : this.globalStateMap.get(k)) {
                collectedStates.add(new MethodNameMinifier.MethodNamingState(namingState, unifiedMethod.name, unifiedMethod.proto));
            }
        }
        DexMethod method = key.get();
        assert (method != null);
        Set<String> loggingFilter = this.options.extensiveInterfaceMethodMinifierLoggingFilter;
        if (!loggingFilter.isEmpty()) {
            if (sourceMethods.stream().map(DexMethod::toSourceString).anyMatch(loggingFilter::contains)) {
                this.print(method, sourceMethods, collectedStates, System.out);
            }
        }
        MethodNameMinifier.MethodNamingState originState = new MethodNameMinifier.MethodNamingState(this.originStates.get(key), method.name, method.proto);
        this.assignNameForInterfaceMethodInAllStates(collectedStates, sourceMethods, originState);
    }

    private void assignNameForInterfaceMethodInAllStates(List<MethodNameMinifier.MethodNamingState> collectedStates, Set<DexMethod> sourceMethods, MethodNameMinifier.MethodNamingState originState) {
        DexString candidate;
        assert (!this.anyIsReserved(collectedStates));
        DexString previousCandidate = null;
        block0: do {
            if ((candidate = originState.assignNewName()) != null && candidate == previousCandidate) {
                assert (this.minifierState.useUniqueMemberNames());
                break;
            }
            for (MethodNameMinifier.MethodNamingState state : collectedStates) {
                if (state.isAvailable(candidate)) continue;
                previousCandidate = candidate;
                candidate = null;
                continue block0;
            }
        } while (candidate == null);
        for (MethodNameMinifier.MethodNamingState state : collectedStates) {
            state.addRenaming(candidate);
        }
        for (DexMethod sourceMethod : sourceMethods) {
            this.minifierState.putRenaming(sourceMethod, candidate);
        }
    }

    private void addStatesToGlobalMapForMethod(DexMethod method, Set<NamingState<DexProto, ?>> collectedStates, DexType originInterface) {
        Equivalence.Wrapper<DexMethod> key = this.equivalence.wrap(method);
        this.globalStateMap.computeIfAbsent(key, k -> new HashSet()).addAll(collectedStates);
        this.sourceMethodsMap.computeIfAbsent(key, k -> new HashSet()).add(method);
        this.originStates.putIfAbsent(key, this.minifierState.getState(originInterface));
    }

    private boolean anyIsReserved(Equivalence.Wrapper<DexMethod> key, Map<Equivalence.Wrapper<DexMethod>, Set<Equivalence.Wrapper<DexMethod>>> unification) {
        Set<Equivalence.Wrapper<DexMethod>> unifiedMethods = unification.getOrDefault(key, Collections.singleton(key));
        for (Equivalence.Wrapper<DexMethod> wrapper : unifiedMethods) {
            DexMethod unifiedMethod = wrapper.get();
            assert (unifiedMethod != null);
            for (NamingState<DexProto, ?> namingState : this.globalStateMap.get(wrapper)) {
                if (!namingState.isReserved(unifiedMethod.name, unifiedMethod.proto)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean anyIsReserved(List<MethodNameMinifier.MethodNamingState> collectedStates) {
        DexString name = collectedStates.get(0).getName();
        IdentityHashMap<DexProto, Boolean> globalStateCache = new IdentityHashMap<DexProto, Boolean>();
        for (MethodNameMinifier.MethodNamingState state : collectedStates) {
            assert (state.getName() == name);
            boolean isReservedInGlobalState = globalStateCache.computeIfAbsent(state.getProto(), proto -> this.minifierState.isReservedInGlobalState(name, proto));
            if (!isReservedInGlobalState || !state.isReserved()) continue;
            return true;
        }
        return false;
    }

    private Set<NamingState<DexProto, ?>> getReachableStates(DexType type) {
        if (this.minifierState.useUniqueMemberNames()) {
            return ImmutableSet.of(this.minifierState.globalState());
        }
        Set<DexType> reachableInterfaces = Sets.newIdentityHashSet();
        reachableInterfaces.add(type);
        this.collectSuperInterfaces(type, reachableInterfaces);
        this.collectSubInterfaces(type, reachableInterfaces);
        HashSet reachableStates = new HashSet();
        for (DexType reachableInterface : reachableInterfaces) {
            reachableStates.add(this.minifierState.getState(reachableInterface));
            for (DexType frontier : reachableInterface.allImplementsSubtypes()) {
                NamingState state = this.minifierState.getState(this.frontierState.get(frontier));
                assert (state != null);
                reachableStates.add(state);
            }
        }
        return reachableStates;
    }

    private void collectSuperInterfaces(DexType iface, Set<DexType> interfaces) {
        DexClass clazz = this.appInfo.definitionFor(iface);
        if (clazz != null) {
            for (DexType type : clazz.interfaces.values) {
                if (!interfaces.add(type)) continue;
                this.collectSuperInterfaces(type, interfaces);
            }
        }
    }

    private void collectSubInterfaces(DexType iface, Set<DexType> interfaces) {
        for (DexType subtype : iface.allExtendsSubtypes()) {
            assert (subtype.isInterface());
            if (!interfaces.add(subtype)) continue;
            this.collectSubInterfaces(subtype, interfaces);
        }
    }

    private void print(DexMethod method, Set<DexMethod> sourceMethods, List<MethodNameMinifier.MethodNamingState> collectedStates, PrintStream out) {
        out.println("-----------------------------------------------------------------------");
        out.println("assignNameToInterfaceMethod(`" + method.toSourceString() + "`)");
        out.println("-----------------------------------------------------------------------");
        out.println("Source methods:");
        for (DexMethod sourceMethod : sourceMethods) {
            out.println("  " + sourceMethod.toSourceString());
        }
        out.println("States:");
        collectedStates.forEach(state -> state.print("  ", this.minifierState::getStateKey, out));
        out.println();
    }
}

