/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.experimental.graphinfo.ClassGraphNode;
import com.android.tools.r8.experimental.graphinfo.FieldGraphNode;
import com.android.tools.r8.experimental.graphinfo.GraphConsumer;
import com.android.tools.r8.experimental.graphinfo.GraphEdgeInfo;
import com.android.tools.r8.experimental.graphinfo.GraphNode;
import com.android.tools.r8.experimental.graphinfo.KeepRuleGraphNode;
import com.android.tools.r8.experimental.graphinfo.MethodGraphNode;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.position.Position;
import com.android.tools.r8.position.TextPosition;
import com.android.tools.r8.position.TextRange;
import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.references.FieldReference;
import com.android.tools.r8.references.MethodReference;
import com.android.tools.r8.references.TypeReference;
import com.android.tools.r8.shaking.CollectingGraphConsumer;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.Pair;
import com.android.tools.r8.utils.StringUtils;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class WhyAreYouKeepingConsumer
extends CollectingGraphConsumer {
    public WhyAreYouKeepingConsumer(GraphConsumer subConsumer) {
        super(subConsumer);
    }

    public ClassGraphNode getClassNode(ClassReference clazz) {
        for (GraphNode node : this.getTargets()) {
            if (!(node instanceof ClassGraphNode) || ((ClassGraphNode)node).getReference() != clazz) continue;
            return (ClassGraphNode)node;
        }
        return null;
    }

    public MethodGraphNode getMethodNode(MethodReference method) {
        for (GraphNode node : this.getTargets()) {
            if (!(node instanceof MethodGraphNode) || ((MethodGraphNode)node).getReference() != method) continue;
            return (MethodGraphNode)node;
        }
        return null;
    }

    public FieldGraphNode getFieldNode(FieldReference field) {
        for (GraphNode node : this.getTargets()) {
            if (!(node instanceof FieldGraphNode) || ((FieldGraphNode)node).getReference() != field) continue;
            return (FieldGraphNode)node;
        }
        return null;
    }

    public void printWhyAreYouKeeping(ClassReference reference, PrintStream out) {
        ClassGraphNode node = this.getClassNode(reference);
        this.printWhyAreYouKeeping(node != null ? node : new ClassGraphNode(false, reference), out);
    }

    public void printWhyAreYouKeeping(MethodReference reference, PrintStream out) {
        MethodGraphNode node = this.getMethodNode(reference);
        this.printWhyAreYouKeeping(node != null ? node : new MethodGraphNode(false, reference), out);
    }

    public void printWhyAreYouKeeping(FieldReference reference, PrintStream out) {
        FieldGraphNode node = this.getFieldNode(reference);
        this.printWhyAreYouKeeping(node != null ? node : new FieldGraphNode(false, reference), out);
    }

    public void printWhyAreYouKeeping(GraphNode node, PrintStream out) {
        Formatter formatter = new Formatter(out);
        List<Pair<GraphNode, GraphEdgeInfo>> path = this.findShortestPathTo(node);
        if (path == null) {
            this.printNothingKeeping(node, out);
            return;
        }
        formatter.startItem(this.getNodeString(node));
        for (int i = path.size() - 1; i >= 0; --i) {
            Pair<GraphNode, GraphEdgeInfo> edge = path.get(i);
            this.printEdge(edge.getFirst(), edge.getSecond(), formatter);
        }
        formatter.endItem();
    }

    private void printNothingKeeping(GraphNode node, PrintStream out) {
        out.print("Nothing is keeping ");
        out.println(this.getNodeString(node));
    }

    private void printNothingKeeping(ClassReference clazz, PrintStream out) {
        out.print("Nothing is keeping ");
        out.println(DescriptorUtils.descriptorToJavaType(clazz.getDescriptor()));
    }

    private List<Pair<GraphNode, GraphEdgeInfo>> findShortestPathTo(GraphNode node) {
        if (node == null) {
            return null;
        }
        IdentityHashMap<GraphNode, GraphNode> seen = new IdentityHashMap<GraphNode, GraphNode>();
        LinkedList<GraphPath> queue = new LinkedList<GraphPath>();
        GraphPath path = null;
        GraphNode current = node;
        Map<GraphNode, Set<GraphEdgeInfo>> sources;
        while ((sources = this.getSourcesTargeting(current)) != null) {
            assert (!sources.isEmpty());
            for (GraphNode source : sources.keySet()) {
                if (seen.containsKey(source)) continue;
                seen.put(source, source);
                queue.addLast(new GraphPath(source, path));
            }
            if (queue.isEmpty()) {
                return this.getCanonicalPath(new GraphPath(GraphNode.cycle(), path), node);
            }
            path = (GraphPath)queue.removeFirst();
            current = path.node;
        }
        return this.getCanonicalPath(path, node);
    }

    private List<Pair<GraphNode, GraphEdgeInfo>> getCanonicalPath(GraphPath path, GraphNode endTarget) {
        if (path == null) {
            return null;
        }
        ArrayList<Pair<GraphNode, GraphEdgeInfo>> canonical = new ArrayList<Pair<GraphNode, GraphEdgeInfo>>();
        while (path.path != null) {
            GraphNode source = path.node;
            if (source.isCycle()) {
                canonical.add(new Pair<GraphNode, GraphEdgeInfo>(source, new GraphEdgeInfo(GraphEdgeInfo.EdgeKind.Unknown)));
            } else {
                GraphNode target = path.path.node;
                Set<GraphEdgeInfo> infos = this.getSourcesTargeting(target).get(source);
                canonical.add(new Pair<GraphNode, GraphEdgeInfo>(source, this.getCanonicalInfo(infos)));
            }
            path = path.path;
        }
        Set<GraphEdgeInfo> infos = this.getSourcesTargeting(endTarget).get(path.node);
        canonical.add(new Pair<GraphNode, GraphEdgeInfo>(path.node, this.getCanonicalInfo(infos)));
        return canonical;
    }

    private GraphEdgeInfo getCanonicalInfo(Set<GraphEdgeInfo> infos) {
        for (GraphEdgeInfo.EdgeKind kind : GraphEdgeInfo.EdgeKind.values()) {
            for (GraphEdgeInfo info : infos) {
                if (info.edgeKind() != kind) continue;
                return info;
            }
        }
        assert (false) : "Unexpected empty set of graph edge info";
        return GraphEdgeInfo.unknown();
    }

    private void printEdge(GraphNode node, GraphEdgeInfo info, Formatter formatter) {
        formatter.addReason("is " + info.getInfoPrefix() + ":");
        this.addNodeMessage(node, formatter);
    }

    private String getNodeString(GraphNode node) {
        if (node instanceof ClassGraphNode) {
            return DescriptorUtils.descriptorToJavaType(((ClassGraphNode)node).getReference().getDescriptor());
        }
        if (node instanceof MethodGraphNode) {
            MethodReference method = ((MethodGraphNode)node).getReference();
            return (method.getReturnType() == null ? "void" : method.getReturnType().getTypeName()) + ' ' + method.getHolderClass().getTypeName() + '.' + method.getMethodName() + StringUtils.join(ListUtils.map(method.getFormalTypes(), TypeReference::getTypeName), ",", StringUtils.BraceType.PARENS);
        }
        if (node instanceof FieldGraphNode) {
            FieldReference field = ((FieldGraphNode)node).getReference();
            return field.getFieldType().getTypeName() + ' ' + field.getHolderClass().getTypeName() + '.' + field.getFieldName();
        }
        if (node instanceof KeepRuleGraphNode) {
            KeepRuleGraphNode keepRuleNode = (KeepRuleGraphNode)node;
            return keepRuleNode.getOrigin() == Origin.unknown() ? keepRuleNode.getContent() : keepRuleNode.getOrigin() + ":" + WhyAreYouKeepingConsumer.shortPositionInfo(keepRuleNode.getPosition());
        }
        if (node == GraphNode.cycle()) {
            return "only cyclic dependencies remain, failed to determine a path from a keep rule";
        }
        assert (false) : "Unexpected graph node type: " + node;
        return Objects.toString(node);
    }

    private void addNodeMessage(GraphNode node, Formatter formatter) {
        for (String line : StringUtils.splitLines(this.getNodeString(node))) {
            formatter.addMessage(line);
        }
    }

    private static String shortPositionInfo(Position position) {
        if (position instanceof TextRange) {
            TextPosition start = ((TextRange)position).getStart();
            return start.getLine() + ":" + start.getColumn();
        }
        return position.getDescription();
    }

    private static class Formatter {
        private final PrintStream output;
        private int indentation = -1;

        public Formatter(PrintStream output) {
            this.output = output;
        }

        void startItem(String itemString) {
            ++this.indentation;
            this.indent();
            this.output.println(itemString);
        }

        private void indent() {
            for (int i = 0; i < this.indentation; ++i) {
                this.output.print("  ");
            }
        }

        void addReason(String thing) {
            this.indent();
            this.output.print("|- ");
            this.output.println(thing);
        }

        void addMessage(String thing) {
            this.indent();
            this.output.print("|  ");
            this.output.println(thing);
        }

        void endItem() {
            --this.indentation;
        }
    }

    private static class GraphPath {
        final GraphNode node;
        final GraphPath path;

        public GraphPath(GraphNode node, GraphPath path) {
            assert (node != null);
            this.node = node;
            this.path = path;
        }
    }
}

