/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.com.google.common.collect.BiMap;
import com.android.tools.r8.com.google.common.collect.HashBiMap;
import com.android.tools.r8.com.google.common.collect.ImmutableBiMap;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.Streams;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.ArgumentUse;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.ir.optimize.ArgumentRemovalUtils;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.utils.MethodSignatureEquivalence;
import com.android.tools.r8.utils.ThreadUtils;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;

public class UnusedArgumentsCollector {
    private final AppView<Enqueuer.AppInfoWithLiveness> appView;
    private final BiMap<DexMethod, DexMethod> methodMapping = HashBiMap.create();
    private final Map<DexMethod, GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo> removedArguments = new IdentityHashMap<DexMethod, GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo>();

    public UnusedArgumentsCollector(AppView<Enqueuer.AppInfoWithLiveness> appView) {
        this.appView = appView;
    }

    public GraphLense run(ExecutorService executorService) throws ExecutionException {
        ThreadUtils.awaitFutures(Streams.stream(this.appView.appInfo().classes()).map(this::runnableForClass).map(executorService::submit).collect(Collectors.toList()));
        if (!this.methodMapping.isEmpty()) {
            return new UnusedArgumentsGraphLense(ImmutableMap.of(), this.methodMapping, ImmutableMap.of(), ImmutableBiMap.of(), this.methodMapping.inverse(), this.appView.graphLense(), this.appView.dexItemFactory(), this.removedArguments);
        }
        return this.appView.graphLense();
    }

    private Runnable runnableForClass(DexProgramClass clazz) {
        return () -> this.processClass(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processClass(DexProgramClass clazz) {
        UsedSignatures signatures = new UsedSignatures();
        for (DexEncodedMethod method : clazz.methods()) {
            signatures.markSignatureAsUsed(method.method);
        }
        List<DexEncodedMethod> directMethods = clazz.directMethods();
        for (int i = 0; i < directMethods.size(); ++i) {
            GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo unused;
            DexEncodedMethod method = directMethods.get(i);
            DexEncodedMethod newMethod = signatures.removeArguments(method, unused = this.collectUnusedArguments(method));
            if (newMethod == null) continue;
            clazz.setDirectMethod(i, newMethod);
            UnusedArgumentsCollector unusedArgumentsCollector = this;
            synchronized (unusedArgumentsCollector) {
                this.methodMapping.put(method.method, newMethod.method);
                this.removedArguments.put(newMethod.method, unused);
                continue;
            }
        }
    }

    private GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo collectUnusedArguments(DexEncodedMethod method) {
        if (ArgumentRemovalUtils.isPinned(method, this.appView) || this.appView.appInfo().keepUnusedArguments.contains(method.method)) {
            return null;
        }
        if (method.getCode() == null || !method.getCode().isJarCode()) {
            return null;
        }
        assert (method.getCode().getOwner() == method);
        int offset = method.accessFlags.isStatic() ? 0 : 1;
        int argumentCount = method.method.proto.parameters.size() + offset;
        if (method.accessFlags.isPrivate() || method.accessFlags.isStatic()) {
            CollectUsedArguments collector = new CollectUsedArguments();
            if (!method.accessFlags.isStatic()) {
                collector.register(0);
            }
            method.getCode().registerArgumentReferences(collector);
            BitSet used = collector.getUsedArguments();
            if (used.cardinality() < argumentCount) {
                ArrayList<GraphLense.RewrittenPrototypeDescription.RemovedArgumentInfo> unused = new ArrayList<GraphLense.RewrittenPrototypeDescription.RemovedArgumentInfo>();
                for (int argumentIndex = 0; argumentIndex < argumentCount; ++argumentIndex) {
                    if (used.get(argumentIndex)) continue;
                    unused.add(GraphLense.RewrittenPrototypeDescription.RemovedArgumentInfo.builder().setArgumentIndex(argumentIndex).setType(method.method.proto.parameters.values[argumentIndex - offset]).build());
                }
                return new GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo(unused);
            }
        }
        return null;
    }

    private static class CollectUsedArguments
    extends ArgumentUse {
        private final BitSet used = new BitSet();

        private CollectUsedArguments() {
        }

        BitSet getUsedArguments() {
            return this.used;
        }

        @Override
        public boolean register(int argument) {
            this.used.set(argument);
            return true;
        }
    }

    private class UsedSignatures {
        private final MethodSignatureEquivalence equivalence = MethodSignatureEquivalence.get();
        private final Set<Equivalence.Wrapper<DexMethod>> usedSignatures = new HashSet<Equivalence.Wrapper<DexMethod>>();

        private UsedSignatures() {
        }

        private DexProto protoWithRemovedArguments(DexEncodedMethod encodedMethod, GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo unused) {
            DexMethod method = encodedMethod.method;
            int firstArgumentIndex = encodedMethod.isStatic() ? 0 : 1;
            int numberOfParameters = method.proto.parameters.size() - unused.numberOfRemovedArguments();
            if (!encodedMethod.isStatic() && unused.isArgumentRemoved(0)) {
                ++numberOfParameters;
            }
            DexType[] parameters = new DexType[numberOfParameters];
            if (numberOfParameters > 0) {
                int newIndex = 0;
                for (int oldIndex = 0; oldIndex < method.proto.parameters.size(); ++oldIndex) {
                    if (unused.isArgumentRemoved(oldIndex + firstArgumentIndex)) continue;
                    parameters[newIndex++] = method.proto.parameters.values[oldIndex];
                }
                assert (newIndex == parameters.length);
            }
            return ((Enqueuer.AppInfoWithLiveness)((UnusedArgumentsCollector)UnusedArgumentsCollector.this).appView.appInfo()).dexItemFactory.createProto(method.proto.returnType, parameters);
        }

        private boolean isMethodSignatureAvailable(DexMethod method) {
            return !this.usedSignatures.contains(this.equivalence.wrap(method));
        }

        private void markSignatureAsUsed(DexMethod method) {
            this.usedSignatures.add(this.equivalence.wrap(method));
        }

        private void markSignatureAsNoLongerUsed(DexMethod method) {
            boolean removed = this.usedSignatures.remove(this.equivalence.wrap(method));
            assert (removed);
        }

        DexEncodedMethod removeArguments(DexEncodedMethod method, GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo unused) {
            DexMethod newSignature;
            if (unused == null) {
                return null;
            }
            DexProto newProto = this.protoWithRemovedArguments(method, unused);
            int count = 0;
            DexString newName = null;
            do {
                if (newName == null) {
                    newName = method.method.name;
                } else if (method.method.name != ((UnusedArgumentsCollector)UnusedArgumentsCollector.this).appView.dexItemFactory().initMethodName) {
                    newName = UnusedArgumentsCollector.this.appView.dexItemFactory().createString(method.method.name.toSourceString() + count);
                } else {
                    return null;
                }
                newSignature = UnusedArgumentsCollector.this.appView.dexItemFactory().createMethod(method.method.holder, newProto, newName);
                ++count;
            } while (!this.isMethodSignatureAvailable(newSignature));
            this.markSignatureAsNoLongerUsed(method.method);
            this.markSignatureAsUsed(newSignature);
            return method.toTypeSubstitutedMethod(newSignature);
        }
    }

    static class UnusedArgumentsGraphLense
    extends GraphLense.NestedGraphLense {
        private final Map<DexMethod, GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo> removedArguments;

        UnusedArgumentsGraphLense(Map<DexType, DexType> typeMap, Map<DexMethod, DexMethod> methodMap, Map<DexField, DexField> fieldMap, BiMap<DexField, DexField> originalFieldSignatures, BiMap<DexMethod, DexMethod> originalMethodSignatures, GraphLense previousLense, DexItemFactory dexItemFactory, Map<DexMethod, GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo> removedArguments) {
            super(typeMap, methodMap, fieldMap, originalFieldSignatures, originalMethodSignatures, previousLense, dexItemFactory);
            this.removedArguments = removedArguments;
        }

        @Override
        public GraphLense.RewrittenPrototypeDescription lookupPrototypeChanges(DexMethod method) {
            DexMethod originalMethod = this.originalMethodSignatures != null ? this.originalMethodSignatures.getOrDefault(method, method) : method;
            GraphLense.RewrittenPrototypeDescription result = this.previousLense.lookupPrototypeChanges(originalMethod);
            GraphLense.RewrittenPrototypeDescription.RemovedArgumentsInfo removedArguments = this.removedArguments.get(method);
            return removedArguments != null ? result.withRemovedArguments(removedArguments) : result;
        }
    }
}

