/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.peepholes;

import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Load;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.StackValue;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.peepholes.BasicBlockPeephole;
import com.android.tools.r8.ir.optimize.peepholes.Match;
import com.android.tools.r8.ir.optimize.peepholes.PeepholeHelper;
import com.android.tools.r8.ir.optimize.peepholes.PeepholeLayout;
import com.android.tools.r8.ir.optimize.peepholes.Point;
import com.android.tools.r8.ir.optimize.peepholes.Wildcard;

public class MoveLoadUpPeephole
implements BasicBlockPeephole {
    private Value local = null;
    private int stackHeight = 0;
    private Instruction insertPosition = null;
    private final Point firstLoad = new Point(i -> {
        if (PeepholeHelper.withoutLocalInfo(Instruction::isLoad).test((Instruction)i)) {
            this.local = i.asLoad().src();
            return true;
        }
        return false;
    });
    private final Wildcard canMoveOver = new Wildcard(i -> {
        if (i.isArgument() || i.isMoveException() || i.isStore() && i.outValue() == this.local) {
            return false;
        }
        this.stackHeight += PeepholeHelper.numberOfValuesPutOnStack(i);
        if (this.stackHeight > 0) {
            return false;
        }
        this.stackHeight -= PeepholeHelper.numberOfValuesConsumedFromStack(i);
        if (this.stackHeight == 0 && !i.isDebugPosition()) {
            this.insertPosition = i;
        }
        return true;
    });
    private final PeepholeLayout layout = PeepholeLayout.lookBackward(this.firstLoad, this.canMoveOver);

    @Override
    public boolean match(InstructionListIterator it) {
        this.stackHeight = 0;
        this.insertPosition = null;
        Match match = this.layout.test(it);
        if (match == null || this.insertPosition == null || MoveLoadUpPeephole.isPotentionalIncInstruction(it)) {
            return false;
        }
        Load oldLoad = this.firstLoad.get(match).asLoad();
        assert (!oldLoad.src().hasLocalInfo());
        StackValue oldStackValue = (StackValue)oldLoad.outValue();
        StackValue newStackValue = oldStackValue.duplicate(oldStackValue.getHeight());
        oldStackValue.replaceUsers(newStackValue);
        oldLoad.src().removeUser(oldLoad);
        it.removeOrReplaceByDebugLocalRead();
        Instruction current = (Instruction)it.previous();
        while (current != this.insertPosition) {
            current = (Instruction)it.previous();
        }
        Load newLoad = new Load(newStackValue, oldLoad.src());
        newLoad.setPosition(this.insertPosition.getPosition());
        it.add(newLoad);
        return true;
    }

    private static boolean isPotentionalIncInstruction(InstructionListIterator it) {
        Instruction current;
        it.previous();
        Load load = ((Instruction)it.next()).asLoad();
        if (!it.hasNext()) {
            return false;
        }
        Position position = load.getPosition();
        if (position != (current = (Instruction)it.next()).getPosition() || !current.isConstNumber() || current.outValue().getTypeLattice() != TypeLatticeElement.INT || current.asConstNumber().getIntValue() < -128 || current.asConstNumber().getIntValue() > 127 || !it.hasNext()) {
            PeepholeHelper.resetNext(it, 2);
            return false;
        }
        current = (Instruction)it.next();
        if (position != current.getPosition() || !current.isAdd() || !it.hasNext()) {
            PeepholeHelper.resetNext(it, 3);
            return false;
        }
        current = (Instruction)it.next();
        PeepholeHelper.resetNext(it, 4);
        return position == current.getPosition() && current.isStore();
    }

    @Override
    public boolean resetAfterMatch() {
        return true;
    }
}

