/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.jar;

import com.android.tools.r8.ByteDataView;
import com.android.tools.r8.ClassFileConsumer;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.dex.ApplicationWriter;
import com.android.tools.r8.errors.Unimplemented;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationElement;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexEncodedAnnotation;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.graph.ParameterAnnotationsList;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.naming.ProguardMapSupplier;
import com.android.tools.r8.org.objectweb.asm.AnnotationVisitor;
import com.android.tools.r8.org.objectweb.asm.ClassReader;
import com.android.tools.r8.org.objectweb.asm.ClassWriter;
import com.android.tools.r8.org.objectweb.asm.FieldVisitor;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.org.objectweb.asm.Type;
import com.android.tools.r8.org.objectweb.asm.tree.ClassNode;
import com.android.tools.r8.org.objectweb.asm.tree.MethodNode;
import com.android.tools.r8.org.objectweb.asm.util.CheckClassAdapter;
import com.android.tools.r8.org.objectweb.asm.util.Textifier;
import com.android.tools.r8.org.objectweb.asm.util.TraceMethodVisitor;
import com.android.tools.r8.utils.ExceptionUtils;
import com.android.tools.r8.utils.InternalOptions;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.ExecutorService;

public class CfApplicationWriter {
    private static final boolean RUN_VERIFIER = false;
    private static final boolean PRINT_CF = false;
    private final DexApplication application;
    private final AppView<? extends AppInfo> appView;
    private final GraphLense graphLense;
    private final NamingLens namingLens;
    private final InternalOptions options;
    public final ProguardMapSupplier proguardMapSupplier;
    public final String deadCode;
    public final String proguardSeedsData;

    public CfApplicationWriter(DexApplication application, AppView<? extends AppInfo> appView, InternalOptions options, String deadCode, GraphLense graphLense, NamingLens namingLens, String proguardSeedsData, ProguardMapSupplier proguardMapSupplier) {
        this.application = application;
        this.appView = appView;
        this.graphLense = graphLense;
        this.namingLens = namingLens;
        this.options = options;
        this.proguardMapSupplier = proguardMapSupplier;
        this.deadCode = deadCode;
        this.proguardSeedsData = proguardSeedsData;
    }

    public void write(ClassFileConsumer consumer, ExecutorService executor) {
        this.application.timing.begin("CfApplicationWriter.write");
        try {
            this.writeApplication(consumer, executor);
        }
        finally {
            this.application.timing.end();
        }
    }

    private void writeApplication(ClassFileConsumer consumer, ExecutorService executor) {
        for (DexProgramClass clazz : this.application.classes()) {
            if (clazz.getSynthesizedFrom().isEmpty()) {
                this.writeClass(clazz, consumer);
                continue;
            }
            throw new Unimplemented("No support for synthetics in the Java bytecode backend.");
        }
        ApplicationWriter.supplyAdditionalConsumers(this.application, this.appView, this.graphLense, this.namingLens, this.options, this.deadCode, this.proguardMapSupplier, this.proguardSeedsData);
    }

    private void writeClass(DexProgramClass clazz, ClassFileConsumer consumer) {
        ClassWriter writer = new ClassWriter(0);
        writer.visitSource(clazz.sourceFile != null ? clazz.sourceFile.toString() : null, null);
        int version = this.getClassFileVersion(clazz);
        int access = clazz.accessFlags.getAsCfAccessFlags();
        String desc = this.namingLens.lookupDescriptor(clazz.type).toString();
        String name = this.namingLens.lookupInternalName(clazz.type);
        String signature = this.getSignature(clazz.annotations);
        String superName = clazz.type == this.options.itemFactory.objectType ? null : this.namingLens.lookupInternalName(clazz.superType);
        String[] interfaces = new String[clazz.interfaces.values.length];
        for (int i = 0; i < clazz.interfaces.values.length; ++i) {
            interfaces[i] = this.namingLens.lookupInternalName(clazz.interfaces.values[i]);
        }
        writer.visit(version, access, name, signature, superName, interfaces);
        this.writeAnnotations(writer::visitAnnotation, clazz.annotations.annotations);
        ImmutableMap<DexString, DexValue> defaults = this.getAnnotationDefaults(clazz.annotations);
        if (clazz.getEnclosingMethod() != null) {
            clazz.getEnclosingMethod().write(writer, this.namingLens);
        }
        for (InnerClassAttribute entry : clazz.getInnerClasses()) {
            entry.write(writer, this.namingLens, this.options);
        }
        for (DexEncodedField field : clazz.staticFields()) {
            this.writeField(field, writer);
        }
        for (DexEncodedField field : clazz.instanceFields()) {
            this.writeField(field, writer);
        }
        for (DexEncodedMethod method : clazz.directMethods()) {
            this.writeMethod(method, writer, defaults, version);
        }
        for (DexEncodedMethod method : clazz.virtualMethods()) {
            this.writeMethod(method, writer, defaults, version);
        }
        writer.visitEnd();
        byte[] result = writer.toByteArray();
        ExceptionUtils.withConsumeResourceHandler(this.options.reporter, handler -> consumer.accept(ByteDataView.of(result), desc, (DiagnosticsHandler)handler));
    }

    private int getClassFileVersion(DexProgramClass clazz) {
        int version = clazz.hasClassFileVersion() ? clazz.getInitialClassFileVersion() : 50;
        for (DexEncodedMethod method : clazz.directMethods()) {
            version = Math.max(version, method.getClassFileVersion());
        }
        for (DexEncodedMethod method : clazz.virtualMethods()) {
            version = Math.max(version, method.getClassFileVersion());
        }
        return version;
    }

    private DexValue getSystemAnnotationValue(DexAnnotationSet annotations, DexType type) {
        DexAnnotation annotation = annotations.getFirstMatching(type);
        if (annotation == null) {
            return null;
        }
        assert (annotation.visibility == 2);
        DexEncodedAnnotation encodedAnnotation = annotation.annotation;
        assert (encodedAnnotation.elements.length == 1);
        return encodedAnnotation.elements[0].value;
    }

    private String getSignature(DexAnnotationSet annotations) {
        DexValue.DexValueArray value = (DexValue.DexValueArray)this.getSystemAnnotationValue(annotations, this.application.dexItemFactory.annotationSignature);
        if (value == null) {
            return null;
        }
        DexValue[] parts = value.getValues();
        StringBuilder res = new StringBuilder();
        for (DexValue part : parts) {
            res.append(((DexString)((DexValue.DexValueString)part).getValue()).toString());
        }
        return res.toString();
    }

    private ImmutableMap<DexString, DexValue> getAnnotationDefaults(DexAnnotationSet annotations) {
        DexValue.DexValueAnnotation value = (DexValue.DexValueAnnotation)this.getSystemAnnotationValue(annotations, this.application.dexItemFactory.annotationDefault);
        if (value == null) {
            return ImmutableMap.of();
        }
        DexEncodedAnnotation annotation = value.value;
        ImmutableMap.Builder<DexString, DexValue> builder = ImmutableMap.builder();
        for (DexAnnotationElement element : annotation.elements) {
            builder.put(element.name, element.value);
        }
        return builder.build();
    }

    private String[] getExceptions(DexAnnotationSet annotations) {
        DexValue.DexValueArray value = (DexValue.DexValueArray)this.getSystemAnnotationValue(annotations, this.application.dexItemFactory.annotationThrows);
        if (value == null) {
            return null;
        }
        DexValue[] values2 = value.getValues();
        String[] res = new String[values2.length];
        for (int i = 0; i < values2.length; ++i) {
            res[i] = this.namingLens.lookupInternalName((DexType)((DexValue.DexValueType)values2[i]).value);
        }
        return res;
    }

    private Object getStaticValue(DexEncodedField field) {
        if (!field.accessFlags.isStatic() || !field.hasExplicitStaticValue()) {
            return null;
        }
        return field.getStaticValue().asAsmEncodedObject();
    }

    private void writeField(DexEncodedField field, ClassWriter writer) {
        int access = field.accessFlags.getAsCfAccessFlags();
        String name = this.namingLens.lookupName(field.field).toString();
        String desc = this.namingLens.lookupDescriptor(field.field.type).toString();
        String signature = this.getSignature(field.annotations);
        Object value = this.getStaticValue(field);
        FieldVisitor visitor = writer.visitField(access, name, desc, signature, value);
        this.writeAnnotations(visitor::visitAnnotation, field.annotations.annotations);
        visitor.visitEnd();
    }

    private void writeMethod(DexEncodedMethod method, ClassWriter writer, ImmutableMap<DexString, DexValue> defaults, int classFileVersion) {
        AnnotationVisitor defaultVisitor;
        int access = method.accessFlags.getAsCfAccessFlags();
        String name = this.namingLens.lookupName(method.method).toString();
        String desc = method.descriptor(this.namingLens);
        String signature = this.getSignature(method.annotations);
        String[] exceptions = this.getExceptions(method.annotations);
        MethodVisitor visitor = writer.visitMethod(access, name, desc, signature, exceptions);
        if (defaults.containsKey(method.method.name) && (defaultVisitor = visitor.visitAnnotationDefault()) != null) {
            this.writeAnnotationElement(defaultVisitor, null, defaults.get(method.method.name));
            defaultVisitor.visitEnd();
        }
        this.writeAnnotations(visitor::visitAnnotation, method.annotations.annotations);
        this.writeParameterAnnotations(visitor, method.parameterAnnotationsList);
        if (!method.shouldNotHaveCode()) {
            this.writeCode(method.getCode(), visitor, this.options, classFileVersion);
        }
        visitor.visitEnd();
    }

    private void writeParameterAnnotations(MethodVisitor visitor, ParameterAnnotationsList parameterAnnotations) {
        visitor.visitAnnotableParameterCount(parameterAnnotations.getAnnotableParameterCount(), true);
        visitor.visitAnnotableParameterCount(parameterAnnotations.getAnnotableParameterCount(), false);
        for (int i = 0; i < parameterAnnotations.size(); ++i) {
            int iFinal = i;
            this.writeAnnotations((d, vis) -> visitor.visitParameterAnnotation(iFinal, d, vis), parameterAnnotations.get((int)i).annotations);
        }
    }

    private void writeAnnotations(AnnotationConsumer visitor, DexAnnotation[] annotations) {
        for (DexAnnotation dexAnnotation : annotations) {
            if (dexAnnotation.visibility == 2) continue;
            AnnotationVisitor v = visitor.visit(this.namingLens.lookupDescriptor(dexAnnotation.annotation.type).toString(), dexAnnotation.visibility == 1);
            if (v == null) continue;
            this.writeAnnotation(v, dexAnnotation.annotation);
            v.visitEnd();
        }
    }

    private void writeAnnotation(AnnotationVisitor v, DexEncodedAnnotation annotation) {
        for (DexAnnotationElement element : annotation.elements) {
            this.writeAnnotationElement(v, element.name.toString(), element.value);
        }
    }

    private void writeAnnotationElement(AnnotationVisitor visitor, String name, DexValue value) {
        if (value instanceof DexValue.DexValueAnnotation) {
            DexValue.DexValueAnnotation valueAnnotation = (DexValue.DexValueAnnotation)value;
            AnnotationVisitor innerVisitor = visitor.visitAnnotation(name, this.namingLens.lookupDescriptor(valueAnnotation.value.type).toString());
            if (innerVisitor != null) {
                this.writeAnnotation(innerVisitor, valueAnnotation.value);
                innerVisitor.visitEnd();
            }
        } else if (value instanceof DexValue.DexValueArray) {
            DexValue[] values2 = ((DexValue.DexValueArray)value).getValues();
            AnnotationVisitor innerVisitor = visitor.visitArray(name);
            if (innerVisitor != null) {
                for (DexValue arrayValue : values2) {
                    this.writeAnnotationElement(innerVisitor, null, arrayValue);
                }
                innerVisitor.visitEnd();
            }
        } else if (value instanceof DexValue.DexValueEnum) {
            DexValue.DexValueEnum en = (DexValue.DexValueEnum)value;
            visitor.visitEnum(name, this.namingLens.lookupDescriptor(((DexField)en.value).type).toString(), ((DexField)en.value).name.toString());
        } else {
            if (value instanceof DexValue.DexValueField) {
                throw new Unreachable("writeAnnotationElement of DexValueField");
            }
            if (value instanceof DexValue.DexValueMethod) {
                throw new Unreachable("writeAnnotationElement of DexValueMethod");
            }
            if (value instanceof DexValue.DexValueMethodHandle) {
                throw new Unreachable("writeAnnotationElement of DexValueMethodHandle");
            }
            if (value instanceof DexValue.DexValueMethodType) {
                throw new Unreachable("writeAnnotationElement of DexValueMethodType");
            }
            if (value instanceof DexValue.DexValueString) {
                DexValue.DexValueString str = (DexValue.DexValueString)value;
                visitor.visit(name, ((DexString)str.getValue()).toString());
            } else if (value instanceof DexValue.DexValueType) {
                DexValue.DexValueType ty = (DexValue.DexValueType)value;
                visitor.visit(name, Type.getType(this.namingLens.lookupDescriptor((DexType)ty.value).toString()));
            } else {
                if (value instanceof DexValue.UnknownDexValue) {
                    throw new Unreachable("writeAnnotationElement of UnknownDexValue");
                }
                visitor.visit(name, value.getBoxedValue());
            }
        }
    }

    private void writeCode(Code code, MethodVisitor visitor, InternalOptions options, int classFileVersion) {
        if (code.isJarCode()) {
            assert (this.namingLens.isIdentityLens());
            code.asJarCode().writeTo(visitor);
        } else {
            assert (code.isCfCode());
            code.asCfCode().write(visitor, this.namingLens, options, classFileVersion);
        }
    }

    public static String printCf(byte[] result) {
        ClassReader reader = new ClassReader(result);
        ClassNode node = new ClassNode(393216);
        reader.accept(node, 393216);
        StringWriter writer = new StringWriter();
        for (MethodNode method : node.methods) {
            writer.append(method.name).append(method.desc).append('\n');
            TraceMethodVisitor visitor = new TraceMethodVisitor(new Textifier());
            method.accept(visitor);
            visitor.p.print(new PrintWriter(writer));
            writer.append('\n');
        }
        return writer.toString();
    }

    private static void verifyCf(byte[] result) {
        ClassReader reader = new ClassReader(result);
        PrintWriter pw = new PrintWriter(System.out);
        CheckClassAdapter.verify(reader, false, pw);
    }

    private static interface AnnotationConsumer {
        public AnnotationVisitor visit(String var1, boolean var2);
    }
}

