/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.compiling;

import com.android.builder.internal.ClassFieldImpl;
import com.android.builder.model.ClassField;
import com.android.ide.common.xml.XmlPrettyPrinter;
import com.android.resources.ResourceType;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ResValueGenerator {
    public static final String RES_VALUE_FILENAME_XML = "generated.xml";
    private static final List<ResourceType> RESOURCES_WITH_TAGS = ImmutableList.of((Object)ResourceType.ARRAY, (Object)ResourceType.ATTR, (Object)ResourceType.BOOL, (Object)ResourceType.COLOR, (Object)ResourceType.STYLEABLE, (Object)ResourceType.DIMEN, (Object)ResourceType.FRACTION, (Object)ResourceType.INTEGER, (Object)ResourceType.PLURALS, (Object)ResourceType.STRING, (Object)ResourceType.STYLE);
    private final File mGenFolder;
    private final List<ClassField> mFields = Lists.newArrayList();
    private List<Object> mItems = Lists.newArrayList();

    public ResValueGenerator(File genFolder) {
        this.mGenFolder = (File)Preconditions.checkNotNull((Object)genFolder);
    }

    public ResValueGenerator addResource(String type, String name, String value) {
        this.mFields.add(new ClassFieldImpl(type, name, value));
        return this;
    }

    public ResValueGenerator addItems(Collection<Object> items) {
        if (items != null) {
            this.mItems.addAll(items);
        }
        return this;
    }

    public File getFolderPath() {
        return new File(this.mGenFolder, "values");
    }

    public void generate() throws IOException, ParserConfigurationException {
        String content;
        File pkgFolder = this.getFolderPath();
        if (!pkgFolder.isDirectory() && !pkgFolder.mkdirs()) {
            throw new RuntimeException("Failed to create " + pkgFolder.getAbsolutePath());
        }
        File resFile = new File(pkgFolder, RES_VALUE_FILENAME_XML);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        factory.setIgnoringComments(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element rootNode = document.createElement("resources");
        document.appendChild(rootNode);
        rootNode.appendChild(document.createTextNode("\n"));
        rootNode.appendChild(document.createComment("Automatically generated file. DO NOT MODIFY"));
        rootNode.appendChild(document.createTextNode("\n\n"));
        for (Object item : this.mItems) {
            if (item instanceof ClassField) {
                ClassField field = (ClassField)item;
                ResourceType type = ResourceType.fromClassName((String)field.getType());
                if (type == null && "declare-styleable".equals(field.getType())) {
                    type = ResourceType.STYLEABLE;
                }
                boolean hasResourceTag = type != null && RESOURCES_WITH_TAGS.contains(type);
                Element itemNode = document.createElement(hasResourceTag ? field.getType() : "item");
                Attr nameAttr = document.createAttribute("name");
                nameAttr.setValue(field.getName());
                itemNode.getAttributes().setNamedItem(nameAttr);
                if (!hasResourceTag) {
                    Attr typeAttr = document.createAttribute("type");
                    typeAttr.setValue(field.getType());
                    itemNode.getAttributes().setNamedItem(typeAttr);
                }
                if (type == ResourceType.STRING) {
                    Attr translatable = document.createAttribute("translatable");
                    translatable.setValue("false");
                    itemNode.getAttributes().setNamedItem(translatable);
                }
                if (!field.getValue().isEmpty()) {
                    itemNode.appendChild(document.createTextNode(field.getValue()));
                }
                rootNode.appendChild(itemNode);
                continue;
            }
            if (!(item instanceof String)) continue;
            rootNode.appendChild(document.createTextNode("\n"));
            rootNode.appendChild(document.createComment((String)item));
            rootNode.appendChild(document.createTextNode("\n"));
        }
        try {
            content = XmlPrettyPrinter.prettyPrint((Node)document, (boolean)true);
        }
        catch (Throwable t) {
            content = XmlUtils.toXml((Node)document);
        }
        Files.asCharSink((File)resFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)content);
    }
}

