/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.profile;

import com.android.builder.profile.ProcessProfileWriter;
import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.AnalyticsSettingsData;
import com.android.tools.analytics.Anonymizer;
import com.android.tools.analytics.UsageTracker;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public final class ProcessProfileWriterFactory {
    private static final Object LOCK = new Object();
    private static ProcessProfileWriterFactory sINSTANCE;
    private ScheduledExecutorService mScheduledExecutorService = null;
    private ILogger mLogger = null;
    private ProcessProfileWriter processProfileWriter = null;
    private boolean enableChromeTracingOutput;

    private ProcessProfileWriterFactory() {
    }

    public static void initialize(File rootProjectDirectoryPath, String gradleVersion, ILogger logger, boolean enableChromeTracingOutput) {
        ProcessProfileWriterFactory.getFactory().initializeInternal(rootProjectDirectoryPath, gradleVersion, logger, enableChromeTracingOutput);
    }

    private synchronized void initializeInternal(File rootProjectDirectoryPath, String gradleVersion, ILogger logger, boolean enableChromeTracingOutput) {
        if (this.isInitialized()) {
            return;
        }
        this.mLogger = logger;
        this.enableChromeTracingOutput = enableChromeTracingOutput;
        ProcessProfileWriter recorder = this.get();
        ProcessProfileWriterFactory.setGlobalProperties(recorder, rootProjectDirectoryPath, gradleVersion, logger);
    }

    private static void setGlobalProperties(ProcessProfileWriter recorder, File projectPath, String gradleVersion, ILogger logger) {
        String anonymizedProjectId;
        recorder.getProperties().setOsName(Strings.nullToEmpty((String)System.getProperty("os.name"))).setOsVersion(Strings.nullToEmpty((String)System.getProperty("os.version"))).setJavaVersion(Strings.nullToEmpty((String)System.getProperty("java.version"))).setJavaVmVersion(Strings.nullToEmpty((String)System.getProperty("java.vm.version"))).setMaxMemory(Runtime.getRuntime().maxMemory()).setGradleVersion(Strings.nullToEmpty((String)gradleVersion));
        try {
            anonymizedProjectId = Anonymizer.anonymizeUtf8((ILogger)logger, (String)projectPath.getAbsolutePath());
        }
        catch (IOException e) {
            anonymizedProjectId = "*ANONYMIZATION_ERROR*";
        }
        recorder.getProperties().setProjectId(anonymizedProjectId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessProfileWriterFactory getFactory() {
        Object object = LOCK;
        synchronized (object) {
            if (sINSTANCE == null) {
                sINSTANCE = new ProcessProfileWriterFactory();
            }
            return sINSTANCE;
        }
    }

    synchronized boolean isInitialized() {
        return this.processProfileWriter != null;
    }

    public static Future<Void> shutdownAndMaybeWrite(Path outputFile) {
        return ProcessProfileWriterFactory.getFactory().shutdownAndMaybeWriteInternal(outputFile);
    }

    @VisibleForTesting
    public static void initializeForTests() {
        AnalyticsSettings.setInstanceForTest((AnalyticsSettingsData)new AnalyticsSettingsData());
        ProcessProfileWriterFactory.shutdownAndMaybeWrite(null);
        ProcessProfileWriterFactory.initialize(new File("fake/path/to/test_project"), "2.10", (ILogger)new StdLogger(StdLogger.Level.VERBOSE), false);
    }

    private static void initializeAnalytics(ILogger logger, ScheduledExecutorService eventLoop) {
        AnalyticsSettings.initialize((ILogger)logger);
        UsageTracker.initialize((ScheduledExecutorService)eventLoop);
        UsageTracker.setMaxJournalTime((long)10L, (TimeUnit)TimeUnit.MINUTES);
        UsageTracker.setMaxJournalSize((int)1000);
    }

    private synchronized Future<Void> shutdownAndMaybeWriteInternal(Path outputFile) {
        Future<Object> shutdownAction;
        if (this.isInitialized()) {
            ProcessProfileWriter processProfileWriter = (ProcessProfileWriter)Verify.verifyNotNull((Object)this.processProfileWriter);
            if (outputFile == null) {
                shutdownAction = this.getScheduledExecutorService().submit(() -> {
                    processProfileWriter.finish();
                    this.deinitializeAnalytics();
                    return null;
                });
            } else {
                processProfileWriter.finishAndWrite(outputFile);
                this.deinitializeAnalytics();
                shutdownAction = CompletableFuture.completedFuture(null);
            }
        } else {
            shutdownAction = CompletableFuture.completedFuture(null);
        }
        this.processProfileWriter = null;
        return shutdownAction;
    }

    synchronized ProcessProfileWriter get() {
        if (this.processProfileWriter == null) {
            if (this.mLogger == null) {
                this.mLogger = new StdLogger(StdLogger.Level.INFO);
            }
            ProcessProfileWriterFactory.initializeAnalytics(this.mLogger, this.getScheduledExecutorService());
            this.processProfileWriter = new ProcessProfileWriter(this.enableChromeTracingOutput);
        }
        return this.processProfileWriter;
    }

    private synchronized ScheduledExecutorService getScheduledExecutorService() {
        if (this.mScheduledExecutorService == null) {
            this.mScheduledExecutorService = Executors.newScheduledThreadPool(1);
        }
        return this.mScheduledExecutorService;
    }

    private synchronized void deinitializeAnalytics() {
        if (this.mScheduledExecutorService != null) {
            UsageTracker.deinitialize();
            this.mScheduledExecutorService.shutdown();
            this.mScheduledExecutorService = null;
        }
    }
}

