/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.string;

import com.android.tools.r8.com.google.common.annotations.VisibleForTesting;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.EscapeAnalysis;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.ConstClass;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.ConstString;
import com.android.tools.r8.ir.code.DexItemBasedConstString;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.CodeRewriter;
import com.android.tools.r8.ir.optimize.ReflectionOptimizer;
import com.android.tools.r8.shaking.RootSetBuilder;
import com.android.tools.r8.utils.InternalOptions;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

public class StringOptimizer {
    private final AppInfo appInfo;
    private final DexItemFactory factory;
    private final BasicBlock.ThrowingInfo throwingInfo;

    public StringOptimizer(AppInfo appInfo, InternalOptions options) {
        this.appInfo = appInfo;
        this.factory = appInfo.dexItemFactory;
        this.throwingInfo = options.isGeneratingClassFiles() ? BasicBlock.ThrowingInfo.NO_THROW : BasicBlock.ThrowingInfo.CAN_THROW;
    }

    public void computeTrivialOperationsOnConstString(IRCode code) {
        if (!code.hasConstString) {
            return;
        }
        InstructionIterator it = code.instructionIterator();
        while (it.hasNext()) {
            Instruction instr = (Instruction)it.next();
            if (!instr.isInvokeVirtual()) continue;
            InvokeVirtual invoke = instr.asInvokeVirtual();
            DexMethod invokedMethod = invoke.getInvokedMethod();
            Function<String, Integer> operatorWithNoArg = null;
            BiFunction<String, String, Integer> operatorWithString = null;
            if (invokedMethod == this.factory.stringMethods.length) {
                operatorWithNoArg = String::length;
            } else if (invokedMethod == this.factory.stringMethods.isEmpty) {
                operatorWithNoArg = rcv -> rcv.isEmpty() ? 1 : 0;
            } else if (invokedMethod == this.factory.stringMethods.contains) {
                operatorWithString = (rcv, arg) -> rcv.contains((CharSequence)arg) ? 1 : 0;
            } else if (invokedMethod == this.factory.stringMethods.startsWith) {
                operatorWithString = (rcv, arg) -> rcv.startsWith((String)arg) ? 1 : 0;
            } else if (invokedMethod == this.factory.stringMethods.endsWith) {
                operatorWithString = (rcv, arg) -> rcv.endsWith((String)arg) ? 1 : 0;
            } else if (invokedMethod == this.factory.stringMethods.equals) {
                operatorWithString = (rcv, arg) -> rcv.equals(arg) ? 1 : 0;
            } else if (invokedMethod == this.factory.stringMethods.equalsIgnoreCase) {
                operatorWithString = (rcv, arg) -> rcv.equalsIgnoreCase((String)arg) ? 1 : 0;
            } else if (invokedMethod == this.factory.stringMethods.contentEqualsCharSequence) {
                operatorWithString = (rcv, arg) -> rcv.contentEquals((CharSequence)arg) ? 1 : 0;
            }
            if (operatorWithNoArg == null && operatorWithString == null) continue;
            Value rcv2 = invoke.getReceiver().getAliasedValue();
            if (rcv2.definition == null || !rcv2.definition.isConstString() || !rcv2.isConstant()) continue;
            if (operatorWithNoArg != null) {
                assert (invoke.inValues().size() == 1);
                ConstString rcvString = rcv2.definition.asConstString();
                int v = operatorWithNoArg.apply(rcvString.getValue().toString());
                ConstNumber constNumber = code.createIntConstant(v);
                it.replaceCurrentInstruction(constNumber);
                continue;
            }
            assert (operatorWithString != null);
            assert (invoke.inValues().size() == 2);
            Value arg2 = invoke.inValues().get(1).getAliasedValue();
            if (arg2.definition == null || !arg2.definition.isConstString() || !arg2.isConstant()) continue;
            ConstString rcvString = rcv2.definition.asConstString();
            ConstString argString = arg2.definition.asConstString();
            int v = operatorWithString.apply(rcvString.getValue().toString(), argString.getValue().toString());
            ConstNumber constNumber = code.createIntConstant(v);
            it.replaceCurrentInstruction(constNumber);
        }
    }

    public void rewriteClassGetName(IRCode code, RootSetBuilder.RootSet rootSet) {
        if (code.method.isClassInitializer()) {
            return;
        }
        boolean markUseIdentifierNameString = false;
        InstructionIterator it = code.instructionIterator();
        while (it.hasNext()) {
            DexClass holder;
            Value out;
            InvokeVirtual invoke;
            DexMethod invokedMethod;
            Instruction instr = (Instruction)it.next();
            if (!instr.isInvokeVirtual() || !this.factory.classMethods.isReflectiveNameLookup(invokedMethod = (invoke = instr.asInvokeVirtual()).getInvokedMethod()) || (out = invoke.outValue()) == null || out.numberOfAllUsers() == 0 || !code.options.testing.forceNameReflectionOptimization && !StringOptimizer.hasPotentialReadOutside(this.appInfo, code.method, EscapeAnalysis.escape(code, out))) continue;
            assert (invoke.inValues().size() == 1);
            Value in = invoke.getReceiver().getAliasedValue();
            if (in.definition == null || !in.definition.isConstClass() || !in.isConstant()) continue;
            ConstClass constClass = in.definition.asConstClass();
            DexType type = constClass.getValue();
            int arrayDepth = type.getNumberOfLeadingSquareBrackets();
            DexType baseType = type.toBaseType(this.factory);
            if (!baseType.isClassType() || (holder = this.appInfo.definitionFor(baseType)) == null) continue;
            String descriptor = baseType.toDescriptorString();
            boolean assumeTopLevel = descriptor.indexOf(36) < 0;
            DexItemBasedConstString deferred = null;
            String name = null;
            if (invokedMethod == this.factory.classMethods.getName) {
                if (code.options.enableMinification && !rootSet.noObfuscation.contains(holder)) {
                    deferred = new DexItemBasedConstString(invoke.outValue(), baseType, new ReflectionOptimizer.ClassNameComputationInfo(ReflectionOptimizer.ClassNameComputationInfo.ClassNameComputationOption.NAME, arrayDepth));
                } else {
                    name = ReflectionOptimizer.computeClassName(descriptor, holder, ReflectionOptimizer.ClassNameComputationInfo.ClassNameComputationOption.NAME, arrayDepth);
                }
            } else {
                if (invokedMethod == this.factory.classMethods.getTypeName) continue;
                if (invokedMethod == this.factory.classMethods.getCanonicalName) {
                    if (holder.isLocalClass() || holder.isAnonymousClass()) {
                        ConstNumber constNull = code.createConstNull();
                        it.replaceCurrentInstruction(constNull);
                    } else {
                        if (!assumeTopLevel) continue;
                        if (code.options.enableMinification && !rootSet.noObfuscation.contains(holder)) {
                            deferred = new DexItemBasedConstString(invoke.outValue(), baseType, new ReflectionOptimizer.ClassNameComputationInfo(ReflectionOptimizer.ClassNameComputationInfo.ClassNameComputationOption.CANONICAL_NAME, arrayDepth));
                        } else {
                            name = ReflectionOptimizer.computeClassName(descriptor, holder, ReflectionOptimizer.ClassNameComputationInfo.ClassNameComputationOption.CANONICAL_NAME, arrayDepth);
                        }
                    }
                } else if (invokedMethod == this.factory.classMethods.getSimpleName) {
                    if (holder.isAnonymousClass()) {
                        name = "";
                    } else {
                        if (!assumeTopLevel) continue;
                        if (code.options.enableMinification && !rootSet.noObfuscation.contains(holder)) {
                            deferred = new DexItemBasedConstString(invoke.outValue(), baseType, new ReflectionOptimizer.ClassNameComputationInfo(ReflectionOptimizer.ClassNameComputationInfo.ClassNameComputationOption.SIMPLE_NAME, arrayDepth));
                        } else {
                            name = ReflectionOptimizer.computeClassName(descriptor, holder, ReflectionOptimizer.ClassNameComputationInfo.ClassNameComputationOption.SIMPLE_NAME, arrayDepth);
                        }
                    }
                }
            }
            if (name != null) {
                Value stringValue = code.createValue(TypeLatticeElement.stringClassType(this.appInfo, Nullability.definitelyNotNull()), invoke.getLocalInfo());
                ConstString constString = new ConstString(stringValue, this.factory.createString(name), this.throwingInfo);
                it.replaceCurrentInstruction(constString);
                continue;
            }
            if (deferred == null) continue;
            it.replaceCurrentInstruction(deferred);
            markUseIdentifierNameString = true;
        }
        if (markUseIdentifierNameString) {
            code.method.getMutableOptimizationInfo().markUseIdentifierNameString();
        }
    }

    @VisibleForTesting
    public static boolean hasPotentialReadOutside(AppInfo appInfo, DexEncodedMethod invocationContext, Set<Instruction> escapingInstructions) {
        for (Instruction instr : escapingInstructions) {
            if (instr.isReturn() || instr.isThrow() || instr.isStaticPut()) {
                return true;
            }
            if (instr.isInvokeMethod()) {
                DexMethod invokedMethod = instr.asInvokeMethod().getInvokedMethod();
                DexClass holder = appInfo.definitionFor(invokedMethod.getHolder());
                if (holder == null || holder.isLibraryClass() || invokedMethod.name == invocationContext.method.name) continue;
                return true;
            }
            if (!instr.isArrayPut()) continue;
            return instr.asArrayPut().array().isArgument();
        }
        return false;
    }

    public void removeTrivialConversions(IRCode code) {
        InstructionIterator it = code.instructionIterator();
        while (it.hasNext()) {
            Value out;
            TypeLatticeElement inType;
            Value in;
            DexMethod invokedMethod;
            InvokeMethod invoke;
            Instruction instr = (Instruction)it.next();
            if (instr.isInvokeStatic()) {
                invoke = instr.asInvokeStatic();
                invokedMethod = invoke.getInvokedMethod();
                if (invokedMethod != this.factory.stringMethods.valueOf) continue;
                assert (invoke.inValues().size() == 1);
                in = invoke.inValues().get(0);
                if (in.hasLocalInfo()) continue;
                inType = in.getTypeLattice();
                if (inType.isNullType()) {
                    Value nullStringValue = code.createValue(TypeLatticeElement.stringClassType(this.appInfo, Nullability.definitelyNotNull()), invoke.getLocalInfo());
                    ConstString nullString = new ConstString(nullStringValue, this.factory.createString("null"), this.throwingInfo);
                    it.replaceCurrentInstruction(nullString);
                    continue;
                }
                if (!inType.nullability().isDefinitelyNotNull() || !inType.isClassType() || !inType.asClassTypeLatticeElement().getClassType().equals(this.factory.stringType)) continue;
                out = invoke.outValue();
                if (out != null) {
                    CodeRewriter.removeOrReplaceByDebugLocalWrite(invoke, it, in, out);
                    continue;
                }
                it.removeOrReplaceByDebugLocalRead();
                continue;
            }
            if (!instr.isInvokeVirtual() || (invokedMethod = (invoke = instr.asInvokeVirtual()).getInvokedMethod()) != this.factory.stringMethods.toString) continue;
            assert (invoke.inValues().size() == 1);
            in = ((InvokeMethodWithReceiver)invoke).getReceiver();
            inType = in.getTypeLattice();
            if (!inType.nullability().isDefinitelyNotNull() || !inType.isClassType() || !inType.asClassTypeLatticeElement().getClassType().equals(this.factory.stringType)) continue;
            out = invoke.outValue();
            if (out != null) {
                CodeRewriter.removeOrReplaceByDebugLocalWrite(invoke, it, in, out);
                continue;
            }
            it.removeOrReplaceByDebugLocalRead();
        }
    }
}

