/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.jar;

import com.android.tools.r8.graph.ArgumentUse;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2IntMap;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;

public class JarArgumentUseVisitor
extends MethodVisitor {
    private final ArgumentUse registry;
    private final Int2IntMap slotToArgument;
    private final int arguments;

    public JarArgumentUseVisitor(DexEncodedMethod method, ArgumentUse registry) {
        super(393216);
        this.registry = registry;
        DexProto proto = method.method.proto;
        boolean isStatic = method.accessFlags.isStatic();
        boolean hasLongOrDouble = false;
        for (DexType value : proto.parameters.values) {
            if (!value.isLongType() && !value.isDoubleType()) continue;
            hasLongOrDouble = true;
            break;
        }
        if (hasLongOrDouble) {
            this.slotToArgument = new Int2IntArrayMap();
            int nextSlot = 0;
            int nextArgument = 0;
            if (!isStatic) {
                this.slotToArgument.put(nextSlot++, nextArgument++);
            }
            for (DexType value : proto.parameters.values) {
                this.slotToArgument.put(nextSlot++, nextArgument++);
                if (!value.isLongType() && !value.isDoubleType()) continue;
                ++nextSlot;
            }
            this.arguments = nextSlot;
        } else {
            this.slotToArgument = null;
            this.arguments = proto.parameters.values.length + (isStatic ? 0 : 1);
        }
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        switch (opcode) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                if (var >= this.arguments) break;
                this.registry.register(this.slotToArgument == null ? var : this.slotToArgument.get(var));
                break;
            }
        }
    }
}

