/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.code;

import com.android.dx.rop.code.LocalItem;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.util.MutabilityControl;

public final class RegisterSpecSet
extends MutabilityControl {
    public static final RegisterSpecSet EMPTY = new RegisterSpecSet(0);
    private final RegisterSpec[] specs;
    private int size;

    public RegisterSpecSet(int maxSize) {
        super(maxSize != 0);
        this.specs = new RegisterSpec[maxSize];
        this.size = 0;
    }

    public boolean equals(Object other) {
        if (!(other instanceof RegisterSpecSet)) {
            return false;
        }
        RegisterSpecSet otherSet = (RegisterSpecSet)other;
        int len = this.specs.length;
        RegisterSpec[] otherSpecs = otherSet.specs;
        if (len != otherSpecs.length || this.size() != otherSet.size()) {
            return false;
        }
        for (int i2 = 0; i2 < len; ++i2) {
            RegisterSpec s1 = this.specs[i2];
            RegisterSpec s2 = otherSpecs[i2];
            if (s1 == s2 || s1 != null && s1.equals(s2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int len = this.specs.length;
        int hash = 0;
        for (int i2 = 0; i2 < len; ++i2) {
            RegisterSpec spec = this.specs[i2];
            int oneHash = spec == null ? 0 : spec.hashCode();
            hash = hash * 31 + oneHash;
        }
        return hash;
    }

    public String toString() {
        int len = this.specs.length;
        StringBuilder sb2 = new StringBuilder(len * 25);
        sb2.append('{');
        boolean any = false;
        for (int i2 = 0; i2 < len; ++i2) {
            RegisterSpec spec = this.specs[i2];
            if (spec == null) continue;
            if (any) {
                sb2.append(", ");
            } else {
                any = true;
            }
            sb2.append(spec);
        }
        sb2.append('}');
        return sb2.toString();
    }

    public int getMaxSize() {
        return this.specs.length;
    }

    public int size() {
        int result = this.size;
        if (result < 0) {
            int len = this.specs.length;
            result = 0;
            for (int i2 = 0; i2 < len; ++i2) {
                if (this.specs[i2] == null) continue;
                ++result;
            }
            this.size = result;
        }
        return result;
    }

    public RegisterSpec get(int reg) {
        try {
            return this.specs[reg];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new IllegalArgumentException("bogus reg");
        }
    }

    public RegisterSpec get(RegisterSpec spec) {
        return this.get(spec.getReg());
    }

    public RegisterSpec findMatchingLocal(RegisterSpec spec) {
        for (RegisterSpec s2 : this.specs) {
            if (s2 == null || !spec.matchesVariable(s2)) continue;
            return s2;
        }
        return null;
    }

    public RegisterSpec localItemToSpec(LocalItem local) {
        for (RegisterSpec spec : this.specs) {
            if (spec == null || !local.equals(spec.getLocalItem())) continue;
            return spec;
        }
        return null;
    }

    public void remove(RegisterSpec toRemove) {
        try {
            this.specs[toRemove.getReg()] = null;
            this.size = -1;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new IllegalArgumentException("bogus reg");
        }
    }

    public void put(RegisterSpec spec) {
        this.throwIfImmutable();
        if (spec == null) {
            throw new NullPointerException("spec == null");
        }
        this.size = -1;
        try {
            int prevReg;
            RegisterSpec prevSpec;
            int reg = spec.getReg();
            this.specs[reg] = spec;
            if (reg > 0 && (prevSpec = this.specs[prevReg = reg - 1]) != null && prevSpec.getCategory() == 2) {
                this.specs[prevReg] = null;
            }
            if (spec.getCategory() == 2) {
                this.specs[reg + 1] = null;
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new IllegalArgumentException("spec.getReg() out of range");
        }
    }

    public void putAll(RegisterSpecSet set) {
        int max = set.getMaxSize();
        for (int i2 = 0; i2 < max; ++i2) {
            RegisterSpec spec = set.get(i2);
            if (spec == null) continue;
            this.put(spec);
        }
    }

    public void intersect(RegisterSpecSet other, boolean localPrimary) {
        int i2;
        this.throwIfImmutable();
        RegisterSpec[] otherSpecs = other.specs;
        int thisLen = this.specs.length;
        int len = Math.min(thisLen, otherSpecs.length);
        this.size = -1;
        for (i2 = 0; i2 < len; ++i2) {
            RegisterSpec intersection;
            RegisterSpec spec = this.specs[i2];
            if (spec == null || (intersection = spec.intersect(otherSpecs[i2], localPrimary)) == spec) continue;
            this.specs[i2] = intersection;
        }
        for (i2 = len; i2 < thisLen; ++i2) {
            this.specs[i2] = null;
        }
    }

    public RegisterSpecSet withOffset(int delta) {
        int len = this.specs.length;
        RegisterSpecSet result = new RegisterSpecSet(len + delta);
        for (int i2 = 0; i2 < len; ++i2) {
            RegisterSpec spec = this.specs[i2];
            if (spec == null) continue;
            result.put(spec.withOffset(delta));
        }
        result.size = this.size;
        if (this.isImmutable()) {
            result.setImmutable();
        }
        return result;
    }

    public RegisterSpecSet mutableCopy() {
        int len = this.specs.length;
        RegisterSpecSet copy = new RegisterSpecSet(len);
        for (int i2 = 0; i2 < len; ++i2) {
            RegisterSpec spec = this.specs[i2];
            if (spec == null) continue;
            copy.put(spec);
        }
        copy.size = this.size;
        return copy;
    }
}

