/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa;

import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.ssa.NormalSsaInsn;
import com.android.dx.ssa.PhiInsn;
import com.android.dx.ssa.SsaBasicBlock;
import com.android.dx.ssa.SsaInsn;
import com.android.dx.ssa.SsaMethod;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;

public class DeadCodeRemover {
    private final SsaMethod ssaMeth;
    private final int regCount;
    private final BitSet worklist;
    private final ArrayList<SsaInsn>[] useList;

    public static void process(SsaMethod ssaMethod) {
        DeadCodeRemover dc2 = new DeadCodeRemover(ssaMethod);
        dc2.run();
    }

    private DeadCodeRemover(SsaMethod ssaMethod) {
        this.ssaMeth = ssaMethod;
        this.regCount = ssaMethod.getRegCount();
        this.worklist = new BitSet(this.regCount);
        this.useList = this.ssaMeth.getUseListCopy();
    }

    private void run() {
        int regV;
        this.pruneDeadInstructions();
        HashSet<SsaInsn> deletedInsns = new HashSet<SsaInsn>();
        this.ssaMeth.forEachInsn(new NoSideEffectVisitor(this.worklist));
        while (0 <= (regV = this.worklist.nextSetBit(0))) {
            SsaInsn insnS;
            this.worklist.clear(regV);
            if (this.useList[regV].size() != 0 && !this.isCircularNoSideEffect(regV, null) || deletedInsns.contains(insnS = this.ssaMeth.getDefinitionForRegister(regV))) continue;
            RegisterSpecList sources = insnS.getSources();
            int sz = sources.size();
            for (int i2 = 0; i2 < sz; ++i2) {
                RegisterSpec source = sources.get(i2);
                this.useList[source.getReg()].remove(insnS);
                if (DeadCodeRemover.hasSideEffect(this.ssaMeth.getDefinitionForRegister(source.getReg()))) continue;
                this.worklist.set(source.getReg());
            }
            deletedInsns.add(insnS);
        }
        this.ssaMeth.deleteInsns(deletedInsns);
    }

    private void pruneDeadInstructions() {
        HashSet<SsaInsn> deletedInsns = new HashSet<SsaInsn>();
        BitSet reachable = this.ssaMeth.computeReachability();
        ArrayList<SsaBasicBlock> blocks = this.ssaMeth.getBlocks();
        int blockIndex = 0;
        while ((blockIndex = reachable.nextClearBit(blockIndex)) < blocks.size()) {
            SsaBasicBlock block = blocks.get(blockIndex);
            ++blockIndex;
            for (int i2 = 0; i2 < block.getInsns().size(); ++i2) {
                SsaInsn insn = block.getInsns().get(i2);
                RegisterSpecList sources = insn.getSources();
                int sourcesSize = sources.size();
                if (sourcesSize != 0) {
                    deletedInsns.add(insn);
                }
                for (int j2 = 0; j2 < sourcesSize; ++j2) {
                    RegisterSpec source = sources.get(j2);
                    this.useList[source.getReg()].remove(insn);
                }
                RegisterSpec result = insn.getResult();
                if (result == null) continue;
                for (SsaInsn use2 : this.useList[result.getReg()]) {
                    if (!(use2 instanceof PhiInsn)) continue;
                    PhiInsn phiUse = (PhiInsn)use2;
                    phiUse.removePhiRegister(result);
                }
            }
        }
        this.ssaMeth.deleteInsns(deletedInsns);
    }

    private boolean isCircularNoSideEffect(int regV, BitSet set) {
        if (set != null && set.get(regV)) {
            return true;
        }
        for (SsaInsn use2 : this.useList[regV]) {
            if (!DeadCodeRemover.hasSideEffect(use2)) continue;
            return false;
        }
        if (set == null) {
            set = new BitSet(this.regCount);
        }
        set.set(regV);
        for (SsaInsn use2 : this.useList[regV]) {
            RegisterSpec result = use2.getResult();
            if (result != null && this.isCircularNoSideEffect(result.getReg(), set)) continue;
            return false;
        }
        return true;
    }

    private static boolean hasSideEffect(SsaInsn insn) {
        if (insn == null) {
            return true;
        }
        return insn.hasSideEffect();
    }

    private static class NoSideEffectVisitor
    implements SsaInsn.Visitor {
        BitSet noSideEffectRegs;

        public NoSideEffectVisitor(BitSet noSideEffectRegs) {
            this.noSideEffectRegs = noSideEffectRegs;
        }

        @Override
        public void visitMoveInsn(NormalSsaInsn insn) {
            if (!DeadCodeRemover.hasSideEffect(insn)) {
                this.noSideEffectRegs.set(insn.getResult().getReg());
            }
        }

        @Override
        public void visitPhiInsn(PhiInsn phi) {
            if (!DeadCodeRemover.hasSideEffect(phi)) {
                this.noSideEffectRegs.set(phi.getResult().getReg());
            }
        }

        @Override
        public void visitNonMoveInsn(NormalSsaInsn insn) {
            RegisterSpec result = insn.getResult();
            if (!DeadCodeRemover.hasSideEffect(insn) && result != null) {
                this.noSideEffectRegs.set(result.getReg());
            }
        }
    }
}

