/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa;

import com.android.dx.cf.code.Merger;
import com.android.dx.rop.code.LocalItem;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.type.Type;
import com.android.dx.rop.type.TypeBearer;
import com.android.dx.ssa.PhiInsn;
import com.android.dx.ssa.SsaInsn;
import com.android.dx.ssa.SsaMethod;
import java.util.BitSet;
import java.util.List;

public class PhiTypeResolver {
    SsaMethod ssaMeth;
    private final BitSet worklist;

    public static void process(SsaMethod ssaMeth) {
        new PhiTypeResolver(ssaMeth).run();
    }

    private PhiTypeResolver(SsaMethod ssaMeth) {
        this.ssaMeth = ssaMeth;
        this.worklist = new BitSet(ssaMeth.getRegCount());
    }

    private void run() {
        SsaInsn definsn;
        int reg;
        int regCount = this.ssaMeth.getRegCount();
        for (reg = 0; reg < regCount; ++reg) {
            definsn = this.ssaMeth.getDefinitionForRegister(reg);
            if (definsn == null || definsn.getResult().getBasicType() != 0) continue;
            this.worklist.set(reg);
        }
        while (0 <= (reg = this.worklist.nextSetBit(0))) {
            this.worklist.clear(reg);
            definsn = (PhiInsn)this.ssaMeth.getDefinitionForRegister(reg);
            if (!this.resolveResultType((PhiInsn)definsn)) continue;
            List<SsaInsn> useList = this.ssaMeth.getUseListForRegister(reg);
            int sz = useList.size();
            for (int i2 = 0; i2 < sz; ++i2) {
                SsaInsn useInsn = useList.get(i2);
                RegisterSpec resultReg = useInsn.getResult();
                if (resultReg == null || !(useInsn instanceof PhiInsn)) continue;
                this.worklist.set(resultReg.getReg());
            }
        }
    }

    private static boolean equalsHandlesNulls(LocalItem a2, LocalItem b2) {
        return a2 == b2 || a2 != null && a2.equals(b2);
    }

    boolean resolveResultType(PhiInsn insn) {
        insn.updateSourcesToDefinitions(this.ssaMeth);
        RegisterSpecList sources = insn.getSources();
        RegisterSpec first = null;
        int firstIndex = -1;
        int szSources = sources.size();
        for (int i2 = 0; i2 < szSources; ++i2) {
            RegisterSpec rs = sources.get(i2);
            if (rs.getBasicType() == 0) continue;
            first = rs;
            firstIndex = i2;
        }
        if (first == null) {
            return false;
        }
        LocalItem firstLocal = first.getLocalItem();
        TypeBearer mergedType = first.getType();
        boolean sameLocals = true;
        for (int i3 = 0; i3 < szSources; ++i3) {
            RegisterSpec rs;
            if (i3 == firstIndex || (rs = sources.get(i3)).getBasicType() == 0) continue;
            sameLocals = sameLocals && PhiTypeResolver.equalsHandlesNulls(firstLocal, rs.getLocalItem());
            mergedType = Merger.mergeType(mergedType, rs.getType());
        }
        if (mergedType == null) {
            StringBuilder sb2 = new StringBuilder();
            for (int i4 = 0; i4 < szSources; ++i4) {
                sb2.append(sources.get(i4).toString());
                sb2.append(' ');
            }
            throw new RuntimeException("Couldn't map types in phi insn:" + sb2);
        }
        Type newResultType = mergedType;
        LocalItem newLocal = sameLocals ? firstLocal : null;
        RegisterSpec result = insn.getResult();
        if (result.getTypeBearer() == newResultType && PhiTypeResolver.equalsHandlesNulls(newLocal, result.getLocalItem())) {
            return false;
        }
        insn.changeResultType(newResultType, newLocal);
        return true;
    }
}

