/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.testing;

import com.android.builder.internal.InstallUtils;
import com.android.builder.internal.testing.CustomTestRunListener;
import com.android.builder.testing.TestData;
import com.android.builder.testing.TestRunner;
import com.android.builder.testing.api.DeviceConfigProvider;
import com.android.builder.testing.api.DeviceConfigProviderImpl;
import com.android.builder.testing.api.DeviceConnector;
import com.android.builder.testing.api.DeviceException;
import com.android.builder.testing.api.TestException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.workers.ExecutorServiceAdapter;
import com.android.ide.common.workers.WorkerExecutorException;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class BaseTestRunner
implements TestRunner {
    protected final File splitSelectExec;
    protected final ProcessExecutor processExecutor;
    protected final ExecutorServiceAdapter executor;

    public BaseTestRunner(File splitSelectExec, ProcessExecutor processExecutor, ExecutorServiceAdapter executor) {
        this.splitSelectExec = splitSelectExec;
        this.processExecutor = (ProcessExecutor)Preconditions.checkNotNull((Object)processExecutor);
        this.executor = executor;
    }

    private static void generateXmlOutputForNoDevices(String projectName, String variantName, File resultsDir, ILogger logger, int totalDevices, Map<DeviceConnector, ImmutableList<File>> availableDevices) {
        CustomTestRunListener fakeRunListener = new CustomTestRunListener("TestRunner", projectName, variantName, logger);
        fakeRunListener.setReportDir(resultsDir);
        Map<String, String> emptyMetrics = Collections.emptyMap();
        TestIdentifier fakeTest = new TestIdentifier(variantName, totalDevices == 0 ? ": No devices connected." : ": No compatible devices connected.");
        fakeRunListener.testStarted(fakeTest);
        fakeRunListener.testFailed(fakeTest, String.format("Found %d connected device(s), %d of which were compatible.", totalDevices, availableDevices.size()));
        fakeRunListener.testEnded(fakeTest, emptyMetrics);
        fakeRunListener.testRunEnded(0L, emptyMetrics);
    }

    private static void generateXmlOutputForUnauthorizedDevices(String projectName, String variantName, File resultsDir, ILogger logger, int unauthorizedDevices) {
        CustomTestRunListener fakeRunListener = new CustomTestRunListener("TestRunner", projectName, variantName, logger);
        fakeRunListener.setReportDir(resultsDir);
        Map<String, String> emptyMetrics = Collections.emptyMap();
        TestIdentifier fakeTest = new TestIdentifier(variantName, ": found unauthorized devices.");
        fakeRunListener.testStarted(fakeTest);
        fakeRunListener.testFailed(fakeTest, String.format("Found %d unauthorized device(s).", unauthorizedDevices));
        fakeRunListener.testEnded(fakeTest, emptyMetrics);
        fakeRunListener.testRunEnded(0L, emptyMetrics);
    }

    @Override
    public boolean runTests(String projectName, String variantName, TestData testData, Set<File> helperApks, List<? extends DeviceConnector> deviceList, int timeoutInMs, Collection<String> installOptions, File resultsDir, File coverageDir, ILogger logger) throws TestException {
        boolean bl;
        int totalDevices = deviceList.size();
        int unauthorizedDevices = 0;
        HashMap<DeviceConnector, ImmutableList<File>> apksForDevice = new HashMap<DeviceConnector, ImmutableList<File>>();
        for (DeviceConnector deviceConnector : deviceList) {
            if (deviceConnector.getState() != IDevice.DeviceState.UNAUTHORIZED) {
                DeviceConfigProviderImpl deviceConfigProvider;
                if (!InstallUtils.checkDeviceApiLevel(deviceConnector, testData.getMinSdkVersion(), logger, projectName, variantName)) continue;
                try {
                    deviceConfigProvider = new DeviceConfigProviderImpl(deviceConnector);
                }
                catch (DeviceException e2) {
                    throw new TestException((Throwable)e2);
                }
                ImmutableList<File> testedApks = ImmutableList.of();
                if (!testData.isLibrary()) {
                    try {
                        testedApks = testData.getTestedApks(this.processExecutor, this.splitSelectExec, (DeviceConfigProvider)deviceConfigProvider, logger);
                    }
                    catch (ProcessException e3) {
                        throw new TestException((Throwable)e3);
                    }
                    if (testedApks.isEmpty()) {
                        logger.info("Skipping device '%1$s' for '%2$s:%3$s': No matching output file", new Object[]{deviceConnector.getName(), projectName, variantName});
                        continue;
                    }
                }
                apksForDevice.put(deviceConnector, testedApks);
                continue;
            }
            ++unauthorizedDevices;
        }
        if (totalDevices == 0 || apksForDevice.isEmpty()) {
            BaseTestRunner.generateXmlOutputForNoDevices(projectName, variantName, resultsDir, logger, totalDevices, apksForDevice);
            return false;
        }
        if (unauthorizedDevices > 0) {
            BaseTestRunner.generateXmlOutputForUnauthorizedDevices(projectName, variantName, resultsDir, logger, unauthorizedDevices);
        }
        List<TestResult> results = this.scheduleTests(projectName, variantName, testData, apksForDevice, helperApks, timeoutInMs, installOptions, resultsDir, coverageDir, logger);
        try {
            this.executor.await();
        }
        catch (WorkerExecutorException workerExecutorException) {
            workerExecutorException.getCauses().forEach(cause -> logger.error(cause, null, new Object[0]));
            return false;
        }
        boolean bl2 = unauthorizedDevices == 0;
        for (TestResult result : results) {
            if (result.getTestResult() != TestResult.Result.FAILED) continue;
            bl = false;
        }
        return bl;
    }

    protected abstract List<TestResult> scheduleTests(String var1, String var2, TestData var3, Map<DeviceConnector, ImmutableList<File>> var4, Set<File> var5, int var6, Collection<String> var7, File var8, File var9, ILogger var10);

    public static class TestResult {
        Result testResult;

        public void setTestResult(Result testResult) {
            this.testResult = testResult;
        }

        public Result getTestResult() {
            return this.testResult;
        }

        public static enum Result {
            SUCCEEDED,
            FAILED;

        }
    }
}

