/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.DexArchive;
import com.android.builder.dexing.DexArchiveEntry;
import com.android.builder.dexing.DexArchiveMerger;
import com.android.builder.dexing.DexArchiveMergerCallable;
import com.android.builder.dexing.DexArchiveMergerException;
import com.android.builder.dexing.DexArchives;
import com.android.builder.dexing.DexingType;
import com.android.builder.dexing.ReferenceCountMergingStrategy;
import com.android.dex.Dex;
import com.android.dx.command.dexer.DxContext;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public final class DxDexArchiveMerger
implements DexArchiveMerger {
    private final DxContext dxContext;
    private final ForkJoinPool forkJoinPool;
    private final boolean isDebuggable;

    public DxDexArchiveMerger(DxContext dxContext, ForkJoinPool forkJoinPool, boolean isDebuggable) {
        this.dxContext = dxContext;
        this.forkJoinPool = forkJoinPool;
        this.isDebuggable = isDebuggable;
    }

    @Override
    public void mergeDexArchives(Iterator<Path> inputs, Path outputDir, Path mainDexClasses, DexingType dexingType) throws DexArchiveMergerException {
        ArrayList inputPaths = Lists.newArrayList(inputs);
        inputPaths.sort(Ordering.natural());
        if (inputPaths.isEmpty()) {
            return;
        }
        try {
            switch (dexingType) {
                case MONO_DEX: {
                    Preconditions.checkState((mainDexClasses == null ? 1 : 0) != 0, (Object)"Main dex list cannot be set for monodex.");
                    this.mergeMonoDex(inputPaths, outputDir);
                    break;
                }
                case LEGACY_MULTIDEX: {
                    Preconditions.checkNotNull((Object)mainDexClasses, (Object)"Main dex list must be set for legacy multidex.");
                    this.mergeMultidex(inputPaths, outputDir, Sets.newHashSet(Files.readAllLines(mainDexClasses)), dexingType);
                    break;
                }
                case NATIVE_MULTIDEX: {
                    Preconditions.checkState((mainDexClasses == null ? 1 : 0) != 0, (Object)"Main dex list cannot be set for native multidex.");
                    this.mergeMultidex(inputPaths, outputDir, Collections.emptySet(), dexingType);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown dexing mode" + (Object)((Object)dexingType));
                }
            }
        }
        catch (IOException e) {
            throw new DexArchiveMergerException(e);
        }
    }

    private void mergeMonoDex(Collection<Path> inputs, Path output2) throws IOException {
        ConcurrentMap dexesFromArchives = Maps.newConcurrentMap();
        AtomicInteger inputsToProcess = new AtomicInteger(inputs.size());
        ArrayList<Future> subTasks = new ArrayList<Future>();
        for (Path archivePath : inputs) {
            subTasks.add(this.forkJoinPool.submit(() -> {
                try (DexArchive dexArchive = DexArchives.fromInput(archivePath);){
                    List<DexArchiveEntry> entries = dexArchive.getFiles();
                    ArrayList<Dex> dexes = new ArrayList<Dex>(entries.size());
                    for (DexArchiveEntry e : entries) {
                        dexes.add(new Dex(e.getDexFileContent()));
                    }
                    dexesFromArchives.put(dexArchive.getRootPath(), dexes);
                }
                if (inputsToProcess.decrementAndGet() == 0) {
                    this.mergeMonoDexEntries(output2, dexesFromArchives).join();
                }
                return null;
            }));
        }
        subTasks.forEach((Consumer<Future>)((Consumer<ForkJoinTask>)ForkJoinTask::join));
    }

    private ForkJoinTask<Void> mergeMonoDexEntries(Path output2, Map<Path, List<Dex>> dexesFromArchives) {
        List sortedPaths = Ordering.natural().sortedCopy(dexesFromArchives.keySet());
        int numberOfDexFiles = dexesFromArchives.values().stream().mapToInt(List::size).sum();
        ArrayList<Dex> sortedDexes = new ArrayList<Dex>(numberOfDexFiles);
        for (Path p : sortedPaths) {
            sortedDexes.addAll((Collection<Dex>)dexesFromArchives.get(p));
        }
        return this.submitForMerging(sortedDexes, output2.resolve(this.getDexFileName(0)));
    }

    private void mergeMultidex(Collection<Path> inputs, Path output2, Set<String> mainDexClasses, DexingType dexingType) throws IOException, DexArchiveMergerException {
        List<DexArchiveEntry> entries = DexArchives.getAllEntriesFromArchives(inputs);
        if (entries.isEmpty()) {
            return;
        }
        int classesDexSuffix = dexingType == DexingType.LEGACY_MULTIDEX ? 1 : 0;
        ReferenceCountMergingStrategy mainDexTracker = new ReferenceCountMergingStrategy();
        mainDexTracker.startNewDex();
        for (DexArchiveEntry entry : entries) {
            String relativeUnixPath = DexArchiveEntry.withClassExtension(entry.getRelativePathInArchive());
            if (!mainDexClasses.contains(relativeUnixPath)) continue;
            Preconditions.checkState((boolean)mainDexTracker.tryToAddForMerging(new Dex(entry.getDexFileContent())), (Object)"Main dex list too large.");
        }
        ReferenceCountMergingStrategy mergingStrategy = new ReferenceCountMergingStrategy();
        ArrayList<ForkJoinTask<Void>> subTasks = new ArrayList<ForkJoinTask<Void>>();
        mergingStrategy.startNewDex();
        for (DexArchiveEntry entry : entries) {
            String relativeUnixPath;
            Dex dex = new Dex(entry.getDexFileContent());
            if (dexingType == DexingType.LEGACY_MULTIDEX && (mainDexClasses.contains(relativeUnixPath = DexArchiveEntry.withClassExtension(entry.getRelativePathInArchive())) || !this.isDebuggable && mainDexTracker.tryToAddForMerging(dex)) || mergingStrategy.tryToAddForMerging(dex)) continue;
            Path dexOutput = output2.resolve(this.getDexFileName(classesDexSuffix++));
            subTasks.add(this.submitForMerging((List<Dex>)mergingStrategy.getAllDexToMerge(), dexOutput));
            mergingStrategy.startNewDex();
            if (mergingStrategy.tryToAddForMerging(dex)) continue;
            throw new DexArchiveMergerException("A single DEX file from a dex archive has more than 64K references.");
        }
        if (dexingType == DexingType.LEGACY_MULTIDEX) {
            subTasks.add(this.submitForMerging((List<Dex>)mainDexTracker.getAllDexToMerge(), output2.resolve(this.getDexFileName(0))));
        }
        if (!mergingStrategy.getAllDexToMerge().isEmpty()) {
            Path dexOutput = output2.resolve(this.getDexFileName(classesDexSuffix));
            subTasks.add(this.submitForMerging((List<Dex>)mergingStrategy.getAllDexToMerge(), dexOutput));
        }
        subTasks.forEach(ForkJoinTask::join);
    }

    private ForkJoinTask<Void> submitForMerging(List<Dex> dexes, Path dexOutputPath) {
        return this.forkJoinPool.submit((Callable)new DexArchiveMergerCallable(dexes, dexOutputPath, this.dxContext));
    }

    private String getDexFileName(int classesDexIndex) {
        if (classesDexIndex == 0) {
            return "classes.dex";
        }
        return String.format("classes%d.dex", classesDexIndex + 1);
    }
}

