/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.profile;

import com.android.builder.profile.NoOpRecorder;
import com.android.builder.profile.ProcessProfileWriter;
import com.android.builder.profile.ProcessProfileWriterFactory;
import com.android.builder.profile.ProfileRecordWriter;
import com.android.builder.profile.Recorder;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import com.google.wireless.android.sdk.stats.GradleTransformExecution;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ThreadRecorder
implements Recorder {
    private static final Recorder NO_OP_RECORDER = new NoOpRecorder();
    private static final AtomicLong THREAD_ID_ALLOCATOR = new AtomicLong(1L);
    private static final Recorder RECORDER = new ThreadRecorder();
    protected final ThreadLocal<Deque<Long>> recordStacks = ThreadLocal.withInitial(ArrayDeque::new);

    public static Recorder get() {
        return ProcessProfileWriterFactory.getFactory().isInitialized() ? RECORDER : NO_OP_RECORDER;
    }

    @Override
    public <T> T record(GradleBuildProfileSpan.ExecutionType executionType, String projectPath, String variant, Recorder.Block<T> block) {
        return this.record(executionType, null, projectPath, variant, block);
    }

    @Override
    public void record(GradleBuildProfileSpan.ExecutionType executionType, String projectPath, String variant, Recorder.VoidBlock block) {
        ProcessProfileWriter profileRecordWriter = ProcessProfileWriter.get();
        GradleBuildProfileSpan.Builder currentRecord = this.create(profileRecordWriter, executionType, null);
        try {
            block.call();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            this.write(profileRecordWriter, currentRecord, projectPath, variant);
            if (this.recordStacks.get().isEmpty()) {
                this.recordStacks.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T record(GradleBuildProfileSpan.ExecutionType executionType, GradleTransformExecution transform, String projectPath, String variant, Recorder.Block<T> block) {
        ProcessProfileWriter profileRecordWriter = ProcessProfileWriter.get();
        GradleBuildProfileSpan.Builder currentRecord = this.create(profileRecordWriter, executionType, transform);
        try {
            Object v = block.call();
            return (T)v;
        }
        catch (Exception e) {
            block.handleException(e);
        }
        finally {
            this.write(profileRecordWriter, currentRecord, projectPath, variant);
            if (this.recordStacks.get().isEmpty()) {
                this.recordStacks.remove();
            }
        }
        return null;
    }

    private GradleBuildProfileSpan.Builder create(ProfileRecordWriter profileRecordWriter, GradleBuildProfileSpan.ExecutionType executionType, GradleTransformExecution transform) {
        long thisRecordId = profileRecordWriter.allocateRecordId();
        Long parentId = this.recordStacks.get().peek();
        long startTimeInMs = System.currentTimeMillis();
        GradleBuildProfileSpan.Builder currentRecord = GradleBuildProfileSpan.newBuilder().setId(thisRecordId).setType(executionType).setThreadId(Thread.currentThread().getId()).setStartTimeInMs(startTimeInMs);
        if (transform != null) {
            currentRecord.setTransform(transform);
        }
        if (parentId != null) {
            currentRecord.setParentId(parentId.longValue());
        }
        currentRecord.setThreadId(Thread.currentThread().getId());
        this.recordStacks.get().push(thisRecordId);
        return currentRecord;
    }

    private void write(ProfileRecordWriter profileRecordWriter, GradleBuildProfileSpan.Builder currentRecord, String projectPath, String variant) {
        if (this.recordStacks.get().pop().longValue() != currentRecord.getId()) {
            Logger.getLogger(ThreadRecorder.class.getName()).log(Level.SEVERE, "Profiler stack corrupted");
        }
        currentRecord.setDurationInMs(System.currentTimeMillis() - currentRecord.getStartTimeInMs());
        profileRecordWriter.writeRecord(projectPath, variant, currentRecord);
    }
}

