/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.com.google.common.collect.BiMap;
import com.android.tools.r8.com.google.common.collect.HashBiMap;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.ImmutableSortedSet;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.PresortedComparable;
import com.android.tools.r8.ir.code.ConstInstruction;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import com.android.tools.r8.utils.IteratorUtils;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;

public abstract class GraphLense {
    public static Builder builder() {
        return new Builder();
    }

    public abstract DexType getOriginalType(DexType var1);

    public abstract DexField getOriginalFieldSignature(DexField var1);

    public abstract DexMethod getOriginalMethodSignature(DexMethod var1);

    public abstract DexField getRenamedFieldSignature(DexField var1);

    public abstract DexMethod getRenamedMethodSignature(DexMethod var1);

    public DexEncodedMethod mapDexEncodedMethod(DexEncodedMethod originalEncodedMethod, AppInfo appInfo) {
        DexMethod newMethod = this.getRenamedMethodSignature(originalEncodedMethod.method);
        DexClass newHolder = appInfo.definitionFor(newMethod.holder);
        assert (newHolder != null);
        DexEncodedMethod newEncodedMethod = newHolder.lookupMethod(newMethod);
        assert (newEncodedMethod != null);
        return newEncodedMethod;
    }

    public abstract DexType lookupType(DexType var1);

    public DexMethod lookupMethod(DexMethod method) {
        assert (this.isContextFreeForMethod(method));
        return this.lookupMethod(method, null, null).getMethod();
    }

    public abstract GraphLenseLookupResult lookupMethod(DexMethod var1, DexMethod var2, Invoke.Type var3);

    public abstract RewrittenPrototypeDescription lookupPrototypeChanges(DexMethod var1);

    public Set<DexMethod> lookupMethodInAllContexts(DexMethod method) {
        assert (this.isContextFreeForMethod(method));
        DexMethod result = this.lookupMethod(method);
        if (result != null) {
            return ImmutableSet.of(result);
        }
        return ImmutableSet.of();
    }

    public abstract DexField lookupField(DexField var1);

    public DexReference lookupReference(DexReference reference) {
        if (reference.isDexType()) {
            return this.lookupType(reference.asDexType());
        }
        if (reference.isDexMethod()) {
            return this.lookupMethod(reference.asDexMethod());
        }
        assert (reference.isDexField());
        return this.lookupField(reference.asDexField());
    }

    public abstract boolean isContextFreeForMethods();

    public boolean isContextFreeForMethod(DexMethod method) {
        return this.isContextFreeForMethods();
    }

    public static GraphLense getIdentityLense() {
        return IdentityGraphLense.getInstance();
    }

    public final boolean isIdentityLense() {
        return this == GraphLense.getIdentityLense();
    }

    public <T extends DexDefinition> boolean assertDefinitionsNotModified(Iterable<T> definitions) {
        for (DexDefinition definition : definitions) {
            boolean isBridge;
            DexReference reference = definition.toReference();
            boolean bl = isBridge = definition.isDexEncodedMethod() && definition.asDexEncodedMethod().accessFlags.isBridge();
            assert (isBridge || this.lookupReference(reference) == reference);
        }
        return true;
    }

    public <T extends DexReference> boolean assertReferencesNotModified(Iterable<T> references) {
        for (DexReference reference : references) {
            if (reference.isDexField()) {
                DexField field = reference.asDexField();
                assert (this.getRenamedFieldSignature(field) == field);
                continue;
            }
            if (reference.isDexMethod()) {
                DexMethod method = reference.asDexMethod();
                assert (this.getRenamedMethodSignature(method) == method);
                continue;
            }
            assert (reference.isDexType());
            DexType type = reference.asDexType();
            assert (this.lookupType(type) == type);
        }
        return true;
    }

    public ImmutableList<DexReference> rewriteReferencesConservatively(List<DexReference> original) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (DexReference item : original) {
            if (item.isDexMethod()) {
                DexMethod method = item.asDexMethod();
                if (this.isContextFreeForMethod(method)) {
                    builder.add(this.lookupMethod(method));
                    continue;
                }
                builder.addAll(this.lookupMethodInAllContexts(method));
                continue;
            }
            builder.add(this.lookupReference(item));
        }
        return builder.build();
    }

    public ImmutableSet<DexReference> rewriteReferencesConservatively(Set<DexReference> original) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (DexReference item : original) {
            if (item.isDexMethod()) {
                DexMethod method = item.asDexMethod();
                if (this.isContextFreeForMethod(method)) {
                    builder.add(this.lookupMethod(method));
                    continue;
                }
                builder.addAll(this.lookupMethodInAllContexts(method));
                continue;
            }
            builder.add(this.lookupReference(item));
        }
        return builder.build();
    }

    public Set<DexReference> rewriteMutableReferencesConservatively(Set<DexReference> original) {
        Set<DexReference> result = Sets.newIdentityHashSet();
        for (DexReference item : original) {
            if (item.isDexMethod()) {
                DexMethod method = item.asDexMethod();
                if (this.isContextFreeForMethod(method)) {
                    result.add(this.lookupMethod(method));
                    continue;
                }
                result.addAll(this.lookupMethodInAllContexts(method));
                continue;
            }
            result.add(this.lookupReference(item));
        }
        return result;
    }

    public Object2BooleanMap<DexReference> rewriteReferencesConservatively(Object2BooleanMap<DexReference> original) {
        Object2BooleanArrayMap<DexReference> result = new Object2BooleanArrayMap<DexReference>();
        for (Object2BooleanMap.Entry entry : original.object2BooleanEntrySet()) {
            DexReference item = (DexReference)entry.getKey();
            if (item.isDexMethod()) {
                DexMethod method = item.asDexMethod();
                if (this.isContextFreeForMethod(method)) {
                    result.put((DexReference)this.lookupMethod(method), entry.getBooleanValue());
                    continue;
                }
                for (DexMethod candidate : this.lookupMethodInAllContexts(method)) {
                    result.put((DexReference)candidate, entry.getBooleanValue());
                }
                continue;
            }
            result.put(this.lookupReference(item), entry.getBooleanValue());
        }
        return result;
    }

    public ImmutableSet<DexType> rewriteTypesConservatively(Set<DexType> original) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (DexType item : original) {
            builder.add(this.lookupType(item));
        }
        return builder.build();
    }

    public Set<DexType> rewriteMutableTypesConservatively(Set<DexType> original) {
        Set<DexType> result = Sets.newIdentityHashSet();
        for (DexType item : original) {
            result.add(this.lookupType(item));
        }
        return result;
    }

    public ImmutableSortedSet<DexMethod> rewriteMethodsWithRenamedSignature(Set<DexMethod> methods) {
        ImmutableSortedSet.Builder builder = new ImmutableSortedSet.Builder(PresortedComparable::slowCompare);
        for (DexMethod method : methods) {
            builder.add(this.getRenamedMethodSignature(method));
        }
        return builder.build();
    }

    public ImmutableSortedSet<DexMethod> rewriteMethodsConservatively(Set<DexMethod> original) {
        ImmutableSortedSet.Builder builder = new ImmutableSortedSet.Builder(PresortedComparable::slowCompare);
        if (this.isContextFreeForMethods()) {
            for (DexMethod item : original) {
                builder.add(this.lookupMethod(item));
            }
        } else {
            for (DexMethod item : original) {
                if (this.isContextFreeForMethod(item)) {
                    builder.add(this.lookupMethod(item));
                    continue;
                }
                builder.addAll(this.lookupMethodInAllContexts(item));
            }
        }
        return builder.build();
    }

    public SortedSet<DexMethod> rewriteMutableMethodsConservatively(Set<DexMethod> original) {
        TreeSet<DexMethod> result = new TreeSet<DexMethod>(PresortedComparable::slowCompare);
        if (this.isContextFreeForMethods()) {
            for (DexMethod item : original) {
                result.add(this.lookupMethod(item));
            }
        } else {
            for (DexMethod item : original) {
                if (this.isContextFreeForMethod(item)) {
                    result.add(this.lookupMethod(item));
                    continue;
                }
                result.addAll(this.lookupMethodInAllContexts(item));
            }
        }
        return result;
    }

    public static <T extends DexReference, S> ImmutableMap<T, S> rewriteReferenceKeys(Map<T, S> original, Function<T, T> rewrite) {
        ImmutableMap.Builder<DexReference, S> builder = new ImmutableMap.Builder<DexReference, S>();
        for (DexReference item : original.keySet()) {
            builder.put((DexReference)rewrite.apply(item), original.get(item));
        }
        return builder.build();
    }

    public static <T extends DexReference, S> Map<T, S> rewriteMutableReferenceKeys(Map<T, S> original, Function<T, T> rewrite) {
        IdentityHashMap<DexReference, S> result = new IdentityHashMap<DexReference, S>();
        for (DexReference item : original.keySet()) {
            result.put((DexReference)rewrite.apply(item), original.get(item));
        }
        return result;
    }

    public boolean verifyMappingToOriginalProgram(Iterable<DexProgramClass> classes, DexApplication originalApplication, DexItemFactory dexItemFactory) {
        Set<DexField> originalFields = Sets.newIdentityHashSet();
        Set<DexMethod> originalMethods = Sets.newIdentityHashSet();
        for (DexProgramClass clazz : originalApplication.classes()) {
            for (DexEncodedField field : clazz.fields()) {
                originalFields.add(field.field);
            }
            for (DexEncodedMethod method : clazz.methods()) {
                originalMethods.add(method.method);
            }
        }
        for (DexProgramClass clazz : classes) {
            if (clazz.type.isD8R8SynthesizedClassType()) continue;
            for (DexEncodedField field : clazz.fields()) {
                DexField originalField = this.getOriginalFieldSignature(field.field);
                assert (originalFields.contains(originalField)) : "Unable to map field `" + field.field.toSourceString() + "` back to original program";
            }
            for (DexEncodedMethod method : clazz.methods()) {
                if (method.accessFlags.isSynthetic()) continue;
                DexMethod originalMethod = this.getOriginalMethodSignature(method.method);
                assert (originalMethods.contains(originalMethod) || GraphLense.verifyIsBridgeMethod(originalMethod, originalApplication, originalMethods, dexItemFactory)) : "Unable to map method `" + originalMethod.toSourceString() + "` back to original program";
            }
        }
        return true;
    }

    private static boolean verifyIsBridgeMethod(DexMethod method, DexApplication originalApplication, Set<DexMethod> originalMethods, DexItemFactory dexItemFactory) {
        ArrayDeque<DexType> worklist = new ArrayDeque<DexType>();
        Set<DexType> visited = Sets.newIdentityHashSet();
        worklist.add(method.holder);
        while (!worklist.isEmpty()) {
            DexClass clazz;
            DexType holder = (DexType)worklist.removeFirst();
            if (!visited.add(holder)) continue;
            DexMethod targetMethod = dexItemFactory.createMethod(holder, method.proto, method.name);
            if (originalMethods.contains(targetMethod)) {
                return true;
            }
            if (holder == dexItemFactory.objectType || (clazz = originalApplication.definitionFor(holder)) == null) continue;
            worklist.add(clazz.superType);
            Collections.addAll(worklist, clazz.interfaces.values);
        }
        return false;
    }

    public static class NestedGraphLense
    extends GraphLense {
        protected final GraphLense previousLense;
        protected final DexItemFactory dexItemFactory;
        protected final Map<DexType, DexType> typeMap;
        private final Map<DexType, DexType> arrayTypeCache = new IdentityHashMap<DexType, DexType>();
        protected final Map<DexMethod, DexMethod> methodMap;
        protected final Map<DexField, DexField> fieldMap;
        protected final BiMap<DexField, DexField> originalFieldSignatures;
        protected final BiMap<DexMethod, DexMethod> originalMethodSignatures;

        public NestedGraphLense(Map<DexType, DexType> typeMap, Map<DexMethod, DexMethod> methodMap, Map<DexField, DexField> fieldMap, BiMap<DexField, DexField> originalFieldSignatures, BiMap<DexMethod, DexMethod> originalMethodSignatures, GraphLense previousLense, DexItemFactory dexItemFactory) {
            this.typeMap = typeMap.isEmpty() ? null : typeMap;
            this.methodMap = methodMap;
            this.fieldMap = fieldMap;
            this.originalFieldSignatures = originalFieldSignatures;
            this.originalMethodSignatures = originalMethodSignatures;
            this.previousLense = previousLense;
            this.dexItemFactory = dexItemFactory;
        }

        @Override
        public DexType getOriginalType(DexType type) {
            return this.previousLense.getOriginalType(type);
        }

        @Override
        public DexField getOriginalFieldSignature(DexField field) {
            DexField originalField = this.originalFieldSignatures != null ? this.originalFieldSignatures.getOrDefault(field, field) : field;
            return this.previousLense.getOriginalFieldSignature(originalField);
        }

        @Override
        public DexMethod getOriginalMethodSignature(DexMethod method) {
            DexMethod originalMethod = this.originalMethodSignatures != null ? this.originalMethodSignatures.getOrDefault(method, method) : method;
            return this.previousLense.getOriginalMethodSignature(originalMethod);
        }

        @Override
        public DexField getRenamedFieldSignature(DexField originalField) {
            DexField renamedField = this.previousLense.getRenamedFieldSignature(originalField);
            return this.originalFieldSignatures != null ? this.originalFieldSignatures.inverse().getOrDefault(renamedField, renamedField) : renamedField;
        }

        @Override
        public DexMethod getRenamedMethodSignature(DexMethod originalMethod) {
            DexMethod renamedMethod = this.previousLense.getRenamedMethodSignature(originalMethod);
            return this.originalMethodSignatures != null ? this.originalMethodSignatures.inverse().getOrDefault(renamedMethod, renamedMethod) : renamedMethod;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DexType lookupType(DexType type) {
            if (type.isArrayType()) {
                NestedGraphLense nestedGraphLense = this;
                synchronized (nestedGraphLense) {
                    DexType result = this.arrayTypeCache.get(type);
                    if (result == null) {
                        DexType newType;
                        DexType baseType = type.toBaseType(this.dexItemFactory);
                        result = baseType == (newType = this.lookupType(baseType)) ? type : type.replaceBaseType(newType, this.dexItemFactory);
                        this.arrayTypeCache.put(type, result);
                    }
                    return result;
                }
            }
            DexType previous = this.previousLense.lookupType(type);
            return this.typeMap != null ? this.typeMap.getOrDefault(previous, previous) : previous;
        }

        @Override
        public GraphLenseLookupResult lookupMethod(DexMethod method, DexMethod context, Invoke.Type type) {
            DexMethod previousContext = this.originalMethodSignatures != null ? this.originalMethodSignatures.getOrDefault(context, context) : context;
            GraphLenseLookupResult previous = this.previousLense.lookupMethod(method, previousContext, type);
            DexMethod newMethod = this.methodMap.get(previous.getMethod());
            if (newMethod == null) {
                return previous;
            }
            return new GraphLenseLookupResult(newMethod, this.mapInvocationType(newMethod, method, previous.getType()));
        }

        @Override
        public RewrittenPrototypeDescription lookupPrototypeChanges(DexMethod method) {
            return this.previousLense.lookupPrototypeChanges(method);
        }

        protected Invoke.Type mapInvocationType(DexMethod newMethod, DexMethod originalMethod, Invoke.Type type) {
            return type;
        }

        protected final Invoke.Type mapVirtualInterfaceInvocationTypes(AppInfo appInfo, DexMethod newMethod, DexMethod originalMethod, Invoke.Type type) {
            if (type == Invoke.Type.VIRTUAL || type == Invoke.Type.INTERFACE) {
                DexClass newTargetClass = appInfo.definitionFor(newMethod.holder);
                if (newTargetClass == null) {
                    return type;
                }
                DexClass originalTargetClass = appInfo.definitionFor(originalMethod.holder);
                if (originalTargetClass != null && originalTargetClass.isInterface() ^ type == Invoke.Type.INTERFACE) {
                    return newTargetClass.accessFlags.isInterface() ? Invoke.Type.VIRTUAL : Invoke.Type.INTERFACE;
                }
                return newTargetClass.accessFlags.isInterface() ? Invoke.Type.INTERFACE : Invoke.Type.VIRTUAL;
            }
            return type;
        }

        @Override
        public Set<DexMethod> lookupMethodInAllContexts(DexMethod method) {
            HashSet<DexMethod> result = new HashSet<DexMethod>();
            for (DexMethod previous : this.previousLense.lookupMethodInAllContexts(method)) {
                result.add(this.methodMap.getOrDefault(previous, previous));
            }
            return result;
        }

        @Override
        public DexField lookupField(DexField field) {
            DexField previous = this.previousLense.lookupField(field);
            return this.fieldMap.getOrDefault(previous, previous);
        }

        @Override
        public boolean isContextFreeForMethods() {
            return this.previousLense.isContextFreeForMethods();
        }

        @Override
        public boolean isContextFreeForMethod(DexMethod method) {
            return this.previousLense.isContextFreeForMethod(method);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.typeMap != null) {
                for (Map.Entry<DexReference, DexReference> entry : this.typeMap.entrySet()) {
                    builder.append(((DexType)entry.getKey()).toSourceString()).append(" -> ");
                    builder.append(((DexType)entry.getValue()).toSourceString()).append(System.lineSeparator());
                }
            }
            for (Map.Entry<DexReference, DexReference> entry : this.methodMap.entrySet()) {
                builder.append(((DexMethod)entry.getKey()).toSourceString()).append(" -> ");
                builder.append(((DexMethod)entry.getValue()).toSourceString()).append(System.lineSeparator());
            }
            for (Map.Entry<DexReference, DexReference> entry : this.fieldMap.entrySet()) {
                builder.append(((DexField)entry.getKey()).toSourceString()).append(" -> ");
                builder.append(((DexField)entry.getValue()).toSourceString()).append(System.lineSeparator());
            }
            builder.append(this.previousLense.toString());
            return builder.toString();
        }
    }

    private static class IdentityGraphLense
    extends GraphLense {
        private static IdentityGraphLense INSTANCE = new IdentityGraphLense();

        private IdentityGraphLense() {
        }

        private static IdentityGraphLense getInstance() {
            return INSTANCE;
        }

        @Override
        public DexType getOriginalType(DexType type) {
            return type;
        }

        @Override
        public DexField getOriginalFieldSignature(DexField field) {
            return field;
        }

        @Override
        public DexMethod getOriginalMethodSignature(DexMethod method) {
            return method;
        }

        @Override
        public DexField getRenamedFieldSignature(DexField originalField) {
            return originalField;
        }

        @Override
        public DexMethod getRenamedMethodSignature(DexMethod originalMethod) {
            return originalMethod;
        }

        @Override
        public DexType lookupType(DexType type) {
            return type;
        }

        @Override
        public GraphLenseLookupResult lookupMethod(DexMethod method, DexMethod context, Invoke.Type type) {
            return new GraphLenseLookupResult(method, type);
        }

        @Override
        public RewrittenPrototypeDescription lookupPrototypeChanges(DexMethod method) {
            return RewrittenPrototypeDescription.none();
        }

        @Override
        public DexField lookupField(DexField field) {
            return field;
        }

        @Override
        public boolean isContextFreeForMethods() {
            return true;
        }
    }

    public static class Builder {
        protected final Map<DexType, DexType> typeMap = new IdentityHashMap<DexType, DexType>();
        protected final Map<DexMethod, DexMethod> methodMap = new IdentityHashMap<DexMethod, DexMethod>();
        protected final Map<DexField, DexField> fieldMap = new IdentityHashMap<DexField, DexField>();
        private final BiMap<DexField, DexField> originalFieldSignatures = HashBiMap.create();
        private final BiMap<DexMethod, DexMethod> originalMethodSignatures = HashBiMap.create();

        protected Builder() {
        }

        public void map(DexType from, DexType to) {
            if (from == to) {
                return;
            }
            this.typeMap.put(from, to);
        }

        public void map(DexMethod from, DexMethod to) {
            if (from == to) {
                return;
            }
            this.methodMap.put(from, to);
        }

        public void map(DexField from, DexField to) {
            if (from == to) {
                return;
            }
            this.fieldMap.put(from, to);
        }

        public void move(DexMethod from, DexMethod to) {
            if (from == to) {
                return;
            }
            this.map(from, to);
            this.originalMethodSignatures.put(to, from);
        }

        public void move(DexField from, DexField to) {
            if (from == to) {
                return;
            }
            this.fieldMap.put(from, to);
            this.originalFieldSignatures.put(to, from);
        }

        public GraphLense build(DexItemFactory dexItemFactory) {
            return this.build(dexItemFactory, GraphLense.getIdentityLense());
        }

        public GraphLense build(DexItemFactory dexItemFactory, GraphLense previousLense) {
            if (this.typeMap.isEmpty() && this.methodMap.isEmpty() && this.fieldMap.isEmpty()) {
                return previousLense;
            }
            return new NestedGraphLense(this.typeMap, this.methodMap, this.fieldMap, this.originalFieldSignatures, this.originalMethodSignatures, previousLense, dexItemFactory);
        }
    }

    public static class RewrittenPrototypeDescription {
        private static final RewrittenPrototypeDescription none = new RewrittenPrototypeDescription();
        private final boolean hasBeenChangedToReturnVoid;
        private final RemovedArgumentsInfo removedArgumentsInfo;

        private RewrittenPrototypeDescription() {
            this(false, RemovedArgumentsInfo.empty());
        }

        public RewrittenPrototypeDescription(boolean hasBeenChangedToReturnVoid, RemovedArgumentsInfo removedArgumentsInfo) {
            assert (removedArgumentsInfo != null);
            this.hasBeenChangedToReturnVoid = hasBeenChangedToReturnVoid;
            this.removedArgumentsInfo = removedArgumentsInfo;
        }

        public static RewrittenPrototypeDescription none() {
            return none;
        }

        public boolean isEmpty() {
            return !this.hasBeenChangedToReturnVoid && !this.getRemovedArgumentsInfo().hasRemovedArguments();
        }

        public boolean hasBeenChangedToReturnVoid() {
            return this.hasBeenChangedToReturnVoid;
        }

        public RemovedArgumentsInfo getRemovedArgumentsInfo() {
            return this.removedArgumentsInfo;
        }

        public ConstInstruction getConstantReturn(IRCode code, Position position) {
            assert (this.hasBeenChangedToReturnVoid);
            ConstNumber instruction = code.createConstNull();
            instruction.setPosition(position);
            return instruction;
        }

        public DexType rewriteReturnType(DexType returnType, DexItemFactory dexItemFactory) {
            return this.hasBeenChangedToReturnVoid ? dexItemFactory.voidType : returnType;
        }

        public DexType[] rewriteParameters(DexType[] params) {
            RemovedArgumentsInfo removedArgumentsInfo = this.getRemovedArgumentsInfo();
            if (removedArgumentsInfo.hasRemovedArguments()) {
                DexType[] newParams = new DexType[params.length - removedArgumentsInfo.numberOfRemovedArguments()];
                int newParamIndex = 0;
                for (int oldParamIndex = 0; oldParamIndex < params.length; ++oldParamIndex) {
                    if (removedArgumentsInfo.isArgumentRemoved(oldParamIndex)) continue;
                    newParams[newParamIndex] = params[oldParamIndex];
                    ++newParamIndex;
                }
                return newParams;
            }
            return params;
        }

        public DexProto rewriteProto(DexProto proto, DexItemFactory dexItemFactory) {
            DexType newReturnType = this.rewriteReturnType(proto.returnType, dexItemFactory);
            DexType[] newParameters = this.rewriteParameters(proto.parameters.values);
            return dexItemFactory.createProto(newReturnType, newParameters);
        }

        public RewrittenPrototypeDescription withConstantReturn() {
            return !this.hasBeenChangedToReturnVoid ? new RewrittenPrototypeDescription(true, this.removedArgumentsInfo) : this;
        }

        public RewrittenPrototypeDescription withRemovedArguments(RemovedArgumentsInfo other) {
            return new RewrittenPrototypeDescription(this.hasBeenChangedToReturnVoid, this.removedArgumentsInfo.combine(other));
        }

        public static class RemovedArgumentsInfo {
            private static final RemovedArgumentsInfo empty = new RemovedArgumentsInfo(null);
            private final List<RemovedArgumentInfo> removedArguments;

            public RemovedArgumentsInfo(List<RemovedArgumentInfo> removedArguments) {
                assert (RemovedArgumentsInfo.verifyRemovedArguments(removedArguments));
                this.removedArguments = removedArguments;
            }

            private static boolean verifyRemovedArguments(List<RemovedArgumentInfo> removedArguments) {
                if (removedArguments != null && !removedArguments.isEmpty()) {
                    int lastArgumentIndex = removedArguments.get(0).getArgumentIndex();
                    for (int i = 1; i < removedArguments.size(); ++i) {
                        int currentArgumentIndex = removedArguments.get(i).getArgumentIndex();
                        assert (lastArgumentIndex < currentArgumentIndex);
                        lastArgumentIndex = currentArgumentIndex;
                    }
                }
                return true;
            }

            public static RemovedArgumentsInfo empty() {
                return empty;
            }

            public ListIterator<RemovedArgumentInfo> iterator() {
                return this.removedArguments == null ? Collections.emptyListIterator() : this.removedArguments.listIterator();
            }

            public boolean hasRemovedArguments() {
                return this.removedArguments != null && !this.removedArguments.isEmpty();
            }

            public boolean isArgumentRemoved(int argumentIndex) {
                if (this.removedArguments != null) {
                    for (RemovedArgumentInfo info : this.removedArguments) {
                        if (info.getArgumentIndex() != argumentIndex) continue;
                        return true;
                    }
                }
                return false;
            }

            public int numberOfRemovedArguments() {
                return this.removedArguments != null ? this.removedArguments.size() : 0;
            }

            public RemovedArgumentsInfo combine(RemovedArgumentsInfo info) {
                assert (info != null);
                if (this.hasRemovedArguments()) {
                    if (!info.hasRemovedArguments()) {
                        return this;
                    }
                } else {
                    return info;
                }
                LinkedList<RemovedArgumentInfo> newRemovedArguments = new LinkedList<RemovedArgumentInfo>(this.removedArguments);
                ListIterator<RemovedArgumentInfo> iterator2 = newRemovedArguments.listIterator();
                int offset = 0;
                for (RemovedArgumentInfo pending : info.removedArguments) {
                    RemovedArgumentInfo next = (RemovedArgumentInfo)IteratorUtils.peekNext(iterator2);
                    while (next != null && next.getArgumentIndex() <= pending.getArgumentIndex() + offset) {
                        iterator2.next();
                        next = (RemovedArgumentInfo)IteratorUtils.peekNext(iterator2);
                        ++offset;
                    }
                    iterator2.add(pending.withArgumentIndex(pending.getArgumentIndex() + offset));
                }
                return new RemovedArgumentsInfo(newRemovedArguments);
            }
        }

        public static class RemovedArgumentInfo {
            private final int argumentIndex;
            private final boolean isAlwaysNull;
            private final DexType type;

            private RemovedArgumentInfo(int argumentIndex, boolean isAlwaysNull, DexType type) {
                this.argumentIndex = argumentIndex;
                this.isAlwaysNull = isAlwaysNull;
                this.type = type;
            }

            public static Builder builder() {
                return new Builder();
            }

            public int getArgumentIndex() {
                return this.argumentIndex;
            }

            public DexType getType() {
                return this.type;
            }

            public boolean isAlwaysNull() {
                return this.isAlwaysNull;
            }

            public boolean isNeverUsed() {
                return !this.isAlwaysNull;
            }

            public RemovedArgumentInfo withArgumentIndex(int argumentIndex) {
                return this.argumentIndex != argumentIndex ? new RemovedArgumentInfo(argumentIndex, this.isAlwaysNull, this.type) : this;
            }

            public static class Builder {
                private int argumentIndex = -1;
                private boolean isAlwaysNull = false;
                private DexType type = null;

                public Builder setArgumentIndex(int argumentIndex) {
                    this.argumentIndex = argumentIndex;
                    return this;
                }

                public Builder setIsAlwaysNull() {
                    this.isAlwaysNull = true;
                    return this;
                }

                public Builder setType(DexType type) {
                    this.type = type;
                    return this;
                }

                public RemovedArgumentInfo build() {
                    assert (this.argumentIndex >= 0);
                    assert (this.type != null);
                    return new RemovedArgumentInfo(this.argumentIndex, this.isAlwaysNull, this.type);
                }
            }
        }
    }

    public static class GraphLenseLookupResult {
        private final DexMethod method;
        private final Invoke.Type type;

        public GraphLenseLookupResult(DexMethod method, Invoke.Type type) {
            this.method = method;
            this.type = type;
        }

        public DexMethod getMethod() {
            return this.method;
        }

        public Invoke.Type getType() {
            return this.type;
        }
    }
}

