/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.com.google.common.collect.ImmutableCollection;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.ReferenceTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.utils.LRUCacheTable;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ClassTypeLatticeElement
extends ReferenceTypeLatticeElement {
    private Set<DexType> lazyInterfaces;
    private AppInfo appInfoForLazyInterfacesComputation;

    public ClassTypeLatticeElement(DexType classType, Nullability nullability, Set<DexType> interfaces) {
        this(classType, nullability, interfaces, null);
    }

    public ClassTypeLatticeElement(DexType classType, Nullability nullability, AppInfo appInfo) {
        this(classType, nullability, null, appInfo);
    }

    private ClassTypeLatticeElement(DexType classType, Nullability nullability, Set<DexType> interfaces, AppInfo appInfo) {
        super(nullability, classType);
        assert (classType.isClassType());
        this.appInfoForLazyInterfacesComputation = appInfo;
        this.lazyInterfaces = interfaces;
    }

    public DexType getClassType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<DexType> getInterfaces() {
        if (this.lazyInterfaces != null) {
            return this.lazyInterfaces;
        }
        ClassTypeLatticeElement classTypeLatticeElement = this;
        synchronized (classTypeLatticeElement) {
            if (this.lazyInterfaces == null) {
                Set<DexType> itfs = this.type.implementedInterfaces(this.appInfoForLazyInterfacesComputation);
                this.lazyInterfaces = ClassTypeLatticeElement.computeLeastUpperBoundOfInterfaces(this.appInfoForLazyInterfacesComputation, itfs, itfs);
                this.appInfoForLazyInterfacesComputation = null;
            }
        }
        return this.lazyInterfaces;
    }

    @Override
    ReferenceTypeLatticeElement createVariant(Nullability nullability) {
        if (this.nullability == nullability) {
            return this;
        }
        return new ClassTypeLatticeElement(this.type, nullability, this.lazyInterfaces, this.appInfoForLazyInterfacesComputation);
    }

    @Override
    public TypeLatticeElement asNullable() {
        return this.nullability.isNullable() ? this : this.getOrCreateVariant(Nullability.maybeNull());
    }

    @Override
    public TypeLatticeElement asNonNullable() {
        return this.nullability.isDefinitelyNotNull() ? this : this.getOrCreateVariant(Nullability.definitelyNotNull());
    }

    @Override
    public boolean isBasedOnMissingClass(AppInfo appInfo) {
        return this.getClassType().isMissingOrHasMissingSuperType(appInfo) || this.getInterfaces().stream().anyMatch(type -> type.isMissingOrHasMissingSuperType(appInfo));
    }

    @Override
    public boolean isClassType() {
        return true;
    }

    @Override
    public ClassTypeLatticeElement asClassTypeLatticeElement() {
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append(" {");
        builder.append(this.getInterfaces().stream().map(DexType::toString).collect(Collectors.joining(", ")));
        builder.append("}");
        return builder.toString();
    }

    @Override
    public int hashCode() {
        return (this.isNullable() ? 1 : -1) * this.type.hashCode();
    }

    ClassTypeLatticeElement join(ClassTypeLatticeElement other, AppInfo appInfo) {
        DexType lubType = this.getClassType().computeLeastUpperBoundOfClasses(appInfo, other.getClassType());
        Set<DexType> c1lubItfs = this.getInterfaces();
        Set<DexType> c2lubItfs = other.getInterfaces();
        Set<DexType> lubItfs = null;
        if (c1lubItfs.size() == c2lubItfs.size() && c1lubItfs.containsAll(c2lubItfs)) {
            lubItfs = c1lubItfs;
        }
        if (lubItfs == null) {
            lubItfs = ClassTypeLatticeElement.computeLeastUpperBoundOfInterfaces(appInfo, c1lubItfs, c2lubItfs);
        }
        Nullability nullability = this.nullability().join(other.nullability());
        return new ClassTypeLatticeElement(lubType, nullability, lubItfs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<DexType> computeLeastUpperBoundOfInterfaces(AppInfo appInfo, Set<DexType> s1, Set<DexType> s2) {
        Set<DexType> cached = appInfo.dexItemFactory.leastUpperBoundOfInterfacesTable.get(s1, s2);
        if (cached != null) {
            return cached;
        }
        cached = appInfo.dexItemFactory.leastUpperBoundOfInterfacesTable.get(s2, s1);
        if (cached != null) {
            return cached;
        }
        IdentityHashMap<DexType, Set> seen = new IdentityHashMap<DexType, Set>();
        ArrayDeque<InterfaceWithMarker> worklist = new ArrayDeque<InterfaceWithMarker>();
        for (DexType itf1 : s1) {
            worklist.add(new InterfaceWithMarker(itf1, InterfaceMarker.LEFT));
        }
        for (DexType itf2 : s2) {
            worklist.add(new InterfaceWithMarker(itf2, InterfaceMarker.RIGHT));
        }
        while (!worklist.isEmpty()) {
            InterfaceWithMarker item = (InterfaceWithMarker)worklist.poll();
            DexType itf = item.itf;
            InterfaceMarker interfaceMarker = item.marker;
            Object markers = seen.computeIfAbsent(itf, k -> new HashSet());
            if (markers.contains((Object)interfaceMarker)) continue;
            if (markers.size() == 1) {
                markers.add(interfaceMarker);
                continue;
            }
            markers.add(interfaceMarker);
            DexClass itfClass = appInfo.definitionFor(itf);
            if (itfClass == null) continue;
            for (DexType superItf : itfClass.interfaces.values) {
                markers = seen.computeIfAbsent(superItf, k -> new HashSet());
                if (markers.contains((Object)interfaceMarker)) continue;
                worklist.add(new InterfaceWithMarker(superItf, interfaceMarker));
            }
        }
        ImmutableSet.Builder commonBuilder = ImmutableSet.builder();
        for (Map.Entry entry : seen.entrySet()) {
            if (((Set)entry.getValue()).size() < 2) continue;
            commonBuilder.add((DexType)entry.getKey());
        }
        ImmutableCollection commonlyVisited = commonBuilder.build();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (DexType itf : commonlyVisited) {
            boolean notTheLeast = false;
            for (DexType other : commonlyVisited) {
                if (!other.isStrictSubtypeOf(itf, appInfo)) continue;
                notTheLeast = true;
                break;
            }
            if (notTheLeast) continue;
            builder.add(itf);
        }
        ImmutableCollection lub = builder.build();
        if (s1.size() != s2.size() || !s1.containsAll(s2)) {
            LRUCacheTable<Set<DexType>, Set<DexType>, Set<DexType>> lRUCacheTable = appInfo.dexItemFactory.leastUpperBoundOfInterfacesTable;
            synchronized (lRUCacheTable) {
                appInfo.dexItemFactory.leastUpperBoundOfInterfacesTable.put(s1, s2, (Set<DexType>)((Object)lub));
            }
        }
        return lub;
    }

    private static class InterfaceWithMarker {
        final DexType itf;
        final InterfaceMarker marker;

        InterfaceWithMarker(DexType itf, InterfaceMarker marker) {
            this.itf = itf;
            this.marker = marker;
        }
    }

    private static enum InterfaceMarker {
        LEFT,
        RIGHT;

    }
}

