/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import java.util.Collections;
import java.util.Set;

public class ReferenceTypeLatticeElement
extends TypeLatticeElement {
    private static final ReferenceTypeLatticeElement NULL_INSTANCE = new ReferenceTypeLatticeElement(Nullability.definitelyNull(), DexItemFactory.nullValueType);
    final DexType type;
    final Nullability nullability;
    private ReferenceTypeLatticeElement primaryOrNullVariant;
    private ReferenceTypeLatticeElement nonNullVariant;

    ReferenceTypeLatticeElement(Nullability nullability, DexType type) {
        this.nullability = nullability;
        this.type = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferenceTypeLatticeElement getOrCreateVariant(Nullability variantNullability) {
        if (this.nullability == variantNullability) {
            return this;
        }
        ReferenceTypeLatticeElement primary = this.nullability.isMaybeNull() ? this : this.primaryOrNullVariant;
        ReferenceTypeLatticeElement referenceTypeLatticeElement = this;
        synchronized (referenceTypeLatticeElement) {
            if (primary == null) {
                primary = this.createVariant(Nullability.maybeNull());
                ReferenceTypeLatticeElement.linkVariant(primary, this);
            }
        }
        if (variantNullability.isMaybeNull()) {
            return primary;
        }
        referenceTypeLatticeElement = primary;
        synchronized (referenceTypeLatticeElement) {
            ReferenceTypeLatticeElement variant;
            ReferenceTypeLatticeElement referenceTypeLatticeElement2 = variant = variantNullability.isDefinitelyNull() ? primary.primaryOrNullVariant : primary.nonNullVariant;
            if (variant == null) {
                variant = this.createVariant(variantNullability);
                ReferenceTypeLatticeElement.linkVariant(primary, variant);
            }
            return variant;
        }
    }

    ReferenceTypeLatticeElement createVariant(Nullability nullability) {
        throw new Unreachable("Should be defined by class/array type lattice element");
    }

    private static void linkVariant(ReferenceTypeLatticeElement primary, ReferenceTypeLatticeElement variant) {
        assert (primary.nullability().isMaybeNull());
        assert (variant.primaryOrNullVariant == null && variant.nonNullVariant == null);
        variant.primaryOrNullVariant = primary;
        if (variant.nullability().isDefinitelyNotNull()) {
            assert (primary.nonNullVariant == null);
            primary.nonNullVariant = variant;
        } else {
            assert (variant.nullability().isDefinitelyNull());
            assert (primary.primaryOrNullVariant == null);
            primary.primaryOrNullVariant = variant;
        }
    }

    @Override
    public Nullability nullability() {
        return this.nullability;
    }

    static ReferenceTypeLatticeElement getNullTypeLatticeElement() {
        return NULL_INSTANCE;
    }

    public Set<DexType> getInterfaces() {
        return Collections.emptySet();
    }

    @Override
    public boolean isNullType() {
        return this.type == DexItemFactory.nullValueType;
    }

    @Override
    public TypeLatticeElement asNullable() {
        assert (this.isNullType());
        return this;
    }

    @Override
    public boolean isReference() {
        return true;
    }

    @Override
    public String toString() {
        return this.nullability.toString() + " " + this.type.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReferenceTypeLatticeElement)) {
            return false;
        }
        ReferenceTypeLatticeElement other = (ReferenceTypeLatticeElement)o;
        if (this.nullability() != other.nullability()) {
            return false;
        }
        if (!this.type.equals(other.type)) {
            return false;
        }
        Set<DexType> thisInterfaces = this.getInterfaces();
        Set<DexType> otherInterfaces = other.getInterfaces();
        if (thisInterfaces.size() != otherInterfaces.size()) {
            return false;
        }
        return thisInterfaces.containsAll(otherInterfaces);
    }

    @Override
    public int hashCode() {
        assert (this.isNullType());
        return System.identityHashCode(this);
    }
}

