/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.code.Base3Format;
import com.android.tools.r8.code.InvokeDirectRange;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.ClassInitializationAnalysis;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.shaking.Enqueuer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class InvokeDirect
extends InvokeMethodWithReceiver {
    private final boolean itf;

    public InvokeDirect(DexMethod target, Value result, List<Value> arguments) {
        this(target, result, arguments, false);
    }

    public InvokeDirect(DexMethod target, Value result, List<Value> arguments, boolean itf) {
        super(target, result, arguments);
        this.itf = itf;
        assert (!target.name.toString().equals("<init>") || result == null);
    }

    @Override
    public Invoke.Type getType() {
        return Invoke.Type.DIRECT;
    }

    @Override
    protected String getTypeString() {
        return "Direct";
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Base3Format instruction;
        int argumentRegisters = this.requiredArgumentRegisters();
        builder.requestOutgoingRegisters(argumentRegisters);
        if (this.needsRangedInvoke(builder)) {
            assert (this.argumentsConsecutive(builder));
            int firstRegister = this.argumentRegisterValue(0, builder);
            instruction = new InvokeDirectRange(firstRegister, argumentRegisters, this.getInvokedMethod());
        } else {
            int[] individualArgumentRegisters = new int[5];
            int argumentRegistersCount = this.fillArgumentRegisters(builder, individualArgumentRegisters);
            instruction = new com.android.tools.r8.code.InvokeDirect(argumentRegistersCount, this.getInvokedMethod(), individualArgumentRegisters[0], individualArgumentRegisters[1], individualArgumentRegisters[2], individualArgumentRegisters[3], individualArgumentRegisters[4]);
        }
        this.addInvokeAndMoveResult(instruction, builder);
    }

    public boolean sameConstructorReceiverValue(Invoke other) {
        if (!this.getInvokedMethod().name.toString().equals("<init>")) {
            return true;
        }
        return this.inValues.get(0) == other.inValues.get(0);
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isInvokeDirect() && super.identicalNonValueNonPositionParts(other);
    }

    @Override
    public boolean isInvokeDirect() {
        return true;
    }

    @Override
    public InvokeDirect asInvokeDirect() {
        return this;
    }

    @Override
    public DexEncodedMethod lookupSingleTarget(Enqueuer.AppInfoWithLiveness appInfo, DexType invocationContext) {
        return appInfo.lookupDirectTarget(this.getInvokedMethod());
    }

    @Override
    public Collection<DexEncodedMethod> lookupTargets(AppInfoWithSubtyping appInfo, DexType invocationContext) {
        DexEncodedMethod target = appInfo.lookupDirectTarget(this.getInvokedMethod());
        return target == null ? Collections.emptyList() : Collections.singletonList(target);
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forInvokeDirect(this.getInvokedMethod(), invocationContext);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfInvoke(183, this.getInvokedMethod(), this.itf));
    }

    @Override
    public boolean definitelyTriggersClassInitialization(DexType clazz, AppView<? extends AppInfoWithSubtyping> appView, ClassInitializationAnalysis.Query mode, ClassInitializationAnalysis.AnalysisAssumption assumption) {
        return ClassInitializationAnalysis.InstructionUtils.forInvokeDirect(this, clazz, appView, mode, assumption);
    }
}

