/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar;

import com.android.tools.r8.com.google.common.collect.BiMap;
import com.android.tools.r8.com.google.common.collect.HashBiMap;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeCustom;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.NewInstance;
import com.android.tools.r8.ir.code.StaticGet;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.desugar.LambdaClass;
import com.android.tools.r8.ir.desugar.LambdaDescriptor;
import com.android.tools.r8.ir.desugar.LambdaRewriterGraphLense;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class LambdaRewriter {
    public static final String LAMBDA_CLASS_NAME_PREFIX = "-$$Lambda$";
    public static final String LAMBDA_GROUP_CLASS_NAME_PREFIX = "-$$LambdaGroup$";
    static final String EXPECTED_LAMBDA_METHOD_PREFIX = "lambda$";
    static final String LAMBDA_INSTANCE_FIELD_NAME = "INSTANCE";
    final IRConverter converter;
    final AppInfo appInfo;
    final DexItemFactory factory;
    final DexMethod objectInitMethod;
    final DexString constructorName;
    final DexString classConstructorName;
    final DexString instanceFieldName;
    final BiMap<DexMethod, DexMethod> methodMapping = HashBiMap.create();
    private final Map<DexCallSite, LambdaDescriptor> knownCallSites = new IdentityHashMap<DexCallSite, LambdaDescriptor>();
    private final Map<DexType, LambdaClass> knownLambdaClasses = new IdentityHashMap<DexType, LambdaClass>();

    public static boolean hasLambdaClassPrefix(DexType clazz) {
        return clazz.getName().startsWith(LAMBDA_CLASS_NAME_PREFIX);
    }

    public LambdaRewriter(IRConverter converter) {
        assert (converter != null);
        this.converter = converter;
        this.factory = converter.appInfo.dexItemFactory;
        this.appInfo = converter.appInfo;
        this.constructorName = this.factory.createString("<init>");
        DexProto initProto = this.factory.createProto(this.factory.voidType, new DexType[0]);
        this.objectInitMethod = this.factory.createMethod(this.factory.objectType, initProto, this.constructorName);
        this.classConstructorName = this.factory.createString("<clinit>");
        this.instanceFieldName = this.factory.createString(LAMBDA_INSTANCE_FIELD_NAME);
    }

    public void desugarLambdas(DexEncodedMethod encodedMethod, IRCode code) {
        DexType currentType = encodedMethod.method.holder;
        ListIterator<BasicBlock> blocks = code.listIterator();
        while (blocks.hasNext()) {
            BasicBlock block = blocks.next();
            InstructionListIterator instructions = block.listIterator();
            while (instructions.hasNext()) {
                LambdaDescriptor descriptor;
                Instruction instruction = (Instruction)instructions.next();
                if (!instruction.isInvokeCustom() || (descriptor = this.inferLambdaDescriptor(instruction.asInvokeCustom().getCallSite())) == LambdaDescriptor.MATCH_FAILED) continue;
                LambdaClass lambdaClass = this.getOrCreateLambdaClass(descriptor, currentType);
                assert (lambdaClass != null);
                this.patchInstruction(lambdaClass, code, blocks, instructions);
            }
        }
    }

    public boolean removeLambdaDeserializationMethods(Iterable<DexProgramClass> classes) {
        for (DexProgramClass clazz : classes) {
            List<DexEncodedMethod> directMethods = clazz.directMethods();
            if (directMethods == null) continue;
            int methodCount = directMethods.size();
            for (int i = 0; i < methodCount; ++i) {
                DexEncodedMethod encoded = directMethods.get(i);
                DexMethod method = encoded.method;
                if (!method.isLambdaDeserializeMethod(this.appInfo.dexItemFactory)) continue;
                assert (encoded.accessFlags.isStatic());
                assert (encoded.accessFlags.isSynthetic());
                clazz.removeDirectMethod(i);
                return true;
            }
        }
        return false;
    }

    public void adjustAccessibility() {
        for (LambdaClass lambdaClass : this.knownLambdaClasses.values()) {
            lambdaClass.target.ensureAccessibility();
        }
        if (this.converter.enableWholeProgramOptimizations && !this.methodMapping.isEmpty()) {
            this.converter.appView.setGraphLense(new LambdaRewriterGraphLense(this.methodMapping, this.converter.appView.graphLense(), this.factory));
        }
    }

    public DexProgramClass getLambdaClass(DexType type) {
        LambdaClass lambdaClass = LambdaRewriter.getKnown(this.knownLambdaClasses, type);
        return lambdaClass == null ? null : lambdaClass.getLambdaClass();
    }

    public void synthesizeLambdaClasses(DexApplication.Builder<?> builder, ExecutorService executorService) throws ExecutionException {
        for (LambdaClass lambdaClass : this.knownLambdaClasses.values()) {
            DexProgramClass synthesizedClass = lambdaClass.getLambdaClass();
            this.appInfo.addSynthesizedClass(synthesizedClass);
            builder.addSynthesizedClass(synthesizedClass, lambdaClass.addToMainDexList.get());
        }
        this.converter.optimizeSynthesizedClasses(this.knownLambdaClasses.values().stream().map(LambdaClass::getLambdaClass).collect(ImmutableSet.toImmutableSet()), executorService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DexCallSite> getDesugaredCallSites() {
        Map<DexCallSite, LambdaDescriptor> map2 = this.knownCallSites;
        synchronized (map2) {
            return this.knownCallSites.keySet();
        }
    }

    private LambdaDescriptor inferLambdaDescriptor(DexCallSite callSite) {
        LambdaDescriptor descriptor = LambdaRewriter.getKnown(this.knownCallSites, callSite);
        return descriptor != null ? descriptor : LambdaRewriter.putIfAbsent(this.knownCallSites, callSite, LambdaDescriptor.infer(callSite, this.converter.appInfo));
    }

    private boolean isInMainDexList(DexType type) {
        return this.converter.appInfo.isInMainDexList(type);
    }

    private LambdaClass getOrCreateLambdaClass(LambdaDescriptor descriptor, DexType accessedFrom) {
        DexType lambdaClassType = LambdaClass.createLambdaClassType(this, accessedFrom, descriptor);
        LambdaClass lambdaClass = LambdaRewriter.getKnown(this.knownLambdaClasses, lambdaClassType);
        if (lambdaClass == null) {
            lambdaClass = LambdaRewriter.putIfAbsent(this.knownLambdaClasses, lambdaClassType, new LambdaClass(this, accessedFrom, lambdaClassType, descriptor));
        }
        lambdaClass.addSynthesizedFrom(this.appInfo.definitionFor(accessedFrom).asProgramClass());
        if (this.isInMainDexList(accessedFrom)) {
            lambdaClass.addToMainDexList.set(true);
        }
        return lambdaClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <K, V> V getKnown(Map<K, V> map2, K key) {
        Map<K, V> map3 = map2;
        synchronized (map3) {
            return map2.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <K, V> V putIfAbsent(Map<K, V> map2, K key, V value) {
        Map<K, V> map3 = map2;
        synchronized (map3) {
            V known = map2.get(key);
            if (known != null) {
                return known;
            }
            map2.put(key, value);
            return value;
        }
    }

    private void patchInstruction(LambdaClass lambdaClass, IRCode code, ListIterator<BasicBlock> blocks, InstructionListIterator instructions) {
        assert (lambdaClass != null);
        assert (instructions != null);
        assert (instructions.peekPrevious().isInvokeCustom());
        InvokeCustom invoke = ((Instruction)instructions.previous()).asInvokeCustom();
        Value lambdaInstanceValue = invoke.outValue();
        if (lambdaInstanceValue == null) {
            lambdaInstanceValue = code.createValue(TypeLatticeElement.fromDexType(lambdaClass.type, Nullability.maybeNull(), this.appInfo));
        }
        if (lambdaClass.isStateless()) {
            instructions.replaceCurrentInstruction(new StaticGet(lambdaInstanceValue, lambdaClass.instanceField));
            return;
        }
        NewInstance newInstance = new NewInstance(lambdaClass.type, lambdaInstanceValue);
        instructions.replaceCurrentInstruction(newInstance);
        ArrayList<Value> arguments = new ArrayList<Value>();
        arguments.add(lambdaInstanceValue);
        arguments.addAll(invoke.arguments());
        InvokeDirect constructorCall = new InvokeDirect(lambdaClass.constructor, null, arguments);
        instructions.add(constructorCall);
        constructorCall.setPosition(newInstance.getPosition());
        if (!constructorCall.getBlock().hasCatchHandlers()) {
            return;
        }
        instructions.previous();
        assert (instructions.peekNext().isInvokeDirect());
        BasicBlock currentBlock = newInstance.getBlock();
        BasicBlock nextBlock = instructions.split(code, blocks);
        assert (!instructions.hasNext());
        nextBlock.copyCatchHandlers(code, blocks, currentBlock, code.options);
    }
}

