/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.annotations.VisibleForTesting;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.DominatorTree;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.NonNull;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.OptimizationFeedback;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntArrayList;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntList;
import com.android.tools.r8.shaking.Enqueuer;
import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.function.Predicate;

public class NonNullTracker {
    private final Enqueuer.AppInfoWithLiveness appInfo;
    private final Set<DexMethod> libraryMethodsReturningNonNull;

    public NonNullTracker(Enqueuer.AppInfoWithLiveness appInfo, Set<DexMethod> libraryMethodsReturningNonNull) {
        this.appInfo = appInfo;
        this.libraryMethodsReturningNonNull = libraryMethodsReturningNonNull;
    }

    @VisibleForTesting
    static boolean throwsOnNullInput(Instruction instruction) {
        return instruction.isInvokeMethodWithReceiver() && !instruction.isInvokeDirect() || instruction.isInstanceGet() || instruction.isInstancePut() || instruction.isArrayGet() || instruction.isArrayPut() || instruction.isArrayLength() || instruction.isMonitor();
    }

    private Value getNonNullInput(Instruction instruction) {
        if (instruction.isInvokeMethodWithReceiver()) {
            return instruction.asInvokeMethodWithReceiver().getReceiver();
        }
        if (instruction.isInstanceGet()) {
            return instruction.asInstanceGet().object();
        }
        if (instruction.isInstancePut()) {
            return instruction.asInstancePut().object();
        }
        if (instruction.isArrayGet()) {
            return instruction.asArrayGet().array();
        }
        if (instruction.isArrayPut()) {
            return instruction.asArrayPut().array();
        }
        if (instruction.isArrayLength()) {
            return instruction.asArrayLength().array();
        }
        if (instruction.isMonitor()) {
            return instruction.asMonitor().object();
        }
        throw new Unreachable("Should conform to throwsOnNullInput.");
    }

    public void addNonNull(IRCode code) {
        this.addNonNullInPart(code, code.blocks.listIterator(), b -> true);
    }

    public void addNonNullInPart(IRCode code, ListIterator<BasicBlock> blockIterator, Predicate<BasicBlock> blockTester) {
        Set<Value> affectedValues = Sets.newIdentityHashSet();
        Set<Value> knownToBeNonNullValues = Sets.newIdentityHashSet();
        while (blockIterator.hasNext()) {
            DominatorTree dominatorTree;
            BasicBlock target;
            If theIf;
            Value knownToBeNonNullValue;
            BasicBlock block = blockIterator.next();
            if (!blockTester.test(block)) continue;
            InstructionListIterator iterator2 = block.listIterator();
            while (iterator2.hasNext()) {
                DexEncodedMethod singleTarget;
                Instruction current = (Instruction)iterator2.next();
                if (current.isInvokeMethod() && this.libraryMethodsReturningNonNull.contains(current.asInvokeMethod().getInvokedMethod()) && (knownToBeNonNullValue = current.outValue()) != null && this.isNonNullCandidate(knownToBeNonNullValue)) {
                    knownToBeNonNullValues.add(knownToBeNonNullValue);
                }
                if (NonNullTracker.throwsOnNullInput(current) && this.isNonNullCandidate(knownToBeNonNullValue = this.getNonNullInput(current))) {
                    knownToBeNonNullValues.add(knownToBeNonNullValue);
                }
                if (current.isInvokeMethod() && !current.isInvokePolymorphic() && (singleTarget = current.asInvokeMethod().lookupSingleTarget(this.appInfo, code.method.method.getHolder())) != null && singleTarget.getOptimizationInfo().getNonNullParamOnNormalExits() != null) {
                    BitSet facts = singleTarget.getOptimizationInfo().getNonNullParamOnNormalExits();
                    for (int i = 0; i < current.inValues().size(); ++i) {
                        Value knownToBeNonNullValue2;
                        if (!facts.get(i) || !this.isNonNullCandidate(knownToBeNonNullValue2 = current.inValues().get(i))) continue;
                        knownToBeNonNullValues.add(knownToBeNonNullValue2);
                    }
                }
                if (knownToBeNonNullValues.isEmpty()) continue;
                this.addNonNullForValues(code, blockIterator, block, iterator2, current, knownToBeNonNullValues, affectedValues);
                knownToBeNonNullValues.clear();
            }
            if (!block.exit().isIf() || !block.exit().asIf().isZeroTest() || !this.isNonNullCandidate(knownToBeNonNullValue = (theIf = block.exit().asIf()).inValues().get(0)) || (target = theIf.targetFromNonNullObject()).isEmpty() || !(dominatorTree = new DominatorTree(code, DominatorTree.Assumption.MAY_HAVE_UNREACHABLE_BLOCKS)).dominatedBy(target, block)) continue;
            Set<Instruction> dominatedUsers = Sets.newIdentityHashSet();
            IdentityHashMap<Phi, IntList> dominatedPhiUsersWithPositions = new IdentityHashMap<Phi, IntList>();
            HashSet<BasicBlock> dominatedBlocks = Sets.newHashSet(dominatorTree.dominatedBlocks(target));
            for (Instruction instruction : knownToBeNonNullValue.uniqueUsers()) {
                if (!dominatedBlocks.contains(instruction.getBlock())) continue;
                dominatedUsers.add(instruction);
            }
            for (Phi phi : knownToBeNonNullValue.uniquePhiUsers()) {
                IntList dominatedPredecessorIndexes = this.findDominatedPredecessorIndexesInPhi(phi, knownToBeNonNullValue, dominatedBlocks);
                if (dominatedPredecessorIndexes.isEmpty()) continue;
                dominatedPhiUsersWithPositions.put(phi, dominatedPredecessorIndexes);
            }
            if (dominatedUsers.isEmpty() && dominatedPhiUsersWithPositions.isEmpty()) continue;
            TypeLatticeElement typeLattice = knownToBeNonNullValue.getTypeLattice();
            Value value = code.createValue(typeLattice.asNonNullable(), knownToBeNonNullValue.getLocalInfo());
            affectedValues.addAll(knownToBeNonNullValue.affectedValues());
            NonNull nonNull = new NonNull(value, knownToBeNonNullValue, theIf);
            InstructionListIterator targetIterator = target.listIterator();
            nonNull.setPosition(((Instruction)targetIterator.next()).getPosition());
            targetIterator.previous();
            targetIterator.add(nonNull);
            knownToBeNonNullValue.replaceSelectiveUsers(value, dominatedUsers, dominatedPhiUsersWithPositions);
        }
        if (!affectedValues.isEmpty()) {
            new TypeAnalysis(this.appInfo, code.method).narrowing(affectedValues);
        }
    }

    private void addNonNullForValues(IRCode code, ListIterator<BasicBlock> blockIterator, BasicBlock block, InstructionListIterator iterator2, Instruction current, Set<Value> knownToBeNonNullValues, Set<Value> affectedValues) {
        boolean split = block.hasCatchHandlers();
        BasicBlock blockWithNonNullInstruction = split ? iterator2.split(code, blockIterator) : block;
        DominatorTree dominatorTree = new DominatorTree(code, DominatorTree.Assumption.MAY_HAVE_UNREACHABLE_BLOCKS);
        for (Value knownToBeNonNullValue : knownToBeNonNullValues) {
            Set<Instruction> users = knownToBeNonNullValue.uniqueUsers();
            Set<Instruction> dominatedUsers = Sets.newIdentityHashSet();
            IdentityHashMap<Phi, IntList> dominatedPhiUsersWithPositions = new IdentityHashMap<Phi, IntList>();
            Set<BasicBlock> dominatedBlocks = Sets.newIdentityHashSet();
            for (BasicBlock dominatee : dominatorTree.dominatedBlocks(blockWithNonNullInstruction)) {
                dominatedBlocks.add(dominatee);
                InstructionListIterator dominateeIterator = dominatee.listIterator();
                if (dominatee == blockWithNonNullInstruction && !split) {
                    dominateeIterator.nextUntil(instruction -> instruction == current);
                }
                while (dominateeIterator.hasNext()) {
                    Instruction potentialUser = (Instruction)dominateeIterator.next();
                    if (!users.contains(potentialUser)) continue;
                    dominatedUsers.add(potentialUser);
                }
            }
            for (Phi user : knownToBeNonNullValue.uniquePhiUsers()) {
                IntList dominatedPredecessorIndexes = this.findDominatedPredecessorIndexesInPhi(user, knownToBeNonNullValue, dominatedBlocks);
                if (dominatedPredecessorIndexes.isEmpty()) continue;
                dominatedPhiUsersWithPositions.put(user, dominatedPredecessorIndexes);
            }
            if (!knownToBeNonNullValue.isArgument() && dominatedUsers.isEmpty() && dominatedPhiUsersWithPositions.isEmpty()) continue;
            TypeLatticeElement typeLattice = knownToBeNonNullValue.getTypeLattice();
            Value nonNullValue = code.createValue(typeLattice.asNonNullable(), knownToBeNonNullValue.getLocalInfo());
            affectedValues.addAll(knownToBeNonNullValue.affectedValues());
            NonNull nonNull = new NonNull(nonNullValue, knownToBeNonNullValue, current);
            nonNull.setPosition(current.getPosition());
            if (blockWithNonNullInstruction != block) {
                blockWithNonNullInstruction.listIterator().add(nonNull);
            } else {
                iterator2.add(nonNull);
            }
            knownToBeNonNullValue.replaceSelectiveUsers(nonNullValue, dominatedUsers, dominatedPhiUsersWithPositions);
        }
    }

    private IntList findDominatedPredecessorIndexesInPhi(Phi user, Value knownToBeNonNullValue, Set<BasicBlock> dominatedBlocks) {
        assert (user.getOperands().contains(knownToBeNonNullValue));
        List<Value> operands = user.getOperands();
        List<BasicBlock> predecessors = user.getBlock().getPredecessors();
        assert (operands.size() == predecessors.size());
        IntArrayList predecessorIndexes = new IntArrayList();
        int index = 0;
        Iterator<Value> operandIterator = operands.iterator();
        Iterator<BasicBlock> predecessorIterator = predecessors.iterator();
        while (operandIterator.hasNext() && predecessorIterator.hasNext()) {
            Value operand = operandIterator.next();
            BasicBlock predecessor = predecessorIterator.next();
            if (operand == knownToBeNonNullValue && dominatedBlocks.contains(predecessor)) {
                predecessorIndexes.add(index);
            }
            ++index;
        }
        return predecessorIndexes;
    }

    private boolean isNonNullCandidate(Value knownToBeNonNullValue) {
        TypeLatticeElement typeLattice = knownToBeNonNullValue.getTypeLattice();
        return !knownToBeNonNullValue.isNeverNull() && !typeLattice.isNullType() && typeLattice.isNullable() && typeLattice.isReference();
    }

    public void computeNonNullParamOnNormalExits(OptimizationFeedback feedback, IRCode code) {
        Set<BasicBlock> normalExits = Sets.newIdentityHashSet();
        normalExits.addAll(code.computeNormalExitBlocks());
        DominatorTree dominatorTree = new DominatorTree(code, DominatorTree.Assumption.MAY_HAVE_UNREACHABLE_BLOCKS);
        List<Value> arguments = code.collectArguments();
        BitSet facts = new BitSet();
        Set<BasicBlock> nullCheckedBlocks = Sets.newIdentityHashSet();
        for (int index = 0; index < arguments.size(); ++index) {
            Value argument = arguments.get(index);
            if (!argument.getTypeLattice().isReference()) continue;
            if (argument.isThis()) {
                facts.set(index);
                continue;
            }
            nullCheckedBlocks.clear();
            for (Instruction user : argument.uniqueUsers()) {
                if (user.isNonNull()) {
                    nullCheckedBlocks.add(user.asNonNull().getBlock());
                }
                if (!user.isIf() || !user.asIf().isZeroTest() || user.asIf().getType() != If.Type.EQ && user.asIf().getType() != If.Type.NE) continue;
                nullCheckedBlocks.add(user.asIf().targetFromNonNullObject());
            }
            if (nullCheckedBlocks.isEmpty()) continue;
            boolean allExitsCovered = true;
            for (BasicBlock normalExit : normalExits) {
                if (this.isNormalExitDominated(normalExit, code, dominatorTree, nullCheckedBlocks)) continue;
                allExitsCovered = false;
                break;
            }
            if (!allExitsCovered) continue;
            facts.set(index);
        }
        if (facts.length() > 0) {
            feedback.setNonNullParamOnNormalExits(code.method, facts);
        }
    }

    private boolean isNormalExitDominated(BasicBlock normalExit, IRCode code, DominatorTree dominatorTree, Set<BasicBlock> nullCheckedBlocks) {
        for (BasicBlock nullCheckedBlock : nullCheckedBlocks) {
            if (!dominatorTree.dominatedBy(normalExit, nullCheckedBlock)) continue;
            return true;
        }
        Set<BasicBlock> visited = Sets.newIdentityHashSet();
        ArrayDeque<BasicBlock> uncoveredPaths = new ArrayDeque<BasicBlock>(normalExit.getPredecessors());
        while (!uncoveredPaths.isEmpty()) {
            BasicBlock uncoveredPath = (BasicBlock)uncoveredPaths.poll();
            if (uncoveredPath == code.entryBlock()) {
                return false;
            }
            if (!visited.add(uncoveredPath)) {
                if (!uncoveredPaths.isEmpty()) continue;
                return false;
            }
            boolean pathCovered = false;
            for (BasicBlock nullCheckedBlock : nullCheckedBlocks) {
                if (!dominatorTree.dominatedBy(uncoveredPath, nullCheckedBlock)) continue;
                pathCovered = true;
                break;
            }
            if (pathCovered) continue;
            uncoveredPaths.addAll(uncoveredPath.getPredecessors());
        }
        assert (uncoveredPaths.isEmpty());
        return true;
    }

    public void cleanupNonNull(IRCode code) {
        Set<Value> affectedValues = Sets.newIdentityHashSet();
        InstructionIterator it = code.instructionIterator();
        boolean needToCheckTrivialPhis = false;
        while (it.hasNext()) {
            Instruction instruction = (Instruction)it.next();
            if (!instruction.isNonNull()) continue;
            NonNull nonNull = instruction.asNonNull();
            Value src = nonNull.src();
            Value dest = nonNull.dest();
            affectedValues.addAll(dest.affectedValues());
            needToCheckTrivialPhis = needToCheckTrivialPhis || dest.uniquePhiUsers().size() != 0;
            dest.replaceUsers(src);
            it.remove();
        }
        if (needToCheckTrivialPhis) {
            code.removeAllTrivialPhis();
        }
        if (!affectedValues.isEmpty()) {
            new TypeAnalysis(this.appInfo, code.method).widening(affectedValues);
        }
    }
}

