/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.lambda.kotlin;

import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.code.InvokeDirect;
import com.android.tools.r8.code.InvokeDirectRange;
import com.android.tools.r8.code.ReturnVoid;
import com.android.tools.r8.com.google.common.collect.Lists;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.EnclosingMethodAttribute;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.optimize.lambda.LambdaGroup;
import com.android.tools.r8.ir.optimize.lambda.LambdaGroupClassBuilder;
import com.android.tools.r8.ir.optimize.lambda.kotlin.KotlinInstanceInitializerSourceCode;
import com.android.tools.r8.ir.optimize.lambda.kotlin.KotlinLambdaClassValidator;
import com.android.tools.r8.ir.optimize.lambda.kotlin.KotlinLambdaGroup;
import com.android.tools.r8.ir.optimize.lambda.kotlin.KotlinLambdaGroupClassBuilder;
import com.android.tools.r8.ir.optimize.lambda.kotlin.KotlinLambdaGroupId;
import com.android.tools.r8.ir.synthetic.SyntheticSourceCode;
import com.android.tools.r8.kotlin.Kotlin;
import com.android.tools.r8.utils.ThrowingConsumer;
import java.util.function.IntFunction;

final class JStyleLambdaGroup
extends KotlinLambdaGroup {
    private JStyleLambdaGroup(GroupId id) {
        super(id);
    }

    @Override
    protected LambdaGroupClassBuilder getBuilder(DexItemFactory factory) {
        return new ClassBuilder(factory, "java-style lambda group");
    }

    @Override
    public ThrowingConsumer<DexClass, LambdaGroup.LambdaStructureError> lambdaClassValidator(Kotlin kotlin, AppInfoWithSubtyping appInfo) {
        return new ClassValidator(kotlin, appInfo);
    }

    @Override
    protected String getGroupSuffix() {
        return "js$";
    }

    private static final class InstanceInitializerSourceCode
    extends KotlinInstanceInitializerSourceCode {
        private final DexMethod objectInitializer;

        InstanceInitializerSourceCode(DexItemFactory factory, DexType lambdaGroupType, DexField idField, IntFunction<DexField> fieldGenerator, DexMethod method, Position callerPosition) {
            super(lambdaGroupType, idField, fieldGenerator, method, callerPosition);
            this.objectInitializer = factory.objectMethods.constructor;
        }

        @Override
        void prepareSuperConstructorCall(int receiverRegister) {
            this.add(builder -> builder.addInvoke(Invoke.Type.DIRECT, this.objectInitializer, this.objectInitializer.proto, Lists.newArrayList(ValueType.OBJECT), Lists.newArrayList(receiverRegister), false));
        }
    }

    private final class ClassBuilder
    extends KotlinLambdaGroupClassBuilder<JStyleLambdaGroup> {
        ClassBuilder(DexItemFactory factory, String origin) {
            super(JStyleLambdaGroup.this, factory, origin);
        }

        @Override
        protected DexType getSuperClassType() {
            return this.factory.objectType;
        }

        @Override
        SyntheticSourceCode createInstanceInitializerSourceCode(DexType groupClassType, DexMethod initializerMethod, Position callerPosition) {
            return new InstanceInitializerSourceCode(this.factory, groupClassType, ((JStyleLambdaGroup)this.group).getLambdaIdField(this.factory), id -> ((JStyleLambdaGroup)this.group).getCaptureField(this.factory, id), initializerMethod, callerPosition);
        }
    }

    private class ClassValidator
    extends KotlinLambdaClassValidator {
        ClassValidator(Kotlin kotlin, AppInfoWithSubtyping appInfo) {
            super(kotlin, JStyleLambdaGroup.this, appInfo);
        }

        @Override
        int getInstanceInitializerSize(DexEncodedField[] captures) {
            return captures.length + 2;
        }

        @Override
        int validateInstanceInitializerEpilogue(Instruction[] instructions, int index) throws LambdaGroup.LambdaStructureError {
            if (!(instructions[index] instanceof InvokeDirect) && !(instructions[index] instanceof InvokeDirectRange) || instructions[index].getMethod() != this.kotlin.factory.objectMethods.constructor) {
                throw this.structureError("instance initializer code verification failed");
            }
            if (!(instructions[++index] instanceof ReturnVoid)) {
                throw this.structureError("instance initializer code verification failed");
            }
            return index + 1;
        }
    }

    static final class GroupId
    extends KotlinLambdaGroupId {
        GroupId(String capture, DexType iface, String pkg, String signature, DexEncodedMethod mainMethod, InnerClassAttribute inner, EnclosingMethodAttribute enclosing) {
            super(capture, iface, pkg, signature, mainMethod, inner, enclosing);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof GroupId && this.computeEquals((KotlinLambdaGroupId)obj);
        }

        @Override
        String getLambdaKindDescriptor() {
            return "Kotlin j-style lambda group";
        }

        @Override
        public LambdaGroup createGroup() {
            return new JStyleLambdaGroup(this);
        }
    }
}

