/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.ir.code.Invoke;
import java.util.Set;

final class PublicizerLense
extends GraphLense.NestedGraphLense {
    private final AppView appView;
    private final Set<DexMethod> publicizedMethods;

    private PublicizerLense(AppView appView, Set<DexMethod> publicizedMethods) {
        super(ImmutableMap.of(), ImmutableMap.of(), ImmutableMap.of(), null, null, appView.graphLense(), appView.dexItemFactory());
        this.appView = appView;
        this.publicizedMethods = publicizedMethods;
    }

    @Override
    public GraphLense.GraphLenseLookupResult lookupMethod(DexMethod method, DexMethod context, Invoke.Type type) {
        GraphLense.GraphLenseLookupResult previous = this.previousLense.lookupMethod(method, context, type);
        method = previous.getMethod();
        type = previous.getType();
        if (type == Invoke.Type.DIRECT && this.publicizedMethods.contains(method)) {
            assert (this.publicizedMethodIsPresentOnHolder(method, context));
            return new GraphLense.GraphLenseLookupResult(method, Invoke.Type.VIRTUAL);
        }
        return super.lookupMethod(method, context, type);
    }

    private boolean publicizedMethodIsPresentOnHolder(DexMethod method, DexMethod context) {
        GraphLense.GraphLenseLookupResult lookup = this.appView.graphLense().lookupMethod(method, context, Invoke.Type.VIRTUAL);
        DexMethod signatureInCurrentWorld = lookup.getMethod();
        DexClass clazz = ((AppInfo)this.appView.appInfo()).definitionFor(signatureInCurrentWorld.holder);
        assert (clazz != null);
        DexEncodedMethod actualEncodedTarget = clazz.lookupVirtualMethod(signatureInCurrentWorld);
        assert (actualEncodedTarget != null);
        assert (actualEncodedTarget.isPublicized());
        return true;
    }

    static PublicizedLenseBuilder createBuilder() {
        return new PublicizedLenseBuilder();
    }

    static class PublicizedLenseBuilder {
        private final Set<DexMethod> publicizedMethods = Sets.newIdentityHashSet();

        private PublicizedLenseBuilder() {
        }

        public GraphLense build(AppView appView) {
            if (this.publicizedMethods.isEmpty()) {
                return appView.graphLense();
            }
            return new PublicizerLense(appView, this.publicizedMethods);
        }

        public void add(DexMethod publicizedMethod) {
            this.publicizedMethods.add(publicizedMethod);
        }
    }
}

