/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.Resource;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.p;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;

public interface ProgramResource
extends Resource {
    public static ProgramResource fromFile(Kind kind, Path path) {
        return new FileResource(kind, path, null, null);
    }

    public static ProgramResource fromBytes(Origin origin, Kind kind, byte[] byArray, Set<String> set) {
        return new ByteResource(origin, kind, byArray, set, null);
    }

    public Kind getKind();

    public InputStream getByteStream() throws ResourceException;

    public Set<String> getClassDescriptors();

    public static class ByteResource
    implements ProgramResource {
        static final /* synthetic */ boolean a;
        private final Origin b;
        private final Kind c;
        private final byte[] d;
        private final Set<String> e;

        /* synthetic */ ByteResource(Origin origin, Kind kind, byte[] byArray, Set set, p p2) {
            if (!a && byArray == null) {
                throw new AssertionError();
            }
            this.b = origin;
            this.c = kind;
            this.d = byArray;
            this.e = set;
        }

        static {
            a = ProgramResource.class.desiredAssertionStatus() ^ true;
        }

        @Override
        public Origin getOrigin() {
            return this.b;
        }

        @Override
        public Kind getKind() {
            return this.c;
        }

        @Override
        public InputStream getByteStream() throws ResourceException {
            return new ByteArrayInputStream(this.d);
        }

        @Override
        public Set<String> getClassDescriptors() {
            return this.e;
        }
    }

    public static class FileResource
    implements ProgramResource {
        private final Origin a;
        private final Kind b;
        private final Path c;
        private final Set<String> d;

        /* synthetic */ FileResource(Kind kind, Path path, Set set, p p2) {
            this.a = new PathOrigin(path);
            this.b = kind;
            this.c = path;
            this.d = set;
        }

        @Override
        public Origin getOrigin() {
            return this.a;
        }

        @Override
        public Kind getKind() {
            return this.b;
        }

        @Override
        public InputStream getByteStream() throws ResourceException {
            try {
                return Files.newInputStream(this.c, new OpenOption[0]);
            }
            catch (IOException iOException) {
                throw new ResourceException(this.getOrigin(), (Throwable)iOException);
            }
        }

        @Override
        public Set<String> getClassDescriptors() {
            return this.d;
        }
    }

    public static enum Kind {
        CF,
        DEX;

    }
}

