/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.builder.core.DefaultManifestParser;
import com.android.builder.core.DefaultProductFlavor;
import com.android.builder.core.ManifestAttributeSupplier;
import com.android.builder.core.VariantAttributesProvider;
import com.android.builder.model.BuildType;
import com.android.builder.model.ProductFlavor;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.io.Serializable;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u001d\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0002<=B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u000e\u00108\u001a\u00020\r2\u0006\u00109\u001a\u00020\rJ\u000e\u0010:\u001a\u00020\r2\u0006\u00109\u001a\u00020\rJ\u000e\u0010;\u001a\u00020\r2\u0006\u00109\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0011R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0013R\u0013\u0010\u001c\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0013R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0013R\u0013\u0010$\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0013R\u0013\u0010&\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0013R\u0013\u0010(\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0013R\u0011\u0010*\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0011\u0010.\u001a\u00020/8F\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0013\u00102\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0013R\u0019\u00104\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r058F\u00a2\u0006\u0006\u001a\u0004\b6\u00107\u00a8\u0006>"}, d2={"Lcom/android/builder/core/VariantAttributesProvider;", "", "mergedFlavor", "Lcom/android/builder/model/ProductFlavor;", "buildType", "Lcom/android/builder/model/BuildType;", "isTestVariant", "", "manifestSupplier", "Lcom/android/builder/core/ManifestAttributeSupplier;", "manifestFile", "Ljava/io/File;", "fullName", "", "(Lcom/android/builder/model/ProductFlavor;Lcom/android/builder/model/BuildType;ZLcom/android/builder/core/ManifestAttributeSupplier;Ljava/io/File;Ljava/lang/String;)V", "extractNativeLibs", "getExtractNativeLibs", "()Ljava/lang/Boolean;", "getFullName", "()Ljava/lang/String;", "setFullName", "(Ljava/lang/String;)V", "functionalTest", "getFunctionalTest", "handleProfiling", "getHandleProfiling", "idOverride", "getIdOverride", "instrumentationRunner", "getInstrumentationRunner", "getMergedFlavor", "()Lcom/android/builder/model/ProductFlavor;", "setMergedFlavor", "(Lcom/android/builder/model/ProductFlavor;)V", "packageName", "getPackageName", "split", "getSplit", "targetPackage", "getTargetPackage", "testLabel", "getTestLabel", "versionCode", "", "getVersionCode", "()I", "versionCodeSerializableSupplier", "Ljava/util/function/IntSupplier;", "getVersionCodeSerializableSupplier", "()Ljava/util/function/IntSupplier;", "versionName", "getVersionName", "versionNameSerializableSupplier", "Ljava/util/function/Supplier;", "getVersionNameSerializableSupplier", "()Ljava/util/function/Supplier;", "getApplicationId", "testedPackage", "getOriginalApplicationId", "getTestApplicationId", "SerializableIntSupplier", "SerializableStringSupplier", "builder"})
public final class VariantAttributesProvider {
    @NotNull
    private ProductFlavor mergedFlavor;
    private final BuildType buildType;
    private final boolean isTestVariant;
    private final ManifestAttributeSupplier manifestSupplier;
    private final File manifestFile;
    @NotNull
    private String fullName;

    @Nullable
    public final String getIdOverride() {
        String idSuffix;
        String idName = this.mergedFlavor.getApplicationId();
        String string = idSuffix = DefaultProductFlavor.mergeApplicationIdSuffix(this.buildType.getApplicationIdSuffix(), this.mergedFlavor.getApplicationIdSuffix());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"idSuffix");
        CharSequence charSequence = string;
        if (!(charSequence.length() == 0)) {
            String string2 = idName;
            if (string2 == null) {
                string2 = this.getPackageName();
            }
            idName = string2;
            idName = idSuffix.charAt(0) == '.' ? idName + idSuffix : idName + '.' + idSuffix;
        }
        return idName;
    }

    @NotNull
    public final String getPackageName() {
        Preconditions.checkState((!this.isTestVariant ? 1 : 0) != 0);
        String string = this.manifestSupplier.getPackage();
        if (string == null) {
            throw (Throwable)new RuntimeException("Cannot read packageName from " + this.manifestFile.getAbsolutePath());
        }
        return string;
    }

    @Nullable
    public final String getSplit() {
        return this.manifestSupplier.getSplit();
    }

    @Nullable
    public final String getVersionName() {
        CharSequence charSequence;
        String versionName = this.mergedFlavor.getVersionName();
        String versionSuffix = this.mergedFlavor.getVersionNameSuffix();
        if (versionName == null && !this.isTestVariant) {
            versionName = this.manifestSupplier.getVersionName();
        }
        if ((versionSuffix = DefaultProductFlavor.mergeVersionNameSuffix(this.buildType.getVersionNameSuffix(), versionSuffix)) != null && !((charSequence = (CharSequence)versionSuffix).length() == 0)) {
            versionName = Strings.nullToEmpty((String)versionName) + versionSuffix;
        }
        return versionName;
    }

    public final int getVersionCode() {
        int versionCode;
        Integer n2 = this.mergedFlavor.getVersionCode();
        int n3 = versionCode = n2 != null ? n2 : -1;
        if (versionCode == -1 && !this.isTestVariant) {
            versionCode = this.manifestSupplier.getVersionCode();
        }
        return versionCode;
    }

    @Nullable
    public final String getInstrumentationRunner() {
        String string = this.mergedFlavor.getTestInstrumentationRunner();
        if (string == null) {
            string = this.manifestSupplier.getInstrumentationRunner();
        }
        return string;
    }

    @Nullable
    public final String getTargetPackage() {
        return this.manifestSupplier.getTargetPackage();
    }

    @Nullable
    public final Boolean getFunctionalTest() {
        Boolean bl = this.mergedFlavor.getTestFunctionalTest();
        if (bl == null) {
            bl = this.manifestSupplier.getFunctionalTest();
        }
        return bl;
    }

    @Nullable
    public final Boolean getHandleProfiling() {
        Boolean bl = this.mergedFlavor.getTestHandleProfiling();
        if (bl == null) {
            bl = this.manifestSupplier.getHandleProfiling();
        }
        return bl;
    }

    @Nullable
    public final String getTestLabel() {
        return this.manifestSupplier.getTestLabel();
    }

    @Nullable
    public final Boolean getExtractNativeLibs() {
        return this.manifestSupplier.getExtractNativeLibs();
    }

    @NotNull
    public final String getApplicationId(@NotNull String testedPackage) {
        Intrinsics.checkParameterIsNotNull((Object)testedPackage, (String)"testedPackage");
        String id = null;
        if (this.isTestVariant) {
            id = this.mergedFlavor.getTestApplicationId();
            if (id == null) {
                id = testedPackage + ".test";
            } else if (Intrinsics.areEqual((Object)id, (Object)testedPackage)) {
                throw (Throwable)new RuntimeException("Application and test application id cannot be the same: both are " + id + " for " + this.fullName);
            }
        } else {
            String string = this.getIdOverride();
            if (string == null) {
                string = this.getPackageName();
            }
            id = string;
        }
        return id;
    }

    @NotNull
    public final String getOriginalApplicationId(@NotNull String testedPackage) {
        Intrinsics.checkParameterIsNotNull((Object)testedPackage, (String)"testedPackage");
        return this.isTestVariant ? this.getApplicationId(testedPackage) : this.getPackageName();
    }

    @NotNull
    public final String getTestApplicationId(@NotNull String testedPackage) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)testedPackage, (String)"testedPackage");
        Preconditions.checkState((boolean)this.isTestVariant);
        if (!Strings.isNullOrEmpty((String)this.mergedFlavor.getTestApplicationId())) {
            string = this.mergedFlavor.getTestApplicationId();
            if (string == null) {
                Intrinsics.throwNpe();
            }
        } else {
            string = this.getApplicationId(testedPackage);
        }
        return string;
    }

    @NotNull
    public final Supplier<String> getVersionNameSerializableSupplier() {
        File file = this.isTestVariant ? null : this.manifestFile;
        String versionSuffix = DefaultProductFlavor.mergeVersionNameSuffix(this.buildType.getVersionNameSuffix(), this.mergedFlavor.getVersionNameSuffix());
        return new SerializableStringSupplier(file, this.mergedFlavor.getVersionName(), versionSuffix);
    }

    @NotNull
    public final IntSupplier getVersionCodeSerializableSupplier() {
        Integer n2 = this.mergedFlavor.getVersionCode();
        int versionCode = n2 != null ? n2 : -1;
        File file = this.isTestVariant ? null : this.manifestFile;
        return new SerializableIntSupplier(file, versionCode);
    }

    @NotNull
    public final ProductFlavor getMergedFlavor() {
        return this.mergedFlavor;
    }

    public final void setMergedFlavor(@NotNull ProductFlavor productFlavor) {
        Intrinsics.checkParameterIsNotNull((Object)productFlavor, (String)"<set-?>");
        this.mergedFlavor = productFlavor;
    }

    @NotNull
    public final String getFullName() {
        return this.fullName;
    }

    public final void setFullName(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.fullName = string;
    }

    public VariantAttributesProvider(@NotNull ProductFlavor mergedFlavor, @NotNull BuildType buildType, boolean isTestVariant, @NotNull ManifestAttributeSupplier manifestSupplier, @NotNull File manifestFile, @NotNull String fullName) {
        Intrinsics.checkParameterIsNotNull((Object)mergedFlavor, (String)"mergedFlavor");
        Intrinsics.checkParameterIsNotNull((Object)buildType, (String)"buildType");
        Intrinsics.checkParameterIsNotNull((Object)manifestSupplier, (String)"manifestSupplier");
        Intrinsics.checkParameterIsNotNull((Object)manifestFile, (String)"manifestFile");
        Intrinsics.checkParameterIsNotNull((Object)fullName, (String)"fullName");
        this.mergedFlavor = mergedFlavor;
        this.buildType = buildType;
        this.isTestVariant = isTestVariant;
        this.manifestSupplier = manifestSupplier;
        this.manifestFile = manifestFile;
        this.fullName = fullName;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u00020\u0003B)\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0002\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0002\u0010\bJ\n\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/builder/core/VariantAttributesProvider$SerializableStringSupplier;", "Ljava/util/function/Supplier;", "", "Ljava/io/Serializable;", "manifestFile", "Ljava/io/File;", "versionName", "versionSuffix", "(Ljava/io/File;Ljava/lang/String;Ljava/lang/String;)V", "cachedVersionName", "get", "builder"})
    private static final class SerializableStringSupplier
    implements Supplier<String>,
    Serializable {
        private String cachedVersionName;
        private final File manifestFile;
        private final String versionName;
        private final String versionSuffix;

        @Override
        @Nullable
        public String get() {
            CharSequence charSequence;
            if (this.cachedVersionName != null) {
                return this.cachedVersionName;
            }
            this.cachedVersionName = this.versionName;
            if (this.cachedVersionName == null && this.manifestFile != null) {
                this.cachedVersionName = new DefaultManifestParser(this.manifestFile, get.1.INSTANCE, null).getVersionName();
            }
            if (this.versionSuffix != null && !((charSequence = (CharSequence)this.versionSuffix).length() == 0)) {
                this.cachedVersionName = Strings.nullToEmpty((String)this.cachedVersionName) + this.versionSuffix;
            }
            return this.cachedVersionName;
        }

        public SerializableStringSupplier(@Nullable File manifestFile, @Nullable String versionName, @Nullable String versionSuffix) {
            this.manifestFile = manifestFile;
            this.versionName = versionName;
            this.versionSuffix = versionSuffix;
        }

        public /* synthetic */ SerializableStringSupplier(File file, String string, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                file = null;
            }
            if ((n2 & 2) != 0) {
                string = null;
            }
            if ((n2 & 4) != 0) {
                string2 = null;
            }
            this(file, string, string2);
        }

        public SerializableStringSupplier() {
            this(null, null, null, 7, null);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u0006H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/builder/core/VariantAttributesProvider$SerializableIntSupplier;", "Ljava/util/function/IntSupplier;", "Ljava/io/Serializable;", "manifestFile", "Ljava/io/File;", "versionCode", "", "(Ljava/io/File;I)V", "isCached", "", "getAsInt", "builder"})
    private static final class SerializableIntSupplier
    implements IntSupplier,
    Serializable {
        private boolean isCached;
        private final File manifestFile;
        private int versionCode;

        @Override
        public int getAsInt() {
            if (this.isCached) {
                return this.versionCode;
            }
            if (this.versionCode == -1 && this.manifestFile != null) {
                this.versionCode = new DefaultManifestParser(this.manifestFile, getAsInt.1.INSTANCE, null).getVersionCode();
            }
            this.isCached = true;
            return this.versionCode;
        }

        public SerializableIntSupplier(@Nullable File manifestFile, int versionCode) {
            this.manifestFile = manifestFile;
            this.versionCode = versionCode;
        }

        public /* synthetic */ SerializableIntSupplier(File file, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                file = null;
            }
            if ((n3 & 2) != 0) {
                n2 = -1;
            }
            this(file, n2);
        }

        public SerializableIntSupplier() {
            this(null, 0, 3, null);
        }
    }
}

