/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.profile;

import com.android.tools.build.gradle.internal.profile.GradleTaskExecutionType;
import com.android.tools.build.gradle.internal.profile.GradleTransformExecutionType;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.gson.stream.JsonWriter;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.wireless.android.sdk.stats.GradleBuildMemorySample;
import com.google.wireless.android.sdk.stats.GradleBuildProfile;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import com.google.wireless.android.sdk.stats.GradleBuildProject;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ChromeTracingProfileConverter {
    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                throw new AbnormalExitException("Please supply exactly one argument.");
            }
            try {
                ChromeTracingProfileConverter.toJson(args[0]);
            }
            catch (IOException e2) {
                throw new AbnormalExitException(e2);
            }
        }
        catch (AbnormalExitException e3) {
            System.err.println(e3.getMessage());
            if (e3.getCause() != null) {
                System.err.println(Throwables.getStackTraceAsString((Throwable)e3));
            }
            System.err.println();
            System.err.println("Usage:  ChromeTracingProfileConverter <proto_file>");
            System.err.println("        ChromeTracingProfileConverter <directory>");
            System.err.println();
            System.err.println("Given a proto file, outputs a corresponding json file");
            System.err.println("in the same directory that can be opened in chrome://tracing.");
            System.err.println();
            System.err.println("Given a directory, walks the directory and converts all the");
            System.err.println("files not ending in '.json'.");
            System.exit(1);
        }
    }

    private static void toJson(String pathString) throws IOException {
        final Path path = Paths.get(pathString, new String[0]);
        if (Files.isRegularFile(path, new LinkOption[0])) {
            ChromeTracingProfileConverter.toJson(path);
            System.out.format(Locale.US, "Converted %1$s%n", path.getFileName());
        } else if (Files.isDirectory(path, new LinkOption[0])) {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.getFileName().toString().endsWith(".rawproto")) {
                        ChromeTracingProfileConverter.toJson(file);
                        System.out.format(Locale.US, "Converted %1$s\n", path.relativize(file));
                        return FileVisitResult.CONTINUE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        } else {
            throw new AbnormalExitException(String.format(Locale.US, "Error: Argument is neither a file nor a directory: '%1$s'", pathString));
        }
    }

    public static Path getJsonOutFile(Path protoFile) {
        String fileName = protoFile.getFileName().toString();
        if (fileName.endsWith(".rawproto")) {
            fileName = fileName.substring(0, fileName.length() - ".rawproto".length());
        }
        return protoFile.getParent().resolve(fileName + ".json");
    }

    public static void toJson(Path protoFile) throws IOException, AbnormalExitException {
        GradleBuildProfile profile;
        try {
            profile = GradleBuildProfile.parseFrom((byte[])Files.readAllBytes(protoFile));
        }
        catch (InvalidProtocolBufferException e2) {
            throw new AbnormalExitException(String.format(Locale.US, "Could not parse proto file: %1$s '%2$s'", e2.getMessage(), protoFile));
        }
        Path out = ChromeTracingProfileConverter.getJsonOutFile(protoFile);
        Map<Long, ProjectHolder> projects = profile.getProjectList().stream().collect(Collectors.toMap(GradleBuildProject::getId, ProjectHolder::new));
        try (JsonWriter writer = new JsonWriter((Writer)Files.newBufferedWriter(out, new OpenOption[0]));){
            writer.beginObject();
            writer.name("traceEvents");
            writer.beginArray();
            long previousTime = 0L;
            for (GradleBuildMemorySample memorySample : profile.getMemorySampleList()) {
                long timestamp = memorySample.getTimestamp() * 1000L;
                if (timestamp == previousTime) {
                    // empty if block
                }
                previousTime = ++timestamp;
                writer.beginObject().name("pid").value(0L).name("ph").value("i").name("name").value("Memory sample").name("ts").value(timestamp).name("args");
                writer.beginObject();
                writer.name("JVM stats").value(memorySample.getJavaProcessStats().toString());
                writer.endObject();
                writer.endObject();
            }
            Map<Long, String> taskList = profile.getSpanList().stream().filter(it -> it.getParentId() == 0L).collect(Collectors.toMap(GradleBuildProfileSpan::getId, ChromeTracingProfileConverter::getSpanName));
            for (GradleBuildProfileSpan span : profile.getSpanList()) {
                writer.beginObject().name("pid").value(1L).name("tid").value(span.getThreadId()).name("id").value(span.getId());
                ImmutableMap.Builder args = ImmutableMap.builder();
                args.put((Object)"span_id", (Object)span.getId());
                if (span.getParentId() != 0L) {
                    args.put((Object)"parent_span_id", (Object)span.getParentId());
                } else {
                    ProjectHolder projectHolder = projects.get(span.getProject());
                    if (projectHolder != null) {
                        GradleBuildVariant variant;
                        args.put((Object)"project", (Object)projectHolder.project);
                        if (span.getVariant() != 0L && (variant = projectHolder.variants.get(span.getVariant())) != null) {
                            args.put((Object)"variant", (Object)variant);
                        }
                    }
                }
                if (span.getParentId() != 0L) {
                    writer.name("name").value(ChromeTracingProfileConverter.getChildSpanName(span, taskList.get(span.getParentId())));
                } else {
                    writer.name("name").value(ChromeTracingProfileConverter.getSpanName(span));
                }
                switch (span.getType()) {
                    case TASK_EXECUTION: {
                        args.put((Object)"task", (Object)span.getTask());
                        break;
                    }
                    case TASK_TRANSFORM: {
                        args.put((Object)"transform", (Object)span.getTransform());
                        break;
                    }
                    case TASK_TRANSFORM_PREPARATION: {
                        args.put((Object)"transform prep", (Object)span.getTransform());
                        break;
                    }
                    case WORKER_EXECUTION: {
                        args.put((Object)"type", (Object)"worker");
                        break;
                    }
                    case THREAD_EXECUTION: {
                        args.put((Object)"type", (Object)"thread");
                    }
                }
                writer.name("args").beginObject();
                for (Map.Entry entry : args.build().entrySet()) {
                    writer.name((String)entry.getKey()).value(entry.getValue().toString());
                }
                writer.endObject();
                long duration = span.getDurationInMs() * 1000L;
                writer.name("ph").value("X").name("ts").value(span.getStartTimeInMs() * 1000L).name("dur").value(duration == 0L ? 100L : duration).endObject();
            }
            writer.endArray();
            ChromeTracingProfileConverter.writeStackFrames(writer, profile);
            writer.endObject();
        }
    }

    static String getChildSpanName(GradleBuildProfileSpan span, String parentName) {
        switch (span.getType()) {
            case WORKER_EXECUTION: 
            case THREAD_EXECUTION: {
                return parentName;
            }
        }
        return ChromeTracingProfileConverter.pretty((Enum)span.getType());
    }

    static String getSpanName(GradleBuildProfileSpan span) {
        switch (span.getType()) {
            case TASK_EXECUTION: {
                return ChromeTracingProfileConverter.taskName(span);
            }
            case TASK_TRANSFORM: {
                return ChromeTracingProfileConverter.transformName(span);
            }
            case TASK_TRANSFORM_PREPARATION: {
                return "Prep for " + ChromeTracingProfileConverter.transformName(span);
            }
        }
        return ChromeTracingProfileConverter.pretty((Enum)span.getType());
    }

    static void writeStackFrames(JsonWriter writer, GradleBuildProfile profile) throws IOException {
        writer.name("stackFrames");
        writer.beginObject();
        for (GradleBuildProfileSpan span : profile.getSpanList()) {
            writer.name(String.valueOf(span.getId()));
            writer.beginObject().name("name").value(ChromeTracingProfileConverter.getSpanName(span));
            if (span.getParentId() != 0L) {
                writer.name("parent").value(String.valueOf(span.getParentId()));
            }
            writer.endObject();
        }
        writer.endObject();
    }

    private static String taskName(GradleBuildProfileSpan span) {
        return ChromeTracingProfileConverter.pretty((Enum)GradleTaskExecutionType.forNumber((int)span.getTask().getType()));
    }

    private static String transformName(GradleBuildProfileSpan span) {
        return ChromeTracingProfileConverter.pretty((Enum)GradleTransformExecutionType.forNumber((int)span.getTransform().getType()));
    }

    private static String pretty(Enum theEnum) {
        return theEnum.toString().toLowerCase(Locale.US).replace('_', ' ');
    }

    private static final class AbnormalExitException
    extends RuntimeException {
        AbnormalExitException(String text) {
            super(text);
        }

        AbnormalExitException(Throwable throwable) {
            super(throwable);
        }
    }

    static final class ProjectHolder {
        final GradleBuildProject project;
        final Map<Long, GradleBuildVariant> variants;

        ProjectHolder(GradleBuildProject project) {
            this.project = project.toBuilder().clearVariant().build();
            this.variants = project.getVariantList().stream().collect(Collectors.toMap(GradleBuildVariant::getId, Function.identity()));
        }
    }
}

