/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.Diagnostic;
import com.android.tools.r8.e;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.position.Position;

public interface DiagnosticsHandler {
    default public void error(Diagnostic diagnostic) {
        if (diagnostic.getOrigin() != Origin.unknown()) {
            System.err.print(e.a("Error in ").append(diagnostic.getOrigin()).toString());
            if (diagnostic.getPosition() != Position.UNKNOWN) {
                System.err.print(e.a(" at ").append(diagnostic.getPosition().getDescription()).toString());
            }
            System.err.println(":");
        } else {
            System.err.print("Error: ");
        }
        System.err.println(diagnostic.getDiagnosticMessage());
    }

    default public void warning(Diagnostic diagnostic) {
        if (diagnostic.getOrigin() != Origin.unknown()) {
            System.err.print(e.a("Warning in ").append(diagnostic.getOrigin()).append(":\n  ").toString());
        } else {
            System.err.print("Warning: ");
        }
        System.err.println(diagnostic.getDiagnosticMessage());
    }

    default public void info(Diagnostic diagnostic) {
        if (diagnostic.getOrigin() != Origin.unknown()) {
            System.out.print(e.a("In ").append(diagnostic.getOrigin()).append(":\n  ").toString());
        }
        System.out.println(diagnostic.getDiagnosticMessage());
    }
}

