/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.DexArchiveMergerException;
import com.android.dex.Dex;
import com.android.dx.command.dexer.DxContext;
import com.android.dx.merge.CollisionPolicy;
import com.android.dx.merge.DexMerger;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.concurrent.Callable;

public class DexArchiveMergerCallable
implements Callable<Void> {
    private final Collection<Dex> dexesToMerge;
    private final Path outputDex;
    private final DxContext dxContext;

    public DexArchiveMergerCallable(Collection<Dex> dexesToMerge, Path outputDex, DxContext dxContext) {
        this.dexesToMerge = dexesToMerge;
        this.outputDex = outputDex;
        this.dxContext = dxContext;
    }

    @Override
    public Void call() throws Exception {
        try {
            DexMerger dexMerger = new DexMerger(this.dexesToMerge.toArray(new Dex[0]), CollisionPolicy.FAIL, this.dxContext);
            Dex output2 = dexMerger.merge();
            Verify.verifyNotNull((Object)output2, (String)"Merged dex is null. We tried to merge %s DEX files", (Object[])new Object[]{String.valueOf(this.dexesToMerge.size())});
            Files.write(this.outputDex, output2.getBytes(), new OpenOption[0]);
        }
        catch (Exception e2) {
            this.dxContext.err.println("UNEXPECTED TOP-LEVEL EXCEPTION:");
            this.dxContext.err.println(Throwables.getRootCause((Throwable)e2));
            this.dxContext.err.print(Throwables.getStackTraceAsString((Throwable)e2));
            throw new DexArchiveMergerException("Unable to merge dex", e2);
        }
        return null;
    }
}

