/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.merge;

import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

final class CombinedInputStream
extends InputStream {
    private final ListIterator<InputStream> modifiableStreamList;
    private InputStream currentStream;
    private final boolean newLinePadding;
    private int lastByteRead;

    public CombinedInputStream(List<InputStream> inputStreams, boolean newLinePadding) {
        Preconditions.checkArgument((!inputStreams.isEmpty() ? 1 : 0) != 0);
        inputStreams.forEach(Preconditions::checkNotNull);
        this.modifiableStreamList = new ArrayList<InputStream>(inputStreams).listIterator();
        this.currentStream = this.modifiableStreamList.next();
        this.newLinePadding = newLinePadding;
        this.lastByteRead = -1;
    }

    @Override
    public int read() throws IOException {
        while (this.currentStream != null) {
            int byteRead = this.currentStream.read();
            if (byteRead != -1) {
                this.lastByteRead = byteRead;
                return this.lastByteRead;
            }
            this.advanceStream();
        }
        this.lastByteRead = -1;
        return -1;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        Preconditions.checkNotNull((Object)buffer);
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((offset + length <= buffer.length ? 1 : 0) != 0);
        while (this.currentStream != null) {
            int byteCount = this.currentStream.read(buffer, offset, length);
            if (byteCount > 0) {
                this.lastByteRead = buffer[offset + byteCount - 1];
            }
            if (byteCount >= 0) {
                return byteCount;
            }
            this.advanceStream();
        }
        this.lastByteRead = -1;
        return -1;
    }

    private void advanceStream() throws IOException {
        Preconditions.checkNotNull((Object)this.currentStream);
        this.currentStream.close();
        if (this.newLinePadding && this.modifiableStreamList.hasNext() && this.lastByteRead != 10) {
            this.modifiableStreamList.add(new ByteArrayInputStream(new byte[]{10}));
            this.modifiableStreamList.previous();
        }
        this.currentStream = this.modifiableStreamList.hasNext() ? this.modifiableStreamList.next() : null;
    }

    @Override
    public int available() throws IOException {
        return this.currentStream != null ? this.currentStream.available() : 0;
    }

    @Override
    public void close() throws IOException {
        if (this.currentStream == null) {
            return;
        }
        try (Closer closer = Closer.create();){
            closer.register((Closeable)this.currentStream);
            this.modifiableStreamList.forEachRemaining(arg_0 -> ((Closer)closer).register(arg_0));
            this.currentStream = null;
        }
    }
}

