/*
 * Decompiled with CFR 0.152.
 */
package com.android.dex;

import com.android.dex.util.ByteInput;
import java.io.UTFDataFormatException;

public final class Mutf8 {
    private Mutf8() {
    }

    public static String decode(ByteInput in, char[] out) throws UTFDataFormatException {
        int s2 = 0;
        while (true) {
            int b2;
            char a2;
            if ((a2 = (char)(in.readByte() & 0xFF)) == '\u0000') {
                return new String(out, 0, s2);
            }
            out[s2] = a2;
            if (a2 < '\u0080') {
                ++s2;
                continue;
            }
            if ((a2 & 0xE0) == 192) {
                b2 = in.readByte() & 0xFF;
                if ((b2 & 0xC0) != 128) {
                    throw new UTFDataFormatException("bad second byte");
                }
                out[s2++] = (char)((a2 & 0x1F) << 6 | b2 & 0x3F);
                continue;
            }
            if ((a2 & 0xF0) != 224) break;
            b2 = in.readByte() & 0xFF;
            int c2 = in.readByte() & 0xFF;
            if ((b2 & 0xC0) != 128 || (c2 & 0xC0) != 128) {
                throw new UTFDataFormatException("bad second or third byte");
            }
            out[s2++] = (char)((a2 & 0xF) << 12 | (b2 & 0x3F) << 6 | c2 & 0x3F);
        }
        throw new UTFDataFormatException("bad byte");
    }

    private static long countBytes(String s2, boolean shortLength) throws UTFDataFormatException {
        long result = 0L;
        int length = s2.length();
        for (int i2 = 0; i2 < length; ++i2) {
            char ch = s2.charAt(i2);
            result = ch != '\u0000' && ch <= '\u007f' ? ++result : (ch <= '\u07ff' ? (result += 2L) : (result += 3L));
            if (!shortLength || result <= 65535L) continue;
            throw new UTFDataFormatException("String more than 65535 UTF bytes long");
        }
        return result;
    }

    public static void encode(byte[] dst, int offset, String s2) {
        int length = s2.length();
        for (int i2 = 0; i2 < length; ++i2) {
            char ch = s2.charAt(i2);
            if (ch != '\u0000' && ch <= '\u007f') {
                dst[offset++] = (byte)ch;
                continue;
            }
            if (ch <= '\u07ff') {
                dst[offset++] = (byte)(0xC0 | 0x1F & ch >> 6);
                dst[offset++] = (byte)(0x80 | 0x3F & ch);
                continue;
            }
            dst[offset++] = (byte)(0xE0 | 0xF & ch >> 12);
            dst[offset++] = (byte)(0x80 | 0x3F & ch >> 6);
            dst[offset++] = (byte)(0x80 | 0x3F & ch);
        }
    }

    public static byte[] encode(String s2) throws UTFDataFormatException {
        int utfCount = (int)Mutf8.countBytes(s2, true);
        byte[] result = new byte[utfCount];
        Mutf8.encode(result, 0, s2);
        return result;
    }
}

