/*
 * Decompiled with CFR 0.152.
 */
package com.android.dex;

import com.android.dex.util.ByteInput;
import java.io.UTFDataFormatException;

public final class Mutf8 {
    private Mutf8() {
    }

    public static String decode(ByteInput in, char[] out) throws UTFDataFormatException {
        int s3 = 0;
        while (true) {
            int b3;
            char a3;
            if ((a3 = (char)(in.readByte() & 0xFF)) == '\u0000') {
                return new String(out, 0, s3);
            }
            out[s3] = a3;
            if (a3 < '\u0080') {
                ++s3;
                continue;
            }
            if ((a3 & 0xE0) == 192) {
                b3 = in.readByte() & 0xFF;
                if ((b3 & 0xC0) != 128) {
                    throw new UTFDataFormatException("bad second byte");
                }
                out[s3++] = (char)((a3 & 0x1F) << 6 | b3 & 0x3F);
                continue;
            }
            if ((a3 & 0xF0) != 224) break;
            b3 = in.readByte() & 0xFF;
            int c3 = in.readByte() & 0xFF;
            if ((b3 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                throw new UTFDataFormatException("bad second or third byte");
            }
            out[s3++] = (char)((a3 & 0xF) << 12 | (b3 & 0x3F) << 6 | c3 & 0x3F);
        }
        throw new UTFDataFormatException("bad byte");
    }

    private static long countBytes(String s3, boolean shortLength) throws UTFDataFormatException {
        long result = 0L;
        int length = s3.length();
        for (int i3 = 0; i3 < length; ++i3) {
            char ch = s3.charAt(i3);
            result = ch != '\u0000' && ch <= '\u007f' ? ++result : (ch <= '\u07ff' ? (result += 2L) : (result += 3L));
            if (!shortLength || result <= 65535L) continue;
            throw new UTFDataFormatException("String more than 65535 UTF bytes long");
        }
        return result;
    }

    public static void encode(byte[] dst, int offset, String s3) {
        int length = s3.length();
        for (int i3 = 0; i3 < length; ++i3) {
            char ch = s3.charAt(i3);
            if (ch != '\u0000' && ch <= '\u007f') {
                dst[offset++] = (byte)ch;
                continue;
            }
            if (ch <= '\u07ff') {
                dst[offset++] = (byte)(0xC0 | 0x1F & ch >> 6);
                dst[offset++] = (byte)(0x80 | 0x3F & ch);
                continue;
            }
            dst[offset++] = (byte)(0xE0 | 0xF & ch >> 12);
            dst[offset++] = (byte)(0x80 | 0x3F & ch >> 6);
            dst[offset++] = (byte)(0x80 | 0x3F & ch);
        }
    }

    public static byte[] encode(String s3) throws UTFDataFormatException {
        int utfCount = (int)Mutf8.countBytes(s3, true);
        byte[] result = new byte[utfCount];
        Mutf8.encode(result, 0, s3);
        return result;
    }
}

