/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dependency.level2;

import com.android.builder.dependency.HashCodeUtils;
import com.android.builder.dependency.level2.ExtractedDependency;
import com.android.builder.model.MavenCoordinates;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class AndroidDependency
extends ExtractedDependency {
    private final File jarsRootFolder;
    private final boolean isSubModule;
    private final int hashCode;

    public static AndroidDependency createExplodedAarLibrary(File artifactFile, MavenCoordinates coordinates, String name, String projectPath, File extractedFolder) {
        return new AndroidDependency(artifactFile, coordinates, name, projectPath, extractedFolder, new File(extractedFolder, "jars"), null, false);
    }

    public AndroidDependency(File artifactFile, MavenCoordinates coordinates, String name, String projectPath, File extractedFolder, File jarsRootFolder, String variant, boolean isSubModule) {
        super(artifactFile, coordinates, name, projectPath, extractedFolder, variant);
        this.jarsRootFolder = jarsRootFolder;
        this.isSubModule = isSubModule;
        this.hashCode = this.computeHashCode();
        Preconditions.checkArgument((variant == null || projectPath != null ? 1 : 0) != 0);
    }

    @Override
    public File getArtifactFile() {
        throw new UnsupportedOperationException("getArtifactFile() is no longer supported by AndroidDependency.");
    }

    public boolean isSubModule() {
        return this.isSubModule;
    }

    public List<File> getLocalJars() {
        ArrayList localJars = Lists.newArrayList();
        File[] jarList = new File(this.getJarsRootFolder(), "libs").listFiles();
        if (jarList != null) {
            for (File jars : jarList) {
                if (!jars.isFile() || !jars.getName().endsWith(".jar")) continue;
                localJars.add(jars);
            }
        }
        return localJars;
    }

    @Override
    public File getJarFile() {
        return new File(this.getJarsRootFolder(), "classes.jar");
    }

    @Override
    public List<File> getAdditionalClasspath() {
        return this.getLocalJars();
    }

    public File getJniFolder() {
        return new File(this.getExtractedFolder(), "jni");
    }

    public File getAidlFolder() {
        return new File(this.getExtractedFolder(), "aidl");
    }

    public File getRenderscriptFolder() {
        return new File(this.getExtractedFolder(), "rs");
    }

    public File getProguardRules() {
        return new File(this.getExtractedFolder(), "proguard.txt");
    }

    public File getLintJar() {
        return new File(this.getJarsRootFolder(), "lint.jar");
    }

    public File getExternalAnnotations() {
        return new File(this.getExtractedFolder(), "annotations.zip");
    }

    public File getPublicResources() {
        return new File(this.getExtractedFolder(), "public.txt");
    }

    public File getSymbolFile() {
        return new File(this.getExtractedFolder(), "R.txt");
    }

    protected File getJarsRootFolder() {
        return this.jarsRootFolder;
    }

    @Override
    public boolean equals(Object o3) {
        if (this == o3) {
            return true;
        }
        if (o3 == null || this.getClass() != o3.getClass()) {
            return false;
        }
        if (!super.equals(o3)) {
            return false;
        }
        AndroidDependency that = (AndroidDependency)o3;
        return this.isSubModule == that.isSubModule && Objects.equals(this.jarsRootFolder, that.jarsRootFolder);
    }

    private int computeHashCode() {
        return HashCodeUtils.hashCode(super.hashCode(), this.isSubModule, this.jarsRootFolder);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("artifactFile", (Object)this.getArtifactFile()).add("coordinates", (Object)this.getCoordinates()).add("projectPath", (Object)this.getProjectPath()).add("extractedFolder", (Object)this.getExtractedFolder()).add("variant", (Object)this.getVariant()).add("isSubModule", this.isSubModule).add("jarsRootFolder", (Object)this.jarsRootFolder).toString();
    }
}

