/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.BaseCommand;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.StringConsumer;
import com.android.tools.r8.a.a.a.b.da;
import com.android.tools.r8.experimental.graphinfo.GraphConsumer;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.m;
import com.android.tools.r8.n;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.a;
import com.android.tools.r8.shaking.ProguardConfigurationParser;
import com.android.tools.r8.shaking.ProguardConfigurationRule;
import com.android.tools.r8.shaking.ProguardConfigurationSource;
import com.android.tools.r8.shaking.ProguardConfigurationSourceStrings;
import com.android.tools.r8.shaking.oa;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.StringDiagnostic;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class GenerateMainDexListCommand
extends BaseCommand {
    static final String j = String.join((CharSequence)"\n", da.a("Usage: maindex [options] <input-files>", " where <input-files> are JAR files", " and options are:", "  --lib <file>             # Add <file> as a library resource.", "  --main-dex-rules <file>  # Proguard keep rules for classes to place in the", "                           # primary dex file.", "  --main-dex-list <file>   # List of classes to place in the primary dex file.", "  --main-dex-list-output <file>  # Output the full main-dex list in <file>.", "  --version                # Print the version.", "  --help                   # Print this message."));
    private final List<ProguardConfigurationRule> e;
    private final StringConsumer f;
    private final GraphConsumer g;
    private final DexItemFactory h;
    private final Reporter i;

    public static Builder builder() {
        return new Builder(null);
    }

    public static Builder builder(DiagnosticsHandler diagnosticsHandler) {
        return new Builder(diagnosticsHandler, null);
    }

    public static Builder parse(String[] stringArray) {
        Builder builder = GenerateMainDexListCommand.builder();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2].trim();
            if (string.length() == 0) continue;
            if (string.equals("--help")) {
                builder.setPrintHelp(true);
                continue;
            }
            if (string.equals("--version")) {
                builder.setPrintVersion(true);
                continue;
            }
            if (string.equals("--lib")) {
                builder.addLibraryFiles(Paths.get(stringArray[++i2], new String[0]));
                continue;
            }
            if (string.equals("--main-dex-rules")) {
                builder.addMainDexRulesFiles(Paths.get(stringArray[++i2], new String[0]));
                continue;
            }
            if (string.equals("--main-dex-list")) {
                builder.addMainDexListFiles(Paths.get(stringArray[++i2], new String[0]));
                continue;
            }
            if (string.equals("--main-dex-list-output")) {
                builder.setMainDexListOutputPath(Paths.get(stringArray[++i2], new String[0]));
                continue;
            }
            if (string.startsWith("--")) {
                builder.a().error(new StringDiagnostic(n.a("Unknown option: ", string), a.e));
            }
            builder.addProgramFiles(Paths.get(string, new String[0]));
        }
        return builder;
    }

    /* synthetic */ GenerateMainDexListCommand(boolean bl, boolean bl2, m m2) {
        super(bl, bl2);
        this.h = new DexItemFactory();
        this.e = da.i();
        this.f = null;
        this.g = null;
        this.i = new Reporter();
    }

    /* synthetic */ GenerateMainDexListCommand(DexItemFactory dexItemFactory, AndroidApp androidApp, List list, StringConsumer stringConsumer, GraphConsumer graphConsumer, Reporter reporter, m m2) {
        super(androidApp);
        this.h = dexItemFactory;
        this.e = list;
        this.f = stringConsumer;
        this.g = graphConsumer;
        this.i = reporter;
    }

    public StringConsumer getMainDexListConsumer() {
        return this.f;
    }

    Reporter a() {
        return this.i;
    }

    @Override
    InternalOptions getInternalOptions() {
        InternalOptions internalOptions;
        InternalOptions internalOptions2 = internalOptions;
        internalOptions2(this.h, this.i);
        internalOptions2.y = this.e;
        internalOptions2.D = this.f;
        internalOptions.mainDexKeptGraphConsumer = this.g;
        internalOptions.minimalMainDex = internalOptions.debug;
        internalOptions.i = false;
        internalOptions.enableInlining = false;
        return internalOptions;
    }

    public static class Builder
    extends BaseCommand.Builder<GenerateMainDexListCommand, Builder> {
        private final DexItemFactory f = new DexItemFactory();
        private final List<ProguardConfigurationSource> g = new ArrayList<ProguardConfigurationSource>();
        private StringConsumer h = null;
        private GraphConsumer i = null;

        /* synthetic */ Builder(m m2) {
        }

        /* synthetic */ Builder(DiagnosticsHandler diagnosticsHandler, m m2) {
            super(diagnosticsHandler);
        }

        @Override
        Builder c() {
            return this;
        }

        public Builder addMainDexRulesFiles(Path ... pathArray) {
            Builder builder = this;
            builder.a(() -> {
                for (Path path : pathArray) {
                    this.g.add(new oa(path));
                }
            });
            return builder.c();
        }

        public Builder addMainDexRulesFiles(List<Path> list) {
            Builder builder = this;
            builder.a(() -> {
                list = list.iterator();
                while (list.hasNext()) {
                    Path path = (Path)list.next();
                    this.g.add(new oa(path));
                }
            });
            return builder.c();
        }

        public Builder addMainDexRules(List<String> list, Origin origin) {
            Builder builder = this;
            builder.a(() -> this.g.add(new ProguardConfigurationSourceStrings(list, Paths.get(".", new String[0]), origin)));
            return builder.c();
        }

        public Builder setMainDexListOutputPath(Path path) {
            this.h = new StringConsumer.FileConsumer(path);
            return this.c();
        }

        public Builder setMainDexListConsumer(StringConsumer stringConsumer) {
            this.h = stringConsumer;
            return this.c();
        }

        @Override
        protected GenerateMainDexListCommand b() {
            if (!this.isPrintHelp() && !this.isPrintVersion()) {
                List<Object> list;
                if (this.g.isEmpty()) {
                    list = da.i();
                } else {
                    ProguardConfigurationParser proguardConfigurationParser = new ProguardConfigurationParser(this.f, this.a());
                    proguardConfigurationParser.a(this.g);
                    list = proguardConfigurationParser.getConfig().getRules();
                }
                return new GenerateMainDexListCommand(this.f, this.getAppBuilder().build(), list, this.h, this.i, this.a(), null);
            }
            return new GenerateMainDexListCommand(this.isPrintHelp(), this.isPrintVersion(), null);
        }

        public Builder setMainDexKeptGraphConsumer(GraphConsumer graphConsumer) {
            this.i = graphConsumer;
            return this.c();
        }
    }
}

