/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.Resource;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.s;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;

public interface ProgramResource
extends Resource {
    public static ProgramResource fromFile(Kind kind, Path path) {
        return new FileResource(kind, path, null, null);
    }

    public static ProgramResource fromBytes(Origin origin, Kind kind, byte[] byArray, Set<String> set) {
        return new ByteResource(origin, kind, byArray, set, null);
    }

    public Kind getKind();

    public InputStream getByteStream() throws ResourceException;

    public Set<String> getClassDescriptors();

    public static class ByteResource
    implements ProgramResource {
        static final /* synthetic */ boolean e;
        private final Origin a;
        private final Kind b;
        private final byte[] c;
        private final Set<String> d;

        /* synthetic */ ByteResource(Origin origin, Kind kind, byte[] byArray, Set set, s s2) {
            if (!e && byArray == null) {
                throw new AssertionError();
            }
            this.a = origin;
            this.b = kind;
            this.c = byArray;
            this.d = set;
        }

        static {
            e = ProgramResource.class.desiredAssertionStatus() ^ true;
        }

        @Override
        public Origin getOrigin() {
            return this.a;
        }

        @Override
        public Kind getKind() {
            return this.b;
        }

        @Override
        public InputStream getByteStream() throws ResourceException {
            return new ByteArrayInputStream(this.c);
        }

        @Override
        public Set<String> getClassDescriptors() {
            return this.d;
        }
    }

    public static class FileResource
    implements ProgramResource {
        private final Origin a;
        private final Kind b;
        private final Path c;
        private final Set<String> d;

        /* synthetic */ FileResource(Kind kind, Path path, Set set, s s2) {
            this.a = new PathOrigin(path);
            this.b = kind;
            this.c = path;
            this.d = set;
        }

        @Override
        public Origin getOrigin() {
            return this.a;
        }

        @Override
        public Kind getKind() {
            return this.b;
        }

        @Override
        public InputStream getByteStream() throws ResourceException {
            try {
                return Files.newInputStream(this.c, new OpenOption[0]);
            }
            catch (IOException iOException) {
                throw new ResourceException(this.getOrigin(), (Throwable)iOException);
            }
        }

        @Override
        public Set<String> getClassDescriptors() {
            return this.d;
        }
    }

    public static enum Kind {
        CF,
        DEX;

    }
}

