/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.ssa;

import com.android.dx.ssa.Dominators;
import com.android.dx.ssa.SetFactory;
import com.android.dx.ssa.SsaBasicBlock;
import com.android.dx.ssa.SsaMethod;
import com.android.dx.util.IntSet;
import java.util.ArrayList;
import java.util.BitSet;

public class DomFront {
    private static final boolean DEBUG = false;
    private final SsaMethod meth;
    private final ArrayList<SsaBasicBlock> nodes;
    private final DomInfo[] domInfos;

    public DomFront(SsaMethod meth) {
        this.meth = meth;
        this.nodes = meth.getBlocks();
        int szNodes = this.nodes.size();
        this.domInfos = new DomInfo[szNodes];
        for (int i3 = 0; i3 < szNodes; ++i3) {
            this.domInfos[i3] = new DomInfo();
        }
    }

    public DomInfo[] run() {
        int szNodes = this.nodes.size();
        Dominators methDom = Dominators.make(this.meth, this.domInfos, false);
        this.buildDomTree();
        for (int i3 = 0; i3 < szNodes; ++i3) {
            this.domInfos[i3].dominanceFrontiers = SetFactory.makeDomFrontSet(szNodes);
        }
        this.calcDomFronts();
        return this.domInfos;
    }

    private void debugPrintDomChildren() {
        int szNodes = this.nodes.size();
        for (int i3 = 0; i3 < szNodes; ++i3) {
            SsaBasicBlock node = this.nodes.get(i3);
            StringBuffer sb = new StringBuffer();
            sb.append('{');
            boolean comma = false;
            for (SsaBasicBlock child : node.getDomChildren()) {
                if (comma) {
                    sb.append(',');
                }
                sb.append(child);
                comma = true;
            }
            sb.append('}');
            System.out.println("domChildren[" + node + "]: " + sb);
        }
    }

    private void buildDomTree() {
        int szNodes = this.nodes.size();
        for (int i3 = 0; i3 < szNodes; ++i3) {
            DomInfo info = this.domInfos[i3];
            if (info.idom == -1) continue;
            SsaBasicBlock domParent = this.nodes.get(info.idom);
            domParent.addDomChild(this.nodes.get(i3));
        }
    }

    private void calcDomFronts() {
        int szNodes = this.nodes.size();
        for (int b4 = 0; b4 < szNodes; ++b4) {
            SsaBasicBlock nb = this.nodes.get(b4);
            DomInfo nbInfo = this.domInfos[b4];
            BitSet pred = nb.getPredecessors();
            if (pred.cardinality() <= 1) continue;
            int i3 = pred.nextSetBit(0);
            while (i3 >= 0) {
                int runnerIndex = i3;
                while (runnerIndex != nbInfo.idom && runnerIndex != -1) {
                    DomInfo runnerInfo = this.domInfos[runnerIndex];
                    if (runnerInfo.dominanceFrontiers.has(b4)) break;
                    runnerInfo.dominanceFrontiers.add(b4);
                    runnerIndex = runnerInfo.idom;
                }
                i3 = pred.nextSetBit(i3 + 1);
            }
        }
    }

    public static class DomInfo {
        public IntSet dominanceFrontiers;
        public int idom = -1;
    }
}

