/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.files;

import com.android.builder.files.DirectoryEntry;
import com.android.builder.files.ZipCentralDirectoryKt;
import com.android.tools.build.apkzlib.zip.compress.Zip64NotSupportedException;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001'B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0014\u001a\u00020\u0006H\u0002J$\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J\u0014\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u0002J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u0019H\u0002J\u0010\u0010#\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020$H\u0002J\u000e\u0010%\u001a\u00020&2\u0006\u0010\u0002\u001a\u00020\u0003R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR'\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\n\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006("}, d2={"Lcom/android/builder/files/ZipCentralDirectory;", "", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "directoryBuffer", "Ljava/nio/ByteBuffer;", "getDirectoryBuffer", "()Ljava/nio/ByteBuffer;", "directoryBuffer$delegate", "Lkotlin/Lazy;", "entries", "", "", "Lcom/android/builder/files/DirectoryEntry;", "getEntries", "()Ljava/util/Map;", "entries$delegate", "getFile", "()Ljava/io/File;", "initBuffer", "readBuffer", "Lkotlin/Pair;", "", "size", "", "randomAccessFile", "Ljava/io/RandomAccessFile;", "readCentralDirectoryRecord", "Lcom/android/builder/files/ZipCentralDirectory$CdrInfo;", "readEOCDFromBuffer", "buffer", "readZipEntries", "uintToLong", "i", "ushortToInt", "", "writeTo", "", "CdrInfo", "builder"})
public final class ZipCentralDirectory {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final Lazy entries$delegate;
    private final Lazy directoryBuffer$delegate;
    @NotNull
    private final File file;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ZipCentralDirectory.class), "entries", "getEntries()Ljava/util/Map;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ZipCentralDirectory.class), "directoryBuffer", "getDirectoryBuffer()Ljava/nio/ByteBuffer;"))};
    }

    @NotNull
    public final Map<String, DirectoryEntry> getEntries() {
        Lazy lazy = this.entries$delegate;
        ZipCentralDirectory zipCentralDirectory = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (Map)lazy.getValue();
    }

    private final ByteBuffer getDirectoryBuffer() {
        Lazy lazy = this.directoryBuffer$delegate;
        ZipCentralDirectory zipCentralDirectory = this;
        KProperty kProperty = $$delegatedProperties[1];
        boolean bl = false;
        return (ByteBuffer)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeTo(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        ByteBuffer eocd = ByteBuffer.wrap(new byte[22]);
        eocd.order(ByteOrder.LITTLE_ENDIAN);
        eocd.putInt(101010256);
        eocd.putShort((short)0);
        eocd.putShort((short)0);
        eocd.putShort((short)1);
        eocd.putShort((short)1);
        eocd.putInt(this.getDirectoryBuffer().capacity());
        eocd.putInt(0);
        eocd.putShort((short)0);
        this.getDirectoryBuffer().position(0);
        Closeable closeable = new FileOutputStream(file);
        boolean bl = false;
        Throwable throwable = null;
        try {
            FileOutputStream fos = (FileOutputStream)closeable;
            boolean bl2 = false;
            Closeable closeable2 = new BufferedOutputStream(fos);
            boolean bl3 = false;
            Throwable throwable2 = null;
            try {
                BufferedOutputStream bos = (BufferedOutputStream)closeable2;
                boolean bl4 = false;
                bos.write(this.getDirectoryBuffer().array());
                bos.write(eocd.array());
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ByteBuffer initBuffer() {
        ByteBuffer byteBuffer;
        Closeable closeable = new RandomAccessFile(this.file.getAbsolutePath(), "r");
        boolean bl = false;
        Throwable throwable = null;
        try {
            RandomAccessFile raf = (RandomAccessFile)closeable;
            boolean bl2 = false;
            CdrInfo info = this.readCentralDirectoryRecord(raf);
            byte[] cdContent = new byte[(int)info.getCdSize()];
            raf.seek(info.getCdOffset());
            raf.readFully(cdContent);
            ByteBuffer buffer = ByteBuffer.wrap(cdContent);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            ByteBuffer byteBuffer2 = buffer;
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer2, (String)"buffer");
            ByteBuffer byteBuffer3 = byteBuffer2;
            byteBuffer = byteBuffer3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"RandomAccessFile(file.ab\u2026         buffer\n        }");
        return byteBuffer;
    }

    private final CdrInfo readCentralDirectoryRecord(RandomAccessFile randomAccessFile) {
        long l3;
        ByteBuffer buffer;
        Pair<ByteBuffer, Long> pair = this.readBuffer(22, randomAccessFile);
        ByteBuffer byteBuffer = (ByteBuffer)pair.component1();
        long offset = ((Number)pair.component2()).longValue();
        int signature = buffer.getInt();
        if (signature == 101010256) {
            l3 = offset;
        } else {
            Pair<ByteBuffer, Long> pair2 = this.readBuffer(65557, randomAccessFile);
            boolean bl = false;
            boolean bl2 = false;
            Pair<ByteBuffer, Long> it = pair2;
            boolean bl3 = false;
            buffer = (ByteBuffer)it.getFirst();
            offset = ((Number)it.getSecond()).longValue();
            buffer.position(buffer.capacity() - 23);
            while (buffer.getInt() != 101010256) {
                int position = buffer.position() - 4 - 1;
                if (buffer.position() == 0) {
                    throw (Throwable)new RuntimeException("Failed to find EOCD in " + this.file);
                }
                buffer.position(position);
            }
            l3 = (long)buffer.position() + offset - (long)4;
        }
        long eocdOffset = l3;
        CdrInfo info = this.readEOCDFromBuffer(buffer);
        long zip64LocatorStart = eocdOffset - (long)20;
        if (zip64LocatorStart >= 0L) {
            randomAccessFile.seek(zip64LocatorStart);
            for (byte by : ZipCentralDirectoryKt.access$getZIP64_EOCD_LOCATOR_SIGNATURE$p()) {
                if (randomAccessFile.readByte() == by) continue;
                return info;
            }
            throw (Throwable)new Zip64NotSupportedException("Zip64 EOCD locator found but Zip64 format is not supported: " + this.file);
        }
        return info;
    }

    private final Pair<ByteBuffer, Long> readBuffer(int size, RandomAccessFile randomAccessFile) {
        long length = randomAccessFile.length();
        int sizeToRead = (int)Math.min(length, (long)size);
        if (sizeToRead < 22) {
            throw (Throwable)new RuntimeException("Zip file smaller than EOCD size: " + this.file);
        }
        long offset = length - (long)sizeToRead;
        randomAccessFile.seek(offset);
        byte[] byteArray = new byte[sizeToRead];
        randomAccessFile.read(byteArray);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byteArray);
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"ByteBuffer.wrap(byteArray)");
        ByteBuffer buffer = byteBuffer;
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        return new Pair((Object)buffer, (Object)offset);
    }

    private final CdrInfo readEOCDFromBuffer(ByteBuffer buffer) {
        CdrInfo info = new CdrInfo();
        buffer.position(buffer.position() + 8);
        info.setCdSize(this.uintToLong(buffer.getInt()));
        info.setCdOffset(this.uintToLong(buffer.getInt()));
        return info;
    }

    private final Map<String, DirectoryEntry> readZipEntries() {
        ByteBuffer buffer = this.getDirectoryBuffer();
        boolean bl = false;
        Map entries2 = new LinkedHashMap();
        while (buffer.remaining() >= 46 && buffer.getInt() == 33639248) {
            Charset charset;
            buffer.position(buffer.position() + 12);
            long crc = this.uintToLong(buffer.getInt());
            this.uintToLong(buffer.getInt());
            long decompressedSize = this.uintToLong(buffer.getInt());
            int pathLength = this.ushortToInt(buffer.getShort());
            int extraLength = this.ushortToInt(buffer.getShort());
            int commentLength = this.ushortToInt(buffer.getShort());
            buffer.position(buffer.position() + 8);
            this.uintToLong(buffer.getInt());
            byte[] pathBytes = new byte[pathLength];
            buffer.get(pathBytes);
            Intrinsics.checkExpressionValueIsNotNull((Object)Charset.forName("UTF-8"), (String)"Charset.forName(\"UTF-8\")");
            boolean bl2 = false;
            String name = new String(pathBytes, charset);
            buffer.position(buffer.position() + extraLength + commentLength);
            if (decompressedSize <= 0L && StringsKt.endsWith$default((String)name, (String)"/", (boolean)false, (int)2, null)) continue;
            DirectoryEntry entry = new DirectoryEntry(name, crc, decompressedSize);
            entries2.put(entry.getName(), entry);
        }
        Map<String, DirectoryEntry> map = Collections.unmodifiableMap(entries2);
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"Collections.unmodifiableMap(entries)");
        return map;
    }

    private final long uintToLong(int i3) {
        return 0xFFFFFFFFL & (long)i3;
    }

    private final int ushortToInt(short i3) {
        return 0xFFFF & i3;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    public ZipCentralDirectory(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.file = file;
        this.entries$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<String, ? extends DirectoryEntry>>(this){
            final /* synthetic */ ZipCentralDirectory this$0;

            @NotNull
            public final Map<String, DirectoryEntry> invoke() {
                return ZipCentralDirectory.access$readZipEntries(this.this$0);
            }
            {
                this.this$0 = zipCentralDirectory;
                super(0);
            }
        }));
        this.directoryBuffer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ByteBuffer>(this){
            final /* synthetic */ ZipCentralDirectory this$0;

            @NotNull
            public final ByteBuffer invoke() {
                return ZipCentralDirectory.access$initBuffer(this.this$0);
            }
            {
                this.this$0 = zipCentralDirectory;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ Map access$readZipEntries(ZipCentralDirectory $this) {
        return $this.readZipEntries();
    }

    public static final /* synthetic */ ByteBuffer access$initBuffer(ZipCentralDirectory $this) {
        return $this.initBuffer();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\b\u00a8\u0006\f"}, d2={"Lcom/android/builder/files/ZipCentralDirectory$CdrInfo;", "", "()V", "cdOffset", "", "getCdOffset", "()J", "setCdOffset", "(J)V", "cdSize", "getCdSize", "setCdSize", "builder"})
    private static final class CdrInfo {
        private long cdOffset = -1L;
        private long cdSize = -1L;

        public final long getCdOffset() {
            return this.cdOffset;
        }

        public final void setCdOffset(long l3) {
            this.cdOffset = l3;
        }

        public final long getCdSize() {
            return this.cdSize;
        }

        public final void setCdSize(long l3) {
            this.cdSize = l3;
        }
    }
}

