/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.files;

import com.android.builder.files.ZipCentralDirectory;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.function.Function;
import org.apache.commons.codec.binary.Base64;

public class KeyedFileCache {
    private final File directory;
    private final Function<File, String> keyFunction;

    public KeyedFileCache(File directory, Function<File, String> keyFunction) {
        Preconditions.checkArgument((boolean)directory.isDirectory(), (String)"!File.isDirectory(): %s", (Object)directory);
        this.directory = directory;
        this.keyFunction = keyFunction;
    }

    public void add(File f3) throws IOException {
        Preconditions.checkArgument((boolean)f3.isFile(), (String)"!File.isFile(): %s", (Object)f3);
        if (!this.directory.isDirectory()) {
            FileUtils.mkdirs((File)this.directory);
        }
        String k3 = this.key(f3);
        Files.copy((File)f3, (File)new File(this.directory, k3));
    }

    public void add(ZipCentralDirectory centralDirectory) throws IOException {
        File file = centralDirectory.getFile();
        Preconditions.checkArgument((boolean)file.isFile(), (String)"!File.isFile(): %s", (Object)file);
        if (!this.directory.isDirectory()) {
            FileUtils.mkdirs((File)this.directory);
        }
        centralDirectory.writeTo(new File(this.directory, this.key(file)));
    }

    public File get(File f3) {
        File file = new File(this.directory, this.key(f3));
        if (file.isFile()) {
            return file;
        }
        return null;
    }

    public void remove(File f3) throws IOException {
        File toRemove = new File(this.directory, this.key(f3));
        if (toRemove.exists()) {
            FileUtils.delete((File)toRemove);
        }
    }

    private String key(File f3) {
        String key = this.keyFunction.apply(f3);
        if (key != null) {
            return key;
        }
        throw new IllegalStateException("No key found for file " + f3);
    }

    public static String fileNameKey(File f3) {
        String absolutePath = f3.getAbsolutePath();
        byte[] sha1Sum = Hashing.sha1().hashString((CharSequence)absolutePath, Charsets.UTF_8).asBytes();
        return new String(Base64.encodeBase64((byte[])sha1Sum), Charsets.US_ASCII).replaceAll("/", "_");
    }

    public void clear() throws IOException {
        File[] files = this.directory.listFiles();
        if (files == null) {
            return;
        }
        for (File f3 : files) {
            if (!f3.isFile()) continue;
            FileUtils.delete((File)f3);
        }
    }
}

