/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.multidex;

import com.android.builder.dexing.ClassFileInput;
import com.android.builder.dexing.D8DiagnosticsHandler;
import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageReceiver;
import com.android.tools.r8.Diagnostic;
import com.android.tools.r8.GenerateMainDexList;
import com.android.tools.r8.GenerateMainDexListCommand;
import com.android.tools.r8.errors.DuplicateTypesDiagnostic;
import com.android.tools.r8.origin.Origin;
import com.android.utils.PathUtils;
import com.google.common.collect.ImmutableList;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class D8MainDexList {
    private D8MainDexList() {
    }

    public static List<String> generate(List<String> mainDexRules, List<Path> mainDexRulesFiles, Collection<Path> programFiles, Collection<Path> libraryFiles, MessageReceiver messageReceiver) throws MainDexListException {
        InterceptingDiagnosticsHandler d8DiagnosticsHandler = new InterceptingDiagnosticsHandler(messageReceiver);
        try {
            GenerateMainDexListCommand.Builder command = (GenerateMainDexListCommand.Builder)GenerateMainDexListCommand.builder(d8DiagnosticsHandler).addMainDexRules(mainDexRules, Origin.unknown()).addMainDexRulesFiles(mainDexRulesFiles).addLibraryFiles(libraryFiles);
            for (Path program : programFiles) {
                if (Files.isRegularFile(program, new LinkOption[0])) {
                    command.addProgramFiles(program);
                    continue;
                }
                Stream<Path> classFiles = Files.walk(program, new FileVisitOption[0]);
                Throwable throwable = null;
                try {
                    List<Path> allClasses = classFiles.filter(file -> {
                        Path relative = program.relativize((Path)file);
                        return ClassFileInput.CLASS_MATCHER.test(PathUtils.toSystemIndependentPath((Path)relative));
                    }).collect(Collectors.toList());
                    command.addProgramFiles(allClasses);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (classFiles == null) continue;
                    if (throwable != null) {
                        try {
                            classFiles.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    classFiles.close();
                }
            }
            return ImmutableList.copyOf(GenerateMainDexList.run((GenerateMainDexListCommand)command.build(), ForkJoinPool.commonPool()));
        }
        catch (Exception e3) {
            throw D8MainDexList.getExceptionToRethrow(e3, d8DiagnosticsHandler);
        }
    }

    private static MainDexListException getExceptionToRethrow(Throwable t3, D8DiagnosticsHandler d8DiagnosticsHandler) {
        StringBuilder msg = new StringBuilder("Error while merging dex archives: ");
        for (String hint : d8DiagnosticsHandler.getPendingHints()) {
            msg.append(System.lineSeparator());
            msg.append(hint);
        }
        return new MainDexListException(msg.toString(), t3);
    }

    private static class InterceptingDiagnosticsHandler
    extends D8DiagnosticsHandler {
        public InterceptingDiagnosticsHandler(MessageReceiver messageReceiver) {
            super(messageReceiver);
        }

        @Override
        protected Message convertToMessage(Message.Kind kind, Diagnostic diagnostic) {
            if (diagnostic instanceof DuplicateTypesDiagnostic) {
                this.addHint(diagnostic.getDiagnosticMessage());
                this.addHint("Learn how to resolve the issue at https://developer.android.com/studio/build/dependencies#duplicate_classes.");
            }
            return super.convertToMessage(kind, diagnostic);
        }
    }

    public static class MainDexListException
    extends Exception {
        public MainDexListException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

