/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.BaseCommand;
import com.android.tools.r8.ClassFileConsumer;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.DexFilePerClassFileConsumer;
import com.android.tools.r8.DexIndexedConsumer;
import com.android.tools.r8.Diagnostic;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.InternalProgramOutputPathConsumer;
import com.android.tools.r8.OutputMode;
import com.android.tools.r8.ProgramConsumer;
import com.android.tools.r8.StringConsumer;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.StringDiagnostic;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.function.BiPredicate;

public abstract class BaseCompilerCommand
extends BaseCommand {
    static final /* synthetic */ boolean o;
    private final CompilationMode e;
    private final ProgramConsumer f;
    private final StringConsumer g;
    private final int h;
    private final Reporter i;
    private final boolean j;
    private final boolean k;
    private final boolean l;
    private String m;
    private final BiPredicate<String, Long> n;

    BaseCompilerCommand(boolean bl, boolean bl2) {
        super(bl, bl2);
        this.f = null;
        this.g = null;
        this.e = null;
        this.h = 0;
        this.i = new Reporter();
        this.j = true;
        this.k = false;
        this.l = false;
        this.n = (string, l3) -> true;
    }

    BaseCompilerCommand(AndroidApp androidApp, CompilationMode compilationMode, ProgramConsumer programConsumer2, StringConsumer stringConsumer, int n3, Reporter reporter, boolean bl, boolean bl2, String string, boolean bl3, BiPredicate<String, Long> biPredicate) {
        super(androidApp);
        if (!o && n3 <= 0) {
            throw new AssertionError();
        }
        if (!o && compilationMode == null) {
            throw new AssertionError();
        }
        BaseCompilerCommand baseCompilerCommand = this;
        baseCompilerCommand.e = compilationMode;
        baseCompilerCommand.f = programConsumer2;
        baseCompilerCommand.g = stringConsumer;
        baseCompilerCommand.h = n3;
        baseCompilerCommand.i = reporter;
        baseCompilerCommand.j = bl;
        baseCompilerCommand.l = bl2;
        baseCompilerCommand.m = string;
        baseCompilerCommand.k = bl3;
        baseCompilerCommand.n = biPredicate;
    }

    static {
        o = BaseCompilerCommand.class.desiredAssertionStatus() ^ true;
    }

    public CompilationMode getMode() {
        return this.e;
    }

    public int getMinApiLevel() {
        return this.h;
    }

    public ProgramConsumer getProgramConsumer() {
        return this.f;
    }

    public StringConsumer getMainDexListConsumer() {
        return this.g;
    }

    public boolean getEnableDesugaring() {
        return this.j;
    }

    public boolean getIncludeClassesChecksum() {
        return this.k;
    }

    public BiPredicate<String, Long> getDexClassChecksumFilter() {
        return this.n;
    }

    public boolean isOptimizeMultidexForLinearAlloc() {
        return this.l;
    }

    Reporter a() {
        return this.i;
    }

    public String getSpecialLibraryConfiguration() {
        return this.m;
    }

    public static abstract class Builder<C extends BaseCompilerCommand, B extends Builder<C, B>>
    extends BaseCommand.Builder<C, B> {
        static final /* synthetic */ boolean q;
        private ProgramConsumer f;
        private StringConsumer g;
        private Path h;
        private OutputMode i;
        private CompilationMode j;
        private int k;
        private boolean l;
        private String m;
        private boolean n;
        private boolean o;
        private BiPredicate<String, Long> p;

        Builder(DiagnosticsHandler diagnosticsHandler) {
            Builder builder = this;
            super(diagnosticsHandler);
            builder.f = null;
            builder.g = null;
            builder.h = null;
            builder.i = OutputMode.DexIndexed;
            builder.k = 0;
            builder.l = false;
            builder.n = false;
            builder.o = false;
            builder.p = (string, l3) -> true;
            builder.j = builder.e();
        }

        Builder(AndroidApp androidApp) {
            Builder builder = this;
            super(AndroidApp.builder(androidApp));
            builder.f = null;
            builder.g = null;
            builder.h = null;
            builder.i = OutputMode.DexIndexed;
            builder.k = 0;
            builder.l = false;
            builder.n = false;
            builder.o = false;
            builder.p = (string, l3) -> true;
            builder.j = builder.e();
        }

        Builder(AndroidApp androidApp, DiagnosticsHandler diagnosticsHandler) {
            Builder builder = this;
            super(AndroidApp.a(androidApp, new Reporter(diagnosticsHandler)));
            builder.f = null;
            builder.g = null;
            builder.h = null;
            builder.i = OutputMode.DexIndexed;
            builder.k = 0;
            builder.l = false;
            builder.n = false;
            builder.o = false;
            builder.p = (string, l3) -> true;
            builder.j = builder.e();
        }

        static {
            q = BaseCompilerCommand.class.desiredAssertionStatus() ^ true;
        }

        abstract CompilationMode e();

        public CompilationMode getMode() {
            return this.j;
        }

        public B setMode(CompilationMode compilationMode) {
            if (!q && compilationMode == null) {
                throw new AssertionError();
            }
            this.j = compilationMode;
            return (B)((Builder)this.c());
        }

        public Path getOutputPath() {
            return this.h;
        }

        public OutputMode getOutputMode() {
            return this.i;
        }

        public ProgramConsumer getProgramConsumer() {
            return this.f;
        }

        public StringConsumer getMainDexListConsumer() {
            return this.g;
        }

        public BiPredicate<String, Long> getDexClassChecksumFilter() {
            return this.p;
        }

        public B setOptimizeMultidexForLinearAlloc(boolean bl) {
            this.o = bl;
            return (B)((Builder)this.c());
        }

        protected boolean g() {
            return this.o;
        }

        public B setProgramConsumer(ProgramConsumer programConsumer2) {
            Builder builder = this;
            builder.h = null;
            builder.i = null;
            this.f = programConsumer2;
            return (B)((Builder)this.c());
        }

        public B setMainDexListOutputPath(Path path) {
            this.g = new StringConsumer.FileConsumer(path);
            return (B)((Builder)this.c());
        }

        public B setMainDexListConsumer(StringConsumer stringConsumer) {
            this.g = stringConsumer;
            return (B)((Builder)this.c());
        }

        public B setOutput(Path path, OutputMode outputMode) {
            return this.setOutput(path, outputMode, false);
        }

        protected B setOutput(Path path, OutputMode outputMode, boolean bl) {
            if (!q && path == null) {
                throw new AssertionError();
            }
            if (!q && outputMode == null) {
                throw new AssertionError();
            }
            Builder builder = this;
            this.h = path;
            this.i = outputMode;
            builder.f = builder.a(path, outputMode, bl);
            return (B)((Builder)builder.c());
        }

        public B setDexClassChecksumFilter(BiPredicate<String, Long> biPredicate) {
            if (!q && biPredicate == null) {
                throw new AssertionError();
            }
            this.p = biPredicate;
            return (B)((Builder)this.c());
        }

        protected InternalProgramOutputPathConsumer a(Path path, OutputMode outputMode, boolean bl) {
            Object object;
            if (outputMode == OutputMode.DexIndexed) {
                if (FileUtils.isArchive(path)) {
                    DexIndexedConsumer.ArchiveConsumer archiveConsumer;
                    object = archiveConsumer;
                    archiveConsumer = new DexIndexedConsumer.ArchiveConsumer(path, bl);
                } else {
                    DexIndexedConsumer.DirectoryConsumer directoryConsumer;
                    object = directoryConsumer;
                    directoryConsumer = new DexIndexedConsumer.DirectoryConsumer(path, bl);
                }
                return object;
            }
            if (outputMode == OutputMode.DexFilePerClass) {
                if (FileUtils.isArchive(path)) {
                    return new DexFilePerClassFileConsumer.ArchiveConsumer((Builder)object, path, bl){

                        @Override
                        public boolean combineSyntheticClassesWithPrimaryClass() {
                            return false;
                        }
                    };
                }
                return new DexFilePerClassFileConsumer.DirectoryConsumer((Builder)object, path, bl){

                    @Override
                    public boolean combineSyntheticClassesWithPrimaryClass() {
                        return false;
                    }
                };
            }
            if (outputMode == OutputMode.DexFilePerClassFile) {
                if (FileUtils.isArchive(path)) {
                    DexFilePerClassFileConsumer.ArchiveConsumer archiveConsumer;
                    object = archiveConsumer;
                    archiveConsumer = new DexFilePerClassFileConsumer.ArchiveConsumer(path, bl);
                } else {
                    DexFilePerClassFileConsumer.DirectoryConsumer directoryConsumer;
                    object = directoryConsumer;
                    directoryConsumer = new DexFilePerClassFileConsumer.DirectoryConsumer(path, bl);
                }
                return object;
            }
            if (outputMode == OutputMode.ClassFile) {
                if (FileUtils.isArchive(path)) {
                    ClassFileConsumer.ArchiveConsumer archiveConsumer;
                    object = archiveConsumer;
                    archiveConsumer = new ClassFileConsumer.ArchiveConsumer(path, bl);
                } else {
                    ClassFileConsumer.DirectoryConsumer directoryConsumer;
                    object = directoryConsumer;
                    directoryConsumer = new ClassFileConsumer.DirectoryConsumer(path, bl);
                }
                return object;
            }
            throw new Unreachable("Unexpected output mode: " + (Object)((Object)outputMode));
        }

        public int getMinApiLevel() {
            return this.f() ? this.k : AndroidApiLevel.getDefault().getLevel();
        }

        boolean f() {
            return this.k != 0;
        }

        public B setMinApiLevel(int n3) {
            if (n3 <= 0) {
                this.a().a("Invalid minApiLevel: " + n3);
            } else {
                this.k = n3;
            }
            return (B)((Builder)this.c());
        }

        public B setEnableDesugaring(boolean bl) {
            this.l = bl ^ true;
            return (B)((Builder)this.c());
        }

        public B setDisableDesugaring(boolean bl) {
            this.l = bl;
            return (B)((Builder)this.c());
        }

        public boolean getDisableDesugaring() {
            return this.l;
        }

        public B addSpecialLibraryConfiguration(String string) {
            this.m = string;
            return (B)((Builder)this.c());
        }

        public String getSpecialLibraryConfiguration() {
            return this.m;
        }

        public B setIncludeClassesChecksum(boolean bl) {
            this.n = bl;
            return (B)((Builder)this.c());
        }

        public boolean getIncludeClassesChecksum() {
            return this.n;
        }

        @Override
        void d() {
            ArrayList<Class<ClassFileConsumer>> arrayList;
            Builder builder = this;
            Object object = builder.a();
            if (builder.j == null) {
                ((Reporter)object).a("Expected valid compilation mode, was null");
            }
            Builder builder2 = this;
            FileUtils.a(builder2.h, (Reporter)object);
            if (builder2.getProgramConsumer() == null) {
                ((Reporter)object).a("A ProgramConsumer or Output is required for compilation");
            }
            Serializable serializable = arrayList;
            arrayList = new ArrayList<Class<ClassFileConsumer>>(3);
            if (this.f instanceof DexIndexedConsumer) {
                serializable.add(DexIndexedConsumer.class);
            }
            if (this.f instanceof DexFilePerClassFileConsumer) {
                serializable.add(DexFilePerClassFileConsumer.class);
            }
            if (this.f instanceof ClassFileConsumer) {
                serializable.add(ClassFileConsumer.class);
            }
            if (serializable.size() > 1) {
                ArrayList<Class<ClassFileConsumer>> arrayList2 = serializable;
                serializable = new StringBuilder().append("Invalid program consumer.").append(" A program consumer can implement at most one consumer type but ").append(this.f.getClass().getName()).append(" implements types:");
                for (Class clazz : arrayList2) {
                    ((StringBuilder)serializable).append(" ").append(clazz.getName());
                }
                ((Reporter)object).a(((StringBuilder)serializable).toString());
            }
            if (this.m != null) {
                StringDiagnostic stringDiagnostic;
                Reporter reporter = object;
                object = stringDiagnostic;
                stringDiagnostic = new StringDiagnostic("Special library configuration is still work in progress");
                reporter.warning((Diagnostic)object);
            }
            super.d();
        }
    }
}

