/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.dex.BinaryReader;
import com.android.tools.r8.dex.DexOutputBuffer;
import java.util.Arrays;

public class LebUtils {
    static final /* synthetic */ boolean a;

    public static int parseUleb128(BinaryReader binaryReader) {
        byte by;
        int n3 = 0;
        int n4 = 0;
        do {
            by = binaryReader.a();
            n3 |= (by & 0x7F) << n4;
            n4 += 7;
        } while ((by & 0xFFFFFF80) == -128);
        if (!a && n4 > 35) {
            throw new AssertionError();
        }
        if (!a && n3 < 0) {
            throw new AssertionError();
        }
        return n3;
    }

    public static byte[] encodeUleb128(int n3) {
        byte[] byArray = new byte[5];
        int n4 = n3 >>> 7;
        int n5 = 0;
        while (n4 != 0) {
            byArray[n5++] = (byte)(n3 & 0x7F | 0x80);
            int n6 = n3 = n4 >>> 7;
            n3 = n4;
            n4 = n6;
        }
        int n7 = n3;
        n3 = n5 + 1;
        byArray[n5] = (byte)(n7 & 0x7F);
        return Arrays.copyOf(byArray, n3);
    }

    public static void putUleb128(DexOutputBuffer dexOutputBuffer, int n3) {
        int n4 = n3 >>> 7;
        while (n4 != 0) {
            dexOutputBuffer.putByte((byte)(n3 & 0x7F | 0x80));
            int n5 = n3 = n4 >>> 7;
            n3 = n4;
            n4 = n5;
        }
        dexOutputBuffer.putByte((byte)(n3 & 0x7F));
    }

    public static int sizeAsUleb128(int n3) {
        return Math.max(1, (32 - Integer.numberOfLeadingZeros(n3) + 6) / 7);
    }

    public static int parseSleb128(BinaryReader binaryReader) {
        byte by;
        int n3 = 0;
        int n4 = 0;
        do {
            by = binaryReader.a();
            n3 |= (by & 0x7F) << n4;
            n4 += 7;
        } while ((by & 0xFFFFFF80) == -128);
        int n5 = 1 << n4 - 1;
        if (!a && n4 > 35) {
            throw new AssertionError();
        }
        return (n3 ^ n5) - n5;
    }

    public static byte[] encodeSleb128(int n3) {
        int n4 = n3;
        byte[] byArray = new byte[5];
        int n5 = n4 >> 7;
        boolean bl = true;
        int n6 = n4 >= 0 ? 0 : -1;
        int n7 = 0;
        while (bl) {
            bl = n5 != n6 || (n5 & 1) != (n3 >> 6 & 1);
            int n8 = n3;
            n3 = n7 + 1;
            int n9 = n8 & 0x7F;
            int n10 = bl ? 128 : 0;
            byArray[n7] = (byte)(n9 | n10);
            n7 = n5 >> 7;
            int n11 = n3;
            n3 = n5;
            n5 = n7;
            n7 = n11;
        }
        return Arrays.copyOf(byArray, n7);
    }

    public static void putSleb128(DexOutputBuffer dexOutputBuffer, int n3) {
        int n4 = n3;
        int n5 = n4 >> 7;
        boolean bl = true;
        int n6 = (n4 & Integer.MIN_VALUE) == 0 ? 0 : -1;
        while (bl) {
            bl = n5 != n6 || (n5 & 1) != (n3 >> 6 & 1);
            int n7 = bl ? 128 : 0;
            dexOutputBuffer.putByte((byte)((n3 &= 0x7F) | n7));
            int n8 = n3 = n5 >> 7;
            n3 = n5;
            n5 = n8;
        }
    }

    public static int sizeAsSleb128(int n3) {
        if (n3 < 0) {
            n3 ^= 0xFFFFFFFF;
        }
        return (32 - Integer.numberOfLeadingZeros(n3) + 7) / 7;
    }

    static {
        a = LebUtils.class.desiredAssertionStatus() ^ true;
    }
}

