/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.errors.e;
import com.android.tools.r8.experimental.graphinfo.GraphNode;
import com.android.tools.r8.experimental.graphinfo.a;
import com.android.tools.r8.graph.N;
import com.android.tools.r8.graph.T;
import com.android.tools.r8.graph.V;
import com.android.tools.r8.graph.Z;
import com.android.tools.r8.graph.d0;
import com.android.tools.r8.graph.f0;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.ProguardIfRule;
import com.android.tools.r8.shaking.ProguardKeepRule;
import com.android.tools.r8.shaking.ProguardKeepRuleBase;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public abstract class KeepReason {
    static KeepReason annotatedOn(N n4) {
        return new AnnotatedOn(n4);
    }

    static KeepReason dueToKeepRule(ProguardKeepRuleBase proguardKeepRuleBase) {
        if (proguardKeepRuleBase instanceof ProguardKeepRule) {
            return new DueToKeepRule(proguardKeepRuleBase);
        }
        if (proguardKeepRuleBase instanceof ProguardIfRule) {
            proguardKeepRuleBase = (ProguardIfRule)proguardKeepRuleBase;
            return new DueToConditionalKeepRule(proguardKeepRuleBase, ((ProguardIfRule)proguardKeepRuleBase).getPreconditions());
        }
        throw new e("Unexpected proguard keep rule: " + proguardKeepRuleBase);
    }

    static KeepReason dueToConditionalKeepRule(ProguardKeepRuleBase proguardKeepRuleBase, d0 d02) {
        return new DueToConditionalKeepRule(proguardKeepRuleBase, d02);
    }

    static KeepReason dueToProguardCompatibilityKeepRule(ProguardKeepRule proguardKeepRule) {
        return new DueToProguardCompatibilityKeepRule(proguardKeepRule);
    }

    static KeepReason instantiatedIn(T t4) {
        return new InstatiatedIn(t4);
    }

    public static KeepReason invokedViaSuperFrom(T t4) {
        return new InvokedViaSuper(t4);
    }

    public static KeepReason reachableFromLiveType(f0 f02) {
        return new ReachableFromLiveType(f02);
    }

    public static KeepReason invokedFrom(T t4) {
        return new InvokedFrom(t4);
    }

    public static KeepReason invokedFromLambdaCreatedIn(T t4) {
        return new InvokedFromLambdaCreatedIn(t4);
    }

    public static KeepReason isLibraryMethod(f0 f02, f0 f03) {
        return new IsLibraryMethod(f02, f03);
    }

    public static KeepReason fieldReferencedIn(T t4) {
        return new ReferencedFrom(t4);
    }

    public static KeepReason referencedInAnnotation(V v4) {
        return new ReferencedInAnnotation(v4);
    }

    public static KeepReason targetedBySuperFrom(T t4) {
        return new TargetedBySuper(t4);
    }

    public static KeepReason reflectiveUseIn(T t4) {
        return new ReflectiveUseFrom(t4);
    }

    public static KeepReason methodHandleReferencedIn(T t4) {
        return new MethodHandleReferencedFrom(t4);
    }

    public static KeepReason overridesMethod(T t4) {
        return new OverridesMethod(t4);
    }

    public abstract a.a edgeKind();

    public abstract GraphNode getSourceNode(Enqueuer var1);

    public boolean isDueToKeepRule() {
        return false;
    }

    public boolean isDueToReflectiveUse() {
        return false;
    }

    public boolean isDueToProguardCompatibility() {
        return false;
    }

    public boolean isDueToConditionalKeepRule() {
        return false;
    }

    public boolean isInstantiatedIn() {
        return false;
    }

    public InstatiatedIn asInstantiatedIn() {
        return null;
    }

    public ProguardKeepRuleBase getProguardKeepRule() {
        return null;
    }

    public Collection<d0> getPreconditions() {
        throw new e();
    }

    private static class MethodHandleReferencedFrom
    extends BasedOnOtherMethod {
        private MethodHandleReferencedFrom(T t4) {
            super(t4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.q;
        }

        @Override
        String getKind() {
            return "method handle referenced from";
        }
    }

    private static class ReflectiveUseFrom
    extends BasedOnOtherMethod {
        private ReflectiveUseFrom(T t4) {
            super(t4);
        }

        @Override
        public boolean isDueToReflectiveUse() {
            return true;
        }

        @Override
        public a.a edgeKind() {
            return a.a.l;
        }

        @Override
        String getKind() {
            return "reflective use in";
        }
    }

    private static class AnnotatedOn
    extends KeepReason {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final N holder;

        private AnnotatedOn(N n4) {
            this.holder = n4;
        }

        static {
            $assertionsDisabled = KeepReason.class.desiredAssertionStatus() ^ true;
        }

        @Override
        public a.a edgeKind() {
            return a.a.j;
        }

        @Override
        public GraphNode getSourceNode(Enqueuer enqueuer) {
            if (this.holder.h()) {
                return enqueuer.getClassGraphNode(this.holder.e().c);
            }
            if (this.holder.i()) {
                return enqueuer.getFieldGraphNode(this.holder.f().a);
            }
            if (!$assertionsDisabled && !this.holder.j()) {
                throw new AssertionError();
            }
            return enqueuer.getMethodGraphNode(this.holder.g().a);
        }
    }

    private static class ReferencedInAnnotation
    extends KeepReason {
        private final V holder;

        private ReferencedInAnnotation(V v4) {
            this.holder = v4;
        }

        @Override
        public a.a edgeKind() {
            return a.a.n;
        }

        @Override
        public GraphNode getSourceNode(Enqueuer enqueuer) {
            return enqueuer.getAnnotationGraphNode(this.holder);
        }
    }

    public static class IsLibraryMethod
    extends KeepReason {
        private final f0 implementer;
        private final f0 libraryType;

        private IsLibraryMethod(f0 f02, f0 f03) {
            this.implementer = f02;
            this.libraryType = f03;
        }

        @Override
        public a.a edgeKind() {
            return a.a.o;
        }

        @Override
        public GraphNode getSourceNode(Enqueuer enqueuer) {
            return enqueuer.getClassGraphNode(this.implementer);
        }
    }

    private static class ReachableFromLiveType
    extends KeepReason {
        private final f0 type;

        private ReachableFromLiveType(f0 f02) {
            this.type = f02;
        }

        @Override
        public a.a edgeKind() {
            return a.a.m;
        }

        @Override
        public GraphNode getSourceNode(Enqueuer enqueuer) {
            return enqueuer.getClassGraphNode(this.type);
        }
    }

    private static class ReferencedFrom
    extends BasedOnOtherMethod {
        private ReferencedFrom(T t4) {
            super(t4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.k;
        }

        @Override
        String getKind() {
            return "referenced from";
        }
    }

    private static class InvokedFromLambdaCreatedIn
    extends BasedOnOtherMethod {
        private InvokedFromLambdaCreatedIn(T t4) {
            super(t4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.i;
        }

        @Override
        String getKind() {
            return "invoked from lambda created in";
        }
    }

    private static class InvokedFrom
    extends BasedOnOtherMethod {
        private InvokedFrom(T t4) {
            super(t4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.h;
        }

        @Override
        String getKind() {
            return "invoked from";
        }
    }

    private static class TargetedBySuper
    extends BasedOnOtherMethod {
        private TargetedBySuper(T t4) {
            super(t4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.g;
        }

        @Override
        String getKind() {
            return "targeted by super from";
        }
    }

    private static class InvokedViaSuper
    extends BasedOnOtherMethod {
        private InvokedViaSuper(T t4) {
            super(t4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.f;
        }

        @Override
        String getKind() {
            return "invoked via super from";
        }
    }

    public static class InstatiatedIn
    extends BasedOnOtherMethod {
        private InstatiatedIn(T t4) {
            super(t4);
        }

        @Override
        public boolean isInstantiatedIn() {
            return true;
        }

        @Override
        public InstatiatedIn asInstantiatedIn() {
            return this;
        }

        @Override
        public a.a edgeKind() {
            return a.a.e;
        }

        @Override
        String getKind() {
            return "instantiated in";
        }
    }

    private static class OverridesMethod
    extends BasedOnOtherMethod {
        public OverridesMethod(T t4) {
            super(t4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.p;
        }

        @Override
        String getKind() {
            return "overrides";
        }
    }

    private static abstract class BasedOnOtherMethod
    extends KeepReason {
        private final T method;

        private BasedOnOtherMethod(T t4) {
            this.method = t4;
        }

        abstract String getKind();

        public Z getMethod() {
            return this.method.a;
        }

        @Override
        public GraphNode getSourceNode(Enqueuer enqueuer) {
            return enqueuer.getMethodGraphNode(this.method.a);
        }
    }

    private static class DueToConditionalKeepRule
    extends DueToKeepRule {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final Set<d0> preconditions;

        public DueToConditionalKeepRule(ProguardKeepRuleBase proguardKeepRuleBase, d0 d02) {
            this(proguardKeepRuleBase, Collections.singleton(d02));
            if (!$assertionsDisabled && d02 == null) {
                throw new AssertionError();
            }
        }

        public DueToConditionalKeepRule(ProguardKeepRuleBase proguardKeepRuleBase, Set<d0> set) {
            super(proguardKeepRuleBase);
            if (!$assertionsDisabled && set.isEmpty()) {
                throw new AssertionError();
            }
            this.preconditions = set;
        }

        static {
            $assertionsDisabled = KeepReason.class.desiredAssertionStatus() ^ true;
        }

        public Set<d0> getPreconditions() {
            return this.preconditions;
        }

        @Override
        public boolean isDueToConditionalKeepRule() {
            return true;
        }

        @Override
        public a.a edgeKind() {
            return a.a.c;
        }
    }

    private static class DueToProguardCompatibilityKeepRule
    extends DueToKeepRule {
        private DueToProguardCompatibilityKeepRule(ProguardKeepRule proguardKeepRule) {
            super(proguardKeepRule);
        }

        @Override
        public a.a edgeKind() {
            return a.a.b;
        }

        @Override
        public boolean isDueToProguardCompatibility() {
            return true;
        }
    }

    private static class DueToKeepRule
    extends KeepReason {
        final ProguardKeepRuleBase keepRule;

        private DueToKeepRule(ProguardKeepRuleBase proguardKeepRuleBase) {
            this.keepRule = proguardKeepRuleBase;
        }

        @Override
        public a.a edgeKind() {
            return a.a.a;
        }

        @Override
        public boolean isDueToKeepRule() {
            return true;
        }

        @Override
        public ProguardKeepRuleBase getProguardKeepRule() {
            return this.keepRule;
        }

        @Override
        public GraphNode getSourceNode(Enqueuer enqueuer) {
            return enqueuer.getKeepRuleGraphNode(this.keepRule);
        }
    }
}

