/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.files;

import com.android.utils.FileUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.File;

public class RelativeFile {
    private final File file;
    private final String relativePath;
    public final Type type;

    public RelativeFile(File base, File file) {
        this(file, FileUtils.toSystemIndependentPath((String)FileUtils.relativePossiblyNonExistingPath((File)file, (File)base)), Type.DIRECTORY);
        Preconditions.checkArgument((!base.equals(file) ? 1 : 0) != 0, (String)"Base must not equal file. Given: %s", (Object)base.getAbsolutePath());
    }

    public RelativeFile(File base, String relativePath) {
        this(base, relativePath, Type.JAR);
    }

    public static RelativeFile fileInDirectory(String relativePath, File file) {
        return new RelativeFile(file, relativePath, Type.DIRECTORY);
    }

    private RelativeFile(File file, String relativePath, Type type) {
        Preconditions.checkArgument((!relativePath.isEmpty() ? 1 : 0) != 0, (Object)"Relative path cannot be empty");
        this.file = file;
        this.relativePath = relativePath;
        this.type = type;
    }

    public File getBase() {
        Preconditions.checkState((this.getType() == Type.JAR ? 1 : 0) != 0, (Object)"Only applicable for jars");
        return this.file;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public Type getType() {
        return this.type;
    }

    public File getFile() {
        Preconditions.checkState((this.getType() == Type.DIRECTORY ? 1 : 0) != 0, (Object)"Only applicable for directories");
        return this.file;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.file, this.relativePath});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RelativeFile)) {
            return false;
        }
        RelativeFile other = (RelativeFile)obj;
        return Objects.equal((Object)this.file, (Object)other.file) && Objects.equal((Object)this.relativePath, (Object)other.relativePath) && Objects.equal((Object)((Object)this.type), (Object)((Object)other.type));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("base", (Object)this.file).add("path", (Object)this.relativePath).add("type", (Object)this.type).toString();
    }

    public static enum Type {
        DIRECTORY,
        JAR;

    }
}

