/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.compiling;

import com.android.builder.internal.ClassFieldImpl;
import com.android.builder.model.ClassField;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.io.Closer;
import com.squareup.javawriter.JavaWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;

public class BuildConfigGenerator {
    public static final String BUILD_CONFIG_NAME = "BuildConfig.java";
    private static final Set<Modifier> PUBLIC_FINAL = EnumSet.of(Modifier.PUBLIC, Modifier.FINAL);
    private static final Set<Modifier> PUBLIC_STATIC_FINAL = EnumSet.of(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL);
    private final File mGenFolder;
    private final String mBuildConfigPackageName;
    private final List<ClassField> mFields = Lists.newArrayList();
    private final List<Object> mItems = Lists.newArrayList();

    public BuildConfigGenerator(File genFolder, String buildConfigPackageName) {
        this.mGenFolder = (File)Preconditions.checkNotNull((Object)genFolder);
        this.mBuildConfigPackageName = (String)Preconditions.checkNotNull((Object)buildConfigPackageName);
    }

    public BuildConfigGenerator addField(String type, String name, String value) {
        this.mFields.add(new ClassFieldImpl(type, name, value));
        return this;
    }

    public BuildConfigGenerator addDeprecatedField(String type, String name, String value, String documentation) {
        this.mFields.add(new ClassFieldImpl(type, name, value, documentation, (ImmutableSet<String>)ImmutableSet.of((Object)"Deprecated")));
        return this;
    }

    public BuildConfigGenerator addItems(Collection<Object> items) {
        if (items != null) {
            this.mItems.addAll(items);
        }
        return this;
    }

    public File getFolderPath() {
        return new File(this.mGenFolder, this.mBuildConfigPackageName.replace('.', File.separatorChar));
    }

    public File getBuildConfigFile() {
        File folder = this.getFolderPath();
        return new File(folder, BUILD_CONFIG_NAME);
    }

    public void generate() throws IOException {
        File pkgFolder = this.getFolderPath();
        if (!pkgFolder.isDirectory() && !pkgFolder.mkdirs()) {
            throw new RuntimeException("Failed to create " + pkgFolder.getAbsolutePath());
        }
        File buildConfigJava = new File(pkgFolder, BUILD_CONFIG_NAME);
        try (Closer closer = Closer.create();){
            FileOutputStream fos = (FileOutputStream)closer.register((Closeable)new FileOutputStream(buildConfigJava));
            OutputStreamWriter out = (OutputStreamWriter)closer.register((Closeable)new OutputStreamWriter((OutputStream)fos, Charsets.UTF_8));
            JavaWriter writer = (JavaWriter)closer.register((Closeable)new JavaWriter((Writer)out));
            writer.emitJavadoc("Automatically generated file. DO NOT MODIFY", new Object[0]).emitPackage(this.mBuildConfigPackageName).beginType("BuildConfig", "class", PUBLIC_FINAL);
            for (ClassField field : this.mFields) {
                BuildConfigGenerator.emitClassField(writer, field);
            }
            for (Object item : this.mItems) {
                if (item instanceof ClassField) {
                    BuildConfigGenerator.emitClassField(writer, (ClassField)item);
                    continue;
                }
                if (!(item instanceof String)) continue;
                writer.emitSingleLineComment((String)item, new Object[0]);
            }
            writer.endType();
        }
    }

    private static void emitClassField(JavaWriter writer, ClassField field) throws IOException {
        String documentation = field.getDocumentation();
        if (!documentation.isEmpty()) {
            writer.emitJavadoc(documentation, new Object[0]);
        }
        for (String annotation : field.getAnnotations()) {
            writer.emitAnnotation(annotation);
        }
        writer.emitField(field.getType(), field.getName(), PUBLIC_STATIC_FINAL, field.getValue());
    }
}

