/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dependency.level2;

import com.android.builder.dependency.HashCodeUtils;
import com.android.builder.dependency.level2.Dependency;
import com.android.builder.model.MavenCoordinates;
import com.android.manifmerger.ManifestProvider;
import java.io.File;
import java.util.Objects;

public abstract class ExtractedDependency
extends Dependency
implements ManifestProvider {
    private final File extractedFolder;
    private final File manifestFile;
    private final String variant;

    public ExtractedDependency(File artifactFile, MavenCoordinates coordinates, String name, String projectPath, File extractedFolder, String variant) {
        super(artifactFile, coordinates, name, projectPath);
        this.extractedFolder = extractedFolder;
        this.variant = variant;
        this.manifestFile = new File(extractedFolder, "AndroidManifest.xml");
    }

    @Override
    public Object getAddress() {
        if (this.variant != null) {
            return this.getProjectPath() + "::" + this.variant;
        }
        return super.getAddress();
    }

    public File getExtractedFolder() {
        return this.extractedFolder;
    }

    public String getVariant() {
        return this.variant;
    }

    public File getManifest() {
        return this.manifestFile;
    }

    public File getResFolder() {
        return new File(this.extractedFolder, "res");
    }

    public File getAssetsFolder() {
        return new File(this.extractedFolder, "assets");
    }

    public abstract File getJarFile();

    @Override
    public File getClasspathFile() {
        return this.getJarFile();
    }

    @Override
    public boolean equals(Object o4) {
        if (this == o4) {
            return true;
        }
        if (o4 == null || this.getClass() != o4.getClass()) {
            return false;
        }
        if (!super.equals(o4)) {
            return false;
        }
        ExtractedDependency that = (ExtractedDependency)o4;
        return Objects.equals(this.extractedFolder, that.extractedFolder) && Objects.equals(this.variant, that.variant);
    }

    @Override
    public int hashCode() {
        return HashCodeUtils.hashCode(super.hashCode(), this.extractedFolder, this.variant);
    }
}

